/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.HashMap;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.InvalidDataException;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertActionControl;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertRegistry;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.StatConAlertActionProvider;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

public class AlertTablePanel
extends Composite
implements SelectionListener {
    Combo provider;
    Button tester;
    Label label;
    Group config_panel;
    HashMap actions_cache = new HashMap();
    HashMap controls_cache = new HashMap();
    StackLayout layout_stack = new StackLayout();

    public AlertTablePanel(Composite parent, String description) {
        super(parent, 16);
        this.initGraphics(parent, description);
        this.initEventHandling();
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.provider.setEnabled(b);
        this.label.setEnabled(b);
        this.tester.setEnabled(b);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        block3: {
            Object o;
            block2: {
                o = e.getSource();
                if (o != this.provider) break block2;
                this.updateSubPanel();
                break block3;
            }
            if (o != this.tester) break block3;
            try {
                AlertAction tmp = this.getConfiguredAction();
                tmp.setInformation("TEST ALERT", null, 999.0, System.currentTimeMillis(), true);
                tmp.run();
            }
            catch (Throwable t) {
                MessageBox mbox = new MessageBox(this.getShell());
                mbox.setText(EditorPlugin.getString("ERROR_LABEL"));
                mbox.setMessage(EditorPlugin.getString("ERROR_LABEL") + t.getMessage());
                mbox.open();
            }
        }
    }

    private void updateSubPanel() {
        int i = this.provider.getSelectionIndex();
        StatConAlertActionProvider provider = AlertRegistry.getProviders()[i];
        AlertAction newaction = (AlertAction)this.actions_cache.get(provider);
        this.layout_stack.topControl = (Control)this.controls_cache.get(provider);
        this.config_panel.layout(true);
        this.config_panel.redraw();
    }

    private void initEventHandling() {
        this.provider.addSelectionListener((SelectionListener)this);
        this.tester.addSelectionListener((SelectionListener)this);
    }

    private void initGraphics(Composite main_panel, String description) {
        this.setLayoutData(GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.setLayout((Layout)new GridLayout(3, false));
        this.label = new Label((Composite)this, 0);
        this.label.setText(description);
        this.label.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 1, 2));
        this.provider = new Combo((Composite)this, 2048);
        this.provider.setItems(AlertRegistry.getProviderNames());
        this.provider.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 1, 2));
        this.tester = new Button((Composite)this, 0);
        this.tester.setText(EditorPlugin.getString("ALERT_TEST"));
        this.tester.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 3, 2));
        this.config_panel = new Group((Composite)this, 16);
        this.config_panel.setLayoutData((Object)GData.getGridData(true, true, -1, -1, 3, 1, 4, 4));
        this.config_panel.setLayout((Layout)this.layout_stack);
        StatConAlertActionProvider[] providers = AlertRegistry.getProviders();
        int i = 0;
        while (i < providers.length) {
            this.controls_cache.put(providers[i], providers[i].newAlertAction().getControl((Composite)this.config_panel));
            ++i;
        }
    }

    private int getProviderIndex(String name) {
        String[] provider_names = AlertRegistry.getProviderNames();
        int i = 0;
        while (i < provider_names.length) {
            if (name.equals(provider_names[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void clearControls() {
        StatConAlertActionProvider[] providers = AlertRegistry.getProviders();
        int i = 0;
        while (i < providers.length) {
            AlertActionControl control = (AlertActionControl)((Object)this.controls_cache.get(providers[i]));
            control.readFromAction(providers[i].newAlertAction());
            ++i;
        }
    }

    public void setConfiguredAction(AlertAction action) {
        this.clearControls();
        this.layout_stack.topControl = (Control)this.controls_cache.get(AlertRegistry.getProvider(action.getProviderName()));
        ((AlertActionControl)this.layout_stack.topControl).readFromAction(action);
        this.config_panel.layout(true);
        this.config_panel.redraw();
        this.provider.select(this.getProviderIndex(action.getProviderName()));
    }

    public AlertAction getConfiguredAction() throws InvalidDataException {
        AlertActionControl control = (AlertActionControl)this.layout_stack.topControl;
        return control.writeToClonedAction();
    }

    public String getCurrentDescription() {
        AlertActionControl control = (AlertActionControl)this.layout_stack.topControl;
        return control.getDescription();
    }
}

