/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDCounterDescriptor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.ImageManager;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConModelOp;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConOpState;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConStatisticalImageProvider;
import org.eclipse.hyades.statistical.ui.editor.internal.StatisticalModelGraphViewer;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeItem;

public class OpAddToTree
implements StatConModelOp {
    private static final boolean ADD_SORTED = true;
    public static OpAddToTree INSTANCE = new OpAddToTree();
    static ImageManager img = EditorPlugin.img;

    private static int getIndex(TreeItem parent, String childname) {
        TreeItem[] items = parent.getItems();
        int i = 1;
        while (i < items.length) {
            if (items[i].getText().compareTo(childname) > 1) {
                return i;
            }
            ++i;
        }
        return items.length;
    }

    public static void launch(StatisticalModelGraphViewer statcon, SDDescriptor descriptor, SDDescriptor root, boolean update) {
        StatConOpState state = new StatConOpState(new Boolean(update));
        statcon.applyStatConModelOp(new OpAddToTree(), state, descriptor, root);
    }

    private String getTreeName(SDDescriptor sd) {
        String basicname = null;
        basicname = sd.getDescription() != null ? sd.getName() + " (" + sd.getDescription() + ")" : sd.getName();
        if (basicname == null) {
            basicname = "";
        }
        if (basicname.length() == 0) {
            basicname = "(" + EditorPlugin.getString("ACTION_UNKNOWN") + ")";
        }
        return basicname;
    }

    public void postapply(StatConOpState state, StatisticalModelGraphViewer statcon, SDDescriptor sd, SDDescriptor root_parent, boolean parents_checked, boolean parents_enabled) {
    }

    public StatConOpState preapply(StatConOpState state, StatisticalModelGraphViewer statcon, SDDescriptor sd, SDDescriptor root_parent, boolean parents_checked, boolean parents_enabled) {
        if (sd == null) {
            return state;
        }
        if (sd.getName() == null) {
            return state;
        }
        boolean update = (Boolean)state.state;
        TreeItem item = statcon.mapDescriptorToItem(sd);
        TreeItem parent_item = statcon.mapDescriptorToItem(sd.getParent());
        if (update && item != null) {
            String tmp = this.getTreeName(sd);
            if (!tmp.equals(item.getText())) {
                item.setText(tmp);
            }
        } else {
            String itemName = this.getTreeName(sd);
            if (parent_item == null) {
                TRCAgent agent = sd.getAgent();
                if (agent == null) {
                    return state;
                }
                TreeItem parentTMP = statcon.mapAgentToItem(agent);
                item = new TreeItem(parentTMP, 0, OpAddToTree.getIndex(parentTMP, itemName));
            } else {
                item = new TreeItem(parent_item, 0, OpAddToTree.getIndex(parent_item, itemName));
            }
            item.setText(itemName);
            TRCAgent sdagent = sd.getAgent();
            SDDescriptor parent = sd.getParent();
            while (sdagent == null && parent != null) {
                sdagent = parent.getAgent();
                parent = parent.getParent();
            }
            Image statimg = null;
            int i = 0;
            while (statimg == null && i < statcon.stat_img_providers.size()) {
                try {
                    StatConStatisticalImageProvider provider = (StatConStatisticalImageProvider)statcon.stat_img_providers.get(i);
                    statimg = provider.getImage(sd);
                    if (statimg == null && sdagent != null) {
                        statimg = provider.getImage(sd, sdagent);
                    }
                }
                catch (Throwable t) {
                    EditorPlugin.DBG.error("statistical image provider threw error", t);
                }
                ++i;
            }
            if (statimg == null) {
                if (sd instanceof SDCounterDescriptor) {
                    item.setImage(img.getImage("smodel_counterdescriptor.gif"));
                } else {
                    item.setImage(img.getImage("smodel_descriptor2.gif"));
                }
            } else {
                item.setImage(statimg);
            }
            item.setChecked(true);
            item.setGrayed(false);
            statcon.mapDescriptorToItem(sd, item);
        }
        this.addObservations(statcon, sd, item, update);
        this.addRepresentation(statcon, sd, item, update);
        return state;
    }

    private void addObservations(StatisticalModelGraphViewer statcon, SDDescriptor sd, TreeItem item, boolean update) {
        SDMemberDescriptor sdmem;
        EList obs = null;
        Image obs_image = null;
        if (sd instanceof SDMemberDescriptor && (obs = (sdmem = (SDMemberDescriptor)sd).getSnapshotObservation()) != null) {
            if (obs.size() > 0) {
                obs_image = img.getImage("smodel_counter.gif");
            } else {
                obs = null;
            }
        }
        if (obs != null) {
            int i = 0;
            while (i < obs.size()) {
                SDSnapshotObservation o = (SDSnapshotObservation)obs.get(i);
                if (o instanceof SDContiguousObservation || o instanceof SDDiscreteObservation || o instanceof SDTextObservation) {
                    TreeItem obs_item = statcon.mapObservationToItem(o);
                    if (!update || obs_item == null) {
                        String itemName = sd.getName() + " (" + EditorPlugin.getString("GRAPH") + " " + (i + 1) + ")";
                        obs_item = new TreeItem(item, 0, 0);
                        obs_item.setText(itemName);
                        obs_item.setImage(obs_image);
                        obs_item.setGrayed(false);
                        obs_item.setChecked(true);
                        statcon.mapObservationToItem(o, obs_item);
                    }
                }
                ++i;
            }
        }
    }

    private void addRepresentation(StatisticalModelGraphViewer statcon, SDDescriptor sd, TreeItem item, boolean update) {
        SDMemberDescriptor sdmem;
        SDRepresentation reptmp;
        SDModifiableVariableRepresentation rep = null;
        Image rep_image = null;
        if (sd instanceof SDMemberDescriptor && (reptmp = (sdmem = (SDMemberDescriptor)sd).getRepresentation()) instanceof SDModifiableVariableRepresentation) {
            rep = (SDModifiableVariableRepresentation)reptmp;
            rep_image = rep.getImage();
        }
        if (rep != null) {
            TreeItem rep_item = statcon.mapRepresentationToItem(rep);
            if (!update || rep_item == null) {
                String itemName = sd.getName() + " (" + EditorPlugin.getString("CONTROL") + ")";
                rep_item = new TreeItem(item, 0, 0);
                rep_item.setText(itemName);
                rep_item.setImage(rep_image);
                if (rep_image == null) {
                    rep_item.setImage(img.getImage("smodel_modifiablerep.gif"));
                }
                rep_item.setGrayed(false);
                rep_item.setChecked(true);
                statcon.mapRepresentationToItem(rep, rep_item);
            }
        }
    }
}

