/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLConfigUtil {
    public static DocumentBuilder getDocumentBuilder() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder;
    }

    public static void getXmlHead(StringBuffer sb, Element e) {
        sb.append("<");
        sb.append(e.getTagName());
        sb.append(" ");
        NamedNodeMap attrs = e.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            sb.append(node.getNodeName());
            sb.append("=\"");
            sb.append(XMLConfigUtil.toRawXML(node.getNodeValue()));
            sb.append("\" ");
            ++i;
        }
        sb.append(">\n");
    }

    public static void getXmlTail(StringBuffer sb, Element e) {
        sb.append("</");
        sb.append(e.getTagName());
        sb.append(">\n");
    }

    public static String toRawXML(Node n) {
        StringBuffer sb = new StringBuffer();
        XMLConfigUtil.toRawXML(sb, n);
        return sb.toString();
    }

    public static String toRawXML(String val) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < val.length()) {
            char c = val.charAt(i);
            if (c == '>') {
                sb.append("&gt;");
            } else if (c == '<') {
                sb.append("&lt;");
            } else if (c == '\"') {
                sb.append("&quot;");
            } else if (c == '\'') {
                sb.append("&apos;");
            } else if (c == '&') {
                sb.append("&amp;");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private static void toRawXML(StringBuffer sb, Node n) {
        if (n.getNodeType() == 1) {
            XMLConfigUtil.toXML(sb, (Element)n);
        } else if (n.getNodeType() == 3) {
            String val = n.getNodeValue();
            sb.append(XMLConfigUtil.toRawXML(val));
        }
    }

    public static String toXML(Element e) {
        StringBuffer sb = new StringBuffer();
        XMLConfigUtil.toXML(sb, e);
        return sb.toString();
    }

    private static void toXML(StringBuffer sb, Element e) {
        sb.append("<");
        sb.append(e.getTagName());
        sb.append(" ");
        NamedNodeMap attrs = e.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            sb.append(node.getNodeName());
            sb.append("=\"");
            sb.append(XMLConfigUtil.toRawXML(node.getNodeValue()));
            sb.append("\" ");
            ++i;
        }
        sb.append(">\n");
        ArrayList list = XMLConfigUtil.getAllElements(e.getChildNodes(), null);
        int i2 = 0;
        while (i2 < list.size()) {
            Element x = (Element)list.get(i2);
            XMLConfigUtil.toXML(sb, x);
            ++i2;
        }
        sb.append("</");
        sb.append(e.getTagName());
        sb.append(">\n");
    }

    public static Element getFirstElement(NodeList list, String name) {
        int i = 0;
        while (i < list.getLength()) {
            Node o = list.item(i);
            if (o instanceof Element) {
                Element e = (Element)o;
                if (name != null) {
                    if (e.getTagName().equals(name)) {
                        return e;
                    }
                } else {
                    return e;
                }
            }
            ++i;
        }
        return null;
    }

    public static ArrayList getAllElements(NodeList list, String name) {
        ArrayList<Node> elements = new ArrayList<Node>();
        int i = 0;
        while (i < list.getLength()) {
            Node o = list.item(i);
            if (o instanceof Element) {
                Element e = (Element)o;
                if (name != null) {
                    if (e.getTagName().equals(name)) {
                        elements.add(o);
                    }
                } else {
                    elements.add(o);
                }
            }
            ++i;
        }
        return elements;
    }

    public static void getElementAttributeMap(NodeList list, String name, String attribute, HashMap map) {
        int i = 0;
        while (i < list.getLength()) {
            Node o = list.item(i);
            if (o instanceof Element) {
                String attr;
                Element e = (Element)o;
                if (name != null) {
                    if (e.getTagName().equals(name) && (attr = e.getAttribute(attribute)) != null) {
                        map.put(attr, e);
                    }
                } else {
                    attr = e.getAttribute(attribute);
                    if (attr != null) {
                        map.put(attr, e);
                    }
                }
            }
            ++i;
        }
    }

    public static HashMap getElementAttributeMap(NodeList list, String name, String attribute) {
        HashMap map = new HashMap();
        XMLConfigUtil.getElementAttributeMap(list, name, attribute, map);
        return map;
    }

    public static double parseDouble(String doub, double def) {
        try {
            return Double.parseDouble(doub);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static boolean parseBoolean(String bool, boolean def) {
        if (bool.equals("true")) {
            return true;
        }
        if (bool.equals("false")) {
            return false;
        }
        return def;
    }

    public static String generateNoDataBehaviour(int type) {
        if (type == 0) {
            return "NODATA_DO_NOTHING";
        }
        if (type == 1) {
            return "NODATA_DRAW_ZERO";
        }
        if (type == 2) {
            return "NODATA_DRAW_PREVIOUS";
        }
        return "NODATA_DRAW_ZERO";
    }

    public static int parseNoDataBehaviour(String type, int def) {
        if (type.equals("NODATA_DO_NOTHING")) {
            return 0;
        }
        if (type.equals("NODATA_DRAW_ZERO")) {
            return 1;
        }
        if (type.equals("NODATA_DRAW_PREVIOUS")) {
            return 2;
        }
        return def;
    }

    public static String generatePlottingPeriod(int type) {
        if (type == 0) {
            return "PERIOD_TYPE_TICKS";
        }
        if (type == 1) {
            return "PERIOD_TYPE_MILLIS";
        }
        if (type == 2) {
            return "PERIOD_TYPE_PIXELS";
        }
        if (type == 3) {
            return "PERIOD_TYPE_UNAVERAGED";
        }
        return "PERIOD_TYPE_TICKS";
    }

    public static int parsePlottingPeriod(String type, int def) {
        if (type.equals("PERIOD_TYPE_TICKS")) {
            return 0;
        }
        if (type.equals("PERIOD_TYPE_MILLIS")) {
            return 1;
        }
        if (type.equals("PERIOD_TYPE_PIXELS")) {
            return 2;
        }
        if (type.equals("PERIOD_TYPE_UNAVERAGED")) {
            return 3;
        }
        return def;
    }

    public static String generatePlottingType(int type) {
        if (type == 0) {
            return "PLOTTING_TYPE_AVERAGE";
        }
        if (type == 1) {
            return "PLOTTING_TYPE_MIN";
        }
        if (type == 2) {
            return "PLOTTING_TYPE_MAX";
        }
        if (type == 3) {
            return "PLOTTING_TYPE_MIN_MAX";
        }
        if (type == 4) {
            return "PLOTTING_TYPE_MIN_MAX_AVERAGE";
        }
        if (type == 5) {
            return "PLOTTING_TYPE_SUM";
        }
        if (type == 6) {
            return "PLOTTING_TYPE_NEAREST";
        }
        if (type == 7) {
            return "PLOTTING_TYPE_COUNT";
        }
        if (type == 8) {
            return "PLOTTING_TYPE_STDDEV";
        }
        if (type == 9) {
            return "PLOTTING_TYPE_STDDEV_AVERAGE";
        }
        return "PLOTTING_TYPE_AVERAGE";
    }

    public static int parsePlottingType(String type, int def) {
        if (type.equals("PLOTTING_TYPE_AVERAGE")) {
            return 0;
        }
        if (type.equals("PLOTTING_TYPE_MIN")) {
            return 1;
        }
        if (type.equals("PLOTTING_TYPE_MAX")) {
            return 2;
        }
        if (type.equals("PLOTTING_TYPE_MIN_MAX")) {
            return 3;
        }
        if (type.equals("PLOTTING_TYPE_MIN_MAX_AVERAGE")) {
            return 4;
        }
        if (type.equals("PLOTTING_TYPE_SUM")) {
            return 5;
        }
        if (type.equals("PLOTTING_TYPE_NEAREST")) {
            return 6;
        }
        if (type.equals("PLOTTING_TYPE_COUNT")) {
            return 7;
        }
        if (type.equals("PLOTTING_TYPE_STDDEV")) {
            return 8;
        }
        if (type.equals("PLOTTING_TYPE_STDDEV_AVERAGE")) {
            return 9;
        }
        return def;
    }

    public static int parseLineStyle(String style, int def) {
        if (style.equals("SOLID")) {
            return 1;
        }
        if (style.equals("DOT")) {
            return 3;
        }
        if (style.equals("DASH")) {
            return 2;
        }
        if (style.equals("DASHDOT")) {
            return 4;
        }
        if (style.equals("DASHDOTDOT")) {
            return 5;
        }
        return def;
    }

    public static RGB parseColor(String col, RGB def) {
        try {
            if (!col.startsWith("#")) {
                throw new Exception();
            }
            if (col.length() != 7) {
                throw new Exception();
            }
            String sr = col.substring(1, 3);
            String sg = col.substring(3, 5);
            String sb = col.substring(5, 7);
            int r = Integer.parseInt(sr, 16);
            int g = Integer.parseInt(sg, 16);
            int b = Integer.parseInt(sb, 16);
            return new RGB(r, g, b);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static String colorToString(Color c) {
        RGB rgb = c.getRGB();
        String s = "#";
        if (rgb.red < 16) {
            s = s + "0";
        }
        s = s + Integer.toString(rgb.red, 16);
        if (rgb.green < 16) {
            s = s + "0";
        }
        s = s + Integer.toString(rgb.green, 16);
        if (rgb.blue < 16) {
            s = s + "0";
        }
        s = s + Integer.toString(rgb.blue, 16);
        return s;
    }

    public static String lineStyleToString(int style) {
        if (style == 1) {
            return "SOLID";
        }
        if (style == 3) {
            return "DOT";
        }
        if (style == 2) {
            return "DASH";
        }
        if (style == 4) {
            return "DASHDOT";
        }
        if (style == 5) {
            return "DASHDOTDOT";
        }
        return "SOLID";
    }
}

