/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.monitoractions.internal.email;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.monitoractions.internal.email.EmailControl;
import org.eclipse.hyades.statistical.ui.monitoractions.internal.email.Mailer;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertActionControl;
import org.eclipse.swt.widgets.Composite;

public class EmailAlertAction
implements AlertAction {
    String host = EditorPlugin.getString("ALERT_ACTION_EMAIL_DEFAULT_SERVER");
    int port = 25;
    String sender = EditorPlugin.getString("ALERT_ACTION_EMAIL_DEFAULT_SENDER");
    String recipients = EditorPlugin.getString("ALERT_ACTION_EMAIL_DEFAULT_RECIPIENT");
    String localhostDomain = EditorPlugin.getString("ALERT_ACTION_EMAIL_DEFAULT_DOMAIN");
    static SimpleDateFormat sdf = new SimpleDateFormat();
    boolean trigger;
    String name;
    double value;
    double time;

    public AlertActionControl getControl(Composite c) {
        return new EmailControl(c, this);
    }

    public String getDescription() {
        return EditorPlugin.getString("ALERT_ACTION_NAME_EMAIL") + " (" + this.recipients + ")";
    }

    public String getProviderName() {
        return EditorPlugin.getString("ALERT_ACTION_NAME_EMAIL");
    }

    public void setInformation(String name, SDSnapshotObservation obs, double value, double time, boolean trigger) {
        this.name = name;
        this.value = value;
        this.time = time;
        this.trigger = trigger;
    }

    public void run() {
        try {
            Mailer m = new Mailer(this.host, this.port);
            String subject = this.trigger ? sdf.format(new Date((long)this.time)) + " - " + EditorPlugin.getString("ALERT_ALERT") + " " + this.name + " " + EditorPlugin.getString("ALERT_TRIGGERED_AT") + " " + this.value : sdf.format(new Date((long)this.time)) + " - " + EditorPlugin.getString("ALERT_ALERT") + " " + this.name + " " + EditorPlugin.getString("ALERT_RESET_AT") + " " + this.value;
            String message = subject;
            m.send(this.sender, this.recipients, this.localhostDomain, subject, message);
        }
        catch (Exception e) {
            EditorPlugin.DBG.warning("error sending alert email " + e);
        }
    }

    public Object clone() {
        EmailAlertAction action = new EmailAlertAction();
        action.host = this.host;
        action.port = this.port;
        action.recipients = this.recipients;
        action.localhostDomain = this.localhostDomain;
        return action;
    }
}

