/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.variableloader.internal;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDCounterDescriptor;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDGenericVariable;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDMeasuredVariableRepresentation;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDVariableModifierProxy;
import org.eclipse.swt.graphics.Image;

public class SDMeasuredVariable
extends SDGenericVariable
implements SDMeasuredVariableRepresentation {
    Object value = null;
    int type = -1;
    StatisticalFactory factory = StatisticalFactory.eINSTANCE;
    SDDescriptor descriptor;
    SDVariableModifierProxy modifier;
    SDCounterDescriptor measured_desc;
    SDSnapshotObservation measured;
    Object last_measured;
    long last_time;

    public int getMeasuredType() {
        return this.type;
    }

    SDMeasuredVariable(String unique_id, String name, String description, Image image, boolean has_bar, int type, SDDescriptor descriptor, SDSampleWindow window) {
        super(unique_id, name, description, image, has_bar);
        this.type = type;
        this.descriptor = descriptor;
        if (type == 4) {
            this.measured = this.factory.createSDTextObservation();
            this.last_measured = null;
        } else {
            this.measured = this.factory.createSDContiguousObservation();
            this.last_measured = null;
        }
        this.measured.setWindow(window);
        this.measured_desc = this.factory.createSDCounterDescriptor();
        this.measured_desc.setParent(descriptor);
        this.measured_desc.setName(name + " - " + EditorPlugin.getString("MEASURED"));
        this.measured_desc.setDescription(description);
        this.measured.setMemberDescriptor((SDMemberDescriptor)this.measured_desc);
    }

    public SDSnapshotObservation getMeasuredObservation() {
        return this.measured;
    }

    public Object getLastMeasuredValue() {
        return this.last_measured;
    }

    public long getLastMeasuredTime() {
        return this.last_time;
    }

    private void addMeasuredValue(long t, Double d) {
        SDContiguousObservation obs = (SDContiguousObservation)this.measured;
        BasicEList times = (BasicEList)obs.getCreationTime();
        BasicEList values = (BasicEList)obs.getValue();
        this.addValue(times, values, t, d);
        this.last_measured = d;
        this.last_time = t;
    }

    private void addMeasuredValue(long t, String s) {
        SDTextObservation obs = (SDTextObservation)this.measured;
        BasicEList times = (BasicEList)obs.getCreationTime();
        BasicEList values = (BasicEList)obs.getTextValue();
        this.addValue(times, values, t, s);
        this.last_measured = s;
        this.last_time = t;
    }

    public void setMeasuredValue(long t, int i) throws ClassCastException {
        this.addMeasuredValue(t, new Double(i));
    }

    public void setMeasuredValue(long t, long i) throws ClassCastException {
        this.addMeasuredValue(t, new Double(i));
    }

    public void setMeasuredValue(long t, float i) throws ClassCastException {
        this.addMeasuredValue(t, new Double(i));
    }

    public void setMeasuredValue(long t, double i) throws ClassCastException {
        this.addMeasuredValue(t, new Double(i));
    }

    public void setMeasuredValue(long t, Object newval) throws ClassCastException {
        if (this.type == 4) {
            this.addMeasuredValue(t, (String)newval);
        } else {
            this.addMeasuredValue(t, new Double(((Number)newval).doubleValue()));
        }
    }
}

