/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.alert.internal;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.SDSnapshotObservationGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertListener;

public class Alert
extends Thread {
    public String name = EditorPlugin.getString("NEW_ALERT_NAME");
    public long period = 1000L;
    public int calc_type = 0;
    public double lower = 0.0;
    public double upper = 100.0;
    public boolean max_trigger = true;
    public AlertAction[] trigger_actions = new AlertAction[0];
    public AlertAction[] reset_actions = new AlertAction[0];
    public SDSnapshotObservation observation;
    boolean die;
    SDSnapshotObservationGraphSource gsource;
    EList times;
    EList values;
    int timesPtr = 0;
    boolean triggered = false;
    double lastTime = Double.MIN_VALUE;
    ArrayList listeners = new ArrayList();
    Object LOCK = new Object();

    public void addAlertListener(AlertListener listener) {
        this.listeners.add(listener);
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    public void shutdown() {
        this.die = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Object object = this.LOCK;
        synchronized (object) {
            this.timesPtr = 0;
            this.lastTime = Double.MIN_VALUE;
            this.triggered = false;
        }
    }

    public Alert() {
    }

    public Alert(SDContiguousObservation obs) {
        this.init(obs);
    }

    public void init(SDContiguousObservation obs) {
        this.times = obs.getCreationTime();
        this.values = obs.getValue();
        this.timesPtr = Math.max(0, this.times.size() - 1);
        this.observation = obs;
        this.gsource = new SDSnapshotObservationGraphSource(obs);
        this.setDaemon(true);
        this.start();
    }

    public Alert(SDDiscreteObservation obs) {
        this.times = obs.getCreationTime();
        this.values = obs.getValue();
        this.timesPtr = Math.max(0, this.times.size() - 1);
        this.observation = obs;
        this.gsource = new SDSnapshotObservationGraphSource(obs);
        this.start();
    }

    private double getValueBetween(double t1, double t2) {
        if (this.calc_type == 0) {
            return this.gsource.getAverageBetween(t1, t2);
        }
        if (this.calc_type == 7) {
            return this.gsource.getCountBetween(t1, t2);
        }
        if (this.calc_type == 2) {
            return this.gsource.getMaxBetween(t1, t2);
        }
        if (this.calc_type == 1) {
            return this.gsource.getMinBetween(t1, t2);
        }
        if (this.calc_type == 6) {
            return this.gsource.getValueAt(t1);
        }
        if (this.calc_type == 8) {
            return this.gsource.getStandardDeviationBetween(t1, t2);
        }
        if (this.calc_type == 5) {
            return this.gsource.getSumBetween(t1, t2);
        }
        this.calc_type = 0;
        return this.gsource.getAverageBetween(t1, t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.die) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Object e = this.LOCK;
                synchronized (e) {
                    if (this.times.size() > this.timesPtr) {
                        double time;
                        if (this.lastTime != Double.MIN_VALUE) {
                            time = this.lastTime;
                        } else {
                            time = ((Number)this.times.get(this.timesPtr)).doubleValue();
                            time -= time % (double)this.period;
                        }
                        double latestTimestamp = ((Number)this.times.get(this.times.size() - 1)).doubleValue();
                        double curr = this.getValueBetween(time, time + (double)this.period);
                        while (latestTimestamp > time + (double)this.period) {
                            if (!Double.isNaN(curr)) {
                                if (curr >= this.upper) {
                                    if (this.max_trigger && !this.triggered) {
                                        this.trigger(time, curr);
                                    } else if (!this.max_trigger && this.triggered) {
                                        this.reset(time, curr);
                                    }
                                } else if (curr <= this.lower) {
                                    if (this.max_trigger && this.triggered) {
                                        this.reset(time, curr);
                                    } else if (!this.max_trigger && !this.triggered) {
                                        this.trigger(time, curr);
                                    }
                                }
                            }
                            curr = this.getValueBetween(time += (double)this.period, time + (double)this.period);
                        }
                        this.lastTime = time;
                        this.timesPtr = this.times.size();
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void trigger(double time, double value) {
        this.triggered = true;
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                AlertListener listener = (AlertListener)this.listeners.get(i);
                listener.alertTriggered(this);
            }
            catch (Throwable t) {
                EditorPlugin.DBG.error("Error notifying alert listener of trigger", t);
            }
            ++i;
        }
        int n = 0;
        while (n < this.trigger_actions.length) {
            AlertAction trigger_action = this.trigger_actions[n];
            trigger_action.setInformation(this.name, this.observation, value, time, true);
            trigger_action.run();
            ++n;
        }
    }

    public void reset(double time, double value) {
        this.triggered = false;
        int i = 0;
        while (i < this.listeners.size()) {
            try {
                AlertListener listener = (AlertListener)this.listeners.get(i);
                listener.alertReset(this);
            }
            catch (Throwable t) {
                EditorPlugin.DBG.error("Error notifying alert listener of reset", t);
            }
            ++i;
        }
        int n = 0;
        while (n < this.reset_actions.length) {
            AlertAction reset_action = this.reset_actions[n];
            reset_action.setInformation(this.name, this.observation, value, time, false);
            reset_action.run();
            ++n;
        }
    }
}

