/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.IndicatorSource;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class HistogramGraph
implements Graph {
    GraphSource source;
    ZoomSlider yslider;
    TimeZoomSlider xslider;
    Color fg_col;
    int line_width = 1;
    int line_style = 1;
    double scaling = 1.0;
    double xoffset = 0.0;
    double yoffset = 0.0;

    public HistogramGraph(GraphSource source, TimeZoomSlider xslider, ZoomSlider yslider, Color col) {
        this.source = source;
        this.fg_col = col;
        this.xslider = xslider;
        this.yslider = yslider;
    }

    public BasicGraphSource getGraphSource() {
        return this.source;
    }

    public void setIndicatorSource(IndicatorSource isource) {
    }

    public double getXMin() {
        return this.source.getMin();
    }

    public double getXMax() {
        return this.source.getMax();
    }

    public double getYMin() {
        return this.source.getValueMin();
    }

    public double getYMax() {
        return this.source.getValueMax();
    }

    public void setForeground(Color col) {
        this.fg_col = col;
    }

    public Color getForeground() {
        return this.fg_col;
    }

    public void setLineWidth(int w) {
        this.line_width = w;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setLineStyle(int swt_line_style) {
        this.line_style = swt_line_style;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public void setUseIndicator(boolean b) {
    }

    public void paintGraph(GC gc, int x, int y, int w, int h) {
        gc.setForeground(this.fg_col);
        gc.setLineWidth(this.line_width);
        gc.setLineStyle(this.line_style);
        double start = this.xslider.getMinVisible();
        double end = this.xslider.getMaxVisible();
        double res = this.xslider.getIncrement();
        int yzero = (int)this.yslider.value2Pixel(0.0);
        double i = start;
        while (i <= end) {
            double cx = i;
            double cy = this.source.getValueAt(cx);
            if (Double.isNaN(cy) || Double.isInfinite(cy)) {
                cy = 0.0;
            }
            double pixel_x = this.xslider.value2Pixel(cx);
            double pixel_y = this.yslider.value2Pixel(cy *= this.scaling);
            gc.drawLine((int)pixel_x, yzero, (int)pixel_x, (int)pixel_y);
            i += res;
        }
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setXSlider(TimeZoomSlider slider) {
        this.xslider = slider;
    }

    public void setYSlider(ZoomSlider slider) {
        this.yslider = slider;
    }

    public void setStaticScaling(double mult) {
        this.scaling = mult;
    }

    public double getStaticScaling() {
        return this.scaling;
    }

    public int getPlottingType() {
        return 0;
    }

    public void setPlottingType(int type) {
    }

    public void setPlottingPeriod(int type, double value) {
    }

    public int getPlottingPeriodType() {
        return 0;
    }

    public double getPlottingPeriodValue() {
        return 1.0;
    }

    public void setXOffset(double millis) {
        this.xoffset = millis;
    }

    public double getXOffset() {
        return this.xoffset;
    }

    public void setYOffset(double millis) {
        this.yoffset = millis;
    }

    public double getYOffset() {
        return this.yoffset;
    }

    public int getNoDataBehaviour() {
        return 0;
    }

    public void setNoDataBehaviour(int i) {
    }
}

