/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.IndicatorSource;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomIndicator;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderTick;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class LineGraph
implements Graph {
    private static final boolean DRAW_ONLY_IF_DATA = true;
    private static final boolean DRAW_LINE_FOR_DATA_POINT = true;
    private static final int PLOTTING_TYPE_STDDEV_AVERAGE_PLUS = -9990;
    private static final int PLOTTING_TYPE_STDDEV_AVERAGE_MINUS = -9991;
    GraphSource source;
    ZoomSlider yslider;
    TimeZoomSlider xslider;
    Color fg_col;
    int line_width = 2;
    int line_style = 1;
    int plotting_type = 0;
    int plotting_period_type = 0;
    double plotting_period_value = 1.0;
    int nodata = 1;
    double xoffset = 0.0;
    double yoffset = 0.0;
    double scaling = 1.0;
    double last_drawn_value = 0.0;
    boolean use_indicators = true;
    ZoomIndicator indicator;
    IndicatorSource isource;
    double recentMaxValue = Double.MIN_VALUE;
    double tmpMaxValue = 0.0;

    public LineGraph(int type, GraphSource source, TimeZoomSlider xslider, ZoomSlider yslider, Color col) {
        this.plotting_period_type = type;
        this.source = source;
        this.fg_col = col;
        this.xslider = xslider;
        this.yslider = yslider;
        this.init();
    }

    public LineGraph(int type, GraphSource source, TimeZoomSlider xslider, ZoomSlider yslider, Color col, boolean pixel_perfect, boolean use_indicators) {
        this.plotting_period_type = type;
        this.source = source;
        this.fg_col = col;
        this.xslider = xslider;
        this.yslider = yslider;
        if (pixel_perfect) {
            this.plotting_period_type = 2;
            this.plotting_period_value = 1.0;
        } else {
            this.plotting_period_type = 0;
            this.plotting_period_value = 1.0;
        }
        this.use_indicators = use_indicators;
        this.init();
    }

    public BasicGraphSource getGraphSource() {
        return this.source;
    }

    private void init() {
        if (this.use_indicators) {
            this.indicator = new ZoomIndicator(this.yslider, this.last_drawn_value, this.fg_col);
            this.yslider.addZoomIndicator(this.indicator);
        }
    }

    public void setIndicatorSource(IndicatorSource source) {
        this.isource = source;
    }

    public void setUseIndicator(boolean b) {
        if (this.use_indicators && !b) {
            this.yslider.removeIndicator(this.indicator);
            this.indicator.dispose();
        } else if (!this.use_indicators && b) {
            this.indicator = new ZoomIndicator(this.yslider, this.last_drawn_value, this.fg_col);
            this.yslider.addZoomIndicator(this.indicator);
        }
        this.use_indicators = b;
    }

    public double getXMin() {
        return this.source.getMin();
    }

    public double getXMax() {
        return this.source.getMax();
    }

    public double getYMin() {
        return this.source.getValueMin();
    }

    public double getYMax() {
        return this.source.getValueMax();
    }

    public void setForeground(Color col) {
        this.fg_col = col;
        if (this.use_indicators) {
            this.indicator.setColor(col);
        }
    }

    public Color getForeground() {
        return this.fg_col;
    }

    public void setLineWidth(int w) {
        this.line_width = w;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setLineStyle(int swt_line_style) {
        this.line_style = swt_line_style;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public int getNoDataBehaviour() {
        return this.nodata;
    }

    public void setNoDataBehaviour(int behaviour) {
        this.nodata = behaviour;
    }

    public double getRecentMaxValue() {
        return this.recentMaxValue;
    }

    public void paintGraph(GC gc, int x, int y, int w, int h) {
        this.tmpMaxValue = Double.MIN_VALUE;
        gc.setForeground(this.fg_col);
        gc.setLineWidth(this.line_width);
        gc.setLineStyle(this.line_style);
        ZoomSliderTick tick_start = this.xslider.getFirstTick();
        ZoomSliderTick tick_end = this.xslider.getLastTick();
        if (tick_start == null || tick_end == null) {
            return;
        }
        double res = this.xslider.getIncrement();
        double start = tick_start.value - res;
        double end = tick_end.value + res;
        if (this.plotting_period_type == 0) {
            res = this.xslider.getIncrement();
            res *= this.plotting_period_value;
        } else if (this.plotting_period_type == 2) {
            res = this.xslider.pixel2Value(1.0) - this.xslider.pixel2Value(0.0);
            res *= this.plotting_period_value;
        } else if (this.plotting_period_type == 1) {
            res = this.plotting_period_value;
            if (res < 10.0) {
                res = 10.0;
            }
        } else if (this.plotting_period_type == 3) {
            res = 10.0;
        }
        start -= start % res;
        if (this.plotting_type == 3) {
            this.paintGraph(gc, x, y, start, end, res, 1);
            this.paintGraph(gc, x, y, start, end, res, 2);
        } else if (this.plotting_type == 4) {
            this.paintGraph(gc, x, y, start, end, res, 1);
            this.paintGraph(gc, x, y, start, end, res, 2);
            this.paintGraph(gc, x, y, start, end, res, 0);
        } else if (this.plotting_type == 9) {
            this.paintGraph(gc, x, y, start, end, res, -9990);
            this.paintGraph(gc, x, y, start, end, res, -9991);
            this.paintGraph(gc, x, y, start, end, res, 0);
        } else {
            this.paintGraph(gc, x, y, start, end, res, this.plotting_type);
        }
    }

    public void paintGraph(GC gc, int xorigin, int yorigin, double start, double end, double res, int plot_type) {
        boolean found_indicator = false;
        double indicator_loc = this.isource.getIndicatorLocation();
        double indicator_val = this.last_drawn_value;
        int indicator_type = this.isource.getSourceType();
        boolean first = true;
        double px = 0.0;
        double py = 0.0;
        double last_clean_cy = 0.0;
        double last_cy = 0.0;
        boolean empty = false;
        double i = start;
        while (i <= end) {
            double cx = i;
            double cx_shifted = cx - this.xoffset;
            if (!(cx_shifted > this.source.getMax() + res) && !(cx_shifted < this.source.getMin() - res)) {
                double pixel_y;
                double pixel_x;
                double cy = 0.0;
                cy = plot_type == 6 ? this.source.getValueAt(cx_shifted) : (plot_type == 0 ? this.source.getAverageBetween(cx_shifted - res, cx_shifted) : (plot_type == 5 ? this.source.getSumBetween(cx_shifted - res, cx_shifted) : (plot_type == 1 ? this.source.getMinBetween(cx_shifted - res, cx_shifted) : (plot_type == 2 ? this.source.getMaxBetween(cx_shifted - res, cx_shifted) : (plot_type == 7 ? this.source.getCountBetween(cx_shifted - res, cx_shifted) : (plot_type == 8 ? this.source.getStandardDeviationBetween(cx_shifted - res, cx_shifted) : (plot_type == -9990 ? this.source.getAverageBetween(cx_shifted - res, cx_shifted) + this.source.getStandardDeviationBetween(cx_shifted - res, cx_shifted) : (plot_type == -9991 ? this.source.getAverageBetween(cx_shifted - res, cx_shifted) - this.source.getStandardDeviationBetween(cx_shifted - res, cx_shifted) : this.source.getAverageBetween(cx_shifted - res, cx_shifted)))))))));
                if (first) {
                    first = false;
                    empty = Double.isNaN(cy);
                    if (empty && this.nodata == 0) {
                        first = true;
                        pixel_x = this.xslider.value2Pixel(cx);
                        pixel_y = py;
                    } else {
                        if (empty && this.nodata == 2) {
                            cy = last_clean_cy;
                        } else if (empty && this.nodata == 1) {
                            cy = 0.0;
                        }
                        last_clean_cy = cy;
                        cy += this.yoffset;
                        last_cy = cy *= this.scaling;
                        pixel_x = this.xslider.value2Pixel(cx);
                        pixel_y = this.yslider.value2Pixel(cy);
                        if (cy > this.tmpMaxValue) {
                            this.tmpMaxValue = cy;
                        }
                        gc.drawLine(xorigin + (int)pixel_x, yorigin + (int)pixel_y, xorigin + (int)pixel_x, yorigin + (int)pixel_y);
                    }
                } else {
                    boolean emptyPrevious = empty;
                    empty = Double.isNaN(cy);
                    if (empty && this.nodata == 0) {
                        first = true;
                        pixel_x = this.xslider.value2Pixel(cx);
                        pixel_y = py;
                        if (indicator_type == 0 && indicator_loc > cx - res && indicator_loc < cx) {
                            found_indicator = true;
                            indicator_val = 0.0;
                        }
                        if (indicator_type == 1 && indicator_loc > px && indicator_loc < pixel_x) {
                            found_indicator = true;
                            indicator_val = 0.0;
                        }
                        if (!emptyPrevious) {
                            gc.drawLine(xorigin + (int)px, yorigin + (int)py, xorigin + (int)pixel_x, yorigin + (int)py);
                        }
                    } else {
                        if (empty && this.nodata == 2) {
                            cy = last_clean_cy;
                        } else if (empty && this.nodata == 1) {
                            cy = 0.0;
                        }
                        last_clean_cy = cy;
                        cy += this.yoffset;
                        cy *= this.scaling;
                        if (indicator_type == 0 && indicator_loc > cx - res && indicator_loc < cx) {
                            found_indicator = true;
                            indicator_val = cy;
                        }
                        last_cy = cy;
                        pixel_x = this.xslider.value2Pixel(cx);
                        pixel_y = this.yslider.value2Pixel(cy);
                        if (cy > this.tmpMaxValue) {
                            this.tmpMaxValue = cy;
                        }
                        if (indicator_type == 1 && indicator_loc > px && indicator_loc < pixel_x) {
                            found_indicator = true;
                            indicator_val = cy;
                        }
                        gc.drawLine(xorigin + (int)px, yorigin + (int)py, xorigin + (int)pixel_x, yorigin + (int)pixel_y);
                    }
                }
                px = pixel_x;
                py = pixel_y;
            }
            i += res;
        }
        this.last_drawn_value = last_cy;
        this.recentMaxValue = this.tmpMaxValue;
        if (this.isource == null || !found_indicator) {
            this.indicator.setBaseValue(this.yoffset);
            this.indicator.setValue(this.last_drawn_value);
        } else {
            this.indicator.setBaseValue(this.yoffset);
            this.indicator.setValue(indicator_val);
        }
        this.yslider.updateIndicators();
    }

    public void paintGraphNearest(GC gc, int x, int y, int w, int h) {
    }

    public int getPlottingType() {
        return this.plotting_type;
    }

    public void setPlottingType(int type) {
        this.plotting_type = type;
    }

    public void setPlottingPeriod(int type, double value) {
        this.plotting_period_type = type;
        this.plotting_period_value = value;
    }

    public int getPlottingPeriodType() {
        return this.plotting_period_type;
    }

    public double getPlottingPeriodValue() {
        return this.plotting_period_value;
    }

    public void setXOffset(double millis) {
        this.xoffset = millis;
    }

    public double getXOffset() {
        return this.xoffset;
    }

    public void setYOffset(double millis) {
        this.yoffset = millis;
    }

    public double getYOffset() {
        return this.yoffset;
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setXSlider(TimeZoomSlider slider) {
        this.xslider = slider;
    }

    public void setYSlider(ZoomSlider slider) {
        if (this.use_indicators) {
            this.yslider.removeIndicator(this.indicator);
            this.indicator.dispose();
        }
        this.yslider = slider;
        if (this.use_indicators) {
            this.indicator = new ZoomIndicator(this.yslider, this.last_drawn_value, this.fg_col);
            this.yslider.addZoomIndicator(this.indicator);
        }
    }

    public void setStaticScaling(double mult) {
        this.scaling = mult;
    }

    public double getStaticScaling() {
        return this.scaling;
    }
}

