/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.trace.CallStackPerThread;
import org.eclipse.hyades.loaders.trace.TraceMethodBaseLoader;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;

public class XMLmethodExitLoader
extends TraceMethodBaseLoader {
    protected static final String OVERHEAD = "overhead";
    protected double overhead;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$trace$CallStackPerThread;

    public void addAttribute(String name, String value) {
        if (!this.loadToModel) {
            return;
        }
        switch (LoadersUtils.getHashCode((String)name)) {
            case 529694900: {
                this.overhead = Double.parseDouble(value);
                break;
            }
            case 111972721: {
                if (this.objectValue == null) break;
                this.objectValue.setStringValue(value);
                break;
            }
            default: {
                super.addAttribute(name, value);
            }
        }
    }

    public void addYourselfInContext() {
        if (!this.loadToModel) {
            return;
        }
        this.cs = (CallStackPerThread)LookupServiceExtensions.getInstance().locate(this.context, class$org$eclipse$hyades$loaders$trace$CallStackPerThread == null ? (class$org$eclipse$hyades$loaders$trace$CallStackPerThread = XMLmethodExitLoader.class$("org.eclipse.hyades.loaders.trace.CallStackPerThread")) : class$org$eclipse$hyades$loaders$trace$CallStackPerThread, LoadersUtils.getLookUpKey((int)this.threadIdRef));
        if (this.cs == null || this.cs.isEmpty()) {
            return;
        }
        this.invocationPool = this.cs.invocationPool;
        this.theProcess = this.getProcess();
        this.dispatchProcessMode(0);
    }

    public void initialize(HierarchyContext context, String name) {
        this.loadToModel = context.isLoadToModel();
        if (!this.loadToModel) {
            return;
        }
        super.initialize(context, name);
        this.activeInvocationContext = false;
        this.overhead = 0.0;
        this.stackDepth = 0;
        this.ticket = 0L;
        this.sequenceCounter = 0L;
        this.inputValues.clear();
        this.outputValues.clear();
        this.objectValue = null;
    }

    protected void processEF(int step) {
        super.processEF(step);
        this.fullInvocation = ((TraceUtils.InvocationInfo)this.cs.peek()).getMethodInvocation();
        if (this.fullInvocation != null) {
            this.theThread = this.fullInvocation.getThread();
            this.fullInvocation.setExitTime(this.createDeltaTime());
            this.fullInvocation.setOverhead(this.overhead);
            this.addInputOutputValues();
            this.updateStatisticalInfo();
            this.invocationPool.release((TraceUtils.InvocationInfo)this.cs.pop());
        }
    }

    protected void processES(int step) {
        super.processES(step);
        this.updateStatisticalInfoOnly();
    }

    private void updateStatisticalInfo() {
        try {
            int size = this.fullInvocation.getInvokes().size();
            if (size > 0) {
                this.lastChildExitTime = ((TRCFullMethodInvocation)this.fullInvocation.getInvokes().get(size - 1)).getExitTime();
                this.deltaBaseTime = this.fullInvocation.getExitTime() - this.lastChildExitTime - this.fullInvocation.getOverhead();
            } else {
                this.deltaBaseTime = this.fullInvocation.getExitTime() - this.fullInvocation.getEntryTime() - this.fullInvocation.getOverhead();
            }
            this.invokerMethod = this.fullInvocation.getMethod();
            this.invokerObject = (TRCFullTraceObject)this.fullInvocation.getOwningObject();
            this.invokerClass = this.fullInvocation.getMethod().getDefiningClass();
            this.invokerObjectClass = this.getExtendedClass(this.invokerObject, this.invokerClass);
            this.updateTimeStatistics();
        }
        catch (Exception e) {
            LoadersUtils.log((Throwable)e);
        }
    }

    private void updateStatisticalInfoOnly() {
        try {
            TraceUtils.InvocationInfo invoker;
            TraceUtils.InvocationInfo currentInvocation = (TraceUtils.InvocationInfo)this.cs.peek();
            double exitTime = this.createDeltaTime();
            this.lastChildExitTime = currentInvocation.getLastChildExitTime();
            this.deltaBaseTime = this.lastChildExitTime > 0.0 ? exitTime - this.lastChildExitTime - this.overhead : exitTime - currentInvocation.getEntryTime() - this.overhead;
            this.invokerObject = currentInvocation.getObject();
            this.invokerClass = currentInvocation.getTheClass();
            this.invokerObjectClass = currentInvocation.getObjectClass();
            this.invokerMethod = currentInvocation.getMethod();
            this.updateTimeStatistics();
            this.invocationPool.release((TraceUtils.InvocationInfo)this.cs.pop());
            if (!this.cs.isEmpty() && (invoker = (TraceUtils.InvocationInfo)this.cs.peek()) != null) {
                invoker.setLastChildExitTime(exitTime);
            }
            this.theProcess.setLastEventTime(exitTime);
        }
        catch (Exception e) {
            LoadersUtils.log((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

