/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;
import org.eclipse.hyades.models.cbe.CBEAvailableSituation;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEComponentIdentification;
import org.eclipse.hyades.models.cbe.CBEConfigureSituation;
import org.eclipse.hyades.models.cbe.CBEConnectSituation;
import org.eclipse.hyades.models.cbe.CBEContextDataElement;
import org.eclipse.hyades.models.cbe.CBECreateSituation;
import org.eclipse.hyades.models.cbe.CBEDependencySituation;
import org.eclipse.hyades.models.cbe.CBEDestroySituation;
import org.eclipse.hyades.models.cbe.CBEExtendedDataElement;
import org.eclipse.hyades.models.cbe.CBEFeatureSituation;
import org.eclipse.hyades.models.cbe.CBEMsgDataElement;
import org.eclipse.hyades.models.cbe.CBEOtherSituation;
import org.eclipse.hyades.models.cbe.CBEReportSituation;
import org.eclipse.hyades.models.cbe.CBERequestSituation;
import org.eclipse.hyades.models.cbe.CBESituation;
import org.eclipse.hyades.models.cbe.CBEStartSituation;
import org.eclipse.hyades.models.cbe.CBEStopSituation;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;

public class CbeEmfUtility {
    protected static EventFactory _eventFactory = EventFactoryContext.getInstance().getEventFactoryHome("org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl").getEventFactory("org.eclipse.hyades.logging.ui");

    public static CommonBaseEvent convertCbe(CBECommonBaseEvent cbe, Hashtable associationMaps) {
        CBESituation sit;
        CBEComponentIdentification scid;
        CommonBaseEvent cbe2 = _eventFactory.createCommonBaseEvent();
        cbe2.setLocalInstanceId(cbe.getLocalInstanceId());
        cbe2.setGlobalInstanceId(cbe.getGlobalInstanceId());
        cbe2.setCreationTime(CbeEmfUtility.formatCreationTime(cbe));
        cbe2.setSeverity(cbe.getSeverity());
        cbe2.setPriority(cbe.getPriority());
        CBEComponentIdentification rcid = cbe.getReporterComponentId();
        if (rcid != null) {
            ComponentIdentification rcid2 = _eventFactory.createComponentIdentification();
            cbe2.setReporterComponentId(rcid2);
            rcid2.setLocation(rcid.getLocation());
            rcid2.setLocationType(rcid.getLocationType());
            rcid2.setApplication(rcid.getApplication());
            rcid2.setExecutionEnvironment(rcid.getExecutionEnvironment());
            rcid2.setComponent(rcid.getComponent());
            rcid2.setSubComponent(rcid.getSubComponent());
            rcid2.setComponentIdType(rcid.getComponentIdType());
            rcid2.setInstanceId(rcid.getInstanceId());
            rcid2.setProcessId(rcid.getProcessId());
            rcid2.setThreadId(rcid.getThreadId());
            rcid2.setComponentType(rcid.getComponentType());
        }
        if ((scid = cbe.getSourceComponentId()) != null) {
            ComponentIdentification scid2 = _eventFactory.createComponentIdentification();
            cbe2.setSourceComponentId(scid2);
            scid2.setLocation(scid.getLocation());
            scid2.setLocationType(scid.getLocationType());
            scid2.setApplication(scid.getApplication());
            scid2.setExecutionEnvironment(scid.getExecutionEnvironment());
            scid2.setComponent(scid.getComponent());
            scid2.setSubComponent(scid.getSubComponent());
            scid2.setComponentIdType(scid.getComponentIdType());
            scid2.setInstanceId(scid.getInstanceId());
            scid2.setProcessId(scid.getProcessId());
            scid2.setThreadId(scid.getThreadId());
            scid2.setComponentType(scid.getComponentType());
        }
        if ((sit = cbe.getSituation()) != null) {
            StartSituation sittype2;
            CBEStartSituation sittype;
            Situation sit2 = _eventFactory.createSituation();
            cbe2.setSituation(sit2);
            sit2.setCategoryName(sit.getCategoryName());
            if (sit instanceof CBEStartSituation) {
                sittype = (CBEStartSituation)sit;
                sittype2 = _eventFactory.createStartSituation();
                sit2.setSituationType((SituationType)sittype2);
                sittype2.setReasoningScope(sittype.getReasoningScope());
                sittype2.setSuccessDisposition(sittype.getSuccessDisposition());
                sittype2.setSituationQualifier(sittype.getSituationQualifier());
            } else if (sit instanceof CBEStopSituation) {
                sittype = (CBEStopSituation)sit;
                sittype2 = _eventFactory.createStopSituation();
                sit2.setSituationType((SituationType)sittype2);
                sittype2.setReasoningScope(sittype.getReasoningScope());
                sittype2.setSuccessDisposition(sittype.getSuccessDisposition());
                sittype2.setSituationQualifier(sittype.getSituationQualifier());
            } else if (sit instanceof CBEConnectSituation) {
                sittype = (CBEConnectSituation)sit;
                sittype2 = _eventFactory.createConnectSituation();
                sit2.setSituationType((SituationType)sittype2);
                sittype2.setReasoningScope(sittype.getReasoningScope());
                sittype2.setSuccessDisposition(sittype.getSuccessDisposition());
                sittype2.setSituationDisposition(sittype.getSituationDisposition());
            } else if (sit instanceof CBERequestSituation) {
                sittype = (CBERequestSituation)sit;
                sittype2 = _eventFactory.createRequestSituation();
                sit2.setSituationType((SituationType)sittype2);
                sittype2.setReasoningScope(sittype.getReasoningScope());
                sittype2.setSuccessDisposition(sittype.getSuccessDisposition());
                sittype2.setSituationQualifier(sittype.getSituationQualifier());
            } else if (sit instanceof CBEConfigureSituation) {
                sittype = (CBEConfigureSituation)sit;
                sittype2 = _eventFactory.createConfigureSituation();
                sit2.setSituationType((SituationType)sittype2);
                sittype2.setReasoningScope(sittype.getReasoningScope());
                sittype2.setSuccessDisposition(sittype.getSuccessDisposition());
            } else if (sit instanceof CBEAvailableSituation) {
                sittype = (CBEAvailableSituation)sit;
                sittype2 = _eventFactory.createAvailableSituation();
                sit2.setSituationType((SituationType)sittype2);
                sittype2.setReasoningScope(sittype.getReasoningScope());
                sittype2.setOperationDisposition(sittype.getOperationDisposition());
                sittype2.setAvailabilityDisposition(sittype.getAvailabilityDisposition());
                sittype2.setProcessingDisposition(sittype.getProcessingDisposition());
            } else if (sit instanceof CBEReportSituation) {
                sittype = (CBEReportSituation)sit;
                sittype2 = _eventFactory.createReportSituation();
                sit2.setSituationType((SituationType)sittype2);
                sittype2.setReasoningScope(sittype.getReasoningScope());
                sittype2.setReportCategory(sittype.getReportCategory());
            } else if (sit instanceof CBECreateSituation) {
                sittype = (CBECreateSituation)sit;
                sittype2 = _eventFactory.createCreateSituation();
                sit2.setSituationType((SituationType)sittype2);
                sittype2.setReasoningScope(sittype.getReasoningScope());
                sittype2.setSuccessDisposition(sittype.getSuccessDisposition());
            } else if (sit instanceof CBEDestroySituation) {
                sittype = (CBEDestroySituation)sit;
                sittype2 = _eventFactory.createDestroySituation();
                sit2.setSituationType((SituationType)sittype2);
                sittype2.setReasoningScope(sittype.getReasoningScope());
                sittype2.setSuccessDisposition(sittype.getSuccessDisposition());
            } else if (sit instanceof CBEFeatureSituation) {
                sittype = (CBEFeatureSituation)sit;
                sittype2 = _eventFactory.createFeatureSituation();
                sit2.setSituationType((SituationType)sittype2);
                sittype2.setReasoningScope(sittype.getReasoningScope());
                sittype2.setFeatureDisposition(sittype.getFeatureDisposition());
            } else if (sit instanceof CBEDependencySituation) {
                sittype = (CBEDependencySituation)sit;
                sittype2 = _eventFactory.createDependencySituation();
                sit2.setSituationType((SituationType)sittype2);
                sittype2.setReasoningScope(sittype.getReasoningScope());
                sittype2.setDependencyDisposition(sittype.getDependencyDisposition());
            } else if (sit instanceof CBEOtherSituation) {
                sittype = (CBEOtherSituation)sit;
                sittype2 = _eventFactory.createOtherSituation();
                sit2.setSituationType((SituationType)sittype2);
                sittype2.setReasoningScope(sittype.getReasoningScope());
            }
        }
        EList ctes = cbe.getContextDataElements();
        ContextDataElement[] ctes2 = new ContextDataElement[ctes.size()];
        int i = 0;
        while (i < ctes.size()) {
            CBEContextDataElement cte = (CBEContextDataElement)ctes.get(i);
            ContextDataElement cte2 = _eventFactory.createContextDataElement();
            cte2.setType(cte.getType());
            cte2.setName(cte.getName());
            cte2.setContextValue(cte.getContextValue());
            cte2.setContextId(cte.getContextId());
            ctes2[i] = cte2;
            ++i;
        }
        CBEMsgDataElement mde = cbe.getMsgDataElement();
        if (mde != null) {
            MsgDataElement mde2 = _eventFactory.createMsgDataElement();
            cbe2.setMsgDataElement(mde2);
            mde2.setMsgId(mde.getMsgId());
            mde2.setMsgIdType(mde.getMsgIdType());
            mde2.setMsgCatalogId(mde.getMsgCatalogId());
            EList msgCatalogTokens = mde.getMsgCatalogTokens();
            MsgCatalogToken[] msgCatalogTokens2 = new MsgCatalogToken[msgCatalogTokens.size()];
            int i2 = 0;
            while (i2 < msgCatalogTokens.size()) {
                String msgCatalogToken = (String)msgCatalogTokens.get(i2);
                MsgCatalogToken msgCatalogToken2 = _eventFactory.createMsgCatalogToken();
                msgCatalogToken2.setValue(msgCatalogToken);
                msgCatalogTokens2[i2] = msgCatalogToken2;
                ++i2;
            }
            mde2.setMsgCatalogTokens(msgCatalogTokens2);
            mde2.setMsgCatalog(mde.getMsgCatalog());
            mde2.setMsgCatalogType(mde.getMsgCatalogType());
            mde2.setMsgLocale(mde.getMsgLocale());
        }
        cbe2.setMsg(cbe.getMsg());
        cbe2.setRepeatCount(cbe.getRepeatCount());
        cbe2.setElapsedTime(cbe.getElapsedTime());
        Enumeration keys = associationMaps.keys();
        while (keys.hasMoreElements()) {
            EMap correlations;
            CorrelationContainerProxy corProxy = (CorrelationContainerProxy)keys.nextElement();
            if (corProxy == null || corProxy.getCorrelationContainer() == null || (correlations = corProxy.getCorrelationContainer().getCorrelations()) == null || correlations.get((Object)cbe) == null) continue;
            AssociationEngine asoEgn = (AssociationEngine)associationMaps.get(corProxy);
            AssociatedEvent asoEvt = _eventFactory.createAssociatedEvent();
            asoEvt.setAssociationEngine(asoEgn.getId());
            cbe2.getAssociatedEvents().add((Object)asoEvt);
            List resolvedEvents = (List)correlations.get((Object)cbe);
            int i3 = 0;
            while (i3 < resolvedEvents.size()) {
                Object cbeEvent = resolvedEvents.get(i3);
                if (cbeEvent instanceof CBECommonBaseEvent) {
                    asoEvt.addResolvedEvent(((CBECommonBaseEvent)cbeEvent).getGlobalInstanceId());
                }
                ++i3;
            }
        }
        cbe2.setExtensionName(cbe.getExtensionName());
        EList edes = cbe.getExtendedProperties();
        i = 0;
        while (i < edes.size()) {
            if (edes.get(i) instanceof CBEExtendedDataElement) {
                CBEExtendedDataElement ede = (CBEExtendedDataElement)edes.get(i);
                ExtendedDataElement ede2 = _eventFactory.createExtendedDataElement();
                cbe2.addExtendedDataElement(ede2);
                CbeEmfUtility.setEdeFields(ede, ede2);
            }
            ++i;
        }
        cbe2.setSequenceNumber(cbe.getSequenceNumber());
        return cbe2;
    }

    protected static void setEdeFields(CBEExtendedDataElement ede, ExtendedDataElement ede2) {
        String hexValue;
        ede2.setName(ede.getName());
        ede2.setType(ede.getType());
        EList values = ede.getValues();
        if (values.size() > 0) {
            String[] values2 = new String[values.size()];
            int j = 0;
            while (j < values.size()) {
                String value;
                values2[j] = value = (String)values.get(j);
                ++j;
            }
            ede2.setValues(values2);
        }
        if ((hexValue = ede.getHexValue()) != null) {
            ede2.setHexValue(hexValue);
        }
        EList children = ede.getChildren();
        int j = 0;
        while (j < children.size()) {
            CBEExtendedDataElement childEde = (CBEExtendedDataElement)children.get(j);
            ExtendedDataElement childEde2 = _eventFactory.createExtendedDataElement();
            ede2.addChild(childEde2);
            CbeEmfUtility.setEdeFields(childEde, childEde2);
            ++j;
        }
    }

    protected static String formatCreationTime(CBECommonBaseEvent event) {
        String res;
        block4: {
            res = "0";
            if (event.getCreationTime() == 0.0) break block4;
            try {
                short value = 0;
                try {
                    value = event.getTimeZone();
                }
                catch (Exception e) {
                    // empty catch block
                }
                double ct = CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)event);
                Double l2 = new Double(ct);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                res = dateFormat.format(new Date(l2.longValue() / 1000L + (long)(value * 60 * 1000)));
                String microseconds = "" + l2.longValue() % 1000000L;
                res = res + "." + "000000".substring(0, 6 - microseconds.length()) + microseconds;
                res = res + (value > 0 ? "+00" : "-00").substring(0, 3 - ("" + Math.abs(value / 60)).length()) + Math.abs(value / 60);
                res = res + ":00".substring(0, 3 - ("" + Math.abs(value % 60)).length()) + Math.abs(value % 60);
                res = res.replace(' ', 'T');
            }
            catch (Exception e) {}
        }
        return res;
    }

    public static AssociationEngine createAssociationEngine(CorrelationEngine corE) {
        AssociationEngine asoE = _eventFactory.createAssociationEngine();
        asoE.setId(corE.getId());
        asoE.setName(corE.getName());
        asoE.setType(corE.getType());
        return asoE;
    }
}

