/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.loaders.util.IPagingList;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.log.ui.internal.util.LogFindCriteria;
import org.eclipse.hyades.log.ui.internal.util.RecordFilterSearchUtil;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.util.LogQueryBuilder;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public class LogRecordSearch {
    private List cbeList;
    private Object start = null;
    private int startIndex = -1;
    private RecordFilterSearchUtil recordFilterSearch = new RecordFilterSearchUtil();
    private LogFindCriteria criteria;
    private Query searchQuery = null;
    private QueryResult queryResult = null;
    private IFilterElement[] filters = null;
    private Map options = null;
    private List searchResult;
    private int cursorIndex = -1;
    private int searchIndex = -1;
    private boolean debug = false;
    private int type;

    public void initialize(List cbeList, Object start, int type) {
        this.cbeList = cbeList;
        this.start = start;
        this.type = type;
        this.startIndex = -1;
        if (type == 0) {
            this.startIndex = this.lookForStartNodeIndex(start);
        }
    }

    public void initStartNode(Object start, int type) {
        this.start = start;
        if (type == 0) {
            this.startIndex = this.lookForStartNodeIndex(start);
        }
    }

    public Object search(SimpleSearchQuery query, LogFindCriteria newCriteria) {
        Query newQuery = LogQueryBuilder.getMergedQuery((Query)query, (ILogFilterCriteria)newCriteria);
        if (this.hasQueryChanged(newQuery)) {
            this.startIndex = -1;
            this.searchQuery = newQuery;
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    LogRecordSearch.this.queryResult = LogQueryBuilder.executeQuery((Query)LogRecordSearch.this.searchQuery, (ResourceSet)HierarchyResourceSetImpl.getInstance());
                }
            });
            ResultEntry resultEntry = (ResultEntry)this.queryResult.getResultEntries().get(0);
            this.searchResult = resultEntry.getObjects();
            this.setCriteria(newCriteria);
        } else if (this.hasDirectionChanged(newCriteria)) {
            this.criteria.setForwardDirection(newCriteria.isForwardDirection());
        }
        if (this.startIndex == -1) {
            this.startIndex = this.lookForStartCursorIndex(newCriteria.isForwardDirection());
            this.cursorIndex = this.criteria.isForwardDirection() ? this.startIndex - 1 : this.startIndex + 1;
        }
        if (this.criteria.isForwardDirection()) {
            if (this.cursorIndex < this.searchResult.size()) {
                ++this.cursorIndex;
            }
            if (this.debug) {
                System.out.println("cursorIndex = " + this.cursorIndex);
                System.out.println("result size = " + this.searchResult.size());
            }
            if (this.cursorIndex < this.searchResult.size()) {
                this.start = this.getRecord();
                return this.start;
            }
        } else if (this.cursorIndex >= 0) {
            --this.cursorIndex;
            if (this.debug) {
                System.out.println("cursorIndex = " + this.cursorIndex);
                System.out.println("result size = " + this.searchResult.size());
            }
            if (this.cursorIndex >= 0) {
                this.start = this.getRecord();
                return this.start;
            }
        }
        if (this.debug) {
            System.out.println("cursorIndex = " + this.cursorIndex);
            System.out.println("result size = " + this.searchResult.size());
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    private void setCriteria(LogFindCriteria newCriteria) {
        if (this.criteria == null) {
            this.criteria = new LogFindCriteria();
            this.criteria.setFilterOptions(new HashMap());
        }
        this.criteria.setForwardDirection(newCriteria.isForwardDirection());
        int s = newCriteria.getFilters().length;
        IFilterElement[] filters = new IFilterElement[s];
        IFilterElement[] newFilters = newCriteria.getFilters();
        int i = 0;
        while (i < s) {
            filters[i] = new FilterTableElement(newFilters[i].getAttribute(), newFilters[i].getOperator(), newFilters[i].getValue());
            ++i;
        }
        this.criteria.setFilters(filters);
        this.criteria.getFilterOptions().clear();
        if (newCriteria.getFilterOptions() != null) {
            this.criteria.getFilterOptions().putAll(newCriteria.getFilterOptions());
        }
    }

    public Object search(IFilterElement[] filterTableElements, int direction, Object lastSelection) {
        if (direction > 0) {
            return this.searchDown(filterTableElements, lastSelection);
        }
        return this.searchUp(filterTableElements, lastSelection);
    }

    private boolean hasDirectionChanged(LogFindCriteria newCriteria) {
        return this.criteria.isForwardDirection() != newCriteria.isForwardDirection();
    }

    private boolean hasQueryChanged(Query newQuery) {
        if (this.searchQuery == null && newQuery != null) {
            return true;
        }
        return !LogQueryBuilder.compare((Query)this.searchQuery, (Query)newQuery);
    }

    private boolean hasSearchCriteriaChanged(LogFindCriteria newCriteria) {
        if (this.criteria == null && newCriteria != null) {
            return true;
        }
        boolean filterHasChanged = false;
        IFilterElement[] newElements = newCriteria.getFilters();
        IFilterElement[] elements = this.criteria.getFilters();
        if (elements.length != newElements.length) {
            filterHasChanged = true;
        }
        if (!filterHasChanged) {
            int i = 0;
            while (i < elements.length) {
                if (!(elements[i].getAttribute().equals(newElements[i].getAttribute()) && elements[i].getOperator().equals(newElements[i].getOperator()) && elements[i].getValue().equals(newElements[i].getValue()))) {
                    filterHasChanged = true;
                }
                ++i;
            }
        }
        if (!(filterHasChanged || newCriteria.getFilterOptions() == null || this.criteria.getFilterOptions().get("sev1").equals(newCriteria.getFilterOptions().get("sev1")) && this.criteria.getFilterOptions().get("sev2").equals(newCriteria.getFilterOptions().get("sev2")) && this.criteria.getFilterOptions().get("sev3").equals(newCriteria.getFilterOptions().get("sev3")))) {
            filterHasChanged = true;
        }
        if (filterHasChanged) {
            this.cursorIndex = -1;
        }
        return filterHasChanged;
    }

    private int lookForStartNodeIndex(Object start) {
        if (start == null) {
            return 0;
        }
        int i = 0;
        while (i < this.cbeList.size()) {
            if (this.cbeList.get(i) instanceof CBECommonBaseEvent && start instanceof CBECommonBaseEvent && ((CBECommonBaseEvent)this.cbeList.get(i)).getGlobalInstanceId().equals(((CBECommonBaseEvent)start).getGlobalInstanceId())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private int lookForStartCursorIndex(final boolean direction) {
        this.searchIndex = 0;
        if (this.searchResult != null) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    int s = LogRecordSearch.this.searchResult.size();
                    int index = -1;
                    LogRecordSearch.this.startIndex = ((IPagingList)LogRecordSearch.this.cbeList).indexOf(LogRecordSearch.this.start);
                    if (LogRecordSearch.this.startIndex == -1) {
                        LogRecordSearch.this.startIndex = 0;
                    }
                    int i = 0;
                    while (i < s) {
                        index = ((IPagingList)LogRecordSearch.this.cbeList).indexOf(LogRecordSearch.this.searchResult.get(i), LogRecordSearch.this.startIndex);
                        if (index > -1) {
                            if (direction) {
                                LogRecordSearch.this.searchIndex = i;
                                break;
                            }
                            LogRecordSearch.this.searchIndex = i - 1;
                            break;
                        }
                        ++i;
                    }
                    if (index < 0 && !direction && s > 0) {
                        LogRecordSearch.this.searchIndex = s - 1;
                    }
                }
            });
        }
        return this.searchIndex;
    }

    private Object searchDown(IFilterElement[] filterTableElements, Object lastSelection) {
        if (lastSelection == this.start) {
            ++this.startIndex;
        }
        int i = this.startIndex;
        while (i < this.cbeList.size()) {
            if (this.recordFilterSearch.isAdvFilterApply((EObject)this.cbeList.get(i), filterTableElements)) {
                return this.cbeList.get(i);
            }
            ++i;
        }
        return null;
    }

    private Object searchUp(IFilterElement[] filterTableElements, Object lastSelection) {
        if (lastSelection == this.start) {
            --this.startIndex;
        }
        int i = this.startIndex;
        while (i >= 0) {
            if (this.recordFilterSearch.isAdvFilterApply((EObject)this.cbeList.get(i), filterTableElements)) {
                return this.cbeList.get(i);
            }
            --i;
        }
        return null;
    }

    private Object getRecord() {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                LogRecordSearch.this.start = LogRecordSearch.this.searchResult.get(LogRecordSearch.this.cursorIndex);
            }
        });
        return this.start;
    }
}

