/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sd.logc.internal.uml2sd;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.ResultEntry;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class LogAsyncReturnMessage
extends AsyncMessageReturn
implements IPropertySource {
    private List correlationList = null;
    private CBECommonBaseEvent source = null;
    private int type = 0;
    private IPropertyDescriptor[] propertyDescriptors;
    private static final String PROPERTY_LIST = "correlation.list.";

    public LogAsyncReturnMessage(int type) {
        this.type = type;
    }

    public void setSource(CBECommonBaseEvent source) {
        this.source = source;
    }

    public CBECommonBaseEvent getSource() {
        return this.source;
    }

    public void addPair(CBECommonBaseEvent source, CBECommonBaseEvent target) {
        SourceTargetPair pair = new SourceTargetPair(source, target);
        this.correlationList.add(pair);
    }

    public List getPairs() {
        return this.correlationList;
    }

    public void generatePairs() {
        if (this.correlationList != null) {
            return;
        }
        this.correlationList = new ArrayList();
        if (this.source == null) {
            return;
        }
        this.getPairs().clear();
        if (this.type == 0) {
            this.generateCorrelationListXMI();
        } else if (this.type == 1) {
            this.generateCorrelationListSQL();
        }
    }

    private void generateCorrelationListSQL() {
        LogInteractions loader = (LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader();
        QueryResult correlations = loader.getCorrelations();
        ResultEntry resultEntry = (ResultEntry)correlations.getResultEntries().get(0);
        EList keysList = resultEntry.getObjects();
        resultEntry = (ResultEntry)correlations.getResultEntries().get(1);
        EList valuesList = resultEntry.getObjects();
        if (keysList.size() > 0) {
            CBECommonBaseEvent sourceElement = null;
            CBECommonBaseEvent target = null;
            int index = keysList.indexOf(this.source);
            int s = keysList.size();
            int i = index;
            while (i < s) {
                sourceElement = (CBECommonBaseEvent)keysList.get(i);
                target = (CBECommonBaseEvent)valuesList.get(i);
                if (sourceElement != this.source) break;
                this.addPair(this.source, target);
                ++i;
            }
        }
    }

    private void generateCorrelationListXMI() {
        List targetList = null;
        CBECommonBaseEvent targetEvent = null;
        LogInteractions loader = (LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader();
        EMap correlations = loader.getCorrelationContainerProxy().getCorrelationContainer().getCorrelations();
        targetList = (List)correlations.get((Object)this.source);
        if (targetList == null) {
            return;
        }
        int s = targetList.size();
        int i = 0;
        while (i < s) {
            targetEvent = (CBECommonBaseEvent)targetList.get(i);
            this.addPair(this.source, targetEvent);
            ++i;
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        this.generatePairs();
        if (this.correlationList.size() == 1) {
            if (this.propertyDescriptors == null) {
                this.propertyDescriptors = new IPropertyDescriptor[1];
                PropertyDescriptor cbeListsDescriptor = new PropertyDescriptor((Object)PROPERTY_LIST, "[" + CBEUtils.formatCreationTime((CBECommonBaseEvent)((SourceTargetPair)this.correlationList.get(0)).getSourceEvent(), (SimpleDateFormat)LogUIPlugin.getDateTimeFormat()) + "] " + ((SourceTargetPair)this.correlationList.get(0)).getSourceEvent().getMsg());
                cbeListsDescriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return "--> [" + CBEUtils.formatCreationTime((CBECommonBaseEvent)((SourceTargetPair)LogAsyncReturnMessage.this.correlationList.get(0)).getTargetEvent(), (SimpleDateFormat)LogUIPlugin.getDateTimeFormat()) + "] " + ((SourceTargetPair)LogAsyncReturnMessage.this.correlationList.get(0)).getTargetEvent().getMsg();
                    }
                });
                cbeListsDescriptor.setCategory(TString.change((String)SDLogcPlugin.getString("STR_LOG_CORR"), (String)"%1", (String)("" + this.correlationList.size())));
                this.propertyDescriptors[0] = cbeListsDescriptor;
            }
        } else if (this.propertyDescriptors == null) {
            this.propertyDescriptors = new IPropertyDescriptor[this.correlationList.size()];
            int i = 0;
            while (i < this.correlationList.size()) {
                PropertyDescriptor cbeListsDescriptor = new PropertyDescriptor((Object)(PROPERTY_LIST + i), "[" + CBEUtils.formatCreationTime((CBECommonBaseEvent)((SourceTargetPair)this.correlationList.get(i)).getSourceEvent(), (SimpleDateFormat)LogUIPlugin.getDateTimeFormat()) + "] " + ((SourceTargetPair)this.correlationList.get(i)).getSourceEvent().getMsg());
                final int idx = i;
                cbeListsDescriptor.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return "--> [" + CBEUtils.formatCreationTime((CBECommonBaseEvent)((SourceTargetPair)LogAsyncReturnMessage.this.correlationList.get(idx)).getTargetEvent(), (SimpleDateFormat)LogUIPlugin.getDateTimeFormat()) + "] " + ((SourceTargetPair)LogAsyncReturnMessage.this.correlationList.get(idx)).getTargetEvent().getMsg();
                    }
                });
                cbeListsDescriptor.setCategory(TString.change((String)SDLogcPlugin.getString("STR_LOG_CORRS"), (String)"%1", (String)("" + this.correlationList.size())));
                this.propertyDescriptors[i] = cbeListsDescriptor;
                ++i;
            }
        }
        return this.propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        if (((String)id).indexOf(PROPERTY_LIST) == 0) {
            return this.correlationList;
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public class SourceTargetPair {
        private CBECommonBaseEvent sourceEvent;
        private CBECommonBaseEvent targetEvent;

        public SourceTargetPair(CBECommonBaseEvent source, CBECommonBaseEvent target) {
            this.setSourceEvent(source);
            this.setTargetEvent(target);
        }

        public CBECommonBaseEvent getSourceEvent() {
            return this.sourceEvent;
        }

        public void setSourceEvent(CBECommonBaseEvent sourceEvent) {
            this.sourceEvent = sourceEvent;
        }

        public CBECommonBaseEvent getTargetEvent() {
            return this.targetEvent;
        }

        public void setTargetEvent(CBECommonBaseEvent targetEvent) {
            this.targetEvent = targetEvent;
        }
    }
}

