/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarWriter {
    private JarOutputStream fJarOutputStream;

    public JarWriter(File file, Manifest manifest, String string) throws IOException {
        if (file.exists()) {
            throw new TargetAlreadyExists(file.toString());
        }
        this.fJarOutputStream = manifest != null ? new JarOutputStream((OutputStream)new FileOutputStream(file), manifest) : new JarOutputStream(new FileOutputStream(file));
        if (string != null) {
            this.fJarOutputStream.setComment(string);
        }
    }

    public void close() throws IOException {
        if (this.fJarOutputStream != null) {
            this.fJarOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, String string, boolean bl) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (file.getName().equals("META-INF")) {
                int n = 0;
                while (n < fileArray.length) {
                    if (fileArray[n].equals("MANIFEST.MF")) {
                        fileArray[n] = null;
                    }
                    ++n;
                }
            }
            String string2 = bl ? string : (string.equals("") ? file.getName() : string + "/" + file.getName());
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n] != null) {
                    this.write(fileArray[n], string2, false);
                }
                ++n;
            }
        } else {
            ByteArrayOutputStream byteArrayOutputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                int n;
                byteArrayOutputStream = new ByteArrayOutputStream();
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                int n2 = Math.max(bufferedInputStream.available(), 4096);
                byte[] byArray = new byte[n2];
                while ((n = bufferedInputStream.read(byArray, 0, n2)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            }
            finally {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            long l = file.lastModified();
            String string3 = string == "" ? file.getName() : string + "/" + file.getName();
            this.write(string3, byteArrayOutputStream.toByteArray(), l);
        }
    }

    protected void write(String string, byte[] byArray, long l) throws IOException {
        JarEntry jarEntry = new JarEntry(string.replace(File.separatorChar, '/'));
        jarEntry.setMethod(8);
        jarEntry.setTime(l);
        this.fJarOutputStream.putNextEntry(jarEntry);
        this.fJarOutputStream.write(byArray);
    }

    public class TargetAlreadyExists
    extends IOException {
        public TargetAlreadyExists(String string) {
            super(string);
        }
    }
}

