/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.probekit.ui.popup.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.probekit.CompilerFactory;
import org.eclipse.hyades.probekit.IProbeCompiler;
import org.eclipse.hyades.probekit.ProbekitCompileProblemException;
import org.eclipse.hyades.probekit.ui.ProbekitUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

class DefaultProbeCompileObjectActionDelegate
implements IObjectActionDelegate {
    List selectedFileList;

    DefaultProbeCompileObjectActionDelegate() {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Shell shell = new Shell();
        try {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        DefaultProbeCompileObjectActionDelegate.this.runWithProgress(monitor);
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            new ProgressMonitorDialog(shell).run(true, false, op);
        }
        catch (InvocationTargetException e) {
            if (!(e.getTargetException() instanceof ProbekitCompileProblemException)) {
                throw new Error(e);
            }
        }
        catch (InterruptedException e) {
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
        action.setChecked(false);
        this.selectedFileList = new LinkedList();
        if (selection != null && selection instanceof IStructuredSelection) {
            Iterator i = ((IStructuredSelection)selection).iterator();
            while (i.hasNext()) {
                IFile f;
                Object o = i.next();
                if (!(o instanceof IFile) || !(f = (IFile)o).getName().endsWith(".probe")) continue;
                this.selectedFileList.add(f);
            }
        }
    }

    private void reportError(String msg, IResource ires) {
        try {
            IMarker m = ires.createMarker("org.eclipse.hyades.probekit.probekitProblem");
            m.setAttribute("message", (Object)msg);
            m.setAttribute("severity", 2);
        }
        catch (CoreException e) {
            Status status = new Status(4, "com.ibm.rational.pd.probekit", 0, ProbekitUI.getResourceString("UI.InternalError"), null);
            ProbekitUI.getDefault().getLog().log((IStatus)status);
        }
    }

    private void removeProbekitMarkers(IResource ires) {
        try {
            ires.deleteMarkers("org.eclipse.hyades.probekit.probekitProblem", true, 0);
        }
        catch (CoreException e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runWithProgress(IProgressMonitor monitor) throws Throwable {
        block15: {
            block13: {
                monitor.beginTask(ProbekitUI.getResourceString("UI.Compiling"), 3);
                IFile firstFile = null;
                try {
                    try {
                        IProbeCompiler c;
                        String basename;
                        block14: {
                            ByteArrayInputStream newJavaContents;
                            IFile javaSourceIFile;
                            block17: {
                                block16: {
                                    if (this.selectedFileList == null) break block16;
                                    if (this.selectedFileList.size() != 0) break block17;
                                }
                                Object var14_3 = null;
                                break block13;
                            }
                            firstFile = (IFile)this.selectedFileList.get(0);
                            this.removeProbekitMarkers((IResource)firstFile);
                            basename = this.getBaseName(firstFile.getName());
                            c = CompilerFactory.INSTANCE.createCompiler();
                            basename = c.makeValidJavaIdentifier(basename);
                            c.setClassPrefix(basename);
                            Iterator i = this.selectedFileList.iterator();
                            while (true) {
                                if (!i.hasNext()) {
                                    monitor.subTask(ProbekitUI.getResourceString("UI.Generating"));
                                    monitor.worked(1);
                                    String generatedSource = c.getGeneratedSource();
                                    monitor.subTask(ProbekitUI.getResourceString("UI.SavingJava"));
                                    monitor.worked(1);
                                    String suffix = c.getClassSuffix();
                                    javaSourceIFile = firstFile.getParent().getFile((IPath)new Path(basename + suffix + ".java"));
                                    newJavaContents = new ByteArrayInputStream(generatedSource.getBytes());
                                    if (!javaSourceIFile.exists()) break;
                                    javaSourceIFile.setContents((InputStream)newJavaContents, true, false, monitor);
                                    break block14;
                                }
                                IFile f = (IFile)i.next();
                                this.removeProbekitMarkers((IResource)f);
                                c.addIFile(f);
                            }
                            javaSourceIFile.create((InputStream)newJavaContents, true, monitor);
                        }
                        monitor.subTask(ProbekitUI.getResourceString("UI.SavingEngineScript"));
                        monitor.worked(1);
                        String engineScript = c.getEngineScript();
                        IFile engineScriptIFile = firstFile.getParent().getFile((IPath)new Path(basename + ".probescript"));
                        ByteArrayInputStream newScriptContents = new ByteArrayInputStream(engineScript.getBytes());
                        if (engineScriptIFile.exists()) {
                            engineScriptIFile.setContents((InputStream)newScriptContents, true, false, monitor);
                            break block15;
                        } else {
                            engineScriptIFile.create((InputStream)newScriptContents, true, monitor);
                        }
                        break block15;
                    }
                    catch (ProbekitCompileProblemException pcpe) {
                        Object var14_5 = null;
                        monitor.done();
                        return;
                    }
                    catch (Exception e) {
                        if (firstFile != null) {
                            this.reportError(ProbekitUI.getResourceString("UI.InternalError"), (IResource)firstFile);
                        }
                        Status status = new Status(4, "com.ibm.rational.pd.probekit", 0, ProbekitUI.getResourceString("UI.InternalError"), (Throwable)e);
                        ProbekitUI.getDefault().getLog().log((IStatus)status);
                        Object var14_6 = null;
                        monitor.done();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_7 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var14_4 = null;
        monitor.done();
    }

    private String getBaseName(String name) {
        if (name == null) {
            return null;
        }
        int lastdot = name.lastIndexOf(".");
        if (lastdot == -1) {
            return name;
        }
        return name.substring(0, lastdot);
    }
}

