/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.extensions;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.ClassMetadata;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;
import org.eclipse.hyades.resources.database.internal.impl.RDBHelper;
import org.eclipse.hyades.resources.database.internal.impl.StatementFactory;

public class GetURICommand
extends DBCommand {
    protected List classesAndIds;
    protected Map classesToMetadata;
    protected DatabaseType type;

    public GetURICommand(JDBCHelper helper, DBMap map, DatabaseType type, List classesAndIds) {
        super(helper, map);
        this.type = type;
        this.classesAndIds = classesAndIds;
    }

    public Object execute() throws Exception {
        ArrayList uris = new ArrayList();
        int i = 0;
        int l = this.classesAndIds.size();
        while (i < l) {
            EClass eClass = (EClass)this.classesAndIds.get(i);
            List ids = (List)this.classesAndIds.get(i + 1);
            this.getURIs(eClass, ids, uris);
            i += 2;
        }
        return uris.toArray(new String[0]);
    }

    protected void getURIs(EClass eClass, List ids, List uris) throws Exception {
        ClassMetadata metadata = this.getMetadata(eClass);
        EReference containerReference = metadata.getContainerReference();
        if (containerReference == null) {
            this.processResourceTable(eClass, ids, uris);
        } else {
            List containerIds = this.getContainers(containerReference, ids);
            this.getURIs(containerReference.getEReferenceType(), containerIds, uris);
        }
    }

    protected List getContainers(EReference containerReference, List ids) throws Exception {
        List noDuplicates = this.removeDuplicates(ids);
        DBMap.ReferenceData data = (DBMap.ReferenceData)this.dbMap.getDBRepresentation((EModelElement)containerReference);
        StatementFactory factory = StatementFactory.INSTANCE;
        int[] sourceIds = new int[noDuplicates.size()];
        int i = 0;
        int l = noDuplicates.size();
        while (i < l) {
            sourceIds[i] = (Integer)noDuplicates.get(i);
            ++i;
        }
        QueryStatement query = factory.createGreedyReferenceQuery(sourceIds, containerReference, this.dbMap, this.type, true);
        String queryString = query.getStatement();
        String[] queryStrings = queryString != null ? new String[]{queryString} : query.getStatements();
        HashMap<Integer, Integer> sourceToContainer = new HashMap<Integer, Integer>();
        int i2 = 0;
        while (i2 < queryStrings.length) {
            if (DBCommand.debug) {
                System.out.println(queryStrings[i2]);
            }
            Statement queryStatement = this.helper.createStatement();
            ResultSet rs = this.helper.executeQuery(queryStatement, queryStrings[i2]);
            while (rs.next()) {
                int source = rs.getInt(1);
                int target = rs.getInt(2);
                if (target <= 0) continue;
                sourceToContainer.put(new Integer(source), new Integer(target));
            }
            rs.close();
            queryStatement.close();
            ++i2;
        }
        ArrayList<Integer> containers = new ArrayList<Integer>();
        int i3 = 0;
        int l2 = ids.size();
        while (i3 < l2) {
            Integer container = (Integer)sourceToContainer.get(ids.get(i3));
            containers.add(container);
            ++i3;
        }
        return containers;
    }

    protected List removeDuplicates(List ids) {
        ArrayList noDuplicates = new ArrayList();
        HashSet idSet = new HashSet();
        int i = 0;
        int l = ids.size();
        while (i < l) {
            Object id = ids.get(i);
            if (id != null && !idSet.contains(id)) {
                idSet.add(id);
                noDuplicates.add(id);
            }
            ++i;
        }
        return noDuplicates;
    }

    protected void processResourceTable(EClass eClass, List ids, List uris) throws Exception {
        ClassMetadata metadata = this.getMetadata(eClass);
        EClass[] subclasses = metadata.getAllSubclasses();
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add(this.getTableName(eClass));
        int i = 0;
        while (i < subclasses.length) {
            tableNames.add(this.getTableName(subclasses[i]));
            ++i;
        }
        this.getURIsFromResourceTable(tableNames, ids, uris);
    }

    protected String getTableName(EClass eClass) {
        DBMap.ClassData data = (DBMap.ClassData)this.dbMap.getDBRepresentation((EModelElement)eClass);
        return data.getTable().getName();
    }

    protected void getURIsFromResourceTable(List tables, List ids, List uris) throws Exception {
        List noDuplicates = this.removeDuplicates(ids);
        Table resourceTable = this.dbMap.getResourceTable();
        HashMap<Integer, String> idsToURIs = new HashMap<Integer, String>();
        String query = this.createResourceTableQuery(resourceTable, tables, noDuplicates);
        Statement statement = this.helper.createStatement();
        ResultSet result = this.helper.executeQuery(statement, query);
        while (result.next()) {
            String uri = result.getString(1);
            int id = result.getInt(2);
            if (uri == null) continue;
            idsToURIs.put(new Integer(id), uri);
        }
        int i = 0;
        int l = ids.size();
        while (i < l) {
            uris.add(idsToURIs.get(ids.get(i)));
            ++i;
        }
        result.close();
        statement.close();
    }

    protected String createResourceTableQuery(Table resourceTable, List tables, List ids) {
        StringBuffer query = new StringBuffer();
        String uri = ((Column)resourceTable.getColumns().get(0)).getName();
        String table = ((Column)resourceTable.getColumns().get(1)).getName();
        String id = ((Column)resourceTable.getColumns().get(2)).getName();
        query.append("SELECT ");
        query.append(this.addQuotes(uri));
        query.append(", ");
        query.append(this.addQuotes(id));
        query.append(" FROM ");
        query.append(this.addQuotes(resourceTable.getName()));
        query.append(" WHERE ");
        query.append(this.addQuotes(table));
        query.append(" IN (");
        int i = 0;
        int l = tables.size();
        while (i < l) {
            if (i == 0) {
                query.append("'");
            } else {
                query.append(", '");
            }
            query.append(tables.get(i));
            ++i;
        }
        query.append("'");
        query.append(") AND ");
        query.append(this.addQuotes(id));
        query.append(" IN (");
        int i2 = 0;
        int l2 = ids.size();
        while (i2 < l2) {
            if (i2 != 0) {
                query.append(", ");
            }
            query.append(ids.get(i2));
            ++i2;
        }
        query.append(")");
        return query.toString();
    }

    protected ClassMetadata getMetadata(EClass eClass) {
        ClassMetadata metadata;
        if (this.classesToMetadata == null) {
            this.classesToMetadata = new HashMap();
        }
        if ((metadata = (ClassMetadata)this.classesToMetadata.get(eClass)) == null) {
            metadata = new ClassMetadata(eClass, this.dbMap, new RDBHelper());
            this.classesToMetadata.put(eClass, metadata);
        }
        return metadata;
    }
}

