/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.PreparedStatement;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
import org.eclipse.hyades.resources.database.internal.impl.DBCommand;
import org.eclipse.hyades.resources.database.internal.impl.InsertStatement;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;
import org.eclipse.hyades.resources.database.internal.impl.StatementFactory;
import org.eclipse.hyades.resources.database.internal.impl.WeakObjectCache;

public class AddResourceCommand
extends DBCommand {
    protected Resource resource;
    protected WeakObjectCache cache;
    protected PreparedStatement prepared;

    public AddResourceCommand(JDBCHelper helper, DBMap map, Resource resource, WeakObjectCache cache) {
        super(helper, map);
        this.resource = resource;
        this.cache = cache;
    }

    public Object execute() throws Exception {
        Table resourceTable = this.dbMap.getResourceTable();
        this.createPreparedStatement(resourceTable);
        EList objects = this.resource.getContents();
        String uri = this.resource.getURI().toString();
        int i = 0;
        int l = objects.size();
        while (i < l) {
            EObject object = (EObject)objects.get(i);
            int id = this.cache.getId(object);
            this.insertRow(uri, this.getTableName(object), id);
            ++i;
        }
        if (this.prepared != null) {
            this.prepared.close();
        }
        return null;
    }

    protected void createPreparedStatement(Table table) throws Exception {
        StatementFactory factory = StatementFactory.INSTANCE;
        InsertStatement statement = factory.createInsertStatement(this.dbType, table, (List)table.getColumns());
        this.prepared = this.helper.createPreparedStatement(((SQLStatement)statement).getStatement());
    }

    protected String getTableName(EObject object) {
        EClass cls = object.eClass();
        DBMap.ClassData data = (DBMap.ClassData)this.dbMap.getDBRepresentation((EModelElement)cls);
        return data.getTable().getName();
    }

    protected void insertRow(String uri, String tableName, int id) throws Exception {
        this.prepared.setString(1, uri);
        this.prepared.setString(2, tableName);
        this.prepared.setInt(3, id);
        this.prepared.executeUpdate();
    }
}

