/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Database;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
import org.eclipse.hyades.resources.database.internal.impl.ClassMetadata;
import org.eclipse.hyades.resources.database.internal.impl.RDBHelper;

public class DBMapImpl
implements DBMap {
    protected Map map = new HashMap();
    protected Database database;
    protected Map classesToSubclasses;
    protected List classTables = new ArrayList();
    protected List attributeTables = new ArrayList();
    protected List referenceTables = new ArrayList();
    protected Table resourceTable;
    protected Table proxyTable;
    protected Table idTable;
    protected Map tablesToClasses = new HashMap();
    protected Map columnsToReferences;
    protected Map classesToMetadata;

    public DBMapImpl() {
        this.classesToSubclasses = new HashMap();
        this.columnsToReferences = new HashMap();
        this.classesToMetadata = new HashMap();
    }

    public void add(EModelElement element, Object rdbRepresentation) {
        Table table;
        this.map.put(element, rdbRepresentation);
        if (rdbRepresentation instanceof Database) {
            this.database = (Database)rdbRepresentation;
        } else if (element instanceof EClass) {
            this.computeSubclasses((EClass)element);
            Table table2 = ((DBMap.ClassData)rdbRepresentation).getTable();
            this.classTables.add(table2);
            this.tablesToClasses.put(table2, element);
        } else if (element instanceof EReference) {
            Table table3 = ((DBMap.ReferenceData)rdbRepresentation).getTable();
            EReference reference = (EReference)element;
            EReference opposite = reference.getEOpposite();
            if (this.referenceIsTable(reference, opposite)) {
                if (!this.referenceTables.contains(table3)) {
                    this.referenceTables.add(table3);
                }
            } else if (opposite == null || this.map.get(opposite) == null) {
                DBMap.ReferenceData data = (DBMap.ReferenceData)rdbRepresentation;
                Column column = reference.isMany() ? data.getSourceColumn() : data.getTargetColumn();
                this.columnsToReferences.put(column, reference);
            }
        } else if (element instanceof EAttribute && (table = ((DBMap.AttributeData)rdbRepresentation).getTable()) != null) {
            this.attributeTables.add(table);
        }
    }

    protected boolean referenceIsTable(EReference reference, EReference opposite) {
        if (reference.isMany() && !reference.isUnique()) {
            return true;
        }
        if (opposite != null && opposite.isMany() && !opposite.isUnique()) {
            return true;
        }
        if (opposite == null) {
            return reference.isMany();
        }
        return reference.isMany() && opposite.isMany() && !reference.isTransient();
    }

    public Object getDBRepresentation(EModelElement element) {
        return this.map.get(element);
    }

    public Database getDatabase() {
        return this.database;
    }

    public List getClassTables() {
        return this.classTables;
    }

    public List getReferenceTables() {
        return this.referenceTables;
    }

    public List getAttributeTables() {
        return this.attributeTables;
    }

    protected void computeSubclasses(EClass eClass) {
        EList superClasses = eClass.getESuperTypes();
        int i = 0;
        int l = superClasses.size();
        while (i < l) {
            this.addSubclass((EClass)superClasses.get(i), eClass);
            ++i;
        }
    }

    protected void addSubclass(EClass superClass, EClass subClass) {
        ArrayList<EClass> subclasses = (ArrayList<EClass>)this.classesToSubclasses.get(superClass);
        if (subclasses == null) {
            subclasses = new ArrayList<EClass>();
            this.classesToSubclasses.put(superClass, subclasses);
        }
        if (!subclasses.contains(subClass)) {
            subclasses.add(subClass);
        }
    }

    public List getAllSubclasses(EClass eClass) {
        ArrayList subclasses = new ArrayList();
        List direct = (List)this.classesToSubclasses.get(eClass);
        if (direct == null) {
            return subclasses;
        }
        int i = 0;
        int l = direct.size();
        while (i < l) {
            EClass subclass = (EClass)direct.get(i);
            List indirect = this.getAllSubclasses(subclass);
            int j = 0;
            int l2 = indirect.size();
            while (j < l2) {
                if (!subclasses.contains(indirect.get(j))) {
                    subclasses.add(indirect.get(j));
                }
                ++j;
            }
            if (!subclasses.contains(subclass)) {
                subclasses.add(subclass);
            }
            ++i;
        }
        return subclasses;
    }

    public Table getResourceTable() {
        return this.resourceTable;
    }

    public void setResourceTable(Table table) {
        this.resourceTable = table;
    }

    public EClass getClass(Table table) {
        return (EClass)this.tablesToClasses.get(table);
    }

    public EReference getReference(Column column) {
        return (EReference)this.columnsToReferences.get(column);
    }

    public Table getProxyTable() {
        return this.proxyTable;
    }

    public void setProxyTable(Table table) {
        this.proxyTable = table;
    }

    public Table getIdTable() {
        return this.idTable;
    }

    public void setIdTable(Table table) {
        this.idTable = table;
    }

    public ClassMetadata getClassMetadata(EClass eClass) {
        ClassMetadata metadata;
        if (this.classesToMetadata == null) {
            this.classesToMetadata = new HashMap();
        }
        if ((metadata = (ClassMetadata)this.classesToMetadata.get(eClass)) == null) {
            metadata = new ClassMetadata(eClass, this, new RDBHelper());
            this.classesToMetadata.put(eClass, metadata);
        }
        return metadata;
    }
}

