/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.resources.database.internal.DBCollectedExceptions;
import org.eclipse.hyades.resources.database.internal.DBResource;
import org.eclipse.hyades.resources.database.internal.Database;
import org.eclipse.hyades.resources.database.internal.ObjectQuery;
import org.eclipse.hyades.resources.database.internal.QueryFactory;
import org.eclipse.hyades.resources.database.internal.ReferenceQuery;
import org.eclipse.hyades.resources.database.internal.ResourceAddedException;
import org.eclipse.hyades.resources.database.internal.impl.DBResourceContentAdapter;

public class DBResourceImpl
extends ResourceImpl
implements DBResource {
    protected Database database;
    protected Map defaultLoadOptions;
    protected boolean inDatabase;
    protected DBResourceContentAdapter contentAdapter;
    protected HierarchyContext context = null;
    private boolean register;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$util$HierarchyContext;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$util$AgentsContext;

    public DBResourceImpl() {
        this.addAdapter();
    }

    public DBResourceImpl(URI uri) {
        super(uri);
        this.addAdapter();
    }

    public DBResourceImpl(URI uri, Database database) {
        this(uri);
        this.database = database;
    }

    protected void addAdapter() {
        this.contentAdapter = new DBResourceContentAdapter();
        this.eAdapters().add((Object)this.contentAdapter);
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public void save(Map options) throws IOException {
        PerfUtil p = new PerfUtil("DBResourceImpl.save() uri=" + this.getURI(), true);
        try {
            this.doSave(null, options);
            this.inDatabase = true;
        }
        catch (IOException e) {
            p.stopAndPrintStatus(e.getLocalizedMessage());
            throw e;
        }
        p.stopAndPrintStatus();
    }

    protected void doSave(OutputStream outputStream, Map options) throws IOException {
        try {
            this.database.add((Resource)this);
        }
        catch (Exception e) {
            if (e instanceof ResourceAddedException) {
                return;
            }
            throw new DBCollectedExceptions(e);
        }
    }

    public void load(Map options) throws IOException {
        PerfUtil p = new PerfUtil("DBResourceImpl.load() uri=" + this.getURI(), true);
        try {
            this.contentAdapter.setIsLoading(true);
            this.doLoad(null, options);
            this.inDatabase = true;
            this.contentAdapter.setIsLoading(false);
        }
        catch (IOException e) {
            p.stopAndPrintStatus(e.getLocalizedMessage());
            throw e;
        }
        p.stopAndPrintStatus();
    }

    protected void doLoad(InputStream inputStream, Map options) throws IOException {
        boolean allObjects = true;
        if (options == null) {
            options = this.defaultLoadOptions;
        }
        if (options != null && options.get("TOP_LEVEL") == Boolean.TRUE) {
            allObjects = false;
        }
        if (allObjects && this.defaultLoadOptions != null && this.defaultLoadOptions.get("TOP_LEVEL") == Boolean.TRUE) {
            allObjects = false;
        }
        Collection notLoadedClasses = null;
        if (options != null && options.get("NOT_LOADED_CLASSES") != null) {
            notLoadedClasses = (Collection)options.get("NOT_LOADED_CLASSES");
        } else if (this.defaultLoadOptions != null) {
            notLoadedClasses = (Collection)this.defaultLoadOptions.get("NOT_LOADED_CLASSES");
        }
        try {
            this.database.load((Resource)this, allObjects, notLoadedClasses);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Resource.IOWrappedException(e);
        }
    }

    public Map getDefaultLoadOptions() {
        if (this.defaultLoadOptions == null) {
            this.defaultLoadOptions = new HashMap();
        }
        return this.defaultLoadOptions;
    }

    public EObject getEObject(EClass eClass, EAttribute attribute, Object value, EObject related, EReference reference) throws Exception {
        EObject[] objects;
        ObjectQuery query = QueryFactory.INSTANCE.createObjectQuery();
        query.setEClass(eClass);
        query.setURI(this.uri);
        Map attribValues = query.getAttributeValues();
        if (value != null) {
            if (attribute != null) {
                attribValues.put(attribute, value);
            } else {
                attribValues.put(eClass.getEIDAttribute(), value);
            }
        }
        if ((objects = this.database.getObjects(query)) == null) {
            return null;
        }
        if (reference != null && related != null) {
            if (!objects[0].eIsSet((EStructuralFeature)reference)) {
                return this.testRelatedWithReferenceQuery(objects, related, reference);
            }
            return this.testRelatedWithReference(objects, related, reference);
        }
        return objects[0];
    }

    protected EObject testRelatedWithReference(EObject[] objects, EObject related, EReference reference) {
        int i = 0;
        while (i < objects.length) {
            Object referenced = objects[i].eGet((EStructuralFeature)reference);
            if (this.in(related, referenced)) {
                return objects[i];
            }
            ++i;
        }
        return null;
    }

    protected boolean in(EObject related, Object referenced) {
        if (related == referenced) {
            return true;
        }
        if (referenced instanceof List) {
            List values = (List)referenced;
            int i = 0;
            int l = values.size();
            while (i < l) {
                if (related == values.get(i)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected EObject testRelatedWithReferenceQuery(EObject[] objects, EObject related, EReference reference) throws Exception {
        int i = 0;
        while (i < objects.length) {
            ReferenceQuery referenceQuery = QueryFactory.INSTANCE.createReferenceQuery();
            referenceQuery.setEObject(objects[i]);
            referenceQuery.setEReference(reference);
            EObject[] referenced = this.database.getObjects(referenceQuery);
            if (referenced != null) {
                int j = 0;
                while (j < referenced.length) {
                    if (referenced[j] == related) {
                        return objects[i];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public boolean isInDatabase() {
        return this.inDatabase;
    }

    public EContentAdapter getContentAdapter() {
        return this.contentAdapter;
    }

    protected void doUnload() {
        this.unloadLookupContext();
    }

    private void unloadLookupContext() {
        LookupServiceExtensions.getInstance().deregister(this.context);
        LookupServiceExtensions.getInstance().deregister(null, class$org$eclipse$hyades$loaders$util$HierarchyContext == null ? (class$org$eclipse$hyades$loaders$util$HierarchyContext = DBResourceImpl.class$("org.eclipse.hyades.loaders.util.HierarchyContext")) : class$org$eclipse$hyades$loaders$util$HierarchyContext, (Object)this.getURI().toString());
        this.context = null;
    }

    protected HierarchyContext getContext(EObject object) {
        if (this.context == null && object instanceof TRCAgent) {
            this.context = (HierarchyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$HierarchyContext == null ? (class$org$eclipse$hyades$loaders$util$HierarchyContext = DBResourceImpl.class$("org.eclipse.hyades.loaders.util.HierarchyContext")) : class$org$eclipse$hyades$loaders$util$HierarchyContext, (Object)this.getURI().toString());
            if (this.context == null) {
                this.context = new HierarchyContext();
            }
            TRCAgent agent = (TRCAgent)object;
            AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentsContext == null ? (class$org$eclipse$hyades$loaders$util$AgentsContext = DBResourceImpl.class$("org.eclipse.hyades.loaders.util.AgentsContext")) : class$org$eclipse$hyades$loaders$util$AgentsContext, LoadersUtils.getLookUpKey((String)agent.getRuntimeId()));
            if (agentsContext == null) {
                agentsContext = new AgentsContext(agent.getRuntimeId());
                LookupServiceExtensions.getInstance().register(null, (Object)agentsContext);
            }
            agentsContext.registerAgent(agent);
            this.context.setAgent(agent);
            this.context.setContextURI(this.getURI().toString());
            LookupServiceExtensions.getInstance().register(null, (Object)this.context);
            return null;
        }
        if (object instanceof UnresolvedCorrelation) {
            return null;
        }
        return this.context;
    }

    public void attached(EObject value) {
        if (this.register) {
            LookupServiceExtensions.getInstance().register(this.getContext(value), (Object)value);
        }
    }

    public void detached(EObject value) {
        if (this.register) {
            LookupServiceExtensions.getInstance().deregister(this.getContext(value), (Object)value);
        }
    }

    public boolean delete() {
        try {
            this.getDatabase().deleteResource(this.getURI());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteObjects(EList uris) {
        return false;
    }

    public QueryResult executeQuery(Query query) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public QueryResult executeQuery(String queryName) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean storeQuery(Query query) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean unloadObjects(EList uris) {
        return false;
    }

    public boolean validateQuery(Query query) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

