/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.resources.database.internal.impl.DatabaseExtensions;
import org.eclipse.hyades.resources.database.util.IDatabaseExtensions;

class DatabaseRegistryReader
extends RegistryReader {
    static final String TAG_DATABASE_EXTENSION = "databaseExtension";
    static final String ATT_CLASS = "class";

    public DatabaseRegistryReader() {
        super("org.eclipse.hyades.resources.database", "database_extensions");
    }

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_DATABASE_EXTENSION)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                try {
                    IHyadesPluginClassDescriptor classDescriptor = this.createPluginClassDescriptor(element, ATT_CLASS);
                    IDatabaseExtensions databaseExtensions = (IDatabaseExtensions)classDescriptor.createInstance();
                    DatabaseExtensions.getInstance().put(databaseExtensions.getDBType(), databaseExtensions);
                    int i = 0;
                    while (i < databaseExtensions.getSupportedPostfixes().length) {
                        String postfix = databaseExtensions.getSupportedPostfixes()[i];
                        if (DatabaseExtensions.getInstance().containsKey(postfix)) {
                            this.logError(element, "A database extension for this postfix already exists, this extension will be ignored.");
                        } else {
                            DatabaseExtensions.getInstance().put(postfix, databaseExtensions);
                        }
                        ++i;
                    }
                    return true;
                }
                catch (Exception e) {
                    this.logError(element, e.getLocalizedMessage());
                }
            }
        }
        return false;
    }
}

