/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.RDBHelper;
import org.eclipse.hyades.resources.database.internal.impl.SQLStatement;

public class SetAttributeStatement
extends SQLStatement {
    protected Integer id;
    protected EAttribute attribute;
    protected Object value;

    public SetAttributeStatement(DatabaseType dbType, DBMap map, Integer id, EAttribute attribute, Object value) {
        super(dbType, map);
        this.id = id;
        this.attribute = attribute;
        this.value = value;
    }

    public String getStatement() {
        StringBuffer buffer = new StringBuffer();
        DBMap.AttributeData data = (DBMap.AttributeData)this.dbMap.getDBRepresentation((EModelElement)this.attribute);
        buffer.append("UPDATE ");
        buffer.append(this.addQuotes(data.getValueColumn().getTable().getName()));
        buffer.append(" SET ");
        buffer.append(this.addQuotes(data.getValueColumn().getName()));
        buffer.append(" = ");
        this.writeValue(buffer, data.getValueColumn().getType().getSqlType());
        Column primaryKey = new RDBHelper().getPrimaryKey(data.getValueColumn().getTable());
        if (primaryKey == null) {
            return "";
        }
        buffer.append(" WHERE ");
        buffer.append(this.addQuotes(primaryKey.getName()));
        buffer.append(" = ");
        buffer.append(this.id);
        return buffer.toString();
    }

    protected void writeValue(StringBuffer buffer, int sqlType) {
        if (this.value == null) {
            buffer.append("NULL");
        } else if (sqlType == 1 || sqlType == 12 || sqlType == -1) {
            buffer.append("'");
            String valueString = this.value.toString();
            int i = 0;
            int l = valueString.length();
            while (i < l) {
                char c = valueString.charAt(i);
                if (c == '\'') {
                    buffer.append("''");
                } else {
                    buffer.append(c);
                }
                ++i;
            }
            buffer.append("'");
        } else {
            buffer.append(this.value.toString());
        }
    }
}

