/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaGridElement;
import org.eclipse.hyades.collection.threadanalyzer.TaTosNameGridElement;
import org.eclipse.hyades.collection.threadanalyzer.TaTosPctPoolGridElement;
import org.eclipse.hyades.collection.threadanalyzer.TaTosThdCountGridElement;
import org.eclipse.hyades.collection.threadanalyzer.TaTosWeightGridElement;
import org.eclipse.hyades.collection.threadanalyzer.Thd;

public class ServletThreadPool {
    private DumpData _d = null;

    public ServletThreadPool(DumpData d) {
        this._d = d;
    }

    private ServletThreadPool() {
    }

    public Object[] getTosGridHeaders() {
        return new Object[]{TAUtils.getNLSValue("ta.string.Method", "Method"), TAUtils.getNLSValue("ta.string.Same", "#Same"), TAUtils.getNLSValue("ta.string.PctOfPool", "Pct Of Pool"), TAUtils.getNLSValue("ta.string.Weight", "Weight")};
    }

    public TaGridElement[][] getTosGrid() {
        TaGridElement[][] ga = null;
        if (this._d._threadsByTOS != null) {
            int poolSize = 0;
            Enumeration e = this._d._threadsByTOS.keys();
            Vector<TaGridElement[]> gridElements = new Vector<TaGridElement[]>();
            while (e.hasMoreElements()) {
                String tosKey = (String)e.nextElement();
                Vector v = (Vector)this._d._threadsByTOS.get(tosKey);
                int sameTos = 0;
                int weightFactor = 0;
                TaGridElement[] ge = null;
                int i = 0;
                while (i < v.size()) {
                    Thd thd = (Thd)v.elementAt(i);
                    if (thd.isServletThread()) {
                        ++sameTos;
                        ++poolSize;
                        weightFactor += thd.waitingForWebWork() ? 0 : 1;
                    }
                    ++i;
                }
                if (sameTos <= 0) continue;
                String tosInfo = null;
                try {
                    this._d._tosTrans.getString(tosKey);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ge = new TaGridElement[]{new TaTosNameGridElement(tosKey, tosInfo != null ? tosInfo : TAUtils.getNLSValue("ta.msg.NoMoreInfo", "no additional information")), new TaTosThdCountGridElement(sameTos, tosInfo != null ? tosInfo : TAUtils.getNLSValue("ta.msg.NoMoreInfo", "no additional information")), new TaTosPctPoolGridElement(0, tosInfo != null ? tosInfo : TAUtils.getNLSValue("ta.msg.NoMoreInfo", "no additional information")), new TaTosWeightGridElement(weightFactor, TAUtils.getNLSValue("ta.msg.HigherWeightFactors", "Higher weight factors may indicate a need to review the code path and/or resource utilization."))};
                gridElements.add(ge);
            }
            if (gridElements.size() > 0) {
                ga = new TaGridElement[gridElements.size()][4];
                int i = 0;
                while (i < gridElements.size()) {
                    TaGridElement[] gea = null;
                    gea = (TaGridElement[])gridElements.elementAt(i);
                    int j = 0;
                    while (j < gea.length) {
                        ga[i][j] = gea[j];
                        ++j;
                    }
                    ++i;
                }
                int totPct = 0;
                TaTosPctPoolGridElement greatestElem = null;
                int greatestPct = 0;
                int i2 = 0;
                while (i2 < ga.length) {
                    TaTosPctPoolGridElement tmp = (TaTosPctPoolGridElement)ga[i2][2];
                    TaTosThdCountGridElement thdCountElem = (TaTosThdCountGridElement)ga[i2][1];
                    int pct = (int)((double)thdCountElem.getThdCount() / (double)poolSize * 100.0);
                    totPct += pct;
                    tmp.setPctOfPool(pct);
                    if (pct > greatestPct) {
                        greatestPct = pct;
                        greatestElem = tmp;
                    }
                    ++i2;
                }
                this.sort(ga, 2);
                int errPct = totPct - 100;
                int loopCt = 10;
                block7: while (errPct != 0 && loopCt > 0) {
                    int i3 = 0;
                    while (i3 < ga.length) {
                        TaTosPctPoolGridElement tmp = (TaTosPctPoolGridElement)ga[i3][2];
                        if (errPct == 0) continue block7;
                        if (errPct > 0 && tmp.getPctOfPool() > 1) {
                            tmp.setPctOfPool(tmp.getPctOfPool() - 1);
                            --errPct;
                        } else if (errPct < 0) {
                            tmp.setPctOfPool(tmp.getPctOfPool() + 1);
                            ++errPct;
                        }
                        ++i3;
                    }
                }
                this.sort(ga, 3);
            }
        }
        return ga;
    }

    protected void sort(TaGridElement[][] gea, int sortCol) {
        int elements = gea.length;
        if (elements > 0) {
            int width = gea[0].length;
            int i = 0;
            while (i < elements) {
                int j = 0;
                while (j < elements - 1) {
                    TaGridElement e1 = gea[j][sortCol];
                    TaGridElement e2 = gea[j + 1][sortCol];
                    if (e1.compareTo(e2) > 0) {
                        TaGridElement[] tmp = gea[j];
                        gea[j] = gea[j + 1];
                        gea[j + 1] = tmp;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

