/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.common.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.perfmon.utils.internal.DCAgentGenericLoader;
import org.eclipse.hyades.perfmon.utils.internal.StatConImageApplier;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.ClickListener;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;
import org.eclipse.swt.widgets.TreeItem;

public class CommonClickListener
implements ClickListener {
    DCAgentGenericLoader loader;
    TRCAgent agent;

    public CommonClickListener(DCAgentGenericLoader loader, TRCAgent agent) {
        this.loader = loader;
        this.agent = agent;
    }

    public void doubleClick(StatConInterface statcon, TreeItem item, EObject relation, int button) {
        block6: {
            SDDescriptor des;
            block7: {
                TRCAgent tmpagent;
                if (!(relation instanceof SDDescriptor) || (tmpagent = this.getAgent(des = (SDDescriptor)relation)) != this.agent || button != 1) break block6;
                if (!(relation instanceof SDMemberDescriptor)) break block7;
                try {
                    this.loader.getCommandUtil().startTracing(des);
                }
                catch (Exception e) {
                    EditorPlugin.DBG.warning("double click listener failed to start tracing counter", (Throwable)e);
                }
                try {
                    StatConImageApplier.applyBoth(statcon, des, StatConImageApplier.getStandardTracingImage());
                }
                catch (Exception e) {
                    EditorPlugin.DBG.warning("double click listener failed to apply start tracing images", (Throwable)e);
                }
                break block6;
            }
            if (!(relation instanceof SDDescriptor)) break block6;
            try {
                this.loader.getCommandUtil().getUpdatedTree(des);
            }
            catch (Exception e) {
                EditorPlugin.DBG.warning("double click listener failed to get updated tree", (Throwable)e);
            }
        }
    }

    private TRCAgent getAgent(SDDescriptor descriptor) {
        TRCAgent agent = descriptor.getAgent();
        if (agent != null) {
            return agent;
        }
        if (descriptor.getParent() != null) {
            return this.getAgent(descriptor.getParent());
        }
        return null;
    }
}

