/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.jonas.internal;

import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.common.internal.CommonModuleTrace;
import org.eclipse.hyades.perfmon.common.internal.CommonModuleTraceLaunchJob;
import org.eclipse.hyades.perfmon.jonas.internal.JonasHostDialog;
import org.eclipse.hyades.perfmon.jonas.internal.JonasModuleTrace;
import org.eclipse.hyades.perfmon.utils.internal.JobLauncher;
import org.eclipse.hyades.statistical.ui.editor.internal.EntityExistsException;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConModule;
import org.eclipse.hyades.statistical.ui.editor.internal.XMLConfigUtil;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JonasStatConModule
implements StatConModule {
    ArrayList traces = new ArrayList();
    ImageManager img = PerfmonPlugin.img;
    StatConInterface statcon;
    boolean ica = false;
    String JONAS_NODE = "JONAS_NODE_ID";
    String NEW_JONAS_TRACE = "NEW_TRACE_ID";
    static String ACTION_SETSMODELPATH = "Set Statistical Model save path...";
    URI smodelpath = null;
    SimpleDateFormat smodel_sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");

    static String uriToHumanReadable(URI uri) {
        String path = uri.path();
        if (path.toLowerCase().startsWith("/resource/")) {
            path = path.substring(10);
        }
        return path;
    }

    private void redoActions() {
        this.statcon.addModuleNodeAction(this.JONAS_NODE, ACTION_SETSMODELPATH, PerfmonPlugin.getString("ACTION_SETSMODELPATH") + " (" + JonasStatConModule.uriToHumanReadable(this.smodelpath) + ")", this.img.getImage("save.gif"), (Runnable)new PerfmonSetPath());
    }

    public void load(StatConInterface statcon) throws Exception {
        this.statcon = statcon;
        this.smodelpath = statcon.getCurrentProjectURI();
        try {
            statcon.addModuleNode(PerfmonPlugin.getString("DATACOLLECTION_NODE"), PerfmonPlugin.DATACOLLECTION_NODE_ID, this.img.getImage("logo.gif"));
        }
        catch (EntityExistsException e) {
            // empty catch block
        }
        statcon.addModuleNode(PerfmonPlugin.getString("JONAS_NODE"), this.JONAS_NODE, PerfmonPlugin.DATACOLLECTION_NODE_ID, this.img.getImage("server_obj.gif"));
        statcon.addModuleNodeAction(this.JONAS_NODE, this.NEW_JONAS_TRACE, PerfmonPlugin.getString("NEW_JONAS_TRACE"), this.img.getImage("trace_start.gif"), (Runnable)new NewTraceAction());
        statcon.addModuleNodeAction(this.JONAS_NODE, ACTION_SETSMODELPATH, PerfmonPlugin.getString("ACTION_SETSMODELPATH") + " (" + JonasStatConModule.uriToHumanReadable(this.smodelpath) + ")", this.img.getImage("save.gif"), (Runnable)new PerfmonSetPath());
    }

    public void applyConfig(String xml) throws Exception {
    }

    public void loadModuleData(byte[] dat) throws Exception {
        PerfmonPlugin.DBG.info("loading perfmon module data: " + new String(dat));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(dat));
        Element element = doc.getDocumentElement();
        ArrayList list = XMLConfigUtil.getAllElements((NodeList)element.getChildNodes(), (String)"config");
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < list.size()) {
            Element elem = (Element)list.get(i);
            String path = elem.getAttribute("smodelpath");
            if (path != null && path.length() > 0) {
                try {
                    IFile tfile = workspaceRoot.getFile((IPath)new Path(path));
                    this.smodelpath = URI.createPlatformResourceURI((String)tfile.getProjectRelativePath().toString());
                }
                catch (Throwable x) {
                    PerfmonPlugin.DBG.info("invalid valid statistical model save path specified");
                }
            }
            ++i;
        }
        this.redoActions();
    }

    public byte[] saveModuleData() throws Exception {
        StringBuffer xml = new StringBuffer();
        xml.append("<perfmon_config>\n");
        xml.append("  <config smodelpath=\"" + this.smodelpath + "\" />\n");
        xml.append("</perfmon_config>\n");
        PerfmonPlugin.DBG.info("saving perfmon module data:" + xml);
        return xml.toString().getBytes();
    }

    public String getModuleRef() {
        return "org.eclipse.hyades.perfmon";
    }

    public void unload() throws Exception {
        this.statcon.removeModuleNode(this.JONAS_NODE);
        int i = 0;
        while (i < this.traces.size()) {
            Object t = this.traces.get(i);
            CommonModuleTrace trace = ((CommonModuleTraceLaunchJob)((Object)t)).getModuleTrace();
            try {
                trace.unloadTrace();
            }
            catch (Exception e) {
                PerfmonPlugin.DBG.warning("failed to unload trace " + i);
            }
            ++i;
        }
    }

    public void startJonasTrace(String rac_host, String jonasHost, String port, URI smodel_path) {
        JonasModuleTrace trace = new JonasModuleTrace(this.statcon, rac_host, port, jonasHost, smodel_path, null);
        CommonModuleTraceLaunchJob job = new CommonModuleTraceLaunchJob(PerfmonPlugin.getString("PROGRESS_LAUNCHING"), trace);
        JobLauncher.launch(job);
        this.traces.add(job);
    }

    class NewTraceAction
    implements Runnable {
        NewTraceAction() {
        }

        public void run() {
            try {
                JonasHostDialog dialog = new JonasHostDialog(JonasStatConModule.this.statcon.getGraphWindow().getShell());
                dialog.open();
                String rac_host = dialog.getRacHost();
                String jonas_host = dialog.getJonasHost();
                String port = dialog.getPort();
                if (rac_host == null) {
                    return;
                }
                JonasStatConModule.this.startJonasTrace(rac_host, jonas_host, port, JonasStatConModule.this.smodelpath);
            }
            catch (Throwable t) {
                PerfmonPlugin.DBG.error("error starting jonas trace", t);
            }
        }
    }

    class PerfmonSetPath
    implements Runnable {
        PerfmonSetPath() {
        }

        public void run() {
            PerfmonPlugin.DBG.info("set test model save path");
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            Path container_savepath = null;
            IFolder container = null;
            try {
                container_savepath = new Path("" + JonasStatConModule.this.smodelpath);
                container = workspaceRoot.getFolder((IPath)container_savepath);
            }
            catch (Throwable e) {
                PerfmonPlugin.DBG.warning("could not find valid IContainer for model save path");
            }
            PerfmonPlugin.DBG.info("showing container selection dialog");
            ContainerSelectionDialog dialog = null;
            dialog = new ContainerSelectionDialog(JonasStatConModule.this.statcon.getGraphWindow().getShell(), (IContainer)container, false, PerfmonPlugin.getString("SMODEL_SELECT_PATH_DESCRIPTION"));
            dialog.open();
            Object[] result = dialog.getResult();
            if (result != null && result.length > 0) {
                URI savepath;
                Path container_path = (Path)result[0];
                JonasStatConModule.this.smodelpath = savepath = URI.createPlatformResourceURI((String)container_path.toString());
                PerfmonPlugin.DBG.info("updating menuitems to reflect new model save path");
                JonasStatConModule.this.redoActions();
                JonasStatConModule.this.statcon.setDirty(true);
            }
        }
    }
}

