/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.utils.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.utils.internal.DCAgentGenericLoader;
import org.eclipse.hyades.perfmon.utils.internal.StatisticalLoaderListener;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;

public class AgentUpdater
extends Thread
implements StatisticalLoaderListener {
    public boolean die;
    TRCAgent agent;
    StatConInterface statcon;
    Object list_lock = new Object();
    ArrayList descriptor_updates = new ArrayList();
    Map descriptor_map = Collections.synchronizedMap(new HashMap(300, 0.6f));
    ArrayList agent_updates = new ArrayList();

    public void shutdown() {
        this.die = true;
    }

    public AgentUpdater(StatConInterface statcon, TRCAgent trcagent, DCAgentGenericLoader loader) {
        this.agent = trcagent;
        this.statcon = statcon;
        this.setDaemon(true);
        loader.addLoaderListener(this);
        this.start();
        this.modelChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelChanged(SDDescriptor des) {
        SDDescriptor parent = des;
        Object object = this.list_lock;
        synchronized (object) {
            if (parent == null) {
                if (this.agent_updates.size() == 0) {
                    this.agent_updates.add(this.agent);
                }
            } else {
                if (this.descriptor_map.get(parent) != null) {
                    return;
                }
                SDDescriptor tmp = parent.getParent();
                while (tmp != null) {
                    if (this.descriptor_map.get(tmp) != null) {
                        return;
                    }
                    tmp = tmp.getParent();
                }
                this.descriptor_updates.add(parent);
                this.descriptor_map.put(parent, parent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collapse() {
        Object object = this.list_lock;
        synchronized (object) {
            if (this.agent_updates.size() > 0) {
                return;
            }
            if (this.descriptor_updates.size() > 350) {
                this.agent_updates.add(this.agent);
                return;
            }
            int i = 0;
            while (i < this.descriptor_updates.size()) {
                SDDescriptor descriptor = (SDDescriptor)this.descriptor_updates.get(i);
                SDDescriptor tmp = descriptor.getParent();
                while (tmp != null) {
                    if (this.descriptor_map.get(tmp) != null) {
                        this.descriptor_updates.remove(i--);
                        this.descriptor_map.remove(tmp);
                        break;
                    }
                    tmp = tmp.getParent();
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.die) {
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {
                // empty catch block
            }
            Object object = this.list_lock;
            synchronized (object) {
                this.collapse();
                if (this.agent_updates.size() > 0) {
                    this.statcon.getGraphWindow().getDisplay().syncExec((Runnable)new ListUpdate(this.agent_updates));
                } else if (this.descriptor_updates.size() > 0) {
                    this.statcon.getGraphWindow().getDisplay().syncExec((Runnable)new ListUpdate(this.descriptor_updates));
                }
                this.descriptor_updates = new ArrayList();
                this.descriptor_map = new HashMap();
                this.agent_updates = new ArrayList();
            }
        }
    }

    class ListUpdate
    extends Thread {
        ArrayList items;

        public ListUpdate(ArrayList items) {
            this.items = items;
        }

        public void run() {
            try {
                int i = 0;
                while (i < this.items.size()) {
                    Object o = this.items.get(i);
                    if (o instanceof SDDescriptor) {
                        AgentUpdater.this.statcon.updateModel((SDDescriptor)o);
                    } else if (o instanceof TRCAgent) {
                        AgentUpdater.this.statcon.updateAgent((TRCAgent)o);
                        return;
                    }
                    ++i;
                }
            }
            catch (Throwable t) {
                PerfmonPlugin.DBG.warning("couldnt update perfmon agent " + t);
            }
        }
    }
}

