/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.EditorPage;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditorDetailsPage;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditorOverviewPage;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.hyades.sdb.internal.util.ResourceStateInputProvider;
import org.eclipse.hyades.sdb.internal.util.ResourceStateValidatorImpl;
import org.eclipse.hyades.sdb.internal.util.SymptomDBSearchDialog;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.hyades.sdb.internal.util.ValidateSymptomDBEditListener;
import org.eclipse.hyades.ui.internal.editor.action.ActionHandlerListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.xml.sax.SAXParseException;

public class SymptomDBEditor
extends MultiPageEditorPart
implements ResourceStateInputProvider,
IResourceChangeListener,
IResourceDeltaVisitor {
    IFile iFile;
    SymptomDBEditorOverviewPage overviewPage = null;
    SymptomDBEditorDetailsPage detailsPage = null;
    private RASWidgetFactory factory = new RASWidgetFactory();
    private SDBRuntime fDatabase;
    private boolean dirtyUI = false;
    private boolean dirtyModel = false;
    private final String NL = System.getProperties().getProperty("line.separator");
    private List resources;
    private ValidateSymptomDBEditListener validateEditListener;
    private long cachedTimestamp;
    private ArrayList mofResources = new ArrayList(0);
    private boolean changed = false;
    private Display display;

    private RASWidgetFactory getWidgetFactory() {
        return this.factory;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof IFileEditorInput) {
            this.iFile = ((IFileEditorInput)input).getFile();
            this.setTitle(this.iFile.getName());
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.cachedTimestamp = this.getFileTimestamp();
        this.display = Display.getCurrent();
        this.enableEditActions();
    }

    public void createPages() {
        ScrolledComposite overviewForm = new ScrolledComposite(this.getContainer(), 768);
        overviewForm.setExpandHorizontal(true);
        overviewForm.setExpandVertical(true);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        overviewForm.setLayout((Layout)layout);
        this.overviewPage = new SymptomDBEditorOverviewPage(this.getWidgetFactory());
        overviewForm.setContent(this.overviewPage.getContent((Composite)overviewForm));
        int pageIndex = this.addPage((Control)overviewForm);
        this.setPageText(pageIndex, SDbPlugin.getResourceString("STR_OVERVIEW_LABEL"));
        WorkbenchHelp.setHelp((Control)overviewForm, (String)ContextIds.SYMDB_EDITOR_PAGE_OVERVIEW);
        ScrolledComposite viewForm = new ScrolledComposite(this.getContainer(), 768);
        viewForm.setExpandHorizontal(true);
        viewForm.setExpandVertical(true);
        layout = new GridLayout();
        layout.numColumns = 1;
        viewForm.setLayout((Layout)layout);
        this.detailsPage = new SymptomDBEditorDetailsPage(this.getWidgetFactory());
        viewForm.setContent(this.detailsPage.getContent((Composite)viewForm));
        Point p = this.detailsPage.getContent().computeSize(-1, -1);
        viewForm.setMinWidth(p.x);
        viewForm.setMinHeight(p.y);
        int pageIndex2 = this.addPage((Control)viewForm);
        this.setPageText(pageIndex2, SDbPlugin.getResourceString("STR_DETAILS_LABEL"));
        WorkbenchHelp.setHelp((Control)viewForm, (String)ContextIds.SYMDB_EDITOR_PAGE_DETAILS);
        this.overviewPage.init(this);
        if (this.getSearchDialog() != null) {
            this.getSearchDialog().setTarget(this.detailsPage);
            this.getSearchDialog().enableButton(false);
        }
    }

    protected void pageChange(int newPageIndex) {
        if (newPageIndex == 1) {
            if (this.fDatabase == null) {
                BusyIndicator.showWhile((Display)this.getContainer().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            SymptomDBEditor.this.loadModel();
                        }
                        catch (Exception e) {
                            String errMsg = SDbPlugin.getResourceString("STR_LOAD_MODEL_ERROR_");
                            MessageDialog.openError((Shell)SymptomDBEditor.this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)errMsg);
                            e.printStackTrace();
                            return;
                        }
                    }
                });
                this.validateEditListener = new ValidateSymptomDBEditListener((IWorkbenchPart)this, new ResourceStateValidatorImpl(this));
                this.setViewerInput();
            }
            this.setGlobalFindActionHandler((IAction)this.detailsPage.getFindAction());
            if (this.getSearchDialog() != null) {
                this.getSearchDialog().enableButton(true);
            }
        } else {
            this.setGlobalFindActionHandler(null);
        }
        if (newPageIndex == 0) {
            this.overviewPage.init(this);
            if (this.getSearchDialog() != null) {
                this.getSearchDialog().enableButton(false);
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.isModelDirty() && !this.detailsPage.updateCurrentSelection(this.detailsPage.getCurrentSelection())) {
                return;
            }
            if (this.validateEditListener.checkSave()) {
                this.changed = true;
                this.validateModel();
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("DECLARE_XML", Boolean.TRUE);
                this.fDatabase.eResource().save(options);
                this.changed = false;
                this.cachedTimestamp = this.getFileTimestamp();
                this.updateUIDirtyStatus(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = SDbPlugin.getResourceString("STR_SAVE_SYMPTOMDB_ERROR_");
            message = TString.change(message, "%1", this.fDatabase.getName());
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)message);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isDirtyUI() {
        return this.dirtyUI;
    }

    public void updateUIDirtyStatus(boolean newVal) {
        this.dirtyUI = newVal;
        this.firePropertyChange(257);
    }

    public boolean validateState(Widget widget, Listener listener, String oldValue) {
        boolean result = this.validateEditListener.validateState().isOK();
        if (!result && widget != null) {
            widget.removeListener(24, listener);
            if (widget instanceof Text) {
                ((Text)widget).setText(oldValue);
                widget.addListener(24, listener);
            } else if (widget instanceof CCombo) {
                ((CCombo)widget).setText(oldValue);
                widget.addListener(13, listener);
            }
        }
        return result;
    }

    public boolean isModelDirty() {
        return this.dirtyModel;
    }

    public void updateModelDirtyStatus(boolean newVal) {
        this.dirtyModel = newVal;
    }

    public boolean isDirty() {
        return this.isDirtyUI();
    }

    public void dispose() {
        this.factory.dispose();
        this.iFile.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public IFile getFile() {
        return this.iFile;
    }

    public SDBRuntime getModel() {
        return this.fDatabase;
    }

    public void loadModel() {
        if (this.fDatabase != null || this.iFile == null) {
            return;
        }
        try {
            SDBResourceSetImpl resourceSet = new SDBResourceSetImpl();
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcdbxmi", new SDBResourceFactoryImpl());
            Resource res = resourceSet.getResource(URI.createURI((String)("platform:/resource" + this.iFile.getFullPath().toString())), true);
            Iterator i = res.getContents().iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof SDBRuntime)) continue;
                this.fDatabase = (SDBRuntime)obj;
                EList sol = this.fDatabase.getSolutions();
                int j = 0;
                while (j < sol.size()) {
                    SDBSolution item = (SDBSolution)sol.get(j);
                    item.setDescription(this.convertToPlatformNL(item.getDescription()));
                    ++j;
                }
                EList dir = this.fDatabase.getDirectives();
                int j2 = 0;
                while (j2 < dir.size()) {
                    SDBDirective item = (SDBDirective)dir.get(j2);
                    item.setDirectiveString(this.convertToPlatformNL(item.getDirectiveString()));
                    ++j2;
                }
                return;
            }
        }
        catch (Exception e) {
            String errMsg = SDbPlugin.getResourceString("STR_LOAD_XMI_ERROR_");
            if (e instanceof SAXParseException) {
                Status error = new Status(2, "org.eclipse.core.resources", 566, SDbPlugin.getResourceString("STR_LOAD_XMI_EXC_REASON_"), (Throwable)e);
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)errMsg, (IStatus)error);
            } else {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)errMsg);
            }
            e.printStackTrace();
            return;
        }
    }

    public IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    public boolean isSetGlobalFindActionHandler() {
        IActionBars actionBars;
        IAction action = null;
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && (actionBars = ((EditorActionBarContributor)contributor).getActionBars()) != null) {
            action = actionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        }
        return action instanceof SymptomDBEditorDetailsPage.FindAction;
    }

    public IAction getGlobalFindActionHandler() {
        return this.detailsPage.getFindAction();
    }

    public SymptomDBSearchDialog getSearchDialog() {
        return this.detailsPage.getDialog();
    }

    public void setGlobalFindActionHandler(IAction action) {
        IEditorActionBarContributor contributor;
        if ((action == null || this.getActivePage() == 1) && (contributor = this.getEditorSite().getActionBarContributor()) != null) {
            IActionBars actionBars = ((EditorActionBarContributor)contributor).getActionBars();
            if (actionBars != null) {
                actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), action);
            }
            actionBars.updateActionBars();
        }
    }

    private String convertToPlatformNL(String input) {
        int i = 0;
        String output = input;
        String nl = "\r\n";
        if (this.NL.equals("\r\n")) {
            nl = "\n";
        } else if (this.NL.equals("\n")) {
            nl = "\r\n";
        }
        if (input.indexOf(nl) < 0) {
            return input;
        }
        StringBuffer lines = new StringBuffer();
        i = 0;
        int j = 0;
        if (this.NL.equals("\r\n")) {
            while (i <= input.length()) {
                j = input.indexOf(nl, i);
                if (j <= -1) {
                    lines.append(input.substring(i));
                    break;
                }
                if (j != 0 && input.charAt(j - 1) == '\r') {
                    lines.append(input.substring(i, j - 1) + this.NL);
                } else {
                    lines.append(input.substring(i, j) + this.NL);
                }
                i = j + nl.length();
            }
        } else if (this.NL.equals("\n")) {
            while (i <= input.length()) {
                j = input.indexOf(nl, i);
                if (j <= -1) {
                    lines.append(input.substring(i));
                    break;
                }
                lines.append(input.substring(i, j) + this.NL);
                i = j + nl.length();
            }
        }
        output = lines.toString();
        return output;
    }

    public List getNonResourceFiles() {
        if (this.resources == null) {
            this.resources = new ArrayList();
            this.resources.add(this.iFile);
        }
        return this.resources;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            IResourceDelta iFile_delta;
            if (delta != null && (iFile_delta = delta.findMember(this.iFile.getFullPath())) != null) {
                iFile_delta.accept((IResourceDeltaVisitor)this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean visit(IResourceDelta delta) {
        long currentTimestamp = this.getFileTimestamp();
        if (delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0 && this.cachedTimestamp != currentTimestamp && !this.changed) {
            if (this.fDatabase == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        SymptomDBEditor.this.overviewPage.init(SymptomDBEditor.this);
                    }
                });
            } else {
                this.refreshEditor();
            }
            this.cachedTimestamp = this.getFileTimestamp();
        }
        if (delta.getKind() == 2) {
            this.closeEditor();
        }
        return true;
    }

    private void setViewerInput() {
        Object[] root = new Object[]{this.fDatabase};
        this.detailsPage.getViewer().setInput((Object)root);
        this.detailsPage.setTreeRoot(root);
        this.detailsPage.getViewer().setExpandedState(root[0], true);
        this.detailsPage.init(this);
    }

    private void refreshEditor() {
        if (Thread.currentThread() == this.display.getThread()) {
            BusyIndicator.showWhile((Display)this.getContainer().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        SymptomDBEditor.this.fDatabase = null;
                        SymptomDBEditor.this.loadModel();
                        SymptomDBEditor.this.setViewerInput();
                        SymptomDBEditor.this.overviewPage.init(SymptomDBEditor.this);
                        SymptomDBEditor.this.updateUIDirtyStatus(false);
                    }
                    catch (Exception e) {
                        String errMsg = SDbPlugin.getResourceString("STR_LOAD_MODEL_ERROR_");
                        MessageDialog.openError((Shell)SymptomDBEditor.this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)errMsg);
                        e.printStackTrace();
                        return;
                    }
                }
            });
        } else {
            this.fDatabase = null;
            this.loadModel();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    SymptomDBEditor.this.setViewerInput();
                    SymptomDBEditor.this.overviewPage.init(SymptomDBEditor.this);
                    SymptomDBEditor.this.updateUIDirtyStatus(false);
                }
            });
        }
    }

    private void closeEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SymptomDBEditor.this.getSite().getPage().closeEditor((IEditorPart)SymptomDBEditor.this, false);
            }
        });
    }

    private long getFileTimestamp() {
        long currentTimestamp = 0L;
        IPath path = this.iFile.getLocation();
        if (path != null) {
            currentTimestamp = path.toFile().lastModified();
        }
        return currentTimestamp;
    }

    public Control getControl(int i) {
        return super.getControl(i);
    }

    public EditorPage getPage(int option) {
        EditorPage page = null;
        if (option == 0) {
            page = this.overviewPage;
        } else if (option == 1) {
            page = this.detailsPage;
        }
        return page;
    }

    public int getActivePage() {
        return super.getActivePage();
    }

    private void validateModel() {
        SDBSolution sol;
        Iterator solutions;
        Iterator directives = this.fDatabase.getDirectives().iterator();
        while (directives.hasNext()) {
            Iterator solutions2 = ((SDBDirective)directives.next()).getSolutions().iterator();
            while (solutions2.hasNext()) {
                SDBSolution sol2 = (SDBSolution)solutions2.next();
                if (sol2.eContainer() != null) continue;
                this.fDatabase.getSolutions().add((Object)sol2);
            }
        }
        Iterator symptoms = this.fDatabase.getSymptoms().iterator();
        while (symptoms.hasNext()) {
            solutions = ((SDBSymptom)symptoms.next()).getSolutions().iterator();
            while (solutions.hasNext()) {
                sol = (SDBSolution)solutions.next();
                if (sol.eContainer() != null) continue;
                this.fDatabase.getSolutions().add((Object)sol);
            }
        }
        solutions = this.fDatabase.getSolutions().iterator();
        while (solutions.hasNext()) {
            sol = (SDBSolution)solutions.next();
            Iterator ssymptoms = sol.getSymptoms().iterator();
            while (ssymptoms.hasNext()) {
                SDBSymptom sym = (SDBSymptom)ssymptoms.next();
                if (sym.eContainer() != null) continue;
                this.fDatabase.getSymptoms().add((Object)sym);
            }
            Iterator sdirectives = sol.getDirectives().iterator();
            while (sdirectives.hasNext()) {
                SDBDirective dir = (SDBDirective)sdirectives.next();
                if (dir.eContainer() != null) continue;
                this.fDatabase.getDirectives().add((Object)dir);
            }
        }
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }
}

