/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.wizard;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.SDbPluginImages;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;

public class NewSymptomDBWizardPage
extends WizardDataTransferPage
implements Listener {
    private Text txtLocationFolder;
    private Text txtDBName;
    private Text txtDescription;
    private Button btnLocationBrowse;
    private Button btnCreateFolderCheckbox;
    private Button btnOpenCheckbox;
    private String selFolder;
    private static final String DB_EXT = ".trcdbxmi";

    protected NewSymptomDBWizardPage(String pageName) {
        super(pageName);
        this.setTitle(SDbPlugin.getResourceString("STR_SYPMTOMDB_NEW_WIZARD_PTITLE"));
        this.setDescription(SDbPlugin.getResourceString("STR_SYPMTOMDB_NEW_WIZARD_PDESC"));
        this.setImageDescriptor(SDbPluginImages.getImageDescriptor("new_symptomdb_wiz.gif"));
    }

    protected void init(String selFolder) {
        this.selFolder = selFolder;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = GridUtil.createFill();
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        composite.setLayoutData((Object)data);
        Composite location = this.createLocationGroup(composite);
        this.createNameGroup(location);
        this.createSpacer(composite);
        this.createOptionsGroup(composite);
        this.setControl((Control)composite);
        this.btnLocationBrowse.addListener(13, (Listener)this);
        this.txtLocationFolder.addListener(24, (Listener)this);
        this.txtDBName.addListener(24, (Listener)this);
        this.txtDescription.addListener(24, (Listener)this);
        this.setPageComplete(false);
        WorkbenchHelp.setHelp((Control)this.txtLocationFolder, (String)ContextIds.NEW_SYMDB_LOCATION);
        WorkbenchHelp.setHelp((Control)this.txtDBName, (String)ContextIds.NEW_SYMDB_NAME);
        WorkbenchHelp.setHelp((Control)this.txtDescription, (String)ContextIds.NEW_SYMDB_DESCRIPTION);
        WorkbenchHelp.setHelp((Control)this.btnCreateFolderCheckbox, (String)ContextIds.NEW_SYMDB_CREATE_FOLDER);
    }

    private Composite createLocationGroup(Composite composite) {
        Composite locationGrp = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 2;
        GridData data = GridUtil.createHorizontalFill();
        data.widthHint = 300;
        locationGrp.setLayout((Layout)layout);
        locationGrp.setLayoutData((Object)data);
        Label locationLabel = new Label(locationGrp, 0);
        data = new GridData();
        locationLabel.setLayoutData((Object)data);
        locationLabel.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_LOCATION"));
        this.txtLocationFolder = new Text(locationGrp, 2048);
        data = GridUtil.createHorizontalFill();
        this.txtLocationFolder.setLayoutData((Object)data);
        this.txtLocationFolder.setText(this.selFolder);
        this.btnLocationBrowse = new Button(locationGrp, 8);
        this.btnLocationBrowse.setText(SDbPlugin.getResourceString("BROWSE"));
        return locationGrp;
    }

    public void createNameGroup(Composite parent) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_NAME"));
        this.txtDBName = new Text(parent, 2048);
        this.txtDBName.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label dummy = new Label(parent, 0);
        dummy.setVisible(false);
        Label descriptionLabel = new Label(parent, 0);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        descriptionLabel.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_DESCRIPTION"));
        descriptionLabel.setLayoutData((Object)data);
        this.txtDescription = new Text(parent, 2050);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.heightHint = 150;
        this.txtDescription.setLayoutData((Object)data);
    }

    public void createOptionsGroup(Composite composite) {
        Composite optionsGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label label = new Label(optionsGroup, 0);
        label.setText(SDbPlugin.getResourceString("ExportDBWizardPage.options"));
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        this.btnCreateFolderCheckbox = new Button(optionsGroup, 16416);
        this.btnCreateFolderCheckbox.setText(SDbPlugin.getResourceString("ExportDBWizardPage.create.folder.str"));
        this.btnOpenCheckbox = new Button(optionsGroup, 16416);
        this.btnOpenCheckbox.setText(SDbPlugin.getResourceString("STR_OPTION_OPEN"));
        this.btnOpenCheckbox.setSelection(true);
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    private IContainer createContainer(IPath path) {
        IFolder container = null;
        IWorkspace workbench = ResourcesPlugin.getWorkspace();
        int segCount = path.segmentCount();
        int idx = 0;
        while (idx < segCount) {
            String seg = path.segment(idx);
            if (idx == 0) {
                IProject project = workbench.getRoot().getProject(path.uptoSegment(idx + 1).toString());
                if (project == null || !project.exists()) {
                    try {
                        project.create(null);
                        project.open(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                container = project;
            } else {
                IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx + 1));
                if (folder == null || !folder.exists()) {
                    try {
                        folder.create(false, true, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                container = folder;
            }
            ++idx;
        }
        try {
            container.getProject().refreshLocal(2, null);
        }
        catch (CoreException exc) {
            exc.printStackTrace();
        }
        return container;
    }

    private void showResourceDialog() {
        Object[] result;
        ContainerSelectionDialog dialog;
        Path path = new Path(this.txtLocationFolder.getText().trim());
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        IContainer cont = null;
        if (res != null && res.exists() && res instanceof IContainer) {
            cont = (IContainer)res;
        }
        if ((dialog = new ContainerSelectionDialog(this.getShell(), cont, true, SDbPlugin.getResourceString("STR_RES_DLG_MSG"))).open() == 0 && (result = dialog.getResult()) != null && result.length == 1 && result[0] != null) {
            this.txtLocationFolder.setText(((IPath)result[0]).toOSString());
        }
    }

    protected boolean validateLocationGroup() {
        IStatus pathStatus;
        String locationFieldContents = this.txtLocationFolder.getText().trim();
        if (locationFieldContents.equals("")) {
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (locationFieldContents.charAt(0) != File.separatorChar) {
            locationFieldContents = File.separatorChar + locationFieldContents;
        }
        if (!(pathStatus = workspace.validatePath(locationFieldContents, 6)).isOK()) {
            this.setErrorMessage(pathStatus.getMessage());
            return false;
        }
        return true;
    }

    protected boolean validateNameGroup() {
        return !this.txtDBName.getText().trim().equals("") && this.checkDBName() && this.checkFilePath();
    }

    protected boolean determinePageCompletion() {
        boolean complete;
        boolean bl = complete = this.validateLocationGroup() && this.validateNameGroup();
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    public boolean performFinish() {
        block7: {
            int idx;
            IWorkspace workbench = ResourcesPlugin.getWorkspace();
            Object container = null;
            Path path = new Path(this.txtLocationFolder.getText().trim());
            container = this.btnCreateFolderCheckbox.getSelection() ? this.createContainer((IPath)path) : ((idx = path.segmentCount()) == 1 ? workbench.getRoot().getProject(path.toString()) : workbench.getRoot().getFolder((IPath)path));
            if (container == null || !container.exists()) {
                if (this.queryYesNoQuestion(SDbPlugin.getResourceString("STR_CONTAINER_NOT_FOUND"))) {
                    container = this.createContainer((IPath)path);
                } else {
                    return false;
                }
            }
            String fName = container.getFullPath().toOSString().substring(1) + File.separator + this.checkFileExtension();
            String sdbPath = new Path(fName).toString();
            URI uri = URI.createURI((String)("platform:/resource/" + sdbPath));
            Resource dbDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
            EList ext = dbDoc.getContents();
            SDbPlugin.getDefault().getResourceSet().getResources().add((Object)dbDoc);
            SDBFactoryImpl objFactory = SDbPlugin.getDefault().getSDBFactory();
            SDBRuntime db = objFactory.createSDBRuntime();
            db.setName(this.txtDBName.getText());
            db.setDescription(this.txtDescription.getText());
            db.setSymptomUrl("");
            db.setLocalExternalFileLocation("");
            ext.add((Object)db);
            try {
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("DECLARE_XML", Boolean.TRUE);
                dbDoc.save(options);
                container.refreshLocal(2, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.saveInPreferenceStore(sdbPath);
            SDbPlugin.getDefault().getResourceSet().getResources().remove((Object)dbDoc);
            if (!this.btnOpenCheckbox.getSelection()) break block7;
            try {
                IFile file = (IFile)container.findMember(this.checkFileExtension());
                IDE.openEditor((IWorkbenchPage)SDbPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private void saveInPreferenceStore(String sdbPath) {
        IPreferenceStore store = SDbPlugin.getDefault().getPreferenceStore();
        String prefPath = store.getString("symptom_db_path");
        sdbPath = "/" + sdbPath;
        prefPath = prefPath.length() > 0 ? prefPath + ";" + sdbPath + ",1" : sdbPath + ",1";
        store.setValue("symptom_db_path", prefPath);
    }

    private String checkFileExtension() {
        String text = this.txtDBName.getText();
        if (text.endsWith(DB_EXT)) {
            if (text.length() != DB_EXT.length()) {
                return text;
            }
            return "error";
        }
        return text + DB_EXT;
    }

    private boolean checkFilePath() {
        String dbName = this.checkFileExtension();
        if (dbName.equals("error")) {
            this.setErrorMessage(SDbPlugin.getResourceString("STR_INVALID_NAME_MSG"));
            return false;
        }
        String fName = this.txtLocationFolder.getText() + File.separator + dbName;
        Path path = new Path(fName);
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (res != null) {
            String message = SDbPlugin.getResourceString("STR_FILE_EXISTS_MSG");
            message = TString.change(message, "%1", fName);
            this.setErrorMessage(message);
            return false;
        }
        return true;
    }

    private boolean checkDBName() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(this.txtDBName.getText(), 1);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        return true;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.btnLocationBrowse) {
            this.showResourceDialog();
        }
        if (event.widget == this.txtLocationFolder) {
            if (this.txtLocationFolder.getText().trim().length() == 0) {
                this.setErrorMessage(SDbPlugin.getResourceString("STR_INVALID_LOCATION_MSG"));
            } else {
                this.setErrorMessage(null);
            }
        }
        if (event.widget == this.txtDBName) {
            if (this.txtDBName.getText().trim().length() == 0) {
                this.setErrorMessage(SDbPlugin.getResourceString("STR_INVALID_NAME_MSG"));
            } else {
                this.setErrorMessage(null);
            }
        }
        this.setPageComplete(this.determinePageCompletion());
    }

    public Text getTxtDBName() {
        return this.txtDBName;
    }

    public void setTxtDBName(Text txtDBName) {
        this.txtDBName = txtDBName;
    }
}

