/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.classloader;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.hyades.ui.internal.classloader.FileClassLoader;
import org.eclipse.hyades.ui.internal.util.FileUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;

public class PathEntriesClassLoader
extends FileClassLoader {
    private Hashtable entryDataByPathEntry;
    private Vector directories;

    public PathEntriesClassLoader(String pathEntries) {
        super(pathEntries);
        this.initialize(pathEntries);
    }

    public PathEntriesClassLoader(ClassLoader parent, String pathEntries) {
        super(parent, pathEntries);
        this.initialize(pathEntries);
    }

    private void initialize(String pathEntries) {
        this.entryDataByPathEntry = new Hashtable();
        this.directories = new Vector();
        if (pathEntries != null) {
            String[] auxEntries = StringUtil.tokenizer(pathEntries, File.pathSeparator, false);
            int i = 0;
            int maxi = auxEntries.length;
            while (i < maxi) {
                String entry = auxEntries[i].trim();
                File file = new File(entry);
                if (file.exists() && file.isDirectory()) {
                    this.directories.add(entry);
                } else {
                    this.entryDataByPathEntry.putAll(FileUtil.getZipEntryDataByZipEntryName(entry));
                }
                ++i;
            }
        }
    }

    protected byte[] loadClassBytes(String className) {
        byte[] ret = (byte[])this.entryDataByPathEntry.get(this.formatClassName(className));
        if (ret != null) {
            return ret;
        }
        Iterator i = this.directories.iterator();
        while (i.hasNext()) {
            String dir = (String)i.next();
            ret = super.loadClassBytes(className, dir);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

