/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.hyades.ui.internal.extension.NavigatorFilterSet;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class NavigatorExtensionUtil {
    private static final String ALL = "all";
    private static final Map _contributions = new HashMap();
    private static final Map _filterSets = new HashMap();

    public static void fillContextMenu(IMenuManager menu, IStructuredSelection selection, String navigatorID) {
        INavigatorContribution[] e = NavigatorExtensionUtil.getContributions(navigatorID);
        int i = 0;
        while (i < e.length) {
            e[i].fillContextMenu(menu, selection);
            ++i;
        }
    }

    public static boolean select(Viewer viewer, Object parent, Object element, String navigatorID) {
        return NavigatorExtensionUtil.select(viewer, parent, element, navigatorID, false) || NavigatorExtensionUtil.select(viewer, parent, element, navigatorID, true);
    }

    public static boolean select(Viewer viewer, Object parent, Object element, String navigatorID, boolean recursive) {
        NavigatorFilterSet[] sets = NavigatorExtensionUtil.getFilterSetElements(navigatorID);
        int i = 0;
        while (i < sets.length) {
            if (sets[i].isEnabled() && sets[i].isRecursive() == recursive && sets[i].getViewerFilter().select(viewer, parent, element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static INavigatorContribution[] getContributions(String navigatorID) {
        INavigatorContribution[] cached = (INavigatorContribution[])_contributions.get(navigatorID == null ? ALL : navigatorID);
        if (cached == null) {
            IExtension[] exts = HyadesUIPlugin.getInstance().getDescriptor().getExtensionPoint("navigatorExtensions").getExtensions();
            ArrayList list = new ArrayList();
            int i = 0;
            while (i < exts.length) {
                IConfigurationElement[] elements = exts[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if ("navigatorContribution".equals(elements[j].getName())) {
                        String nav = elements[j].getAttribute("navigatorID");
                        if (navigatorID == null || navigatorID.equals(nav)) {
                            try {
                                String className = elements[j].getAttribute("class");
                                Class<?> classObj = exts[i].getDeclaringPluginDescriptor().getPluginClassLoader().loadClass(className);
                                list.add(classObj.newInstance());
                            }
                            catch (Exception e) {
                                HyadesUIPlugin.logError(e);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            cached = new INavigatorContribution[list.size()];
            list.toArray(cached);
            _contributions.put(navigatorID == null ? ALL : navigatorID, cached);
        }
        return cached;
    }

    public static NavigatorFilterSet getFilterSetElement(String filterID) {
        if (filterID == null) {
            return null;
        }
        NavigatorFilterSet[] e = NavigatorExtensionUtil.getFilterSetElements(null);
        int i = 0;
        while (i < e.length) {
            if (filterID.equals(e[i].getID())) {
                return e[i];
            }
            ++i;
        }
        return null;
    }

    public static NavigatorFilterSet[] getFilterSetElements(String navigatorID) {
        NavigatorFilterSet[] cached = (NavigatorFilterSet[])_filterSets.get(navigatorID == null ? ALL : navigatorID);
        if (cached == null) {
            IExtension[] exts = HyadesUIPlugin.getInstance().getDescriptor().getExtensionPoint("navigatorExtensions").getExtensions();
            ArrayList<NavigatorFilterSet> list = new ArrayList<NavigatorFilterSet>();
            int i = 0;
            while (i < exts.length) {
                IConfigurationElement[] elements = exts[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if ("navigatorFilterSet".equals(elements[j].getName())) {
                        String nav = elements[j].getAttribute("navigatorID");
                        if (navigatorID == null || navigatorID.equals(nav)) {
                            try {
                                list.add(new NavigatorFilterSet(elements[j]));
                            }
                            catch (Exception e) {
                                HyadesUIPlugin.logError(e);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            cached = new NavigatorFilterSet[list.size()];
            list.toArray(cached);
            _filterSets.put(navigatorID == null ? ALL : navigatorID, cached);
        }
        return cached;
    }

    public static boolean hasChildren(Object item, String navigatorID) {
        INavigatorContribution[] e = NavigatorExtensionUtil.getContributions(navigatorID);
        int i = 0;
        while (i < e.length) {
            if (e[i].hasChildren(item)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List getAllChildren(Object item, String navigatorID) {
        INavigatorContribution[] e = NavigatorExtensionUtil.getContributions(navigatorID);
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < e.length) {
            list.addAll(e[i].getChildren(item));
            ++i;
        }
        return list;
    }

    public static Collection getAllModifiedItems(String navigatorID) {
        INavigatorContribution[] e = NavigatorExtensionUtil.getContributions(navigatorID);
        HashSet c = new HashSet();
        int i = 0;
        while (i < e.length) {
            c.addAll(e[i].getModifiedItems());
            ++i;
        }
        return c;
    }

    public static void disposeAll() {
        Iterator iter = _contributions.values().iterator();
        while (iter.hasNext()) {
            INavigatorContribution[] e = (INavigatorContribution[])iter.next();
            int i = 0;
            while (i < e.length) {
                e[i].dispose();
                e[i] = null;
                ++i;
            }
        }
        _contributions.clear();
    }
}

