/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class LocationPage
extends WizardNewFileCreationPage {
    private String fileExtension;
    private boolean allowOverwrite = false;

    public LocationPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
    }

    public void setAllowOverwrite(boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
    }

    public boolean allowOverwrite() {
        return this.allowOverwrite;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    protected boolean validatePage() {
        IPath path;
        this.setMessage(null);
        if (!this.allowOverwrite() && (path = this.getContainerFullPath()) != null) {
            IResource resource;
            String fileName = this.getFileName();
            if (fileName.length() == 0) {
                this.setErrorMessage(null);
                return false;
            }
            if (fileName.startsWith(".")) {
                this.setErrorMessage(HyadesUIPlugin.getString("_ERROR_FILE_NAME_EXT"));
                return false;
            }
            if (!fileName.endsWith("." + this.fileExtension)) {
                fileName = fileName + "." + this.fileExtension;
            }
            if ((resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path.append(fileName))) != null && resource.exists()) {
                this.setErrorMessage(IDEWorkbenchMessages.format((String)"ResourceGroup.nameExists", (Object[])new String[]{fileName}));
                return false;
            }
        }
        return super.validatePage();
    }
}

