/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcesses;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;

public class TraceInteractionUtils {
    private static final boolean unitTestDebug = false;

    public static void searchTRCProcesses(EObject object, TraceProcesses list, IProgressMonitor monitor) {
        TRCAgent agent;
        TRCProcess process;
        if (monitor.isCanceled()) {
            return;
        }
        if (object instanceof TRCMonitor) {
            TRCMonitor m = (TRCMonitor)object;
            if (m.getNodes() == null || m.getNodes().isEmpty()) {
                return;
            }
            Iterator i = m.getNodes().iterator();
            while (i.hasNext() && !monitor.isCanceled()) {
                TraceInteractionUtils.searchTRCProcesses((EObject)i.next(), list, monitor);
            }
        } else if (object instanceof TRCNode) {
            TRCNode n = (TRCNode)object;
            if (n.getProcessProxies() == null || n.getProcessProxies().isEmpty()) {
                return;
            }
            Iterator i = n.getProcessProxies().iterator();
            while (i.hasNext() && !monitor.isCanceled()) {
                TraceInteractionUtils.searchTRCProcesses((EObject)i.next(), list, monitor);
            }
        } else if (object instanceof TRCProcessProxy) {
            TRCProcessProxy pp = (TRCProcessProxy)object;
            if (pp.getAgentProxies() == null || pp.getAgentProxies().isEmpty()) {
                return;
            }
            Iterator i = pp.getAgentProxies().iterator();
            while (i.hasNext() && !monitor.isCanceled()) {
                TraceInteractionUtils.searchTRCProcesses((EObject)i.next(), list, monitor);
            }
        } else if (object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals("Profiler") && (process = TraceUtils.getProcess((TRCAgent)(agent = ((TRCAgentProxy)object).getAgent()))) != null && process.getInvocations() != null && process.getInvocations().size() > 0) {
            list.add(new TraceProcess(process));
        }
    }

    public static List getProfileAgents(TRCProcessProxy processProxy) {
        ArrayList<TRCAgentProxy> profileAgents = new ArrayList<TRCAgentProxy>();
        if (processProxy != null) {
            EList agents = processProxy.getAgentProxies();
            TRCAgentProxy agentProxy = null;
            Iterator iterator = agents.iterator();
            while (iterator.hasNext()) {
                agentProxy = (TRCAgentProxy)iterator.next();
                if (!"Profiler".equals(agentProxy.getType())) continue;
                profileAgents.add(agentProxy);
            }
        }
        return profileAgents;
    }

    public static double getAbsoluteEntryTime(TRCFullMethodInvocation methodInvocation) {
        return TraceInteractionUtils.getAbsoluteEntryTime(methodInvocation.getProcess().getAgent()) + methodInvocation.getEntryTime();
    }

    public static double getAbsoluteEntryTime(TRCAgent agent) {
        double delta = agent.getAgentProxy().getProcessProxy().getNode().getDeltaTime() / 1000000.0;
        return delta + agent.getStartTime();
    }

    public static double getAbsoluteEntryTime(TRCProcess process) {
        return TraceInteractionUtils.getAbsoluteEntryTime(process.getAgent()) + process.getStartTime();
    }

    public static double getAbsoluteEntryTime(TRCThread thread) {
        return TraceInteractionUtils.getAbsoluteEntryTime(thread.getProcess().getAgent()) + thread.getStartTime();
    }

    public static double getAbsoluteExitTime(TRCFullMethodInvocation methodInvocation) {
        double start = TraceInteractionUtils.getAbsoluteEntryTime(methodInvocation.getProcess().getAgent());
        if (methodInvocation.getExitTime() != 0.0) {
            return start + methodInvocation.getExitTime();
        }
        if (methodInvocation.getInvokes() == null || methodInvocation.getInvokes().size() == 0) {
            return TraceInteractionUtils.getAbsoluteExitTime(methodInvocation.getThread());
        }
        TRCFullMethodInvocation lastCalled = (TRCFullMethodInvocation)methodInvocation.getInvokes().get(methodInvocation.getInvokes().size() - 1);
        if (lastCalled.getExitTime() == 0.0) {
            return TraceInteractionUtils.getAbsoluteExitTime(lastCalled);
        }
        return start + lastCalled.getExitTime();
    }

    public static double getAbsoluteExitTime(TRCAgent agent) {
        double delta = agent.getAgentProxy().getProcessProxy().getNode().getDeltaTime() / 1000000.0;
        return delta + agent.getStopTime();
    }

    public static double getAbsoluteExitTime(TRCProcess process) {
        if (process.getStopTime() == 0.0) {
            return TraceInteractionUtils.getAbsoluteExitTime(process.getAgent());
        }
        return TraceInteractionUtils.getAbsoluteEntryTime(process.getAgent()) + process.getStopTime();
    }

    public static double getAbsoluteExitTime(TRCThread thread) {
        if (thread.getStopTime() == 0.0) {
            return TraceInteractionUtils.getAbsoluteExitTime(thread.getProcess().getAgent());
        }
        return TraceInteractionUtils.getAbsoluteEntryTime(thread.getProcess().getAgent()) + thread.getStopTime();
    }

    public static boolean matchCharacter(char c1, char c2, boolean isCaseSensitive) {
        if (TraceSDPlugin.debugMatch) {
            // empty if block
        }
        return c1 == c2 || !isCaseSensitive && Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    private static boolean trailingStars(char[] s, int l) {
        int i = l;
        while (i < s.length && s[i] == '*') {
            ++i;
        }
        return i == s.length;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean matchCriteria(String s, Criteria criteria) {
        try {
            e = criteria.getExpression();
            ea = e.toCharArray();
            if (TraceSDPlugin.debugMatch) {
                // empty if block
            }
            i = 0;
            j = 0;
            while (i < s.length() && j < ea.length) {
                block22: {
                    block21: {
                        sc = s.charAt(i);
                        ec = ea[j];
                        if (TraceSDPlugin.debugMatch) {
                            // empty if block
                        }
                        if (ec == 42) {
                            if (j + 1 == ea.length) {
                                if (TraceSDPlugin.debugMatch) {
                                    // empty if block
                                }
                                return true;
                            }
                            if (ea[j + 1] == '?') {
                                ea[j] = 63;
                                ec = 63;
                                ea[j + 1] = 42;
                            }
                        }
                        if (ec != 42) break block21;
                        k = 1;
                        while (i + k - 1 < s.length() && j + k < ea.length) {
                            if (ea[j + k] == '*' || ea[j + k] == '?') {
                                j += k;
                                i += k - 2;
                                break;
                            }
                            if (!TraceInteractionUtils.matchCharacter(s.charAt(i + k - 1), ea[j + k], criteria.isCaseSenstiveSelected())) break;
                            ++k;
                        }
                        if (TraceSDPlugin.debugMatch) {
                            // empty if block
                        }
                        if (i + k - 1 == s.length() && TraceInteractionUtils.trailingStars(ea, j + k)) {
                            if (TraceSDPlugin.debugMatch) {
                                // empty if block
                            }
                            return true;
                        }
                        break block22;
                    }
                    if (ec != 63) ** GOTO lbl47
                    if (i + 1 < s.length() && j + 1 < ea.length) {
                        ++j;
                    } else {
                        if (TraceSDPlugin.debugMatch) {
                            // empty if block
                        }
                        return i + 1 == s.length() && TraceInteractionUtils.trailingStars(ea, j + 1) != false;
lbl47:
                        // 1 sources

                        if (!TraceInteractionUtils.matchCharacter(sc, (char)ec, criteria.isCaseSenstiveSelected())) {
                            if (TraceSDPlugin.debugMatch) {
                                // empty if block
                            }
                            return false;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (TraceSDPlugin.debugMatch) {
                // empty if block
            }
            return i == s.length() && TraceInteractionUtils.trailingStars(ea, j) != false;
        }
        catch (Exception e) {
            if (TraceSDPlugin.debugMatch) {
                e.printStackTrace();
            }
            return false;
        }
    }
}

