/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.actions;

import java.util.Iterator;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class GoToNextLifelineMessage
implements IViewActionDelegate {
    protected SDView viewer = null;

    public void init(IViewPart view) {
        if (view instanceof SDView) {
            this.viewer = (SDView)view;
        }
    }

    public void run(IAction action) {
        Object node;
        if (this.viewer == null) {
            return;
        }
        SDWidget sdWidget = this.viewer.getSDWidget();
        Frame frame = this.viewer.getFrame();
        if (frame == null || sdWidget == null) {
            return;
        }
        ISelectionProvider selProvider = sdWidget.getSelectionProvider();
        ISelection sel = selProvider.getSelection();
        Object selectedNode = null;
        Iterator it = ((StructuredSelection)sel).iterator();
        while (it.hasNext()) {
            node = it.next();
            if (!(node instanceof BaseMessage) && !(node instanceof Lifeline)) continue;
            selectedNode = node;
        }
        if (selectedNode instanceof BaseMessage) {
            node = frame.getNextLifelineMessage(((BaseMessage)selectedNode).getStartLifeline(), selectedNode);
        } else if (selectedNode instanceof Lifeline) {
            node = frame.getNextLifelineMessage(selectedNode, null);
        } else {
            return;
        }
        if (node != null) {
            sdWidget.clearSelection();
            sdWidget.addSelection((GraphNode)node);
            sdWidget.ensureVisible((GraphNode)node);
            sdWidget.redraw();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

