/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDGraphNodeSupporter;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.TabContents;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Stop;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.help.WorkbenchHelp;

public class SearchFilterDialog
extends Dialog {
    private static final String FIND_CRITERIA = "findCriteria";
    private static final String FIND_EXPRESSION_LIST = "findExpressionList";
    private static final String FILTER_CRITERIA = "filterCriteria";
    private static final String FILTER_EXPRESSION_LIST = "filterExpressionList";
    private static final int MAX_EXPRESSION_LIST = 7;
    private SDView viewer = null;
    private TabFolder tab = null;
    private TabContents content = null;
    private Criteria criteria = null;
    private ISDGraphNodeSupporter provider = null;
    private String okText;
    private String title;
    private String[] expressionList;
    private boolean find;

    public Control createDialogArea(Composite arg0) {
        if (this.provider instanceof ISDFindProvider) {
            WorkbenchHelp.setHelp((Control)arg0, (String)(SDViewerPlugin.getId() + ".UML2SDFIND"));
        } else if (this.provider instanceof ISDFilterProvider) {
            WorkbenchHelp.setHelp((Control)arg0, (String)(SDViewerPlugin.getId() + ".UML2SDFILTER"));
        }
        this.expressionList = this.find ? SDViewerPlugin.getDefault().getDialogSettings().getArray(FIND_EXPRESSION_LIST) : SDViewerPlugin.getDefault().getDialogSettings().getArray(FILTER_EXPRESSION_LIST);
        if (this.expressionList == null) {
            this.expressionList = new String[0];
        }
        return new TabContents(arg0, this.provider, this.getButton(0), this.expressionList);
    }

    public SearchFilterDialog(SDView view_, ISDGraphNodeSupporter provider_, boolean filter_, int style) {
        super(view_.getSDWidget().getShell());
        this.setShellStyle(0x860 | style);
        this.provider = provider_;
        this.viewer = view_;
        this.find = !filter_;
    }

    public int open() {
        this.create();
        if (this.criteria == null) {
            this.loadCriteria();
        }
        if (this.criteria == null) {
            this.criteria = new Criteria();
            this.criteria.setLifeLineSelected(this.provider.isLifelineSupported());
            this.criteria.setSyncMessageSelected(this.provider.isSyncMessageSupported());
            this.criteria.setSyncMessageReturnSelected(this.provider.isSyncMessageReturnSupported());
            this.criteria.setAsyncMessageSelected(this.provider.isAsyncMessageSupported());
            this.criteria.setAsyncMessageReturnSelected(this.provider.isAsyncMessageReturnSupported());
            this.criteria.setStopSelected(this.provider.isStopSupported());
        }
        this.copyFromCriteria(this.criteria);
        if (this.okText != null) {
            this.getButton(0).setText(this.okText);
        } else {
            this.getButton(0).setText(SDViewerPlugin.getResourceString("SEARCH_DIALOG_SEARCH_BUTTON"));
        }
        if (this.find) {
            this.getButton(1).setText(SDViewerPlugin.getResourceString("SEARCH_DIALOG_CLOSE_BUTTON"));
        }
        Button okButton = this.getButton(0);
        ((TabContents)this.getDialogArea()).setOkButton(okButton);
        if (!(this.criteria != null && this.criteria.getExpression() != null && !this.criteria.getExpression().equals("") && (this.criteria.isAsyncMessageReturnSelected() || this.criteria.isAsyncMessageSelected() || this.criteria.isLifeLineSelected() || this.criteria.isStopSelected() || this.criteria.isSyncMessageReturnSelected() || this.criteria.isSyncMessageSelected()))) {
            okButton.setEnabled(false);
        }
        if (this.title != null) {
            this.getShell().setText(this.title);
        } else {
            this.getShell().setText(SDViewerPlugin.getResourceString("SEARCH_DIALOG_TITLE"));
        }
        this.getShell().pack();
        this.getShell().setLocation(this.getShell().getDisplay().getCursorLocation());
        this.criteria = null;
        return super.open();
    }

    private void loadCriteria() {
        String CRITERIA = FIND_CRITERIA;
        if (!this.find) {
            CRITERIA = FILTER_CRITERIA;
        }
        DialogSettings section = (DialogSettings)SDViewerPlugin.getDefault().getDialogSettings().getSection(CRITERIA);
        List selection = this.viewer.getSDWidget().getSelection();
        if (selection == null || selection.size() != 1 || !this.find) {
            if (section != null) {
                this.criteria = new Criteria();
                this.criteria.load(section);
            }
        } else {
            GraphNode gn = (GraphNode)selection.get(0);
            this.criteria = new Criteria();
            this.criteria.setExpression(gn.getName());
            this.criteria.setCaseSenstiveSelected(true);
            if (gn instanceof Lifeline && this.provider.isLifelineSupported()) {
                this.criteria.setLifeLineSelected(true);
            } else if (gn instanceof SyncMessageReturn && this.provider.isSyncMessageReturnSupported()) {
                this.criteria.setSyncMessageReturnSelected(true);
            } else if ((gn instanceof SyncMessageReturn || gn instanceof SyncMessage) && this.provider.isSyncMessageSupported()) {
                this.criteria.setSyncMessageSelected(true);
            } else if (gn instanceof AsyncMessageReturn && this.provider.isAsyncMessageReturnSupported()) {
                this.criteria.setAsyncMessageReturnSelected(true);
            } else if ((gn instanceof AsyncMessageReturn || gn instanceof AsyncMessage) && this.provider.isAsyncMessageSupported()) {
                this.criteria.setAsyncMessageSelected(true);
            } else if (gn instanceof Stop && this.provider.isStopSupported()) {
                this.criteria.setStopSelected(true);
            }
        }
    }

    public void okPressed() {
        this.copyToCriteria();
        if (!this.find) {
            this.saveCriteria();
            super.close();
        }
        if (this.provider != null && this.provider instanceof ISDFindProvider && this.find) {
            boolean result = ((ISDFindProvider)this.provider).find(this.criteria);
            TabContents content = this.getTabContents();
            content.setResult(result);
        }
    }

    public void cancelPressed() {
        if (this.find) {
            this.copyToCriteria();
            if (this.provider instanceof ISDFindProvider) {
                ((ISDFindProvider)this.provider).cancel();
            }
            this.saveCriteria();
        }
        super.cancelPressed();
    }

    public void saveCriteria() {
        DialogSettings settings;
        DialogSettings section;
        String CRITERIA = FIND_CRITERIA;
        String EXPRESSION_LIST = FIND_EXPRESSION_LIST;
        if (!this.find) {
            CRITERIA = FILTER_CRITERIA;
            EXPRESSION_LIST = FILTER_EXPRESSION_LIST;
        }
        if ((section = (DialogSettings)(settings = (DialogSettings)SDViewerPlugin.getDefault().getDialogSettings()).getSection(CRITERIA)) == null) {
            section = (DialogSettings)settings.addNewSection(CRITERIA);
        }
        this.criteria.save(section);
        if (this.criteria.getExpression().length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < this.expressionList.length) {
                list.add(this.expressionList[i].intern());
                ++i;
            }
            list.remove(this.criteria.getExpression().intern());
            list.add(0, this.criteria.getExpression().intern());
            int size = Math.min(list.size(), 7);
            String[] temp = new String[size];
            int i2 = 0;
            while (i2 < size) {
                temp[i2] = (String)list.get(i2);
                ++i2;
            }
            this.expressionList = temp;
            settings.put(EXPRESSION_LIST, this.expressionList);
        }
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Criteria criteria_) {
        this.criteria = criteria_;
    }

    public void copyToCriteria() {
        this.criteria = new Criteria();
        TabContents content = this.getTabContents();
        this.criteria.setLifeLineSelected(content.getLifelineButtonSelection());
        this.criteria.setSyncMessageSelected(content.getSynMessageButtonSelection());
        this.criteria.setSyncMessageReturnSelected(content.getSynMessageReturnButtonSelection());
        this.criteria.setAsyncMessageSelected(content.getAsynMessageButtonSelection());
        this.criteria.setAsyncMessageReturnSelected(content.getAsynMessageReturnButtonSelection());
        this.criteria.setStopSelected(content.getStopButtonSelection());
        this.criteria.setCaseSenstiveSelected(content.getCaseSensitiveSelection());
        this.criteria.setExpression(content.getSearchText());
    }

    private TabContents getTabContents() {
        TabContents content = null;
        content = this.tab == null ? (TabContents)this.getDialogArea() : (TabContents)this.tab.getSelection()[0].getControl();
        return content;
    }

    public void copyFromCriteria(Criteria from) {
        TabContents content = this.getTabContents();
        content.setLifelineButtonSelection(from.isLifeLineSelected());
        content.setSynMessageButtonSelection(from.isSyncMessageSelected());
        content.setSynMessageReturnButtonSelection(from.isSyncMessageReturnSelected());
        content.setAsynMessageButtonSelection(from.isAsyncMessageSelected());
        content.setAsynMessageReturnButtonSelection(from.isSyncMessageReturnSelected());
        content.setStopButtonSelection(from.isStopSelected());
        content.setCaseSensitiveSelection(from.isCaseSenstiveSelected());
        if (from.getExpression() != null) {
            content.setSearchText(from.getExpression());
        }
    }

    public void setOkText(String okText_) {
        this.okText = okText_;
    }

    public void setTitle(String title_) {
        this.title = title_;
    }
}

