/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DiagramToolTip
implements PaintListener {
    protected Control parent = null;
    protected Shell toolTipShell = null;
    protected String text = null;

    public DiagramToolTip(Control _parent) {
        this.parent = _parent;
        this.toolTipShell = new Shell(this.parent.getShell(), 540672);
        this.toolTipShell.setLayout((Layout)new RowLayout());
        this.toolTipShell.setBackground(Display.getDefault().getSystemColor(29));
        this.toolTipShell.addPaintListener((PaintListener)this);
        this.toolTipShell.setSize(10, 10);
    }

    public void showToolTip(String value) {
        if (value == null || value.equalsIgnoreCase("")) {
            this.toolTipShell.setVisible(false);
            return;
        }
        this.text = value;
        int w = this.toolTipShell.getBounds().width;
        int h = this.toolTipShell.getBounds().height;
        Point hr = Display.getDefault().getCursorLocation();
        int cursorH = 32;
        int i = 0;
        while (i < Display.getDefault().getCursorSizes().length) {
            if (Display.getDefault().getCursorSizes()[i].y < cursorH) {
                cursorH = Display.getDefault().getCursorSizes()[i].y;
            }
            ++i;
        }
        if (hr.x + w > Display.getDefault().getBounds().width) {
            int tempX = hr.x + w - Display.getDefault().getBounds().width;
            if (tempX > Display.getDefault().getBounds().width) {
                hr.x = 0;
            }
            hr.x -= tempX;
        }
        this.toolTipShell.setLocation(hr.x, hr.y + cursorH);
        this.toolTipShell.setVisible(true);
    }

    public void hideToolTip() {
        this.toolTipShell.setVisible(false);
    }

    public void paintControl(PaintEvent event) {
        Point size = event.gc.textExtent(this.text);
        event.gc.drawText(this.text, 2, 0, true);
        this.toolTipShell.setSize(size.x + 6, size.y + 2);
    }
}

