/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.view;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.FilterInternalMessages;
import org.eclipse.hyades.uml2sd.ui.actions.MoveToMessage;
import org.eclipse.hyades.uml2sd.ui.actions.NextPage;
import org.eclipse.hyades.uml2sd.ui.actions.OpenSDFiltersDialog;
import org.eclipse.hyades.uml2sd.ui.actions.OpenSDFindDialog;
import org.eclipse.hyades.uml2sd.ui.actions.OpenSDPagesDialog;
import org.eclipse.hyades.uml2sd.ui.actions.PrevPage;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDGraphNodeSupporter;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDInternalMesFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDPagingProvider;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.ui.preferences.SDViewPref;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.hyades.uml2sd.ui.view.TimeCompressionBar;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.part.ViewPart;

public class SDView
extends ViewPart {
    protected SDWidget sdWidget = null;
    protected TimeCompressionBar timeCompressionBar = null;
    protected ISDFindProvider sdFindProvider = null;
    protected ISDPagingProvider sdPagingProvider = null;
    protected ISDFilterProvider sdFilterProvider = null;
    protected IExtendedFilterProvider sdExFilterProvider = null;
    protected IExtendedFindProvider sdExFindProvider = null;
    protected ISDInternalMesFilterProvider sdIntFilterProvider = null;
    protected NextPage nextPageButton = null;
    protected PrevPage prevPageButton = null;
    protected FilterInternalMessages internalFilterButton = null;
    protected Action goToMessageForKeyBinding = null;
    protected Action findForKeyBinding = null;
    private SDViewPref pref;
    private String extFilterId = null;
    private String extFindId = null;
    private static ArrayList toto = null;
    private MenuManager menuMgr = null;
    private Cursor waitCursor;

    public SDWidget getSDWidget() {
        return this.sdWidget;
    }

    public void createPartControl(Composite c) {
        Composite parent = new Composite(c, 0);
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 2;
        parentLayout.marginWidth = 0;
        parentLayout.marginHeight = 0;
        parent.setLayout((Layout)parentLayout);
        GridData timeLayoutdata = new GridData(1040);
        timeLayoutdata.widthHint = 10;
        GridData seqDiagLayoutData = new GridData(1808);
        this.timeCompressionBar = new TimeCompressionBar(parent, 770);
        this.timeCompressionBar.setLayoutData(timeLayoutdata);
        this.sdWidget = new SDWidget(parent, 770);
        this.sdWidget.setLayoutData(seqDiagLayoutData);
        this.sdWidget.setSite(this);
        this.sdWidget.setTimeBar(this.timeCompressionBar);
        this.pref = SDViewPref.getInstance();
        this.goToMessageForKeyBinding = new MoveToMessage(this);
        this.goToMessageForKeyBinding.setActionDefinitionId("org.eclipse.hyades.uml2sd.ui.actions.GoToMessage");
        this.getSite().getKeyBindingService().registerAction((IAction)this.goToMessageForKeyBinding);
        this.findForKeyBinding = new OpenSDFindDialog(this);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.findForKeyBinding);
        this.findForKeyBinding.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.getSite().getKeyBindingService().registerAction((IAction)this.findForKeyBinding);
        this.findForKeyBinding.setEnabled(false);
        this.hookContextMenu();
        IActionBars bar = this.getViewSite().getActionBars();
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_VIEW_MODES"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_WORKING_SET"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_SORTING"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_FILTERING"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_VIEW_LAYOUT"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_LINK_EDITOR"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_OTHER_COMMANDS"));
        bar.getToolBarManager().add((IContributionItem)new Separator("UML2SD_OTHER_PLUGINS_COMMANDS"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_VIEW_MODES"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_WORKING_SET"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_SORTING"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_FILTERING"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_VIEW_LAYOUT"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_LINK_EDITOR"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_OTHER_COMMANDS"));
        bar.getMenuManager().add((IContributionItem)new Separator("UML2SD_OTHER_PLUGINS_COMMANDS"));
        this.createCoolbarContent();
        this.timeCompressionBar.setVisible(false);
        parent.layout(true);
        IUml2SDLoader l = LoadersManager.getLoadersManager().getCurrentLoader();
        if (l != null) {
            l.setViewer(this);
        } else {
            this.loadBlank();
        }
    }

    private void loadBlank() {
        IUml2SDLoader l = new IUml2SDLoader(){

            public void setViewer(SDView viewer) {
                Frame f = new Frame();
                f.setName(SDViewerPlugin.getResourceString("NO_INTERACTIONS_CHOOSEN"));
                viewer.setFrame(f);
            }

            public String getTitleString() {
                return SDViewerPlugin.getResourceString("NO_INTERACTIONS_CHOOSEN");
            }

            public void aboutToBeReplaced() {
            }
        };
        l.setViewer(this);
        this.setTitle(l.getTitleString());
    }

    public void setFocus() {
        if (this.sdWidget != null) {
            this.sdWidget.setFocus();
        }
    }

    public void setSDFindProvider(ISDFindProvider provider) {
        this.sdFindProvider = provider;
        this.sdExFindProvider = null;
        this.createCoolbarContent();
        if (provider != null) {
            this.findForKeyBinding.setEnabled(true);
        } else {
            this.findForKeyBinding.setEnabled(false);
        }
    }

    public void setExtendedFindProvider(IExtendedFindProvider provider) {
        this.sdExFindProvider = provider;
        this.sdFindProvider = null;
        this.createCoolbarContent();
        if (provider != null) {
            this.findForKeyBinding.setEnabled(true);
        } else {
            this.findForKeyBinding.setEnabled(false);
        }
    }

    public IExtendedFindProvider getExtendedFindProvider() {
        return this.sdExFindProvider;
    }

    public void resetProviders() {
        this.findForKeyBinding.setEnabled(false);
        this.sdFindProvider = null;
        this.sdExFindProvider = null;
        this.sdFilterProvider = null;
        this.sdExFilterProvider = null;
        this.sdIntFilterProvider = null;
        this.sdPagingProvider = null;
    }

    public void setSDFilterProvider(ISDFilterProvider provider) {
        this.sdFilterProvider = provider;
        this.sdExFilterProvider = null;
        this.createCoolbarContent();
    }

    public void setExtendedFilterProvider(IExtendedFilterProvider provider) {
        this.sdExFilterProvider = provider;
        this.sdFilterProvider = null;
        this.createCoolbarContent();
    }

    public IExtendedFilterProvider getExtendedFilterProvider() {
        return this.sdExFilterProvider;
    }

    public void setInternalMessageFilterProvider(ISDInternalMesFilterProvider provider) {
        this.sdIntFilterProvider = provider;
        this.createCoolbarContent();
    }

    public ISDInternalMesFilterProvider getInternalMessageFilterProvider() {
        return this.sdIntFilterProvider;
    }

    public void setSDPagingProvider(ISDPagingProvider provider) {
        this.sdPagingProvider = provider;
        this.createCoolbarContent();
    }

    public ISDPagingProvider getSDPagingProvider() {
        return this.sdPagingProvider;
    }

    public ISDGraphNodeSupporter getSDFindProvider() {
        return this.sdFindProvider;
    }

    public ISDFilterProvider getSDFilterProvider() {
        return this.sdFilterProvider;
    }

    private void hookContextMenu() {
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SDView.this.fillContextMenu(manager);
            }
        });
        Menu menu = this.menuMgr.createContextMenu(this.sdWidget.getViewControl());
        this.sdWidget.getViewControl().setMenu(menu);
        this.getSite().registerContextMenu(this.menuMgr, this.sdWidget.getSelectionProvider());
    }

    public MenuManager getMenuManager() {
        return this.menuMgr;
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("Additions"));
        if (this.getSDWidget() != null && this.getSDWidget().currentGraphNode != null) {
            MoveToMessage goToMessage;
            Object node;
            ISelectionProvider selProvider = this.sdWidget.getSelectionProvider();
            ISelection sel = selProvider.getSelection();
            Object selectedNode = null;
            int nbMessage = 0;
            Iterator it = ((StructuredSelection)sel).iterator();
            while (it.hasNext()) {
                node = it.next();
                if (!(node instanceof BaseMessage)) continue;
                ++nbMessage;
            }
            if (nbMessage != 1) {
                return;
            }
            node = this.getSDWidget().currentGraphNode;
            if (node instanceof SyncMessageReturn && ((SyncMessageReturn)node).getMessage() != null) {
                goToMessage = new MoveToMessage(this);
                goToMessage.setText(SDViewerPlugin.getResourceString("POPUP_MENU_GO_TO_MESSAGE"));
                goToMessage.setImageDescriptor(SDViewerPlugin.getResourceImage("hide_image_maplist.gif"));
                manager.add((IAction)goToMessage);
                goToMessage.setActionDefinitionId("org.eclipse.hyades.uml2sd.ui.actions.GoToMessage");
                this.getSite().getKeyBindingService().registerAction((IAction)goToMessage);
            }
            if (node instanceof SyncMessage && ((SyncMessage)node).getMessageReturn() != null) {
                goToMessage = new MoveToMessage(this);
                goToMessage.setText(SDViewerPlugin.getResourceString("POPUP_MENU_GO_TO_MESSAGE_RET"));
                goToMessage.setImageDescriptor(SDViewerPlugin.getResourceImage("show_image_maplist.gif"));
                manager.add((IAction)goToMessage);
                goToMessage.setActionDefinitionId("org.eclipse.hyades.uml2sd.ui.actions.GoToMessage");
                this.getSite().getKeyBindingService().registerAction((IAction)goToMessage);
            }
        }
        manager.add((IContributionItem)new Separator("MultiSelectAdditions"));
    }

    public void setEnableAction(String actionName, boolean state) {
        IContributionItem item;
        IActionBars bar = this.getViewSite().getActionBars();
        if (bar != null && (item = bar.getMenuManager().find(actionName)) != null && item instanceof PluginActionContributionItem) {
            IAction action = ((PluginActionContributionItem)item).getAction();
            if (action != null) {
                action.setEnabled(state);
            }
            item.setVisible(state);
            bar.updateActionBars();
        }
    }

    protected void createCoolbarContent() {
        Action action;
        IContributionItem extendedFilter;
        IContributionItem extendedFind;
        IContributionItem intFilterItem;
        IContributionItem sdFilter;
        IContributionItem sdFind;
        IContributionItem prevPageItem;
        IActionBars bar = this.getViewSite().getActionBars();
        IContributionItem nextPageItem = bar.getToolBarManager().find("org.eclipse.hyades.uml2sd.ui.nextpage");
        if (nextPageItem != null) {
            bar.getToolBarManager().remove(nextPageItem);
            nextPageItem = null;
        }
        if ((nextPageItem = bar.getMenuManager().find("org.eclipse.hyades.uml2sd.ui.nextpage")) != null) {
            bar.getMenuManager().remove(nextPageItem);
            nextPageItem = null;
        }
        if ((prevPageItem = bar.getToolBarManager().find("org.eclipse.hyades.uml2sd.ui.prevpage")) != null) {
            bar.getToolBarManager().remove(prevPageItem);
            prevPageItem = null;
        }
        if ((prevPageItem = bar.getMenuManager().find("org.eclipse.hyades.uml2sd.ui.prevpage")) != null) {
            bar.getMenuManager().remove(prevPageItem);
            prevPageItem = null;
        }
        if ((sdFind = bar.getMenuManager().find("org.eclipse.hyades.uml2sd.ui.sdFind")) != null) {
            bar.getMenuManager().remove(sdFind);
            sdFind = null;
        }
        if ((sdFind = bar.getToolBarManager().find("org.eclipse.hyades.uml2sd.ui.sdFind")) != null) {
            bar.getToolBarManager().remove(sdFind);
            sdFind = null;
        }
        if ((sdFilter = bar.getMenuManager().find("org.eclipse.hyades.uml2sd.ui.sdFilters")) != null) {
            bar.getMenuManager().remove(sdFilter);
            sdFilter = null;
        }
        if ((sdFilter = bar.getToolBarManager().find("org.eclipse.hyades.uml2sd.ui.sdFilters")) != null) {
            bar.getToolBarManager().remove(sdFilter);
            sdFilter = null;
        }
        if ((intFilterItem = bar.getMenuManager().find("org.eclipse.hyades.uml2sd.ui.filterinternalmesssage")) != null) {
            bar.getMenuManager().remove(intFilterItem);
            intFilterItem = null;
        }
        if (this.sdPagingProvider != null) {
            this.nextPageButton = new NextPage(this);
            bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.nextPageButton);
            this.nextPageButton.setEnabled(this.sdPagingProvider.hasNextPage());
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.nextPageButton);
            this.prevPageButton = new PrevPage(this);
            bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.prevPageButton);
            this.prevPageButton.setEnabled(this.sdPagingProvider.hasPrevPage());
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)this.prevPageButton);
        }
        if (this.sdIntFilterProvider != null) {
            this.internalFilterButton = new FilterInternalMessages(this);
            bar.getMenuManager().prependToGroup("UML2SD_FILTERING", (IAction)this.internalFilterButton);
        }
        if ((extendedFind = bar.getMenuManager().find(this.extFindId)) != null) {
            bar.getMenuManager().remove(extendedFind);
            extendedFind = null;
        }
        if ((extendedFind = bar.getToolBarManager().find(this.extFindId)) != null) {
            bar.getToolBarManager().remove(extendedFind);
            extendedFind = null;
        }
        if ((extendedFilter = bar.getMenuManager().find(this.extFilterId)) != null) {
            bar.getMenuManager().remove(extendedFilter);
            extendedFilter = null;
        }
        if ((extendedFilter = bar.getToolBarManager().find(this.extFilterId)) != null) {
            bar.getToolBarManager().remove(extendedFilter);
            extendedFilter = null;
        }
        if (this.sdExFilterProvider != null) {
            action = this.sdExFilterProvider.getFilterAction();
            if (action != null) {
                if (action.getId() == null) {
                    action.setId("org.eclipse.hyades.uml2sd.ui.extendedFilter");
                }
                this.extFilterId = action.getId();
                if (action.getImageDescriptor() == null) {
                    action.setImageDescriptor(SDViewerPlugin.getResourceImage("filter_obj.gif"));
                }
                if (action.getText() == null) {
                    action.setText(SDViewerPlugin.getResourceString("POPUP_MENU_FILTER"));
                }
                bar.getMenuManager().appendToGroup("UML2SD_FILTERING", (IAction)action);
                bar.getToolBarManager().appendToGroup("UML2SD_FILTERING", (IAction)action);
            }
        } else if (this.sdFilterProvider != null) {
            bar.getMenuManager().appendToGroup("UML2SD_FILTERING", (IAction)new OpenSDFiltersDialog(this, this.sdFilterProvider));
            bar.getToolBarManager().appendToGroup("UML2SD_FILTERING", (IAction)new OpenSDFiltersDialog(this, this.sdFilterProvider));
        }
        if (this.sdPagingProvider != null && this.sdPagingProvider instanceof ISDAdvancedPagingProvider) {
            IContributionItem sdPaging = bar.getMenuManager().find("org.eclipse.hyades.uml2sd.ui.sdPaging");
            if (sdPaging != null) {
                bar.getMenuManager().remove(sdPaging);
                sdPaging = null;
            }
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)new OpenSDPagesDialog(this, (ISDAdvancedPagingProvider)this.sdPagingProvider));
        }
        if (this.sdExFindProvider != null) {
            action = this.sdExFindProvider.getFindAction();
            if (action != null) {
                if (action.getId() == null) {
                    action.setId("org.eclipse.hyades.uml2sd.ui.extendedFind");
                }
                this.extFindId = action.getId();
                if (action.getImageDescriptor() == null) {
                    action.setImageDescriptor(SDViewerPlugin.getResourceImage("search_seqdiag_co.gif"));
                }
                if (action.getText() == null) {
                    action.setText(SDViewerPlugin.getResourceString("POPUP_MENU_FIND"));
                }
                bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)action);
                bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)action);
            }
        } else if (this.sdFindProvider != null) {
            bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)new OpenSDFindDialog(this));
            bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)new OpenSDFindDialog(this));
        }
        bar.updateActionBars();
    }

    public void updateCoolBar() {
        if (this.sdPagingProvider != null) {
            IAction prevPageAction;
            IContributionItem prevPage;
            IAction nextPageAction;
            IActionBars bar = this.getViewSite().getActionBars();
            if (bar == null) {
                return;
            }
            IToolBarManager barManager = bar.getToolBarManager();
            if (barManager == null) {
                return;
            }
            IContributionItem nextPage = barManager.find("org.eclipse.hyades.uml2sd.ui.nextpage");
            if (nextPage != null && nextPage instanceof ActionContributionItem && (nextPageAction = ((ActionContributionItem)nextPage).getAction()) != null && nextPageAction instanceof NextPage) {
                ((NextPage)nextPageAction).setEnabled(this.sdPagingProvider.hasNextPage());
            }
            if ((prevPage = barManager.find("org.eclipse.hyades.uml2sd.ui.prevpage")) != null && prevPage instanceof ActionContributionItem && (prevPageAction = ((ActionContributionItem)prevPage).getAction()) != null && prevPageAction instanceof PrevPage) {
                ((PrevPage)prevPageAction).setEnabled(this.sdPagingProvider.hasPrevPage());
            }
        }
    }

    public void setFrame(Frame frame) {
        this.setFrame(frame, true);
    }

    protected void setFrame(Frame frame, boolean resetPosition) {
        Composite parent;
        IUml2SDLoader l = LoadersManager.getLoadersManager().getCurrentLoader();
        if (l != null) {
            this.setTitle(l.getTitleString());
        }
        if (this.getSDWidget() != null) {
            this.getSDWidget().setFrame(frame, resetPosition);
        }
        if (this.timeCompressionBar != null) {
            this.timeCompressionBar.setFrame(frame);
        }
        this.updateCoolBar();
        if (!frame.hasTimeInfo()) {
            parent = this.timeCompressionBar.getParent();
            this.timeCompressionBar.setVisible(false);
            parent.layout(true);
        } else {
            parent = this.timeCompressionBar.getParent();
            this.timeCompressionBar.setVisible(true);
            parent.layout(true);
        }
        IContributionItem shortKeysMenu = this.getViewSite().getActionBars().getMenuManager().find("org.eclipse.hyades.uml2sd.ui.actions");
        MenuManager shortKeys = (MenuManager)shortKeysMenu;
        if (shortKeys == null) {
            return;
        }
        IContributionItem[] items = shortKeys.getItems();
        int i = 0;
        while (i < items.length) {
            IAction action;
            if (items[i] instanceof PluginActionContributionItem && (action = ((PluginActionContributionItem)items[i]).getAction()) != null) {
                action.setEnabled(true);
            }
            ++i;
        }
    }

    public void setEnableCommand(String id, boolean value) {
        IAction action;
        IContributionItem shortKeysMenu = this.getViewSite().getActionBars().getMenuManager().find("org.eclipse.hyades.uml2sd.ui.actions");
        MenuManager shortKeys = (MenuManager)shortKeysMenu;
        if (shortKeys == null) {
            return;
        }
        IContributionItem item = shortKeys.find(id);
        if (item != null && item instanceof PluginActionContributionItem && (action = ((PluginActionContributionItem)item).getAction()) != null) {
            action.setEnabled(value);
        }
    }

    public void setFrameSync(final Frame frame) {
        this.getSDWidget().getDisplay().syncExec(new Runnable(){

            public void run() {
                SDView.this.setFrame(frame);
            }
        });
    }

    public void ensureVisibleSync(final GraphNode sm) {
        this.getSDWidget().getDisplay().syncExec(new Runnable(){

            public void run() {
                SDView.this.getSDWidget().ensureVisible(sm);
            }
        });
    }

    public void setFrameAndEnsureVisibleSync(final Frame frame, final GraphNode sm) {
        this.getSDWidget().getDisplay().syncExec(new Runnable(){

            public void run() {
                SDView.this.setFrameAndEnsureVisible(frame, sm);
            }
        });
    }

    public void setFrameAndEnsureVisible(Frame frame, GraphNode sm) {
        this.getSDWidget().clearSelection();
        this.setFrame(frame, false);
        this.getSDWidget().ensureVisible(sm);
    }

    public void toggleWaitCursorSync(final boolean wait_) {
        this.getSDWidget().getDisplay().syncExec(new Runnable(){

            public void run() {
                if (SDView.this.getSDWidget() == null || SDView.this.getSDWidget().isDisposed()) {
                    return;
                }
                if (wait_) {
                    if (SDView.this.waitCursor != null && !SDView.this.waitCursor.isDisposed()) {
                        SDView.this.waitCursor.dispose();
                    }
                    SDView.this.waitCursor = new Cursor((Device)SDView.this.getSDWidget().getDisplay(), 1);
                    SDView.this.getSDWidget().setCursor(SDView.this.waitCursor);
                    SDView.this.getSDWidget().getDisplay().update();
                } else {
                    if (SDView.this.waitCursor != null && !SDView.this.waitCursor.isDisposed()) {
                        SDView.this.waitCursor.dispose();
                    }
                    SDView.this.waitCursor = null;
                    SDView.this.getSDWidget().setCursor(null);
                    SDView.this.getSDWidget().getDisplay().update();
                }
            }
        });
    }

    public TimeCompressionBar getTimeCompressionBar() {
        return this.timeCompressionBar;
    }

    public Frame getFrame() {
        if (this.getSDWidget() != null) {
            return this.getSDWidget().getFrame();
        }
        return null;
    }
}

