@rem USAGE:  runregex
@rem PURPOSE:  Illustrates the functional capabilities of the Generic Log Adapter (GLA) run-time using an example adapter file and sample log file.
@rem INSTRUCTIONS:  When executing in a GLA run-time environment, change the value of the %GLA_HOME% environment variable to the absolute path of the unzipped GLA run-time.
@rem NOTE:  When executing in a plug-in (e.g. Eclipse) run-time environment, create a temporary working directory and change the value of the %GLA_HOME% environment variable to the 
@rem        absolute path of the new temporary working directory.  Furthermore, create a %GLA_HOME%\config directory and copy the contents of the org.eclipse.hyades.logging.adapter.config 
@rem        plug-in to the new %GLA_HOME%\config directory.  Finally, create a %GLA_HOME%\lib directory and copy the following JAR files to the new %GLA_HOME%\lib directory:
@rem                    Plug-in                 |     JAR
@rem        ---------------------------------------------------
@rem        org.eclipse.hyades.logging.adapter  |  hgla.jar
@rem        org.eclipse.hyades.logging.core     |  hlcbe101.jar
@rem        org.eclipse.hyades.logging.core     |  hlcore.jar
@rem        org.eclipse.hyades.execution.remote |  hexr.jar
@rem        org.eclipse.emf.ecore               |  ecore.jar
@rem        org.eclipse.emf.common              |  common.jar

SET GLA_HOME=d:\GenericLogAdapter
SET CONFIG_FILE=%GLA_HOME%\config\Apache\access\v1.3.26\regex_example.adapter
PUSHD %GLA_HOME%\config\Apache\access\v1.3.26
java -DGLA_HOME="%GLA_HOME%" -classpath "%GLA_HOME%\lib\hgla.jar;%GLA_HOME%\lib\hexr.jar;%GLA_HOME%\lib\hlcbe101.jar;%GLA_HOME%\lib\ecore.jar;%GLA_HOME%\lib\common.jar;%GLA_HOME%\lib\hlcore.jar" org.eclipse.hyades.logging.adapter.Adapter -ac "%CONFIG_FILE%" -cc "%CONFIG_FILE%"
POPD
