/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.AlertTableDialogCellEditor;
import org.eclipse.hyades.statistical.ui.editor.internal.AlertTableListener;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.Alert;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.InvalidTableValueException;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.TableAdapter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class AlertTable
extends TableAdapter
implements DisposeListener,
SelectionListener,
FocusListener,
MouseListener {
    DecimalFormat df = new DecimalFormat("###########################################.########################################");
    public static final int VAL_MONITOR = 0;
    public static final int VAL_NAME = 1;
    public static final int VAL_PERIOD = 2;
    public static final int VAL_CALCTYPE = 3;
    public static final int VAL_LOWER = 4;
    public static final int VAL_UPPER = 5;
    public static final int VAL_MTYPE = 6;
    public static final int VAL_ONTRIGGER = 7;
    public static final int VAL_ONRESET = 8;
    private static final int COL_NAME = 0;
    private static final int COL_PERIOD = 1;
    private static final int COL_CALCTYPE = 2;
    private static final int COL_LOWER = 3;
    private static final int COL_UPPER = 4;
    private static final int COL_MTYPE = 5;
    private static final int COL_ONTRIGGER = 6;
    private static final int COL_ONRESET = 7;
    private Vector listeners = new Vector();
    private Vector datas = new Vector();
    private boolean editable = true;
    Menu alert_menu;
    MenuItem alert_delete;
    MenuItem alert_restart;
    private String[] typeChoices = new String[]{"TYPE_MAX_TRIGGER", "TYPE_MIN_TRIGGER"};
    private String[] typeChoicesString = new String[]{EditorPlugin.getString("TYPE_MAX_TRIGGER"), EditorPlugin.getString("TYPE_MIN_TRIGGER")};
    private String[] calcTypeChoices = new String[]{"PLOTTING_TYPE_AVERAGE", "PLOTTING_TYPE_MAX", "PLOTTING_TYPE_MIN", "PLOTTING_TYPE_SUM", "PLOTTING_TYPE_COUNT", "PLOTTING_TYPE_NEAREST", "PLOTTING_TYPE_STDDEV"};
    private String[] calcTypeChoicesString = new String[]{EditorPlugin.getString("PLOTTING_TYPE_AVERAGE"), EditorPlugin.getString("PLOTTING_TYPE_MAX"), EditorPlugin.getString("PLOTTING_TYPE_MIN"), EditorPlugin.getString("PLOTTING_TYPE_SUM"), EditorPlugin.getString("PLOTTING_TYPE_COUNT"), EditorPlugin.getString("PLOTTING_TYPE_NEAREST"), EditorPlugin.getString("PLOTTING_TYPE_STDDEV")};
    ArrayList disposables = new ArrayList();
    boolean has_focus = false;
    Alert last_selected;

    public void setEditable(boolean newValue) {
        this.editable = newValue;
    }

    public void addListener(AlertTableListener newListener) {
        this.listeners.add(newListener);
    }

    public void notifyListenersSelect(Alert a) {
        int v = 0;
        while (v < this.listeners.size()) {
            AlertTableListener t = (AlertTableListener)this.listeners.elementAt(v);
            t.alertSelected(a);
            ++v;
        }
    }

    public void notifyListenersDelete(Alert a) {
        int v = 0;
        while (v < this.listeners.size()) {
            AlertTableListener t = (AlertTableListener)this.listeners.elementAt(v);
            t.alertDeleted(a);
            ++v;
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    public Object[] getElements(Object inputObject) {
        return this.datas.toArray();
    }

    public void setSelectedIndex(int i) {
        this.getViewer().getTable().setFocus();
        this.getViewer().getTable().setSelection(i);
        this.getViewer().getTable().showSelection();
        this.getViewer().getTable().redraw();
    }

    public void update() {
        this.getViewer().refresh();
    }

    public AlertTable(Composite parent, Object[][] values) {
        super(parent);
        parent.addDisposeListener((DisposeListener)this);
        String[] names = new String[]{EditorPlugin.getString("TABLE_COLUMN_NAME"), EditorPlugin.getString("TABLE_COLUMN_PERIOD"), EditorPlugin.getString("TABLE_COLUMN_CALCTYPE"), EditorPlugin.getString("TABLE_COLUMN_LOWER"), EditorPlugin.getString("TABLE_COLUMN_UPPER"), EditorPlugin.getString("TABLE_COLUMN_MTYPE"), EditorPlugin.getString("TABLE_COLUMN_ONTRIGGER"), EditorPlugin.getString("TABLE_COLUMN_ONRESET")};
        int[] types = new int[]{1, 3, 2, 6, 6, 2, 8, 8};
        this.setColumnNames(names);
        this.setColumnTypes(types);
        this.setColumnEditor((CellEditor)new AlertTableDialogCellEditor((Composite)this.getViewer().getTable()), 6);
        this.setColumnEditor((CellEditor)new AlertTableDialogCellEditor((Composite)this.getViewer().getTable()), 7);
        this.autoSizeOnContents = new boolean[]{true, true, true, true, true, true, true, true};
        this.configure();
        int i = 0;
        while (i < this.datas.size()) {
            try {
                MonitorElement ge = (MonitorElement)this.datas.get(i);
            }
            catch (Throwable e) {
                // empty catch block
            }
            ++i;
        }
        this.datas = new Vector();
        int i2 = 0;
        while (i2 < values.length) {
            this.datas.add(new MonitorElement((Alert)values[i2][0], (String)values[i2][1], (Long)values[i2][2], (String)values[i2][3], (Double)values[i2][4], (Double)values[i2][5], (Boolean)values[i2][6], (AlertAction[])values[i2][7], (AlertAction[])values[i2][8]));
            ++i2;
        }
        this.alert_menu = new Menu((Control)this.getViewer().getTable());
        this.alert_delete = new MenuItem(this.alert_menu, 0);
        this.alert_restart = new MenuItem(this.alert_menu, 0);
        this.alert_delete.setText(EditorPlugin.getString("ALERT_REMOVE"));
        this.alert_delete.setImage(EditorPlugin.img.getImage("smodel_remove.gif"));
        this.alert_restart.setText(EditorPlugin.getString("ALERT_RESTART"));
        this.alert_restart.setImage(EditorPlugin.img.getImage("run_exec.gif"));
        this.getViewer().getTable().addFocusListener((FocusListener)this);
        this.getViewer().getTable().addSelectionListener((SelectionListener)this);
        this.getViewer().getTable().addMouseListener((MouseListener)this);
        this.alert_delete.addSelectionListener((SelectionListener)this);
        this.alert_restart.addSelectionListener((SelectionListener)this);
    }

    public String[] getComboChoices(Object element, int columnIndex) {
        if (columnIndex == 5) {
            return this.typeChoicesString;
        }
        if (columnIndex == 2) {
            return this.calcTypeChoicesString;
        }
        return new String[0];
    }

    public void setValues(Object[][] values) {
        int i = 0;
        while (i < this.datas.size()) {
            try {
                MonitorElement ge = (MonitorElement)this.datas.get(i);
            }
            catch (Throwable e) {
                // empty catch block
            }
            ++i;
        }
        this.datas.clear();
        int i2 = 0;
        while (i2 < values.length) {
            this.datas.add(new MonitorElement((Alert)values[i2][0], (String)values[i2][1], (Long)values[i2][2], (String)values[i2][3], (Double)values[i2][4], (Double)values[i2][5], (Boolean)values[i2][6], (AlertAction[])values[i2][7], (AlertAction[])values[i2][8]));
            ++i2;
        }
        this.configure();
    }

    public Object[][] getValues() {
        Object[][] result = new Object[this.datas.size()][8];
        int v = 0;
        while (v < this.datas.size()) {
            result[v][0] = ((MonitorElement)this.datas.get((int)v)).monitor;
            result[v][1] = ((MonitorElement)this.datas.get((int)v)).name;
            result[v][2] = ((MonitorElement)this.datas.get((int)v)).period;
            result[v][3] = ((MonitorElement)this.datas.get((int)v)).calc_type;
            result[v][4] = ((MonitorElement)this.datas.get((int)v)).lower;
            result[v][5] = ((MonitorElement)this.datas.get((int)v)).upper;
            result[v][6] = ((MonitorElement)this.datas.get((int)v)).max_trigger;
            result[v][7] = ((MonitorElement)this.datas.get((int)v)).trigger_action;
            result[v][8] = ((MonitorElement)this.datas.get((int)v)).reset_action;
            ++v;
        }
        return result;
    }

    public void dispose() {
        super.dispose();
        this.disposables.addAll(this.datas);
        int i = 0;
        while (i < this.disposables.size()) {
            try {
                Object o = this.disposables.get(i);
                if (o != null) {
                    if (o instanceof Widget) {
                        ((Widget)o).dispose();
                    } else if (o instanceof Color) {
                        ((Color)o).dispose();
                    } else if (o instanceof Image) {
                        ((Image)o).dispose();
                    } else {
                        try {
                            EditorPlugin.disposeObject(o);
                        }
                        catch (Throwable e) {
                            EditorPlugin.DBG.warning("Class not found when disposing of " + o.getClass() + "/" + o + " (" + e + ")");
                        }
                    }
                }
            }
            catch (Throwable e) {
                EditorPlugin.DBG.error("Problem disposing of objects", e);
            }
            ++i;
        }
    }

    public void valueChanged(Object element, int column, String newValue) throws InvalidTableValueException {
        MonitorElement e = (MonitorElement)element;
        boolean changed = false;
        if (column == 0) {
            changed = true;
            e.name = newValue;
        }
        if (changed) {
            e.writeToMonitor();
            this.getViewer().refresh((Object)e);
        }
    }

    public void valueChanged(Object element, int column, Float newValue) throws InvalidTableValueException {
        this.valueChanged(element, column, new Double(newValue.doubleValue()));
    }

    public void valueChanged(Object element, int column, Boolean newValue) throws InvalidTableValueException {
    }

    public void valueChanged(Object element, int column, Double newValue) throws InvalidTableValueException {
        double val = newValue;
        MonitorElement e = (MonitorElement)element;
        boolean changed = false;
        if (column == 3) {
            changed = true;
            e.lower = newValue;
            if (val > e.upper) {
                e.upper = new Double(val);
            }
        } else if (column == 4) {
            changed = true;
            e.upper = newValue;
            if (val < e.lower) {
                e.lower = new Double(val);
            }
        }
        if (changed) {
            e.writeToMonitor();
            this.getViewer().refresh((Object)e);
        }
    }

    public void valueChanged(Object element, int column, Integer newValue) throws InvalidTableValueException {
        int val = newValue;
        MonitorElement e = (MonitorElement)element;
        boolean changed = false;
        if (column == 1) {
            changed = true;
            e.period = new Long(val);
        } else if (column == 2) {
            changed = true;
            e.calc_type = this.calcTypeChoices[val];
        } else if (column == 5) {
            changed = true;
            e.max_trigger = new Boolean(val == 0);
        }
        if (changed) {
            e.writeToMonitor();
            this.getViewer().refresh((Object)e);
        }
    }

    public void valueChanged(Object element, int column) throws InvalidTableValueException {
        ((MonitorElement)element).readFromMonitor();
        this.configure();
        this.getViewer().refresh(element);
    }

    private Object lookup(Object[] indexer, Object[] result, Object o) {
        int i = 0;
        while (i < indexer.length) {
            if (indexer[i].equals(o)) {
                return result[i];
            }
            ++i;
        }
        return result[-1];
    }

    public Image getColumnImage(Object element, int columnIndex) {
        MonitorElement el = (MonitorElement)element;
        if (el.monitor.isTriggered() && columnIndex == 0) {
            return EditorPlugin.img.getImage("alert_obj.gif");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        MonitorElement el = (MonitorElement)element;
        if (columnIndex == 0) {
            return el.name;
        }
        if (columnIndex == 1) {
            return el.period + " ms";
        }
        if (columnIndex == 2) {
            return "" + this.lookup(this.calcTypeChoices, this.calcTypeChoicesString, el.calc_type);
        }
        if (columnIndex == 3) {
            String ret = this.df.format(el.lower);
            ret = el.max_trigger != false ? ret + " (" + EditorPlugin.getString("VALUE_RESET") + ")" : ret + " (" + EditorPlugin.getString("VALUE_TRIGGER") + ")";
            return ret;
        }
        if (columnIndex == 4) {
            String ret = this.df.format(el.upper);
            ret = el.max_trigger != false ? ret + " (" + EditorPlugin.getString("VALUE_TRIGGER") + ")" : ret + " (" + EditorPlugin.getString("VALUE_RESET") + ")";
            return ret;
        }
        if (columnIndex == 5) {
            if (el.max_trigger.booleanValue()) {
                return EditorPlugin.getString("TYPE_MAX_TRIGGER");
            }
            return EditorPlugin.getString("TYPE_MIN_TRIGGER");
        }
        if (columnIndex == 6) {
            if (el.trigger_action.length > 0) {
                return "" + el.trigger_action[0].getDescription();
            }
            return EditorPlugin.getString("ALERT_ACTION_NAME_DONOTHING");
        }
        if (columnIndex == 7) {
            if (el.reset_action.length > 0) {
                return "" + el.reset_action[0].getDescription();
            }
            return EditorPlugin.getString("ALERT_ACTION_NAME_DONOTHING");
        }
        return "";
    }

    public Alert getSelectedAlert() {
        if (!this.has_focus) {
            return null;
        }
        int n = this.getViewer().getTable().getSelectionIndex();
        if (n == -1) {
            return null;
        }
        MonitorElement element = (MonitorElement)this.datas.get(n);
        return element.monitor;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.alert_delete) {
            if (this.last_selected != null) {
                this.notifyListenersDelete(this.last_selected);
            }
        } else if (e.getSource() == this.alert_restart) {
            if (this.last_selected != null) {
                this.last_selected.restart();
            }
        } else {
            Alert a = this.getSelectedAlert();
            if (a != null) {
                this.notifyListenersSelect(a);
            }
        }
    }

    public void focusLost(FocusEvent e) {
        this.has_focus = false;
    }

    public void focusGained(FocusEvent e) {
        this.has_focus = true;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        this.last_selected = this.getSelectedAlert();
        if (e.button > 1) {
            this.alert_menu.setVisible(true);
        }
    }

    public class MonitorElement {
        public Alert monitor;
        public String name;
        public Long period;
        public String calc_type;
        public Double lower;
        public Double upper;
        public Boolean max_trigger;
        public AlertAction[] trigger_action;
        public AlertAction[] reset_action;

        public void writeToMonitor() {
            this.monitor.name = this.name;
            this.monitor.period = this.period;
            this.monitor.calc_type = this.calc_type.equals("PLOTTING_TYPE_AVERAGE") ? 0 : (this.calc_type.equals("PLOTTING_TYPE_MAX") ? 2 : (this.calc_type.equals("PLOTTING_TYPE_MIN") ? 1 : (this.calc_type.equals("PLOTTING_TYPE_SUM") ? 5 : (this.calc_type.equals("PLOTTING_TYPE_COUNT") ? 7 : (this.calc_type.equals("PLOTTING_TYPE_NEAREST") ? 6 : (this.calc_type.equals("PLOTTING_TYPE_STDDEV") ? 8 : 0))))));
            this.monitor.lower = this.lower;
            this.monitor.upper = this.upper;
            this.monitor.max_trigger = this.max_trigger;
            this.monitor.trigger_actions = this.trigger_action;
            this.monitor.reset_actions = this.reset_action;
        }

        public void readFromMonitor() {
            this.name = this.monitor.name;
            this.period = new Long(this.monitor.period);
            this.calc_type = this.monitor.calc_type == 0 ? "PLOTTING_TYPE_AVERAGE" : (this.monitor.calc_type == 2 ? "PLOTTING_TYPE_MAX" : (this.monitor.calc_type == 1 ? "PLOTTING_TYPE_MIN" : (this.monitor.calc_type == 5 ? "PLOTTING_TYPE_SUM" : (this.monitor.calc_type == 7 ? "PLOTTING_TYPE_COUNT" : (this.monitor.calc_type == 6 ? "PLOTTING_TYPE_NEAREST" : (this.monitor.calc_type == 8 ? "PLOTTING_TYPE_STDDEV" : "PLOTTING_TYPE_AVERAGE"))))));
            this.lower = new Double(this.monitor.lower);
            this.upper = new Double(this.monitor.upper);
            this.max_trigger = new Boolean(this.monitor.max_trigger);
            this.trigger_action = this.monitor.trigger_actions;
            this.reset_action = this.monitor.reset_actions;
        }

        public MonitorElement(Alert monitor, String name, Long period, String calc_type, Double lower, Double upper, Boolean max_trigger, AlertAction[] trigger_action, AlertAction[] reset_action) {
            this.monitor = monitor;
            this.name = name;
            this.period = period;
            this.calc_type = calc_type;
            this.lower = lower;
            this.upper = upper;
            this.max_trigger = max_trigger;
            this.trigger_action = trigger_action;
            this.reset_action = reset_action;
        }
    }
}

