/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.GraphTableDialogCellEditor;
import org.eclipse.hyades.statistical.ui.editor.internal.GraphTableListener;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSelectionSource;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.InvalidTableValueException;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.TableAdapter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class GraphTable
extends TableAdapter
implements DisposeListener,
GraphSelectionSource,
SelectionListener,
FocusListener {
    public static final int VAL_GRAPH = 0;
    public static final int VAL_NAME = 1;
    public static final int VAL_DESC = 2;
    public static final int VAL_RGB = 3;
    public static final int VAL_WIDTH = 4;
    public static final int VAL_STYLE = 5;
    public static final int VAL_XSLIDER = 6;
    public static final int VAL_YSLIDER = 7;
    private static final int COL_NAME = 0;
    private static final int COL_DESC = 1;
    private static final int COL_RGB = 2;
    private static final int COL_WIDTH = 3;
    private static final int COL_STYLE = 4;
    private static final int COL_XSLIDER = 5;
    private static final int COL_YSLIDER = 6;
    private static final int COL_GRAPH = 7;
    private Control graph_control;
    private int style;
    private Vector datas = new Vector();
    private boolean editable = true;
    private Vector listeners = new Vector();
    private Integer[] sliderXChoices = new Integer[]{new Integer(1)};
    private String[] sliderXChoicesString = new String[]{"1"};
    private Integer[] sliderYChoices = new Integer[]{new Integer(1)};
    private String[] sliderYChoicesString = new String[]{"1"};
    private Integer[] widthChoices = new Integer[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10)};
    private String[] widthChoicesString = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private Integer[] styleChoices = new Integer[]{new Integer(1), new Integer(3), new Integer(2), new Integer(4), new Integer(5)};
    private String[] styleChoicesString = new String[]{EditorPlugin.getString("GRAPH_LINE_SOLID"), EditorPlugin.getString("GRAPH_LINE_DOT"), EditorPlugin.getString("GRAPH_LINE_DASH"), EditorPlugin.getString("GRAPH_LINE_DASH_DOT"), EditorPlugin.getString("GRAPH_LINE_DASH_DOT_DOT")};
    ArrayList disposables = new ArrayList();
    boolean has_focus = false;

    public void addListener(GraphTableListener newListener) {
        this.listeners.add(newListener);
    }

    public void notifyListenersEdit(Graph g) {
        int v = 0;
        while (v < this.listeners.size()) {
            GraphTableListener TCL = (GraphTableListener)this.listeners.elementAt(v);
            TCL.graphEdited(g);
            ++v;
        }
    }

    public void notifyListenersSelect(Graph g) {
        int v = 0;
        while (v < this.listeners.size()) {
            GraphTableListener TCL = (GraphTableListener)this.listeners.elementAt(v);
            TCL.graphSelected(g);
            ++v;
        }
    }

    public void setEditable(boolean newValue) {
        this.editable = newValue;
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    public Object[] getElements(Object inputObject) {
        return this.datas.toArray();
    }

    public void setSelectedIndex(int i) {
        this.getViewer().getTable().setFocus();
        this.getViewer().getTable().setSelection(i);
        this.getViewer().getTable().showSelection();
        this.getViewer().getTable().redraw();
    }

    public GraphTable(Composite parent, Object[][] values, Control graph_control) {
        super(parent);
        this.graph_control = graph_control;
        parent.addDisposeListener((DisposeListener)this);
        String[] names = new String[]{EditorPlugin.getString("TABLE_COLUMN_NAME"), EditorPlugin.getString("TABLE_COLUMN_DESCRIPTION"), EditorPlugin.getString("TABLE_COLUMN_COLOR"), EditorPlugin.getString("TABLE_COLUMN_WIDTH"), EditorPlugin.getString("TABLE_COLUMN_STYLE"), EditorPlugin.getString("TABLE_COLUMN_HSLIDER"), EditorPlugin.getString("TABLE_COLUMN_VSLIDER"), EditorPlugin.getString("TABLE_COLUMN_ADVANCED")};
        int[] types = new int[]{0, 0, 7, 2, 2, 2, 2, 8};
        this.setColumnNames(names);
        this.setColumnTypes(types);
        this.setColumnEditor((CellEditor)new GraphTableDialogCellEditor((Composite)this.getViewer().getTable()), 7);
        this.autoSizeOnContents = new boolean[]{true, false, true, true, true, true, true, true};
        this.configure();
        int i = 0;
        while (i < this.datas.size()) {
            try {
                GraphElement ge = (GraphElement)this.datas.get(i);
                if (ge != null) {
                    ge.dispose();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            ++i;
        }
        this.datas = new Vector();
        int i2 = 0;
        while (i2 < values.length) {
            this.datas.add(new GraphElement((Graph)values[i2][0], (String)values[i2][1], (String)values[i2][2], (RGB)values[i2][3], (Integer)values[i2][4], (Integer)values[i2][5], (Integer)values[i2][6], (Integer)values[i2][7]));
            ++i2;
        }
        this.getViewer().getTable().addFocusListener((FocusListener)this);
        this.getViewer().getTable().addSelectionListener((SelectionListener)this);
    }

    public void ensureGraphsValid() {
        int i = 0;
        while (i < this.datas.size()) {
            GraphElement element = (GraphElement)this.datas.get(i);
            if (element.xslider >= this.sliderXChoices.length) {
                element.xslider = new Integer(0);
            }
            if (element.yslider >= this.sliderYChoices.length) {
                element.yslider = new Integer(0);
            }
            ++i;
        }
        try {
            this.getViewer().refresh(true);
        }
        catch (Exception e) {}
    }

    public String[] getComboChoices(Object element, int columnIndex) {
        if (columnIndex == 4) {
            return this.styleChoicesString;
        }
        if (columnIndex == 3) {
            return this.widthChoicesString;
        }
        if (columnIndex == 5) {
            return this.sliderXChoicesString;
        }
        if (columnIndex == 6) {
            return this.sliderYChoicesString;
        }
        return new String[0];
    }

    public void setXSliderChoices(Integer[] values, String[] names) {
        this.sliderXChoices = values;
        this.sliderXChoicesString = names;
        this.ensureGraphsValid();
        this.redraw();
    }

    public void setYSliderChoices(Integer[] values, String[] names) {
        this.sliderYChoices = values;
        this.sliderYChoicesString = names;
        this.ensureGraphsValid();
        this.redraw();
    }

    public void setValues(Object[][] values) {
        int i = 0;
        while (i < this.datas.size()) {
            try {
                GraphElement ge = (GraphElement)this.datas.get(i);
                if (ge != null) {
                    ge.dispose();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            ++i;
        }
        this.datas.clear();
        int i2 = 0;
        while (i2 < values.length) {
            this.datas.add(new GraphElement((Graph)values[i2][0], (String)values[i2][1], (String)values[i2][2], (RGB)values[i2][3], (Integer)values[i2][4], (Integer)values[i2][5], (Integer)values[i2][6], (Integer)values[i2][7]));
            ++i2;
        }
        this.configure();
    }

    public Object[][] getValues() {
        Object[][] result = new Object[this.datas.size()][8];
        int v = 0;
        while (v < this.datas.size()) {
            result[v][0] = ((GraphElement)this.datas.get((int)v)).graph;
            result[v][1] = ((GraphElement)this.datas.get((int)v)).name;
            result[v][2] = ((GraphElement)this.datas.get((int)v)).description;
            result[v][3] = ((GraphElement)this.datas.get((int)v)).color;
            result[v][4] = ((GraphElement)this.datas.get((int)v)).line_width;
            result[v][5] = ((GraphElement)this.datas.get((int)v)).line_style;
            result[v][6] = ((GraphElement)this.datas.get((int)v)).xslider;
            result[v][7] = ((GraphElement)this.datas.get((int)v)).yslider;
            ++v;
        }
        return result;
    }

    public void dispose() {
        super.dispose();
        this.disposables.addAll(this.datas);
        int i = 0;
        while (i < this.disposables.size()) {
            try {
                Object o = this.disposables.get(i);
                if (o != null) {
                    if (o instanceof Widget) {
                        ((Widget)o).dispose();
                    } else if (o instanceof Color) {
                        ((Color)o).dispose();
                    } else if (o instanceof Image) {
                        ((Image)o).dispose();
                    } else {
                        try {
                            EditorPlugin.disposeObject(o);
                        }
                        catch (Throwable e) {
                            EditorPlugin.DBG.warning("Class not found when disposing of " + o.getClass() + "/" + o + " (" + e + ")");
                        }
                    }
                }
            }
            catch (Throwable e) {
                EditorPlugin.DBG.error("Problem disposing of objects", e);
            }
            ++i;
        }
    }

    public void valueChanged(Object element, int column, String newValue) throws InvalidTableValueException {
    }

    public void valueChanged(Object element, int column, Float newValue) throws InvalidTableValueException {
        this.valueChanged(element, column, new Double(newValue.doubleValue()));
    }

    public void valueChanged(Object element, int column, Double newValue) throws InvalidTableValueException {
    }

    public void valueChanged(Object element, int column, Boolean newValue) throws InvalidTableValueException {
    }

    public void valueChanged(Object element, int column, RGB value) throws InvalidTableValueException {
        GraphElement e = (GraphElement)element;
        boolean changed = false;
        if (column == 2 && !value.equals((Object)e.color)) {
            changed = true;
            e.color = value;
            e.update();
        }
        if (changed) {
            this.notifyListenersEdit(e.graph);
            this.getViewer().refresh((Object)e);
        }
    }

    public void valueChanged(Object element, int column, Integer newValue) throws InvalidTableValueException {
        int val = newValue;
        GraphElement e = (GraphElement)element;
        boolean changed = false;
        if (column == 3) {
            changed = true;
            e.line_width = this.widthChoices[val];
        } else if (column == 4) {
            changed = true;
            e.line_style = this.styleChoices[val];
        } else if (column == 5) {
            changed = true;
            e.xslider = this.sliderXChoices[val];
        } else if (column == 6) {
            changed = true;
            e.yslider = this.sliderYChoices[val];
        }
        if (changed) {
            this.notifyListenersEdit(e.graph);
            this.getViewer().refresh((Object)e);
        }
    }

    public void valueChanged(Object element, int column) throws InvalidTableValueException {
        ((GraphElement)element).readFromGraph();
        this.configure();
        this.getViewer().refresh(element);
    }

    private Object lookup(Object[] indexer, Object[] result, Object o) {
        int i = 0;
        while (i < indexer.length) {
            if (indexer[i].equals(o)) {
                return result[i];
            }
            ++i;
        }
        return result[-1];
    }

    public String getColumnText(Object element, int columnIndex) {
        GraphElement el = (GraphElement)element;
        if (columnIndex == 0) {
            return el.name;
        }
        if (columnIndex == 1) {
            return el.description;
        }
        if (columnIndex == 2) {
            return "";
        }
        if (columnIndex == 3) {
            return "" + this.lookup(this.widthChoices, this.widthChoicesString, el.line_width);
        }
        if (columnIndex == 4) {
            return "" + this.lookup(this.styleChoices, this.styleChoicesString, el.line_style);
        }
        if (columnIndex == 5) {
            return "" + this.lookup(this.sliderXChoices, this.sliderXChoicesString, el.xslider);
        }
        if (columnIndex == 6) {
            return "" + this.lookup(this.sliderYChoices, this.sliderYChoicesString, el.yslider);
        }
        if (columnIndex == 7) {
            return EditorPlugin.getString("TABLE_COLUMN_ADVANCED");
        }
        return "";
    }

    public Image getColumnImage(Object element, int columnIndex) {
        GraphElement el = (GraphElement)element;
        if (columnIndex == 2) {
            return el.image;
        }
        return null;
    }

    public RGB getColumnRGB(Object element, int columnIndex) {
        GraphElement el = (GraphElement)element;
        if (columnIndex == 2) {
            return el.color;
        }
        return null;
    }

    public Graph getSelectedGraph() {
        if (!this.has_focus) {
            return null;
        }
        int n = this.getViewer().getTable().getSelectionIndex();
        if (n == -1) {
            return null;
        }
        GraphElement element = (GraphElement)this.datas.get(n);
        return element.graph;
    }

    public void redrawGraphs() {
        this.graph_control.redraw();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.redrawGraphs();
        Graph g = this.getSelectedGraph();
        if (g != null) {
            this.notifyListenersSelect(g);
        }
    }

    public void focusLost(FocusEvent e) {
        this.has_focus = false;
        this.redrawGraphs();
    }

    public void focusGained(FocusEvent e) {
        this.has_focus = true;
        this.redrawGraphs();
    }

    public class GraphElement {
        public Graph graph;
        public String name;
        public String description;
        public Integer line_width;
        public Integer line_style;
        public Integer xslider;
        public Integer yslider;
        public RGB color;
        RGB black_rgb;
        Image image;
        GC image_gc;

        public void readFromGraph() {
            this.line_width = new Integer(this.graph.getLineWidth());
            this.line_style = new Integer(this.graph.getLineStyle());
            this.xslider = (Integer)GraphTable.this.lookup(GraphTable.this.sliderXChoicesString, GraphTable.this.sliderXChoices, this.graph.getXSlider().getTitle());
            this.yslider = (Integer)GraphTable.this.lookup(GraphTable.this.sliderYChoicesString, GraphTable.this.sliderYChoices, this.graph.getYSlider().getTitle());
            this.color = this.graph.getForeground().getRGB();
            this.redrawImage();
        }

        public GraphElement(Graph graph, String name, String description, RGB color, Integer line_width, Integer line_style, Integer x_slider, Integer y_slider) {
            this.graph = graph;
            this.name = name;
            this.description = description;
            this.line_width = line_width;
            this.line_style = line_style;
            this.xslider = x_slider;
            this.yslider = y_slider;
            this.color = color;
            this.black_rgb = new RGB(0, 0, 0);
            PaletteData palettedat = new PaletteData(new RGB[]{color, color});
            ImageData imgdat = new ImageData(11, 11, 1, palettedat);
            this.image = new Image((Device)GraphTable.this.getDisplay(), imgdat);
            this.redrawImage();
        }

        public void update() {
            this.redrawImage();
        }

        public void redrawImage() {
            PaletteData palettedat = new PaletteData(new RGB[]{this.color, this.color});
            ImageData imgdat = new ImageData(11, 11, 1, palettedat);
            Image tmpimage = this.image;
            this.image = new Image((Device)GraphTable.this.getDisplay(), imgdat);
            tmpimage.dispose();
        }

        public void dispose() {
            this.image.dispose();
        }
    }
}

