/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;

public class ObservationSearcher {
    public static final int RETURN_LATEST_MULTIPLE = 0;
    public static final int RETURN_EARLIEST_MULTIPLE = 1;
    private static final boolean CACHE_INDEXES = false;
    EList times;

    public ObservationSearcher(SDDiscreteObservation obs) {
        this.times = obs.getCreationTime();
    }

    public ObservationSearcher(SDContiguousObservation obs) {
        this.times = obs.getCreationTime();
    }

    public int bchopGetIndex(double t, int multiple_pref) {
        int lower = 0;
        int higher = this.times.size() - 1;
        double t1 = ((Number)this.times.get(lower)).doubleValue();
        double t2 = ((Number)this.times.get(higher)).doubleValue();
        if (t >= t2) {
            return this.times.size() - 1;
        }
        if (t <= t1) {
            return 0;
        }
        return this.bchopGetIndex(lower, higher, t, multiple_pref);
    }

    private int bchopGetIndex(int lower, int higher, double t, int multiple_pref) {
        while (true) {
            if (higher - lower < 10) {
                if (multiple_pref == 0) {
                    int i = lower;
                    while (i <= higher) {
                        Number T = (Number)this.times.get(i);
                        if (T.doubleValue() > t) {
                            if (--i < 0) {
                                return 0;
                            }
                            if (i >= this.times.size()) {
                                return this.times.size() - 1;
                            }
                            return i;
                        }
                        ++i;
                    }
                    return higher;
                }
                int i = lower;
                while (i <= higher) {
                    Number T = (Number)this.times.get(i);
                    if (T.doubleValue() >= t) {
                        if (T.doubleValue() > t) {
                            --i;
                        }
                        if (i < 0) {
                            return 0;
                        }
                        if (i >= this.times.size()) {
                            return this.times.size() - 1;
                        }
                        return i;
                    }
                    ++i;
                }
                return lower;
            }
            double t1 = ((Number)this.times.get(lower)).doubleValue();
            double t2 = ((Number)this.times.get(higher)).doubleValue();
            double chop = (t - t1) / (t2 - t1);
            chop *= (double)(higher - lower - 2);
            double chop_t = ((Number)this.times.get((int)(chop = chop + (double)lower + 1.0))).doubleValue();
            if (chop_t == t) {
                return (int)chop;
            }
            if (chop_t > t) {
                higher = (int)chop;
                continue;
            }
            lower = (int)chop;
        }
    }
}

