/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDTextObservation;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEComponentIdentification;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.ImageManager;
import org.eclipse.hyades.statistical.ui.editor.internal.AgentChangeListener;
import org.eclipse.hyades.statistical.ui.editor.internal.ClickListener;
import org.eclipse.hyades.statistical.ui.editor.internal.DynamicAction;
import org.eclipse.hyades.statistical.ui.editor.internal.EntityExistsException;
import org.eclipse.hyades.statistical.ui.editor.internal.GraphWindow;
import org.eclipse.hyades.statistical.ui.editor.internal.GraphWindowListener;
import org.eclipse.hyades.statistical.ui.editor.internal.HexData;
import org.eclipse.hyades.statistical.ui.editor.internal.ModelChangeListener;
import org.eclipse.hyades.statistical.ui.editor.internal.ModifiableVariableBar;
import org.eclipse.hyades.statistical.ui.editor.internal.ModuleNodeChangeListener;
import org.eclipse.hyades.statistical.ui.editor.internal.ObservationMerger;
import org.eclipse.hyades.statistical.ui.editor.internal.OpAddToTree;
import org.eclipse.hyades.statistical.ui.editor.internal.OpFreeSubTree;
import org.eclipse.hyades.statistical.ui.editor.internal.OpGarbageCollectTree;
import org.eclipse.hyades.statistical.ui.editor.internal.OpGenerateDescriptorConfig;
import org.eclipse.hyades.statistical.ui.editor.internal.OpGenerateTreeConfig;
import org.eclipse.hyades.statistical.ui.editor.internal.SDSnapshotObservationGraphSource;
import org.eclipse.hyades.statistical.ui.editor.internal.SDTextObservationGraphSource;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConDropListener;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConModelOp;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConModule;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConOp;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConOpState;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConStatisticalImageProvider;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConTreeOp;
import org.eclipse.hyades.statistical.ui.editor.internal.XMLConfigUtil;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.Alert;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertListener;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Dirtiable;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.EnumerationGraph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.EnumerationGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.Graph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.HistogramGraph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.LineGraph;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.TestGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomImageBar;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ResourceTransfer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StatisticalModelGraphViewer
implements AlertListener,
DisposeListener,
SelectionListener,
DropTargetListener,
MouseListener,
StatConInterface,
GraphWindowListener {
    private static final boolean DEBUG_LOADING = true;
    public static final int RESERVED_NODES = 1;
    protected ArrayList disposables = new ArrayList();
    protected HashMap module_refs = new HashMap();
    protected ArrayList modules = new ArrayList();
    protected ArrayList stat_img_providers = new ArrayList();
    ArrayList alerts = new ArrayList();
    protected int next = 0;
    protected int[] colours = new int[]{3, 5, 9, 7, 13, 11};
    protected TabFolder tabfolder;
    protected SashForm sashfolder;
    protected Composite leftsash;
    protected Composite rightsash;
    protected GraphWindow graph_window;
    protected Tree chooser_tree;
    protected Menu chooser_menu;
    protected ArrayList chooser_disposables;
    protected MenuItem chooser_add;
    protected ImageManager img;
    protected HashMap reverse_map = new HashMap();
    protected HashMap trcagent_map = new HashMap();
    protected HashMap msglist_map = new HashMap();
    protected HashMap sddescriptor_map = new HashMap();
    protected HashMap counter_map = new HashMap();
    protected HashMap modifiable_map = new HashMap();
    protected HashMap rgraph_map = new HashMap();
    protected HashMap graph_map = new HashMap();
    protected HashMap bar_map = new HashMap();
    protected HashMap bar_slider_map = new HashMap();
    protected HashMap source_map = new HashMap();
    protected HashMap source_graph_map = new HashMap();
    protected Dirtiable dirtiable;
    protected ArrayList agents = new ArrayList();
    protected ArrayList dynamic_actions = new ArrayList();
    protected ArrayList click_listeners = new ArrayList();
    protected ArrayList global_actions = new ArrayList();
    protected ArrayList drop_listeners = new ArrayList();
    protected ArrayList root_nodes = new ArrayList();
    protected ArrayList model_change_listeners = new ArrayList();
    protected ArrayList agent_change_listeners = new ArrayList();
    protected ArrayList node_change_listeners = new ArrayList();
    protected URI current_project;
    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    protected HashMap updates = new HashMap();
    protected SDDescriptor selected_descriptor = null;
    Point pt = new Point(0, 0);
    protected long prev_used = 0L;
    static /* synthetic */ Class class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp;
    static /* synthetic */ Class class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp;

    public void setCurrentProjectURI(URI uri) {
        this.current_project = uri;
    }

    public URI getCurrentProjectURI() {
        return this.current_project;
    }

    public void showTab(int i) {
        this.graph_window.showTab(i);
    }

    public StatisticalModelGraphViewer(Composite parent, int style, boolean tabfolder) {
        EditorPlugin.DBG.info("constructor");
        this.initAsSash(parent);
        this.initCommonActions();
    }

    public StatisticalModelGraphViewer(Composite parent, int style, boolean tabfolder, Dirtiable d, URI current_project) {
        EditorPlugin.DBG.info("constructor");
        this.dirtiable = d;
        this.current_project = current_project;
        this.initAsSash(parent);
        this.initCommonActions();
        this.loadModules();
    }

    public void addClickListener(ClickListener listener) {
        this.click_listeners.add(listener);
    }

    public void removeClickListener(ClickListener listener) {
        this.click_listeners.remove(listener);
    }

    public void addModuleNodeChangeListener(ModuleNodeChangeListener listener) {
        this.node_change_listeners.add(listener);
    }

    public void removeModuleNodeChangeListener(ModuleNodeChangeListener listener) {
        this.node_change_listeners.remove(listener);
    }

    public void addModelChangeListener(ModelChangeListener listener) {
        this.model_change_listeners.add(listener);
    }

    public void removeModelChangeListener(ModelChangeListener listener) {
        this.model_change_listeners.remove(listener);
    }

    public void addAgentChangeListener(AgentChangeListener listener) {
        this.agent_change_listeners.add(listener);
    }

    public void removeAgentChangeListener(AgentChangeListener listener) {
        this.agent_change_listeners.remove(listener);
    }

    public String[] getModuleRefs() {
        String[] refs = new String[this.modules.size()];
        int i = 0;
        while (i < this.modules.size()) {
            refs[i] = ((StatConModule)this.modules.get(i)).getModuleRef();
            ++i;
        }
        return refs;
    }

    public StatConModule getModuleByRef(String ref) {
        return (StatConModule)this.module_refs.get(ref);
    }

    public void unloadModules() {
        EditorPlugin.DBG.info("unloading modules");
        int i = 0;
        while (i < this.modules.size()) {
            try {
                StatConModule module = (StatConModule)this.modules.get(i);
                EditorPlugin.DBG.info("unloading module " + i);
                module.unload();
            }
            catch (Throwable t) {
                EditorPlugin.DBG.error("failed to unload module", t);
            }
            ++i;
        }
        this.modules.clear();
        this.module_refs.clear();
    }

    public ZoomSlider getSelectedSlider() {
        return this.graph_window.getSelectedSlider();
    }

    public double getSelectedSliderValue() {
        return this.graph_window.getSelectedSliderValue();
    }

    public void addSliderAction(String id, String name, Image image, Runnable runnable, boolean horizontal) {
        this.graph_window.addSliderAction(id, name, image, runnable, horizontal);
    }

    public void removeSliderAction(String id) {
        this.graph_window.removeSliderAction(id);
    }

    public void loadModules() {
        EditorPlugin.DBG.info("loading modules");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.hyades.statistical.ui.StatConModule");
        IExtension[] extensions = point.getExtensions();
        EditorPlugin.DBG.info("found " + extensions.length + " modules");
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configs = extensions[i].getConfigurationElements();
            int z = 0;
            while (z < configs.length) {
                String clazz = configs[z].getAttribute("class");
                StatConModule module = null;
                try {
                    EditorPlugin.DBG.info("loading module " + i);
                    module = (StatConModule)configs[z].createExecutableExtension("class");
                    module.load(this);
                    this.module_refs.put(module.getModuleRef(), module);
                    this.modules.add(module);
                    EditorPlugin.DBG.info("loaded OK");
                }
                catch (Throwable e) {
                    try {
                        this.modules.remove(module);
                    }
                    catch (Throwable x) {
                        // empty catch block
                    }
                    try {
                        this.module_refs.remove(module);
                    }
                    catch (Throwable x) {
                        // empty catch block
                    }
                    EditorPlugin.DBG.logVisibleError(e, EditorPlugin.getString("ERROR_LOAD_MODULE") + " \"" + clazz + "\" ", false);
                    EditorPlugin.DBG.error("failed to load module", e);
                }
                ++z;
            }
            ++i;
        }
        EditorPlugin.DBG.info("finished loading modules");
        EditorPlugin.DBG.info("loading statistical image providers");
        registry = Platform.getExtensionRegistry();
        point = registry.getExtensionPoint("org.eclipse.hyades.statistical.ui.StatConStatisticalImageProvider");
        extensions = point.getExtensions();
        EditorPlugin.DBG.info("found " + extensions.length + " statistical image providers");
        int i2 = 0;
        while (i2 < extensions.length) {
            IConfigurationElement[] configs = extensions[i2].getConfigurationElements();
            int z = 0;
            while (z < configs.length) {
                String clazz = configs[z].getAttribute("class");
                StatConStatisticalImageProvider imgprovider = null;
                try {
                    EditorPlugin.DBG.info("loading statistical image provider " + i2);
                    imgprovider = (StatConStatisticalImageProvider)configs[z].createExecutableExtension("class");
                    this.stat_img_providers.add(imgprovider);
                }
                catch (Throwable e) {
                    EditorPlugin.DBG.logVisibleError(e, EditorPlugin.getString("ERROR_LOAD_STAT_IMGPROVIDER") + " \"" + clazz + "\" ", false);
                    EditorPlugin.DBG.error("failed to load statistical image provider", e);
                }
                ++z;
            }
            ++i2;
        }
        EditorPlugin.DBG.info("finished loading statistical image providers");
    }

    private DynamicAction findDynamicAction(String id, ArrayList actions) {
        int i = 0;
        while (i < actions.size()) {
            DynamicAction action = (DynamicAction)actions.get(i);
            if (action.id.equals(id)) {
                return action;
            }
            ++i;
        }
        return null;
    }

    private BasicAction findAction(String id, ArrayList actions) {
        int i = 0;
        while (i < actions.size()) {
            BasicAction action = (BasicAction)actions.get(i);
            if (action.id.equals(id)) {
                return action;
            }
            ++i;
        }
        return null;
    }

    private RootNode getRootNodeName(String name) {
        int i = 0;
        while (i < this.root_nodes.size()) {
            RootNode node = (RootNode)this.root_nodes.get(i);
            if (node.name.equals(name)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private RootNode getRootNodeID(String id) {
        int i = 0;
        while (i < this.root_nodes.size()) {
            RootNode node = (RootNode)this.root_nodes.get(i);
            if (node.id.equals(id)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private StatAgent getStatAgent(TRCAgent agent) {
        int i = 0;
        while (i < this.agents.size()) {
            StatAgent node = (StatAgent)this.agents.get(i);
            if (node.agent == agent) {
                return node;
            }
            ++i;
        }
        return null;
    }

    private StatAgent getStatAgent(EList events) {
        int i = 0;
        while (i < this.agents.size()) {
            StatAgent node = (StatAgent)this.agents.get(i);
            if (node.agent.getDefaultEvents() == events) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public TRCAgent[] getAgents() {
        TRCAgent[] tmp = new TRCAgent[this.agents.size()];
        int i = 0;
        while (i < this.agents.size()) {
            StatAgent node = (StatAgent)this.agents.get(i);
            tmp[i] = node.agent;
            ++i;
        }
        return tmp;
    }

    public TRCAgent getAgentForURI(URI uri) {
        int i = 0;
        while (i < this.agents.size()) {
            StatAgent node = (StatAgent)this.agents.get(i);
            if (node.uri != null && node.uri.toString().equals(uri.toString())) {
                return node.agent;
            }
            ++i;
        }
        return null;
    }

    public void addGlobalAction(String id, String name, Image image, Runnable runnable) {
        BasicAction action = this.findAction(id, this.global_actions);
        if (action == null) {
            action = new BasicAction();
            this.global_actions.add(action);
        }
        action.id = id;
        action.name = name;
        action.image = image;
        action.runnable = runnable;
        action.menuitem = new MenuItem(this.chooser_menu, 0);
        action.menuitem.setText(name);
        action.menuitem.setImage(image);
        action.menuitem.addSelectionListener((SelectionListener)action);
    }

    public void removeGlobalAction(String id) {
        BasicAction action = this.findAction(id, this.global_actions);
        if (action != null) {
            action.dispose();
            this.global_actions.remove(action);
        }
    }

    public void addDynamicAction(String group, String id, String name, DynamicAction action) {
        if (this.findDynamicAction(id, this.dynamic_actions) == null) {
            action.id = id;
            action.name = name;
            action.group = group;
            this.dynamic_actions.add(action);
        }
    }

    public void removeDynamicAction(String id) {
        DynamicAction tmp = this.findDynamicAction(id, this.dynamic_actions);
        if (tmp != null) {
            this.dynamic_actions.remove(tmp);
        }
    }

    public void addDropTargetListener(String extension, StatConDropListener listener) {
        DropListener drop = new DropListener();
        drop.extension = extension;
        drop.listener = listener;
        this.drop_listeners.add(drop);
    }

    public void removeDropTargetListener(String extension) {
        int i = 0;
        while (i < this.drop_listeners.size()) {
            DropListener drop = (DropListener)this.drop_listeners.get(i);
            if (drop.extension.equals(extension)) {
                this.drop_listeners.remove(drop);
            }
            ++i;
        }
    }

    public void addModuleNode(String name, String id, Image image) throws EntityExistsException {
        if (this.getRootNodeID(id) != null) {
            throw new EntityExistsException(EditorPlugin.getString("ROOT_NODE_EXISTS") + " " + name + " " + EditorPlugin.getString("ROOT_NODE_EXISTS_2"));
        }
        RootNode node = new RootNode();
        node.name = name;
        node.image = image;
        node.id = id;
        node.item = new TreeItem(this.chooser_tree, 0, 0);
        node.item.setText(name);
        node.item.setImage(image);
        node.item.setGrayed(true);
        this.root_nodes.add(node);
        int i = 0;
        while (i < this.node_change_listeners.size()) {
            ModuleNodeChangeListener listener = (ModuleNodeChangeListener)this.node_change_listeners.get(i);
            listener.nodeAdded(id);
            ++i;
        }
    }

    public void addModuleNode(String name, String id, String parent_id, Image image) throws EntityExistsException, NullPointerException {
        if (this.getRootNodeID(id) != null) {
            throw new EntityExistsException(EditorPlugin.getString("ROOT_NODE_EXISTS") + " " + name + " " + EditorPlugin.getString("ROOT_NODE_EXISTS_2"));
        }
        RootNode parent = this.getRootNodeID(parent_id);
        if (parent == null) {
            throw new NullPointerException("");
        }
        RootNode node = new RootNode();
        node.name = name;
        node.image = image;
        node.id = id;
        node.parent_id = parent_id;
        node.item = new TreeItem(parent.item, 0, 0);
        node.item.setText(name);
        node.item.setImage(image);
        node.item.setGrayed(true);
        parent.node_children.add(node);
        this.root_nodes.add(node);
        int i = 0;
        while (i < this.node_change_listeners.size()) {
            ModuleNodeChangeListener listener = (ModuleNodeChangeListener)this.node_change_listeners.get(i);
            listener.nodeAdded(id);
            ++i;
        }
    }

    public void removeModuleNode(String id) {
        int i;
        RootNode node = this.getRootNodeID(id);
        if (node != null) {
            if (node.parent_id != null) {
                RootNode parent = this.getRootNodeID(node.parent_id);
                parent.node_children.remove(node);
            }
            i = 0;
            while (i < node.node_children.size()) {
                RootNode child = (RootNode)node.node_children.get(i);
                this.removeModuleNode(child.id);
                ++i;
            }
            node.dispose();
            this.root_nodes.remove(node);
        }
        i = 0;
        while (i < this.node_change_listeners.size()) {
            ModuleNodeChangeListener listener = (ModuleNodeChangeListener)this.node_change_listeners.get(i);
            listener.nodeRemoved(id);
            ++i;
        }
    }

    public void addModuleNodeAction(String node_id, String action_id, String action_name, Image action_image, Runnable runnable) {
        RootNode node = this.getRootNodeID(node_id);
        if (node != null) {
            BasicAction action = this.findAction(action_id, node.actions);
            if (action == null) {
                action = new BasicAction();
                node.actions.add(action);
            }
            action.id = action_id;
            action.name = action_name;
            action.image = action_image;
            action.runnable = runnable;
        }
    }

    public void removeModuleNodeAction(String node_id, String action_id) {
        RootNode node = this.getRootNodeID(node_id);
        if (node != null) {
            int i = 0;
            while (i < node.actions.size()) {
                BasicAction action = (BasicAction)node.actions.get(i);
                if (action.id.equals(action_id)) {
                    node.actions.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    public SDDescriptor[] addAgent(IFile ifile) throws IOException {
        try {
            return this.addAgent(ifile.getProjectRelativePath());
        }
        catch (Exception e) {
            return this.addAgent(ifile.getFullPath());
        }
    }

    private Resource createHierarchyResource(URI uri) {
        try {
            HierarchyResourceSetImpl resourceSet = HierarchyResourceSetImpl.getInstance();
            Resource resource = resourceSet.getResource(uri, false);
            if (resource == null) {
                return resourceSet.createResource(uri);
            }
            return resource;
        }
        catch (Exception e) {
            EditorPlugin.DBG.warning("Problem creating Hierarchy resource", e);
            return null;
        }
    }

    private Resource createResource(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uri, false);
        if (resource == null) {
            return resourceSet.createResource(uri);
        }
        return resource;
    }

    public SDDescriptor[] addAgent(IPath ipath) throws IOException {
        EditorPlugin.DBG.info("add trace agent");
        URI fileURI = URI.createPlatformResourceURI((String)ipath.toString());
        EditorPlugin.DBG.info("agent URI:" + fileURI);
        if (fileURI == null) {
            throw new IOException(EditorPlugin.getString("NULL_URI_WHILE_LOADING") + " " + ipath);
        }
        Resource resource = this.createResource(fileURI);
        if (resource == null) {
            resource = this.createResource(fileURI);
        }
        if (resource == null) {
            throw new IOException(EditorPlugin.getString("NULL_RESOURCE_WHILE_LOADING") + " " + ipath);
        }
        if (resource instanceof XMLResource) {
            EditorPlugin.DBG.info("found XML resource for agent");
            XMLResource xresource = (XMLResource)resource;
            String msg = "";
            try {
                EditorPlugin.DBG.info("trying to load resource as an unzipped file");
                xresource.setUseZip(false);
                xresource.load(Collections.EMPTY_MAP);
                EditorPlugin.DBG.info("loaded resource OK as an unzipped file");
            }
            catch (Throwable e) {
                EditorPlugin.DBG.info("load failed as an unzipped file");
                msg = msg + e.toString() + " / ";
                resource = this.createHierarchyResource(fileURI);
                if (resource == null) {
                    resource = this.createResource(fileURI);
                }
                xresource = (XMLResource)resource;
                try {
                    EditorPlugin.DBG.info("trying to load resource as a zipped file");
                    xresource.setUseZip(true);
                    xresource.load(Collections.EMPTY_MAP);
                    EditorPlugin.DBG.info("loaded resource OK as a zipped file");
                }
                catch (Throwable t) {
                    msg = msg + t.toString();
                    throw new IOException(msg);
                }
            }
        } else {
            EditorPlugin.DBG.info("found a non-XML resource for agent - trying to load anyway");
            if (!resource.isLoaded()) {
                resource.load(Collections.EMPTY_MAP);
            }
        }
        EList list = resource.getContents();
        EditorPlugin.DBG.info("got contents of agent resource (size " + list.size() + ")");
        return this.addAgentFromTree(list, fileURI);
    }

    private SDDescriptor[] addAgentFromTree(EList list, URI fileURI) {
        EditorPlugin.DBG.info("Searching Resource Contents (" + list.size() + ")");
        int k = 0;
        while (k < list.size()) {
            Object o = list.get(k);
            EditorPlugin.DBG.info("resource content " + k + " = " + o.getClass());
            if (o instanceof TRCAgentProxy) {
                TRCAgentProxy proxy = (TRCAgentProxy)o;
                return this.addAgent(proxy.getAgent(), fileURI);
            }
            if (o instanceof TRCAgent) {
                return this.addAgent((TRCAgent)o, fileURI);
            }
            ++k;
        }
        SDDescriptor[] descriptors = null;
        int k2 = 0;
        while (k2 < list.size()) {
            EObject o = (EObject)list.get(k2);
            if (o instanceof TRCProcessProxy) {
                EditorPlugin.DBG.info("resource subcontent ProcessProxy");
                descriptors = this.addAgentFromTree(((TRCProcessProxy)o).getAgentProxies(), fileURI);
            } else if (o instanceof TRCNode) {
                EditorPlugin.DBG.info("resource subcontent Node");
                descriptors = this.addAgentFromTree(((TRCNode)o).getProcessProxies(), fileURI);
            } else if (o instanceof TRCMonitor) {
                EditorPlugin.DBG.info("resource subcontent Monitor");
                descriptors = this.addAgentFromTree(((TRCMonitor)o).getNodes(), fileURI);
            } else {
                EditorPlugin.DBG.info("resource subcontent " + k2 + " = " + o.getClass());
                descriptors = this.addAgentFromTree(o.eContents(), fileURI);
            }
            if (descriptors != null) {
                return descriptors;
            }
            ++k2;
        }
        return null;
    }

    public SDDescriptor[] addAgent(TRCAgent agent) {
        return this.addAgent(agent, null);
    }

    private StringBuffer cbeToString(CBECommonBaseEvent e, StringBuffer sb) {
        Date create = new Date((long)(e.getCreationTime() / 1000.0));
        this.sdf.format(create, sb, new FieldPosition(0));
        sb.append(" ");
        short sev = e.getSeverity();
        if (sev <= 10) {
            sb.append("(" + EditorPlugin.getString("CBE_INFO") + ")");
        } else if (sev <= 30) {
            sb.append("(" + EditorPlugin.getString("CBE_WARNING") + ")");
        } else if (sev <= 40) {
            sb.append("(" + EditorPlugin.getString("CBE_ERROR") + ")");
        } else if (sev <= 60) {
            sb.append("(" + EditorPlugin.getString("CBE_CRITICAL") + ")");
        }
        sb.append(" ");
        if (e.getRepeatCount() > 0) {
            sb.append("(x");
            sb.append(e.getRepeatCount());
            sb.append(") ");
        }
        sb.append(e.getSourceComponentId().getComponent());
        if (e.getSourceComponentId().getSubComponent() != null) {
            sb.append(" / ");
            sb.append(e.getSourceComponentId().getSubComponent());
        }
        sb.append(" - ");
        sb.append(e.getMsg());
        sb.append("\n");
        return sb;
    }

    private boolean filterCBE(CBECommonBaseEvent e) {
        TRCAgent agent = e.getAgent();
        if (agent == null) {
            return false;
        }
        StatAgent stagent = this.getStatAgent(agent);
        if (stagent == null) {
            return false;
        }
        if (stagent.msg_info_item == null) {
            return false;
        }
        if (!stagent.msg_item.getChecked()) {
            return false;
        }
        short severity = e.getSeverity();
        if (severity <= 10 ? !stagent.msg_info_item.getChecked() : (severity <= 30 ? !stagent.msg_warn_item.getChecked() : !stagent.msg_error_item.getChecked())) {
            return false;
        }
        CBEComponentIdentification sid = e.getSourceComponentId();
        String component = sid.getComponent();
        String subcomponent = sid.getSubComponent();
        TreeItem citem = (TreeItem)stagent.msg_locations.get(component);
        if (citem == null) {
            citem = new TreeItem(stagent.msg_loc_item, 0);
            citem.setImage(this.img.getImage("smodel_cbemessage.gif"));
            citem.setText(component);
            citem.setChecked(true);
            stagent.msg_locations.put(component, citem);
        }
        if (!citem.getChecked()) {
            return false;
        }
        if (subcomponent != null) {
            String key = component + "<%$%~%>" + subcomponent;
            TreeItem sitem = (TreeItem)stagent.msg_locations.get(key);
            if (sitem == null) {
                sitem = new TreeItem(citem, 0);
                sitem.setImage(this.img.getImage("smodel_cbemessage.gif"));
                sitem.setText(subcomponent);
                sitem.setChecked(true);
                stagent.msg_locations.put(key, sitem);
            }
            if (!sitem.getChecked()) {
                return false;
            }
        }
        TreeItem[] items = stagent.msg_loc_item.getItems();
        return true;
    }

    private int appendCBEs(List events, int index) {
        StringBuffer sb = new StringBuffer();
        int i = index;
        while (i < events.size()) {
            CBECommonBaseEvent e = (CBECommonBaseEvent)events.get(i);
            if (this.filterCBE(e)) {
                this.cbeToString(e, sb);
            }
            ++i;
        }
        this.graph_window.appendCBEText(sb.toString());
        return events.size();
    }

    private int setCBEs(List events, int index) {
        StringBuffer sb = new StringBuffer();
        int i = index;
        while (i < events.size()) {
            CBECommonBaseEvent e = (CBECommonBaseEvent)events.get(i);
            if (this.filterCBE(e)) {
                this.cbeToString(e, sb);
            }
            ++i;
        }
        this.graph_window.setCBEText(sb.toString());
        return events.size();
    }

    private void sortCBEs(List events) {
        Collections.sort(events, new CBEComparator());
    }

    private void appendCBEs(StatAgent agent) {
        if (agent.show_messages) {
            agent.msgindex = this.appendCBEs((List)agent.agent.getDefaultEvents(), agent.msgindex);
        }
    }

    private void appendAllCBEs() {
        int i = 0;
        while (i < this.agents.size()) {
            StatAgent agent = (StatAgent)this.agents.get(i);
            agent.msgindex = this.appendCBEs((List)agent.agent.getDefaultEvents(), agent.msgindex);
            ++i;
        }
    }

    private void redoAllCBEs() {
        ArrayList all_events = new ArrayList();
        int i = 0;
        while (i < this.agents.size()) {
            StatAgent agent = (StatAgent)this.agents.get(i);
            if (agent.show_messages) {
                agent.msgindex = agent.agent.getDefaultEvents().size();
                all_events.addAll(agent.agent.getDefaultEvents());
            }
            ++i;
        }
        this.sortCBEs(all_events);
        this.setCBEs(all_events, 0);
    }

    public void updateCBELog() {
        this.appendAllCBEs();
    }

    public void reloadCBELog() {
        this.redoAllCBEs();
    }

    public SDDescriptor[] updateAgent(TRCAgent agent) {
        int i = 0;
        while (i < this.agents.size()) {
            StatAgent node = (StatAgent)this.agents.get(i);
            EditorPlugin.DBG.info("agent " + i + " = " + node.agent.getName());
            ++i;
        }
        StatAgent statagent = this.getStatAgent(agent);
        if (statagent == null) {
            EditorPlugin.DBG.info("update requested on non-existent agent " + agent.getName());
            return null;
        }
        EList direct_children = agent.eContents();
        EditorPlugin.DBG.info("checking agent's " + direct_children.size() + " children for Statistical Models");
        ArrayList<Object> added = new ArrayList<Object>();
        int z = 0;
        while (z < direct_children.size()) {
            Object co = direct_children.get(z);
            EditorPlugin.DBG.info("agent child " + z + " = " + co.getClass());
            if (co instanceof SDDescriptor) {
                EditorPlugin.DBG.info("adding agent SDDescriptor (statistical model)");
                if (statagent.model_roots.contains(co)) {
                    this.updateModel((SDDescriptor)co);
                    added.add(co);
                } else {
                    this.addModel((SDDescriptor)co, statagent);
                    added.add(co);
                }
            }
            ++z;
        }
        TreeItem agent_item = statagent.msg_item.getParentItem();
        TreeItem[] items = agent_item.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            if (items[i2] != statagent.msg_item && this.mapItemToDescriptor(items[i2]) == null && !items[i2].isDisposed()) {
                items[i2].dispose();
            }
            ++i2;
        }
        SDDescriptor[] des = new SDDescriptor[added.size()];
        int i3 = 0;
        while (i3 < des.length) {
            des[i3] = (SDDescriptor)added.get(i3);
            ++i3;
        }
        this.updateTreeItems();
        try {
            this.chooser_tree.redraw();
        }
        catch (Exception e) {}
        return des;
    }

    public SDDescriptor[] addAgent(TRCAgent agent, URI fileURI) {
        if (agent == null) {
            EditorPlugin.DBG.logVisibleError(new Exception("Null Agent"), EditorPlugin.getString("ERROR_NULL_AGENT") + " " + fileURI, false);
            return null;
        }
        if (agent.getName() == null) {
            EditorPlugin.DBG.logVisibleError(new Exception("Null Agent Name"), EditorPlugin.getString("ERROR_NULL_NAME") + " " + fileURI, false);
        }
        EditorPlugin.DBG.info("add valid agent " + agent.getName() + " / " + fileURI);
        int i = 0;
        while (i < this.agents.size()) {
            StatAgent node = (StatAgent)this.agents.get(i);
            EditorPlugin.DBG.info("agent " + i + " = " + node.agent.getName());
            ++i;
        }
        if (fileURI != null) {
            int i2 = 0;
            while (i2 < this.agents.size()) {
                StatAgent node = (StatAgent)this.agents.get(i2);
                URI uri = node.uri;
                if (uri != null && uri.equals((Object)fileURI)) {
                    EditorPlugin.DBG.info("URI matched to an existing agent - returning without adding");
                    return null;
                }
                ++i2;
            }
        }
        EditorPlugin.DBG.info("creating new agent");
        StatAgent statagent = this.getStatAgent(agent);
        if (statagent == null) {
            statagent = new StatAgent();
            this.agents.add(statagent);
        }
        statagent.agent = agent;
        statagent.uri = fileURI;
        TreeItem item = new TreeItem(this.chooser_tree, 0);
        if (agent.getName() == null) {
            if (agent.getAgentProxy().getName() != null) {
                item.setText(agent.getAgentProxy().getName());
            } else {
                item.setText(agent.getType() + " / " + agent.getAgentProxy().getProcessProxy().getName() + " / " + agent.getRuntimeId());
            }
        } else {
            item.setText(agent.getName());
        }
        item.setChecked(true);
        item.setGrayed(false);
        item.setImage(this.img.getImage("smodel_trcagent.gif"));
        this.trcagent_map.put(item, agent);
        this.reverse_map.put(agent, item);
        EList events = agent.getDefaultEvents();
        TreeItem msg = new TreeItem(item, 0);
        msg.setImage(this.img.getImage("smodel_cbemessage.gif"));
        msg.setText(EditorPlugin.getString("MESSAGES"));
        msg.setChecked(true);
        msg.setGrayed(false);
        TreeItem msg_severity = new TreeItem(msg, 0);
        msg_severity.setImage(this.img.getImage("smodel_cbemessage.gif"));
        msg_severity.setText(EditorPlugin.getString("SEVERITY"));
        msg_severity.setChecked(true);
        msg_severity.setGrayed(true);
        TreeItem msg_location = new TreeItem(msg, 0);
        msg_location.setImage(this.img.getImage("smodel_cbemessage.gif"));
        msg_location.setText(EditorPlugin.getString("SOURCE_LOCATIONS"));
        msg_location.setChecked(true);
        msg_location.setGrayed(true);
        TreeItem msg_info = new TreeItem(msg_severity, 0);
        msg_info.setImage(this.img.getImage("event_messageinfo.gif"));
        msg_info.setText(EditorPlugin.getString("INFO"));
        msg_info.setChecked(true);
        msg_info.setGrayed(false);
        TreeItem msg_warning = new TreeItem(msg_severity, 0);
        msg_warning.setImage(this.img.getImage("event_messagewarning.gif"));
        msg_warning.setText(EditorPlugin.getString("WARNING"));
        msg_warning.setChecked(true);
        msg_warning.setGrayed(false);
        TreeItem msg_errors = new TreeItem(msg_severity, 0);
        msg_errors.setImage(this.img.getImage("event_messageerror.gif"));
        msg_errors.setText(EditorPlugin.getString("ERROR"));
        msg_errors.setChecked(true);
        msg_errors.setGrayed(false);
        this.msglist_map.put(msg, events);
        this.reverse_map.put(events, msg);
        statagent.msg_item = msg;
        statagent.msg_info_item = msg_info;
        statagent.msg_warn_item = msg_warning;
        statagent.msg_error_item = msg_errors;
        statagent.msg_loc_item = msg_location;
        EditorPlugin.DBG.info("interleaving all agent CBE messages");
        this.redoAllCBEs();
        ArrayList<Object> added = new ArrayList<Object>();
        EList direct_children = agent.eContents();
        EditorPlugin.DBG.info("checking agent's " + direct_children.size() + " children for Statistical Models");
        int z = 0;
        while (z < direct_children.size()) {
            Object co = direct_children.get(z);
            EditorPlugin.DBG.info("agent child " + z + " = " + co.getClass());
            if (co instanceof SDDescriptor) {
                EditorPlugin.DBG.info("adding agent SDDescriptor (statistical model)");
                if (!statagent.model_roots.contains(co)) {
                    this.addModel((SDDescriptor)co, statagent);
                    added.add(co);
                }
            }
            ++z;
        }
        SDDescriptor[] des = new SDDescriptor[added.size()];
        int i3 = 0;
        while (i3 < des.length) {
            des[i3] = (SDDescriptor)added.get(i3);
            ++i3;
        }
        EditorPlugin.DBG.info("agent added ok");
        int i4 = 0;
        while (i4 < this.agents.size()) {
            StatAgent node = (StatAgent)this.agents.get(i4);
            EditorPlugin.DBG.info("agent " + i4 + " = " + node.agent.getName());
            ++i4;
        }
        EditorPlugin.DBG.info("notifying agent listeners");
        int i5 = 0;
        while (i5 < this.agent_change_listeners.size()) {
            AgentChangeListener listener = (AgentChangeListener)this.agent_change_listeners.get(i5);
            EditorPlugin.DBG.info("notifying agent listener " + listener.getClass().getName());
            try {
                listener.agentAdded(agent);
            }
            catch (Throwable t) {
                EditorPlugin.DBG.logVisibleError(t, EditorPlugin.getString("ERROR_NOTIFY_ADD"), false);
            }
            ++i5;
        }
        this.updateTreeItems();
        return des;
    }

    public void updateModel(SDDescriptor model_root) {
        OpAddToTree.launch(this, model_root, null, true);
        TreeItem item = this.mapDescriptorToItem(model_root);
        if (item != null) {
            OpGarbageCollectTree.launch(this, item, null);
            this.treeItemSelected(item);
        }
        this.updateAgentImages();
        try {
            this.chooser_tree.redraw();
        }
        catch (Exception e) {}
    }

    private void addModel(SDDescriptor model_root, StatAgent statagent) {
        OpAddToTree.launch(this, model_root, null, false);
        statagent.model_roots.add(model_root);
        int i = 0;
        while (i < this.model_change_listeners.size()) {
            ModelChangeListener listener = (ModelChangeListener)this.model_change_listeners.get(i);
            listener.modelAdded(model_root);
            ++i;
        }
        this.updateAgentImages();
        try {
            this.chooser_tree.redraw();
        }
        catch (Exception e) {}
    }

    public void setAgentFile(TRCAgent trcagent, IFile ifile) {
        URI fileURI = URI.createPlatformResourceURI((String)ifile.getProjectRelativePath().toString());
        this.setAgentFile(trcagent, fileURI);
    }

    public void setAgentFile(TRCAgent trcagent, URI model_uri) {
        StatAgent statmodel = this.getStatAgent(trcagent);
        EditorPlugin.DBG.info("set agent file " + trcagent.getName() + " / " + model_uri);
        if (statmodel != null) {
            URI uri = statmodel.uri;
            if (uri != null) {
                if (!uri.equals((Object)model_uri)) {
                    this.setDirty(true);
                }
            } else if (model_uri != null) {
                this.setDirty(true);
            }
            statmodel.uri = model_uri;
        }
    }

    public void setAgentImage(TRCAgent trcagent, Image image) {
        EditorPlugin.DBG.info("set agent " + trcagent.getName() + " image");
        StatAgent agent = this.getStatAgent(trcagent);
        if (agent != null) {
            agent.image = image;
        }
        this.updateAgentImages();
    }

    private void updateAgentImages() {
        int i = 0;
        while (i < this.agents.size()) {
            TreeItem agent_item;
            StatAgent agent = (StatAgent)this.agents.get(i);
            if (agent.agent != null && (agent_item = (TreeItem)this.reverse_map.get(agent.agent)) != null) {
                if (agent.image == null) {
                    agent_item.setImage(this.img.getImage("smodel_trcagent.gif"));
                } else {
                    agent_item.setImage(agent.image);
                }
            }
            ++i;
        }
    }

    public void addModelAction(TRCAgent trcagent, String action_id, String action_name, Image image, Runnable runnable) {
        BasicAction action;
        StatAgent agent = this.getStatAgent(trcagent);
        if (agent == null) {
            agent = new StatAgent();
            agent.agent = trcagent;
            this.agents.add(agent);
        }
        if ((action = this.findAction(action_id, agent.modelactions)) == null) {
            action = new BasicAction();
            agent.modelactions.add(action);
        }
        action.id = action_id;
        action.name = action_name;
        action.image = image;
        action.runnable = runnable;
    }

    public void removeModelAction(TRCAgent trcagent, String action_id) {
        StatAgent agent = this.getStatAgent(trcagent);
        if (agent != null) {
            int i = 0;
            while (i < agent.modelactions.size()) {
                BasicAction action = (BasicAction)agent.modelactions.get(i);
                if (action.id.equals(action_id)) {
                    agent.modelactions.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    public void addAgentAction(TRCAgent trcagent, String action_id, String action_name, Image image, Runnable runnable) {
        BasicAction action;
        StatAgent agent = this.getStatAgent(trcagent);
        if (agent == null) {
            agent = new StatAgent();
            agent.agent = trcagent;
            this.agents.add(agent);
        }
        if ((action = this.findAction(action_id, agent.actions)) == null) {
            action = new BasicAction();
            agent.actions.add(action);
        }
        action.id = action_id;
        action.name = action_name;
        action.image = image;
        action.runnable = runnable;
    }

    public void removeAgentAction(TRCAgent trcagent, String action_id) {
        StatAgent agent = this.getStatAgent(trcagent);
        if (agent != null) {
            int i = 0;
            while (i < agent.actions.size()) {
                BasicAction action = (BasicAction)agent.actions.get(i);
                if (action.id.equals(action_id)) {
                    agent.actions.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    public void setDirty(boolean b) {
        if (this.dirtiable != null) {
            this.dirtiable.setDirty(b);
        }
    }

    public Color parseColor(String col, Color def) {
        try {
            if (!col.startsWith("#")) {
                throw new Exception();
            }
            if (col.length() != 7) {
                throw new Exception();
            }
            String sr = col.substring(1, 3);
            String sg = col.substring(3, 5);
            String sb = col.substring(5, 7);
            int r = Integer.parseInt(sr, 16);
            int g = Integer.parseInt(sg, 16);
            int b = Integer.parseInt(sb, 16);
            RGB rgb = XMLConfigUtil.parseColor(col, def.getRGB());
            Color c = new Color((Device)this.graph_window.getDisplay(), rgb);
            this.disposables.add(c);
            return c;
        }
        catch (Throwable e) {
            return def;
        }
    }

    public void applyConfig(InputStream config_xml) throws Exception {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int n = 0;
            while (n != -1) {
                n = config_xml.read(buf, 0, buf.length);
                if (n <= 0) continue;
                bout.write(buf, 0, n);
            }
            String xml = new String(bout.toByteArray());
            this.applyConfig(xml);
        }
        catch (Exception t) {
            EditorPlugin.DBG.warning("error applying configuration", t);
            throw t;
        }
    }

    public void applyConfig(String config_xml) throws Exception {
        try {
            ByteArrayInputStream config_stream = new ByteArrayInputStream(config_xml.getBytes());
            Document doc = XMLConfigUtil.getDocumentBuilder().parse(config_stream);
            EditorPlugin.DBG.info("applying configuration");
            this.applyConfig(doc);
            EditorPlugin.DBG.info("applying configuration to all modules");
            int i = 0;
            while (i < this.modules.size()) {
                StatConModule module = (StatConModule)this.modules.get(i);
                module.applyConfig(config_xml);
                ++i;
            }
        }
        catch (Exception t) {
            EditorPlugin.DBG.warning("error applying configuration", t);
            throw t;
        }
    }

    private void applyConfig(Document doc) throws Exception {
        try {
            int k;
            Element doc_element = doc.getDocumentElement();
            if (!doc_element.getTagName().equals("smgconfig")) {
                EditorPlugin.DBG.error("bad configuration - no valid root <smgconfig> element");
                throw new Exception(EditorPlugin.getString("BAD_ROOT_XML_NODE"));
            }
            EditorPlugin.DBG.info("loading all module data");
            ArrayList moduledats = XMLConfigUtil.getAllElements(doc_element.getChildNodes(), "module_data");
            int k2 = 0;
            while (k2 < moduledats.size()) {
                try {
                    Element mod_dat = (Element)moduledats.get(k2);
                    String ref = mod_dat.getAttribute("ref");
                    String data = mod_dat.getAttribute("data");
                    StatConModule module = (StatConModule)this.module_refs.get(ref);
                    if (module != null) {
                        module.loadModuleData(HexData.hexStringToByteArray(data));
                    } else {
                        EditorPlugin.DBG.warning("Found data for missing module " + ref);
                    }
                }
                catch (Exception e) {
                    EditorPlugin.DBG.error("Error loading data for module " + k2, e);
                }
                ++k2;
            }
            ArrayList xml_models = XMLConfigUtil.getAllElements(doc_element.getChildNodes(), "model");
            EditorPlugin.DBG.info("found " + xml_models.size() + " agent references");
            int i = 0;
            while (i < xml_models.size()) {
                try {
                    Element model = (Element)xml_models.get(i);
                    String file = model.getAttribute("file");
                    EditorPlugin.DBG.info("trying to load agent " + file);
                    Path path = new Path(file);
                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IFile ifile = workspaceRoot.getFile((IPath)path);
                    this.addAgent(ifile);
                }
                catch (Throwable t) {
                    EditorPlugin.DBG.logVisibleError(t, EditorPlugin.getString("ERROR_LOAD_CONFIG"), true);
                }
                ++i;
            }
            ArrayList graphs = XMLConfigUtil.getAllElements(doc_element.getChildNodes(), "graph");
            EditorPlugin.DBG.info("found " + graphs.size() + " graph configurations");
            int i2 = 0;
            while (i2 < graphs.size()) {
                try {
                    Element graph = (Element)graphs.get(i2);
                    if (EditorPlugin.DBG.check("configuration")) {
                        EditorPlugin.DBG.info("applying graph configuration");
                    }
                    Color color = this.parseColor(graph.getAttribute("color"), this.graph_window.getDisplay().getSystemColor(25));
                    boolean match_color = XMLConfigUtil.parseBoolean(graph.getAttribute("match_colors"), false);
                    this.graph_window.setSlidersMatchGraph(match_color);
                    this.graph_window.setGraphBackground(color);
                    ArrayList ysliders = XMLConfigUtil.getAllElements(graph.getChildNodes(), "yslider");
                    ArrayList xsliders = XMLConfigUtil.getAllElements(graph.getChildNodes(), "xslider");
                    EditorPlugin.DBG.info("X slider count of " + xsliders.size());
                    EditorPlugin.DBG.info("Y slider count of " + ysliders.size());
                    while (this.graph_window.getYSliderCount() < Math.max(1, ysliders.size())) {
                        this.graph_window.addYSlider();
                    }
                    while (this.graph_window.getXSliderCount() < Math.max(1, xsliders.size())) {
                        this.graph_window.addXSlider();
                    }
                    k = 0;
                    while (k < ysliders.size()) {
                        Element yslider = (Element)ysliders.get(k);
                        String title = yslider.getAttribute("title");
                        double min_limit = XMLConfigUtil.parseDouble(yslider.getAttribute("min_limit"), -1.0E8);
                        double max_limit = XMLConfigUtil.parseDouble(yslider.getAttribute("max_limit"), 1.0E8);
                        double min_vis = XMLConfigUtil.parseDouble(yslider.getAttribute("min_vis"), 0.0);
                        double max_vis = XMLConfigUtil.parseDouble(yslider.getAttribute("max_vis"), 5000.0);
                        double resolution = XMLConfigUtil.parseDouble(yslider.getAttribute("resolution"), 0.01);
                        boolean min_locked = XMLConfigUtil.parseBoolean(yslider.getAttribute("min_locked"), false);
                        boolean max_locked = XMLConfigUtil.parseBoolean(yslider.getAttribute("max_locked"), false);
                        EditorPlugin.DBG.info("Configuring Y slider " + k + " " + title);
                        ZoomSlider slider = this.graph_window.getYSlider(k);
                        slider.setTitle(title);
                        slider.lock(0, min_locked);
                        slider.lock(1, max_locked);
                        slider.configure(min_limit, max_limit, min_vis, max_vis, resolution);
                        ++k;
                    }
                    int k3 = 0;
                    while (k3 < xsliders.size()) {
                        Element xslider = (Element)xsliders.get(k3);
                        String title = xslider.getAttribute("title");
                        double min_limit = XMLConfigUtil.parseDouble(xslider.getAttribute("min_limit"), 0.0);
                        double max_limit = XMLConfigUtil.parseDouble(xslider.getAttribute("max_limit"), 7200000.0);
                        double min_vis = XMLConfigUtil.parseDouble(xslider.getAttribute("min_vis"), 0.0);
                        double max_vis = XMLConfigUtil.parseDouble(xslider.getAttribute("max_vis"), 180000.0);
                        double resolution = XMLConfigUtil.parseDouble(xslider.getAttribute("resolution"), 0.01);
                        boolean min_locked = XMLConfigUtil.parseBoolean(xslider.getAttribute("min_locked"), false);
                        boolean max_locked = XMLConfigUtil.parseBoolean(xslider.getAttribute("max_locked"), false);
                        boolean following = XMLConfigUtil.parseBoolean(xslider.getAttribute("following"), false);
                        EditorPlugin.DBG.info("Configuring X slider " + k3);
                        TimeZoomSlider slider = this.graph_window.getXSlider(k3);
                        slider.setTitle(title);
                        slider.lock(0, min_locked);
                        slider.lock(1, max_locked);
                        slider.configure(min_limit, max_limit, min_vis, max_vis, resolution);
                        this.graph_window.setTimeSliderFollowing(slider, following);
                        ++k3;
                    }
                }
                catch (Throwable t) {
                    EditorPlugin.DBG.logVisibleError(t, EditorPlugin.getString("ERROR_APPLY_GRAPH"), true);
                }
                ++i2;
            }
            ArrayList agent_roots = XMLConfigUtil.getAllElements(doc_element.getChildNodes(), "agent");
            EditorPlugin.DBG.info("found " + agent_roots.size() + " agent/model configurations");
            int i3 = 0;
            while (i3 < agent_roots.size()) {
                try {
                    Element agent_root = (Element)agent_roots.get(i3);
                    String rootname = agent_root.getAttribute("name");
                    boolean found = false;
                    k = 0;
                    while (k < this.agents.size()) {
                        StatAgent agent = (StatAgent)this.agents.get(k);
                        if (agent.agent != null && agent.agent.getName() != null && agent.agent.getName().equals(rootname)) {
                            EditorPlugin.DBG.info("Applying configuration to agent " + rootname + "");
                            found = true;
                            this.applyAgentConfig(agent, agent_root);
                        }
                        ++k;
                    }
                    if (!found) {
                        EditorPlugin.DBG.warning("Could not find agent " + rootname + " - unable to apply this config");
                    }
                }
                catch (Throwable t) {
                    EditorPlugin.DBG.logVisibleError(t, EditorPlugin.getString("ERROR_APPLY_MODEL"), true);
                }
                ++i3;
            }
            TreeItem[] items = this.chooser_tree.getItems();
            int i4 = 0;
            while (i4 < items.length) {
                try {
                    this.treeItemSelected(items[i4]);
                }
                catch (Throwable t) {
                    EditorPlugin.DBG.logVisibleError(t, EditorPlugin.getString("ERROR_UPDATE_MODEL"), true);
                }
                ++i4;
            }
            this.graph_window.updateTables();
        }
        catch (Exception t) {
            EditorPlugin.DBG.warning("error applying configuration", t);
            throw t;
        }
    }

    private HashMap mapChildrenByName(StatAgent agent) {
        HashMap<String, SDDescriptor> map = new HashMap<String, SDDescriptor>(128, 0.75f);
        ArrayList list = agent.model_roots;
        int i = 0;
        while (i < list.size()) {
            SDDescriptor tmp = (SDDescriptor)list.get(i);
            map.put(tmp.getName(), tmp);
            ++i;
        }
        return map;
    }

    private HashMap mapChildrenByName(TRCAgent agent) {
        HashMap<String, SDDescriptor> map = new HashMap<String, SDDescriptor>(128, 0.75f);
        EList list = agent.getDescriptor();
        int i = 0;
        while (i < list.size()) {
            SDDescriptor tmp = (SDDescriptor)list.get(i);
            map.put(tmp.getName(), tmp);
            ++i;
        }
        return map;
    }

    private HashMap mapChildrenByName(SDDescriptor descriptor) {
        HashMap<String, SDDescriptor> map = new HashMap<String, SDDescriptor>(128, 0.75f);
        EList list = descriptor.getChildren();
        int i = 0;
        while (i < list.size()) {
            SDDescriptor tmp = (SDDescriptor)list.get(i);
            map.put(tmp.getName(), tmp);
            ++i;
        }
        return map;
    }

    private void applyCBEConfig(TreeItem item, Element element, boolean parent_checked) throws Exception {
        if (element == null) {
            return;
        }
        boolean ticked = XMLConfigUtil.parseBoolean(element.getAttribute("ticked"), true);
        boolean expanded = XMLConfigUtil.parseBoolean(element.getAttribute("expanded"), false);
        item.setChecked(ticked);
        item.setExpanded(expanded);
        if (parent_checked) {
            item.setGrayed(false);
        } else {
            item.setGrayed(true);
        }
        TreeItem[] items = item.getItems();
        HashMap<String, TreeItem> item_map = new HashMap<String, TreeItem>();
        int i = 0;
        while (i < items.length) {
            item_map.put(items[i].getText(), items[i]);
            ++i;
        }
        ArrayList cbeconfigs = XMLConfigUtil.getAllElements(element.getChildNodes(), "cbelog");
        int i2 = 0;
        while (i2 < cbeconfigs.size()) {
            TreeItem subitem;
            Element config = (Element)cbeconfigs.get(i2);
            String name = config.getAttribute("name");
            if (name != null && (subitem = (TreeItem)item_map.get(name)) != null) {
                this.applyCBEConfig(subitem, config, parent_checked && ticked);
            }
            ++i2;
        }
    }

    private void applyAgentConfig(StatAgent agent, Element element) throws Exception {
        boolean sd_ticked = XMLConfigUtil.parseBoolean(element.getAttribute("ticked"), true);
        boolean sd_expanded = XMLConfigUtil.parseBoolean(element.getAttribute("expanded"), false);
        TreeItem item = (TreeItem)this.reverse_map.get(agent.agent);
        item.setChecked(sd_ticked);
        item.setExpanded(sd_expanded);
        Element cbeconfig = XMLConfigUtil.getFirstElement(element.getChildNodes(), "cbelog");
        if (cbeconfig != null) {
            this.applyCBEConfig(agent.msg_item, cbeconfig, sd_ticked);
        }
        ArrayList descriptor_roots = XMLConfigUtil.getAllElements(element.getChildNodes(), "descriptor");
        EditorPlugin.DBG.info("found " + descriptor_roots.size() + " model configurations");
        HashMap dmap = this.mapChildrenByName(agent);
        int i = 0;
        while (i < descriptor_roots.size()) {
            Element model_root = (Element)descriptor_roots.get(i);
            String rootname = model_root.getAttribute("name");
            boolean found = false;
            SDDescriptor descriptor = (SDDescriptor)dmap.get(rootname);
            if (descriptor != null) {
                if (EditorPlugin.DBG.check("configuration")) {
                    EditorPlugin.DBG.info("Applying configuration to model " + rootname);
                }
                try {
                    this.applyModelConfig(descriptor, model_root, sd_ticked);
                }
                catch (Throwable e) {
                    EditorPlugin.DBG.error("problem applying model configuration", e);
                }
            } else {
                EditorPlugin.DBG.warning("Could not find model " + rootname + " - unable to apply this model configuration");
            }
            ++i;
        }
    }

    private void applyModelConfig(SDDescriptor descriptor, Element element, boolean parent_checked) throws Exception {
        int y_slider;
        boolean sd_ticked = XMLConfigUtil.parseBoolean(element.getAttribute("ticked"), true);
        boolean sd_expanded = XMLConfigUtil.parseBoolean(element.getAttribute("expanded"), false);
        TreeItem item = (TreeItem)this.reverse_map.get(descriptor);
        item.setChecked(sd_ticked);
        item.setExpanded(sd_expanded);
        if (parent_checked) {
            item.setGrayed(false);
        } else {
            item.setGrayed(true);
        }
        ArrayList obs_graphs = XMLConfigUtil.getAllElements(element.getChildNodes(), "obs_graph");
        int i = 0;
        while (i < obs_graphs.size()) {
            Element obs_graph = (Element)obs_graphs.get(i);
            boolean ticked = XMLConfigUtil.parseBoolean(obs_graph.getAttribute("ticked"), true);
            int obs_index = (int)XMLConfigUtil.parseDouble(obs_graph.getAttribute("obs_index"), 0.0);
            int x_slider = (int)XMLConfigUtil.parseDouble(obs_graph.getAttribute("x_slider"), 0.0);
            y_slider = (int)XMLConfigUtil.parseDouble(obs_graph.getAttribute("y_slider"), 0.0);
            Color color = this.parseColor(obs_graph.getAttribute("color"), this.graph_window.getDisplay().getSystemColor(this.colours[this.next++]));
            if (this.next >= this.colours.length) {
                this.next = 0;
            }
            int line_width = (int)XMLConfigUtil.parseDouble(obs_graph.getAttribute("line_width"), 1.0);
            int line_style = XMLConfigUtil.parseLineStyle(obs_graph.getAttribute("line_style"), 1);
            double multiplier = XMLConfigUtil.parseDouble(obs_graph.getAttribute("multiplier"), 1.0);
            int plotting_type = XMLConfigUtil.parsePlottingType(obs_graph.getAttribute("plotting_type"), 0);
            int plotting_period = XMLConfigUtil.parsePlottingPeriod(obs_graph.getAttribute("plotting_period"), 0);
            double plotting_period_value = XMLConfigUtil.parseDouble(obs_graph.getAttribute("plotting_period_value"), 1.0);
            int nodata_behaviour = XMLConfigUtil.parseNoDataBehaviour(obs_graph.getAttribute("nodata_behaviour"), 1);
            double xoffset = XMLConfigUtil.parseDouble(obs_graph.getAttribute("xoffset"), 0.0);
            double yoffset = XMLConfigUtil.parseDouble(obs_graph.getAttribute("yoffset"), 0.0);
            if (EditorPlugin.DBG.check("configuration")) {
                EditorPlugin.DBG.info("Applying graph configuration for " + descriptor.getName() + " " + ticked + " " + color);
            }
            if (x_slider < 0) {
                x_slider = 0;
            }
            if (x_slider > this.graph_window.getXSliderCount()) {
                x_slider = 0;
            }
            if (y_slider < 0) {
                y_slider = 0;
            }
            if (y_slider > this.graph_window.getYSliderCount()) {
                y_slider = 0;
            }
            if (descriptor instanceof SDMemberDescriptor) {
                SDMemberDescriptor memdescriptor = (SDMemberDescriptor)descriptor;
                EList obs_list = memdescriptor.getSnapshotObservation();
                if (obs_index >= 0 && obs_index < obs_list.size()) {
                    SDSnapshotObservation observation = (SDSnapshotObservation)obs_list.get(obs_index);
                    TreeItem obs_item = (TreeItem)this.reverse_map.get(observation);
                    obs_item.setChecked(ticked);
                    obs_item.setGrayed(!sd_ticked || !parent_checked);
                    this.treeItemSelected(obs_item);
                    BasicGraphSource source = (BasicGraphSource)this.source_map.get(obs_item);
                    if (source != null) {
                        Graph graph = this.getOrCreateGraphForSource(source);
                        if (graph != null) {
                            graph.setXSlider(this.graph_window.getXSlider(x_slider));
                            graph.setYSlider(this.graph_window.getYSlider(y_slider));
                            graph.setForeground(color);
                            graph.setLineWidth(line_width);
                            graph.setLineStyle(line_style);
                            graph.setStaticScaling(multiplier);
                            graph.setPlottingType(plotting_type);
                            graph.setPlottingPeriod(plotting_period, plotting_period_value);
                            graph.setNoDataBehaviour(nodata_behaviour);
                            graph.setXOffset(xoffset);
                            graph.setYOffset(yoffset);
                        } else {
                            EditorPlugin.DBG.warning("Could not find graph - no graph found for " + obs_item.getText());
                        }
                    } else {
                        EditorPlugin.DBG.warning("Could not find graph - no graph source found for " + obs_item.getText());
                    }
                } else {
                    EditorPlugin.DBG.warning("Could not find graph - observation index out of range " + obs_index + " / " + obs_list.size());
                }
            } else {
                EditorPlugin.DBG.warning("Could not find graph - descriptor is not a member descriptor");
            }
            ++i;
        }
        ArrayList obs_controls = XMLConfigUtil.getAllElements(element.getChildNodes(), "control");
        int i2 = 0;
        while (i2 < obs_controls.size()) {
            Element obs_control = (Element)obs_controls.get(i2);
            boolean ticked = XMLConfigUtil.parseBoolean(obs_control.getAttribute("ticked"), true);
            y_slider = (int)XMLConfigUtil.parseDouble(obs_control.getAttribute("y_slider"), 0.0);
            if (EditorPlugin.DBG.check("configuration")) {
                EditorPlugin.DBG.info("Applying control configuration for " + descriptor.getName() + " (yslider:" + y_slider + ")");
            }
            if (descriptor instanceof SDMemberDescriptor) {
                SDMemberDescriptor memdescriptor = (SDMemberDescriptor)descriptor;
                SDRepresentation representation = memdescriptor.getRepresentation();
                if (representation instanceof SDModifiableVariableRepresentation) {
                    SDModifiableVariableRepresentation rep = (SDModifiableVariableRepresentation)representation;
                    try {
                        TreeItem rep_item = (TreeItem)this.reverse_map.get(rep);
                        rep_item.setChecked(ticked);
                        rep_item.setGrayed(!sd_ticked || !parent_checked);
                        if (y_slider >= 0 && y_slider < this.graph_window.getYSliderCount()) {
                            this.bar_slider_map.put(rep_item, this.graph_window.getYSlider(y_slider));
                        }
                        this.treeItemSelected(rep_item);
                        ModifiableVariableBar bar = (ModifiableVariableBar)this.bar_map.get(rep_item);
                        if (bar != null) {
                            if (bar.bar != null) {
                                this.graph_window.barMoved(bar.bar, y_slider);
                            }
                        } else {
                            EditorPlugin.DBG.warning("Could not find bar for representation " + rep_item.getText());
                        }
                        if (y_slider >= 0 && y_slider < this.graph_window.getYSliderCount()) {
                            this.bar_slider_map.put(rep_item, this.graph_window.getYSlider(y_slider));
                        }
                    }
                    catch (NullPointerException e) {
                        EditorPlugin.DBG.warning("Could not find rep item", e);
                    }
                } else {
                    EditorPlugin.DBG.warning("Could not find control - representation is not a modifiable variable representation");
                }
            } else {
                EditorPlugin.DBG.warning("Could not find control - descriptor is not a member descriptor");
            }
            ++i2;
        }
        ArrayList descriptor_children = XMLConfigUtil.getAllElements(element.getChildNodes(), "descriptor");
        HashMap dmap = this.mapChildrenByName(descriptor);
        int i3 = 0;
        while (i3 < descriptor_children.size()) {
            Element child = (Element)descriptor_children.get(i3);
            String childname = child.getAttribute("name");
            SDDescriptor child_descriptor = (SDDescriptor)dmap.get(childname);
            if (child_descriptor != null) {
                if (EditorPlugin.DBG.check("configuration")) {
                    EditorPlugin.DBG.info("Applying configuration to descriptor " + childname);
                }
                this.applyModelConfig(child_descriptor, child, sd_ticked && parent_checked);
            } else {
                EditorPlugin.DBG.warning("Could not find descriptor - descriptor of name " + childname + " was not found under descriptor " + descriptor.getName());
            }
            ++i3;
        }
    }

    public String generateConfig() {
        return this.generateConfig("");
    }

    public String generateConfig(String extra_xml) {
        StringBuffer xml = new StringBuffer();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<!-- Statistical Model Graph Viewer configuration file -->\n");
        xml.append("<!-- Not intended to be human editable - edit at your own risk -->\n");
        xml.append("<smgconfig>\n");
        xml.append(extra_xml);
        int i = 0;
        while (i < this.modules.size()) {
            StatConModule module = (StatConModule)this.modules.get(i);
            String moduleref = module.getModuleRef();
            try {
                byte[] moduledat = module.saveModuleData();
                String hex = HexData.byteArrayToHexString(moduledat);
                xml.append("<module_data ref=\"" + moduleref + "\" data=\"" + hex + "\" />\n");
            }
            catch (Exception e) {
                EditorPlugin.DBG.logVisibleError(e, EditorPlugin.getString("ERROR_SAVING_MODULE") + " " + moduleref, false);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.agents.size()) {
            StatAgent agent = (StatAgent)this.agents.get(i2);
            URI uri = agent.uri;
            if (uri != null) {
                xml.append("<model file=\"").append(uri).append("\" />\n");
            }
            ++i2;
        }
        xml.append("<graph color=\"").append(XMLConfigUtil.colorToString(this.graph_window.getGraphBackground())).append("\" match_colors=\"").append(this.graph_window.getSlidersMatchGraph()).append("\" >\n");
        int i3 = 0;
        while (i3 < this.graph_window.getYSliderCount()) {
            ZoomSlider slider = this.graph_window.getYSlider(i3);
            xml.append("  <yslider ");
            xml.append("title=\"").append(slider.getTitle()).append("\" ");
            xml.append("min_limit=\"").append(slider.getMinLimit()).append("\" ");
            xml.append("max_limit=\"").append(slider.getMaxLimit()).append("\" ");
            xml.append("min_vis=\"").append(slider.getMinVisible()).append("\" ");
            xml.append("max_vis=\"").append(slider.getMaxVisible()).append("\" ");
            xml.append("resolution=\"").append(slider.getResolution()).append("\" ");
            xml.append("min_locked=\"").append(slider.isLocked(0)).append("\" ");
            xml.append("max_locked=\"").append(slider.isLocked(1)).append("\" ");
            xml.append("/>\n");
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.graph_window.getXSliderCount()) {
            TimeZoomSlider slider = this.graph_window.getXSlider(i4);
            xml.append("  <xslider ");
            xml.append("title=\"").append(slider.getTitle()).append("\" ");
            xml.append("min_limit=\"").append(slider.getMinLimit()).append("\" ");
            xml.append("max_limit=\"").append(slider.getMaxLimit()).append("\" ");
            xml.append("min_vis=\"").append(slider.getMinVisible()).append("\" ");
            xml.append("max_vis=\"").append(slider.getMaxVisible()).append("\" ");
            xml.append("resolution=\"").append(slider.getResolution()).append("\" ");
            xml.append("min_locked=\"").append(slider.isLocked(0)).append("\" ");
            xml.append("max_locked=\"").append(slider.isLocked(1)).append("\" ");
            xml.append("following=\"").append(this.graph_window.getTimeSliderFollowing(slider)).append("\" ");
            xml.append("/>\n");
            ++i4;
        }
        xml.append("</graph>\n");
        int i5 = 0;
        while (i5 < this.agents.size()) {
            StatAgent agent = (StatAgent)this.agents.get(i5);
            this.generateConfig(xml, agent, 0);
            ++i5;
        }
        xml.append("</smgconfig>\n");
        return xml.toString();
    }

    public String generateConfig(TRCAgent agent) {
        StringBuffer sb = new StringBuffer();
        StatAgent statagent = this.getStatAgent(agent);
        this.generateConfig(sb, statagent, 0);
        return sb.toString();
    }

    private void generateConfig(StringBuffer xml, StatAgent agent, int depth) {
        TreeItem agent_item = (TreeItem)this.reverse_map.get(agent.agent);
        if (agent_item == null) {
            return;
        }
        xml.append("<agent ");
        xml.append("name=\"").append(agent.agent.getName()).append("\" ");
        xml.append("ticked=\"").append(agent_item.getChecked()).append("\" ");
        xml.append("expanded=\"").append(agent_item.getExpanded()).append("\" ");
        xml.append(">\n");
        OpGenerateTreeConfig.launch(this, agent.msg_item, agent.msg_item, xml, "cbelog", depth + 1);
        int m = 0;
        while (m < agent.model_roots.size()) {
            SDDescriptor root = (SDDescriptor)agent.model_roots.get(m);
            OpGenerateDescriptorConfig.launch(this, root, root, xml, depth + 1);
            ++m;
        }
        xml.append("</agent>");
    }

    public String generateConfig(SDDescriptor model_root) {
        try {
            StringBuffer sb = new StringBuffer();
            EditorPlugin.DBG.info("generating StatCon configuration");
            OpGenerateDescriptorConfig.launch(this, model_root, model_root, sb, 1);
            return sb.toString();
        }
        catch (Throwable e) {
            EditorPlugin.DBG.error("problem generating StatCon configuration", e);
            return null;
        }
    }

    public GraphWindow getGraphWindow() {
        return this.graph_window;
    }

    public void setConstantUpdate(String request_id, boolean request_on, long ms_refresh) {
        Boolean val = new Boolean(request_on);
        this.updates.put(request_id, val);
        boolean on = false;
        Iterator requests = this.updates.values().iterator();
        while (requests.hasNext()) {
            Boolean b = (Boolean)requests.next();
            if (!b.booleanValue()) continue;
            on = true;
            break;
        }
        if (request_on) {
            this.graph_window.setConstantUpdate(on, ms_refresh);
        } else {
            this.graph_window.setConstantUpdate(on);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    public void dispose() {
        int a = 0;
        while (a < this.agents.size()) {
            StatAgent sagent = (StatAgent)this.agents.get(a);
            TRCAgent agent = sagent.agent;
            EList models = agent.getDescriptor();
            int m = 0;
            while (m < models.size()) {
                SDDescriptor model_root = (SDDescriptor)models.get(m);
                int i = 0;
                while (i < this.model_change_listeners.size()) {
                    ModelChangeListener listener = (ModelChangeListener)this.model_change_listeners.get(i);
                    try {
                        listener.modelRemoved(model_root);
                    }
                    catch (Throwable e) {
                        EditorPlugin.DBG.warning("failed to notify model listener " + listener + " of model remove (dispose)");
                    }
                    ++i;
                }
                ++m;
            }
            int i = 0;
            while (i < this.agent_change_listeners.size()) {
                AgentChangeListener listener = (AgentChangeListener)this.agent_change_listeners.get(i);
                try {
                    EditorPlugin.DBG.info("notifying agent listener " + listener.getClass().getName() + " of agent remove (dispose)");
                    listener.agentRemoved(agent);
                }
                catch (Throwable e) {
                    EditorPlugin.DBG.warning("failed to notify agent listener " + listener + " of agent remove (dispose)");
                }
                ++i;
            }
            ++a;
        }
        int i = 0;
        while (i < this.alerts.size()) {
            try {
                Alert alert = (Alert)this.alerts.get(i);
                alert.shutdown();
            }
            catch (Exception e) {
                EditorPlugin.DBG.warning("failed to shut down alert");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.disposables.size()) {
            try {
                Object o = this.disposables.get(i2);
                if (o != null) {
                    if (o instanceof Widget) {
                        ((Widget)o).dispose();
                    } else if (o instanceof Color) {
                        ((Color)o).dispose();
                    } else if (o instanceof Image) {
                        ((Image)o).dispose();
                    } else {
                        try {
                            EditorPlugin.disposeObject(o);
                        }
                        catch (Throwable e) {
                            EditorPlugin.DBG.warning("dispose object failed ", e);
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++i2;
        }
    }

    private void initCommonActions() {
        this.addDynamicAction("statcon.sliders", "SNAP_ALL_XOFFSETS", EditorPlugin.getString("SNAP_ALL_XOFFSETS"), new SnapAllOffsetsDAction());
        this.addDynamicAction("statcon.counter", "JUMP_TO_TABLE_GRAPH", EditorPlugin.getString("JUMP_TO_TABLE_GRAPH"), new JumpToGraphTableDAction());
        this.addDynamicAction("statcon.counter", "JUMP_TO_TABLE_CONTROLS", EditorPlugin.getString("JUMP_TO_TABLE_CONTROLS"), new JumpToControlTableDAction());
        this.addDynamicAction("statcon.edit", "AGENT_REFRESH", EditorPlugin.getString("AGENT_REFRESH"), new AgentRefreshDAction());
        this.addDynamicAction("statcon.edit", "AGENT_SAVE", EditorPlugin.getString("AGENT_SAVE"), new AgentSaveDAction());
        this.addDynamicAction("statcon.edit", "AGENT_REMOVE", EditorPlugin.getString("AGENT_REMOVE"), new AgentRemoveDAction());
        this.addDynamicAction("statcon.edit", "ADD_METRIC_MONITOR", EditorPlugin.getString("ADD_METRIC_MONITOR"), new AddAlertDAction());
        this.addDynamicAction("statcon.edit", "MERGE_OBSERVATIONS", EditorPlugin.getString("MERGE_OBSERVATIONS"), new ObservationMergeDAction());
    }

    private void initAsSash(Composite parent) {
        this.sashfolder = new SashForm(parent, 0);
        this.sashfolder.setOrientation(256);
        WorkbenchHelp.setHelp((Control)parent, (String)(EditorPlugin.getDefault().getInfopopsId() + ".statcon_anywhere"));
        this.leftsash = new Group((Composite)this.sashfolder, 0);
        this.rightsash = new Composite((Composite)this.sashfolder, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.leftsash.setLayout((Layout)layout);
        this.rightsash.setLayout((Layout)new FillLayout());
        parent.addDisposeListener((DisposeListener)this);
        this.img = EditorPlugin.img;
        this.initChooser(this.leftsash);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.chooser_tree.setLayoutData((Object)data);
        this.initAggregateGraph(this.rightsash);
        this.sashfolder.setWeights(new int[]{30, 70});
        this.disposables.add(this.sashfolder);
        this.disposables.add(this.leftsash);
        this.disposables.add(this.rightsash);
    }

    private void initChooser(Composite parent) {
        this.chooser_tree = new Tree(parent, 34);
        WorkbenchHelp.setHelp((Control)parent, (String)(EditorPlugin.getDefault().getInfopopsId() + ".statcon_anywhere"));
        WorkbenchHelp.setHelp((Control)this.chooser_tree, (String)(EditorPlugin.getDefault().getInfopopsId() + ".statcon_anywhere"));
        this.disposables.add(this.chooser_tree);
        this.chooser_menu = new Menu((Control)this.chooser_tree);
        this.chooser_add = new MenuItem(this.chooser_menu, 0);
        this.chooser_add.setText(EditorPlugin.getString("ADD_NEW_TRACE"));
        this.chooser_add.setImage(this.img.getImage("smodel_trcagent.gif"));
        this.disposables.add(this.chooser_menu);
        this.disposables.add(this.chooser_add);
        this.chooser_tree.addMouseListener((MouseListener)this);
        this.chooser_add.addSelectionListener((SelectionListener)this);
        this.chooser_tree.addSelectionListener((SelectionListener)this);
        DropTarget target = new DropTarget((Control)this.chooser_tree, 7);
        target.addDropListener((DropTargetListener)this);
        Transfer[] types = new Transfer[]{ResourceTransfer.getInstance()};
        target.setTransfer(types);
        int i = 0;
        while (i < this.agents.size()) {
            StatAgent agent = (StatAgent)this.agents.get(i);
            int m = 0;
            while (m < agent.model_roots.size()) {
                SDDescriptor sdroot = (SDDescriptor)agent.model_roots.get(m);
                OpAddToTree.launch(this, sdroot, null, false);
                ++m;
            }
            ++i;
        }
        this.updateAgentImages();
    }

    private void updateTreeItems() {
        TreeItem[] items = this.chooser_tree.getItems();
        int i = 0;
        while (i < items.length) {
            this.treeItemSelected(items[i]);
            ++i;
        }
    }

    public void applyStatConModelOp(StatConModelOp op, StatConOpState state, SDDescriptor start, SDDescriptor root) {
        boolean parents_checked = true;
        boolean parents_grayed = false;
        TreeItem parent = this.mapDescriptorToItem(start.getParent());
        while (parent != null) {
            if (!parent.getChecked()) {
                parents_checked = false;
            }
            if (parent.getGrayed()) {
                parents_grayed = true;
            }
            if (!parents_checked && parents_grayed || parent == root) break;
            parent = parent.getParentItem();
        }
        this.rapplyStatConOp(op, class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp == null ? (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp = StatisticalModelGraphViewer.class$("org.eclipse.hyades.statistical.ui.editor.internal.StatConModelOp")) : class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp, state, start, root, parents_checked, parents_grayed);
    }

    public void applyStatConTreeOp(StatConTreeOp op, StatConOpState state, TreeItem start, TreeItem root) {
        boolean parents_checked = true;
        boolean parents_grayed = false;
        TreeItem parent = start.getParentItem();
        while (parent != null) {
            if (!parent.getChecked()) {
                parents_checked = false;
            }
            if (parent.getGrayed()) {
                parents_grayed = true;
            }
            if (!parents_checked && parents_grayed || parent == root) break;
            parent = parent.getParentItem();
        }
        this.rapplyStatConOp(op, class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp == null ? (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp = StatisticalModelGraphViewer.class$("org.eclipse.hyades.statistical.ui.editor.internal.StatConTreeOp")) : class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp, state, start, root, parents_checked, parents_grayed);
    }

    private void rapplyStatConOp(StatConOp op, Class opclass, StatConOpState current_state, Object current, Object root, boolean parents_checked, boolean parents_grayed) {
        EList children;
        StatConOpState state = current_state;
        if (opclass == (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp == null ? (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp = StatisticalModelGraphViewer.class$("org.eclipse.hyades.statistical.ui.editor.internal.StatConTreeOp")) : class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp)) {
            state = ((StatConTreeOp)op).preapply(current_state, this, (TreeItem)current, (TreeItem)root, parents_checked, parents_grayed);
        } else if (opclass == (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp == null ? (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp = StatisticalModelGraphViewer.class$("org.eclipse.hyades.statistical.ui.editor.internal.StatConModelOp")) : class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp)) {
            state = ((StatConModelOp)op).preapply(current_state, this, (SDDescriptor)current, (SDDescriptor)root, parents_checked, parents_grayed);
        }
        if (state == null) {
            return;
        }
        TreeItem current_item = null;
        boolean cparents_checked = parents_checked;
        boolean cparents_grayed = parents_grayed;
        if (opclass == (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp == null ? (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp = StatisticalModelGraphViewer.class$("org.eclipse.hyades.statistical.ui.editor.internal.StatConTreeOp")) : class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp)) {
            current_item = (TreeItem)current;
        } else if (opclass == (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp == null ? (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp = StatisticalModelGraphViewer.class$("org.eclipse.hyades.statistical.ui.editor.internal.StatConModelOp")) : class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp)) {
            SDDescriptor current_des = (SDDescriptor)current;
            current_item = this.mapDescriptorToItem(current_des);
        } else {
            throw new ClassCastException("Unknown recursive op object type " + opclass);
        }
        if (current_item == null) {
            return;
        }
        if (!current_item.isDisposed()) {
            if (!current_item.getChecked()) {
                cparents_checked = false;
            }
            if (current_item.getGrayed()) {
                cparents_grayed = true;
            }
        }
        if (opclass == (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp == null ? (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp = StatisticalModelGraphViewer.class$("org.eclipse.hyades.statistical.ui.editor.internal.StatConTreeOp")) : class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp)) {
            children = ((TreeItem)current).getItems();
            if (children != null) {
                int i = 0;
                while (i < ((EList)children).length) {
                    this.rapplyStatConOp(op, opclass, state, children[i], root, cparents_checked, cparents_grayed);
                    ++i;
                }
            }
        } else if (opclass == (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp == null ? (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp = StatisticalModelGraphViewer.class$("org.eclipse.hyades.statistical.ui.editor.internal.StatConModelOp")) : class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp) && (children = ((SDDescriptor)current).getChildren()) != null) {
            int i = 0;
            while (i < children.size()) {
                this.rapplyStatConOp(op, opclass, state, (SDDescriptor)children.get(i), root, cparents_checked, cparents_grayed);
                ++i;
            }
        }
        if (opclass == (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp == null ? (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp = StatisticalModelGraphViewer.class$("org.eclipse.hyades.statistical.ui.editor.internal.StatConTreeOp")) : class$org$eclipse$hyades$statistical$ui$editor$internal$StatConTreeOp)) {
            ((StatConTreeOp)op).postapply(current_state, this, (TreeItem)current, (TreeItem)root, parents_checked, parents_grayed);
        } else if (opclass == (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp == null ? (class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp = StatisticalModelGraphViewer.class$("org.eclipse.hyades.statistical.ui.editor.internal.StatConModelOp")) : class$org$eclipse$hyades$statistical$ui$editor$internal$StatConModelOp)) {
            ((StatConModelOp)op).postapply(current_state, this, (SDDescriptor)current, (SDDescriptor)root, parents_checked, parents_grayed);
        }
    }

    public SDDescriptor mapItemToDescriptor(TreeItem item) {
        return (SDDescriptor)this.sddescriptor_map.get(item);
    }

    public void mapItemToDescriptor(TreeItem item, SDDescriptor descriptor) {
        this.sddescriptor_map.put(item, descriptor);
    }

    public TreeItem mapAgentToItem(TRCAgent agent) {
        return (TreeItem)this.reverse_map.get(agent);
    }

    public TreeItem mapDescriptorToItem(SDDescriptor descriptor) {
        return (TreeItem)this.reverse_map.get(descriptor);
    }

    public void mapDescriptorToItem(SDDescriptor descriptor, TreeItem item) {
        this.reverse_map.put(descriptor, item);
        this.sddescriptor_map.put(item, descriptor);
    }

    public SDSnapshotObservation mapItemToObservation(TreeItem item) {
        return (SDSnapshotObservation)this.counter_map.get(item);
    }

    public TreeItem mapObservationToItem(SDSnapshotObservation obs) {
        return (TreeItem)this.reverse_map.get(obs);
    }

    public void mapObservationToItem(SDSnapshotObservation o, TreeItem obs_item) {
        this.counter_map.put(obs_item, o);
        this.reverse_map.put(o, obs_item);
        this.sddescriptor_map.put(obs_item, o.getMemberDescriptor());
    }

    public SDRepresentation mapItemToRepresentation(TreeItem item) {
        return (SDRepresentation)this.modifiable_map.get(item);
    }

    public TreeItem mapRepresentationToItem(SDRepresentation rep) {
        return (TreeItem)this.reverse_map.get(rep);
    }

    public void mapRepresentationToItem(SDRepresentation rep, TreeItem rep_item) {
        this.modifiable_map.put(rep_item, rep);
        this.reverse_map.put(rep, rep_item);
        this.sddescriptor_map.put(rep_item, rep.getMemberDescriptor());
    }

    public ZoomSlider mapItemToSlider(TreeItem item) {
        return (ZoomSlider)((Object)this.bar_slider_map.get(item));
    }

    public BasicGraphSource mapItemToGraphSource(TreeItem item) {
        return (BasicGraphSource)this.source_map.get(item);
    }

    public Graph mapSourceToGraph(BasicGraphSource source) {
        return (Graph)this.source_graph_map.get(source);
    }

    public Tree getTree() {
        return this.chooser_tree;
    }

    private void selectTreePath(TreeItem leaf) {
        TreeItem tmp = leaf;
        ArrayList<TreeItem> list = new ArrayList<TreeItem>();
        while (tmp != null) {
            if (!tmp.getExpanded()) {
                list.clear();
            }
            list.add(tmp);
            tmp = tmp.getParentItem();
        }
        TreeItem[] sel = new TreeItem[list.size()];
        list.toArray(sel);
        this.chooser_tree.setSelection(sel);
    }

    public void controlSelected(SDRepresentation rep) {
        TreeItem tmp = this.mapRepresentationToItem(rep);
        this.selectTreePath(tmp);
    }

    public void graphSelected(Graph g) {
        TreeItem tmp = (TreeItem)this.rgraph_map.get(g);
        this.selectTreePath(tmp);
    }

    public void alertSelected(Alert a) {
        TreeItem tmp = (TreeItem)this.reverse_map.get(a.observation);
        this.selectTreePath(tmp);
    }

    public void alertDeleted(Alert a) {
        this.alerts.remove(a);
        a.shutdown();
        this.getGraphWindow().setAlerts(this.alerts.toArray());
    }

    public void initAggregateGraph(Composite parent) {
        this.graph_window = new GraphWindow(parent, 0, this.dirtiable);
        this.graph_window.addUpdateRunnable(new CBEUpdate());
        this.graph_window.addGraphWindowListener(this);
        this.disposables.add(this.graph_window);
    }

    public Control initTestGraph(Composite parent) {
        Color black = parent.getShell().getDisplay().getSystemColor(2);
        Color cyan = parent.getShell().getDisplay().getSystemColor(13);
        Color magenta = parent.getShell().getDisplay().getSystemColor(11);
        GraphWindow window = new GraphWindow(parent, 0);
        this.disposables.add(window);
        window.addXSlider();
        window.addYSlider();
        TestGraphSource sine_source = new TestGraphSource(-1000000.0, 1000000.0, 0);
        LineGraph sine_line = new LineGraph(0, sine_source, window.getXSlider(0), window.getYSlider(0), cyan);
        sine_line.setLineWidth(2);
        TestGraphSource cosine_source = new TestGraphSource(-1000000.0, 1000000.0, 1);
        HistogramGraph cosine_line = new HistogramGraph(cosine_source, window.getXSlider(1), window.getYSlider(1), magenta);
        cosine_line.setLineWidth(2);
        this.graph_window.addGraph("Test Sine", "A test sine wave graph", sine_line, null);
        this.graph_window.addGraph("Test Cosine", "A test cosine wave graph", cosine_line, null);
        return window;
    }

    public SDDescriptor getSelectedDescriptor() {
        return this.selected_descriptor;
    }

    public void setDescriptorImage(SDDescriptor descriptor, Image image) {
        TreeItem item = (TreeItem)this.reverse_map.get(descriptor);
        if (item == null) {
            return;
        }
        item.setImage(image);
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragLeave(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = 1;
    }

    public void dropAccept(DropTargetEvent event) {
        event.detail = 1;
    }

    public void drop(DropTargetEvent event) {
        event.detail = 1;
        if (event.data == null) {
            event.detail = 0;
            return;
        }
        StringBuffer errors = new StringBuffer();
        try {
            IResource[] resources = (IResource[])event.data;
            int i = 0;
            while (i < resources.length) {
                String path = resources[i].getFullPath().toString();
                String extension = path.substring(path.lastIndexOf(".") + 1);
                EditorPlugin.DBG.info("got dragged resource " + path);
                if (extension.equalsIgnoreCase("trcmxmi") || extension.equalsIgnoreCase("trcnxmi") || extension.equalsIgnoreCase("trcpxmi") || extension.equalsIgnoreCase("trcaxmi")) {
                    try {
                        this.addAgent(resources[i].getFullPath());
                        this.setDirty(true);
                    }
                    catch (Throwable e) {
                        errors.append(EditorPlugin.getString("INVALID_TRACE_FILE") + ":" + resources[i].getFullPath() + "\n");
                        EditorPlugin.DBG.warning("bad trace/model file drop ", e);
                    }
                } else {
                    try {
                        boolean accepted = false;
                        int k = 0;
                        while (k < this.drop_listeners.size()) {
                            DropListener drop = (DropListener)this.drop_listeners.get(k);
                            if (drop.extension.equalsIgnoreCase(extension) && drop.listener.drop(this, resources[i])) {
                                accepted = true;
                            }
                            ++k;
                        }
                        if (!accepted) {
                            event.detail = 0;
                            throw new Exception(EditorPlugin.getString("NO_MODULE_ACCEPTED_DROP"));
                        }
                    }
                    catch (Throwable e) {
                        String msg = e.getMessage();
                        if (msg == null) {
                            msg = "";
                        }
                        if (msg.length() > 0) {
                            errors.append(EditorPlugin.getString("INVALID_FILE") + ":" + resources[i].getFullPath() + " (" + e.getMessage() + ")\n");
                        } else {
                            errors.append(EditorPlugin.getString("INVALID_FILE") + ":" + resources[i].getFullPath() + " (no further information)\n");
                        }
                        EditorPlugin.DBG.warning("bad module file drop " + resources[i].getFullPath(), e);
                    }
                }
                ++i;
            }
        }
        catch (Throwable e) {
            errors.append(EditorPlugin.getString("INVALID_FILE_DROP") + ":" + e + "\n");
            EditorPlugin.DBG.error("bad file drop", e);
            event.detail = 0;
            return;
        }
        if (errors.length() > 0) {
            MessageBox mbox = new MessageBox(this.graph_window.getShell(), 40);
            mbox.setText(EditorPlugin.getString("INVALID_FILE_DROP_TITLE"));
            mbox.setMessage(errors.toString());
            mbox.open();
        }
    }

    private EObject getRelation(TreeItem item) {
        EObject relation = (EObject)this.trcagent_map.get(item);
        if (relation == null) {
            relation = (EObject)this.sddescriptor_map.get(item);
        }
        if (relation == null) {
            relation = (EObject)this.counter_map.get(item);
        }
        if (relation == null) {
            relation = (EObject)this.modifiable_map.get(item);
        }
        return relation;
    }

    public void mouseDoubleClick(MouseEvent e) {
        Point pt = new Point(e.x, e.y);
        TreeItem item = this.chooser_tree.getItem(pt);
        EObject relation = this.getRelation(item);
        int i = 0;
        while (i < this.click_listeners.size()) {
            ClickListener listener = (ClickListener)this.click_listeners.get(i);
            listener.doubleClick(this, item, relation, e.button);
            ++i;
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        BasicAction action;
        Point pt = new Point(e.x, e.y);
        TreeItem item = this.chooser_tree.getItem(pt);
        TreeItem[] sel_items = this.chooser_tree.getSelection();
        ArrayList subactions = new ArrayList();
        ArrayList<BasicAction> slideractions = new ArrayList<BasicAction>();
        if (sel_items.length <= 1) {
            boolean toplevel = false;
            if (item != null) {
                TRCAgent trcagent = (TRCAgent)this.trcagent_map.get(item);
                StatAgent agent = this.getStatAgent(trcagent);
                if (agent != null) {
                    subactions = agent.actions;
                } else {
                    int k = 0;
                    while (k < this.root_nodes.size()) {
                        RootNode node = (RootNode)this.root_nodes.get(k);
                        if (node.item == item) {
                            subactions = node.actions;
                            toplevel = true;
                        }
                        ++k;
                    }
                }
            }
            if (item != null && !toplevel) {
                int i = 0;
                while (i < this.graph_window.getYSliderCount()) {
                    ZoomSlider slider = this.graph_window.getYSlider(i);
                    BasicAction action2 = new BasicAction();
                    action2.name = EditorPlugin.getString("SET_ALL_VERTICAL_TO") + " " + slider.getTitle();
                    action2.image = this.img.getImage("slider_v.gif");
                    action2.runnable = new SetSliderAction(false, slider, item);
                    slideractions.add(action2);
                    ++i;
                }
                int i2 = 0;
                while (i2 < this.graph_window.getXSliderCount()) {
                    TimeZoomSlider slider = this.graph_window.getXSlider(i2);
                    BasicAction action3 = new BasicAction();
                    action3.name = EditorPlugin.getString("SET_ALL_HORIZONTAL_TO") + " " + slider.getTitle();
                    action3.image = this.img.getImage("slider_h.gif");
                    action3.runnable = new SetSliderAction(true, slider, item);
                    slideractions.add(action3);
                    ++i2;
                }
            }
            if (item != null) {
                SDDescriptor descriptor;
                this.selected_descriptor = descriptor = (SDDescriptor)this.sddescriptor_map.get(item);
                if (descriptor != null) {
                    while (descriptor.getParent() != null) {
                        descriptor = descriptor.getParent();
                    }
                    int z = 0;
                    while (z < this.agents.size()) {
                        StatAgent node = (StatAgent)this.agents.get(z);
                        if (node.model_roots.contains(descriptor)) {
                            subactions.addAll(node.modelactions);
                            break;
                        }
                        ++z;
                    }
                }
            }
        }
        if (this.chooser_disposables != null) {
            int i = 0;
            while (i < this.chooser_disposables.size()) {
                MenuItem mitem = (MenuItem)this.chooser_disposables.get(i);
                mitem.dispose();
                ++i;
            }
        }
        this.chooser_disposables = new ArrayList();
        if (subactions.size() > 0) {
            MenuItem sep = new MenuItem(this.chooser_menu, 2);
            this.chooser_disposables.add(sep);
            int k = 0;
            while (k < subactions.size()) {
                action = (BasicAction)subactions.get(k);
                action.menuitem = new MenuItem(this.chooser_menu, 0);
                action.menuitem.setText(action.name);
                action.menuitem.setImage(action.image);
                action.menuitem.addSelectionListener((SelectionListener)action);
                this.chooser_disposables.add(action.menuitem);
                ++k;
            }
        }
        if (slideractions.size() > 0) {
            MenuItem sep = new MenuItem(this.chooser_menu, 2);
            this.chooser_disposables.add(sep);
            int k = 0;
            while (k < slideractions.size()) {
                action = (BasicAction)slideractions.get(k);
                action.menuitem = new MenuItem(this.chooser_menu, 0);
                action.menuitem.setText(action.name);
                action.menuitem.setImage(action.image);
                action.menuitem.addSelectionListener((SelectionListener)action);
                this.chooser_disposables.add(action.menuitem);
                ++k;
            }
        }
        EObject[] sel_relations = new EObject[sel_items.length];
        int k = 0;
        while (k < sel_items.length) {
            sel_relations[k] = this.getRelation(sel_items[k]);
            ++k;
        }
        Collections.sort(this.dynamic_actions, new DyanmicActionComparator());
        String prev_group = null;
        boolean not_empty = false;
        int k2 = 0;
        while (k2 < this.dynamic_actions.size()) {
            DynamicAction daction = (DynamicAction)this.dynamic_actions.get(k2);
            try {
                if (daction.canAppear(this, sel_items, sel_relations)) {
                    MenuItem sep;
                    if (prev_group == null) {
                        sep = new MenuItem(this.chooser_menu, 2);
                        this.chooser_disposables.add(sep);
                    } else if (!prev_group.equals(daction.group) && not_empty) {
                        sep = new MenuItem(this.chooser_menu, 2);
                        this.chooser_disposables.add(sep);
                        not_empty = false;
                    }
                    prev_group = daction.group;
                    DynamicActionWrapper action4 = new DynamicActionWrapper();
                    action4.action = daction;
                    action4.items = sel_items;
                    action4.objects = sel_relations;
                    action4.menuitem = new MenuItem(this.chooser_menu, 0);
                    action4.menuitem.setText(daction.name);
                    action4.menuitem.setImage(daction.getImage());
                    action4.menuitem.addSelectionListener((SelectionListener)action4);
                    this.chooser_disposables.add(action4.menuitem);
                    not_empty = true;
                }
            }
            catch (Throwable t) {
                EditorPlugin.DBG.error("error in dynamic action canAppear method", t);
            }
            ++k2;
        }
        if (e.button > 1) {
            this.chooser_menu.setVisible(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        this.widgetSelected(e.item, o);
    }

    public void widgetSelected(Widget widget, Object o) {
        if (o == this.chooser_tree) {
            if (widget == null) {
                return;
            }
            if (widget instanceof TreeItem) {
                TreeItem item = (TreeItem)widget;
                boolean checked = item.getChecked();
                this.treeItemSelected(item);
            }
        } else if (o == this.chooser_add) {
            EditorPlugin.DBG.info("add agent file - opening ResourceSelectionDialog");
            ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.graph_window.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), EditorPlugin.getString("CHOOSE_STATISTICAL_MODEL"));
            dialog.open();
            Object[] results = dialog.getResult();
            if (results != null) {
                int i = 0;
                while (i < results.length) {
                    EditorPlugin.DBG.info("" + results[i].getClass());
                    if (results[i] instanceof IFile) {
                        try {
                            IFile file = (IFile)results[i];
                            EditorPlugin.DBG.info("trying to add " + file);
                            this.addAgent(file.getFullPath());
                            this.setDirty(true);
                            this.chooser_tree.redraw();
                        }
                        catch (Throwable x) {
                            EditorPlugin.DBG.error("model add failed", x);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public void removeAgent(TRCAgent agent) {
        StatAgent statagent = this.getStatAgent(agent);
        this.agents.remove(statagent);
        if (statagent == null) {
            EditorPlugin.DBG.warning("remove agent found no agent (out of " + this.agents.size() + ")");
            return;
        }
        int i = 0;
        while (i < this.agent_change_listeners.size()) {
            AgentChangeListener listener = (AgentChangeListener)this.agent_change_listeners.get(i);
            listener.agentRemoved(agent);
            ++i;
        }
        int m = 0;
        while (m < statagent.model_roots.size()) {
            SDDescriptor model_root = (SDDescriptor)statagent.model_roots.get(m);
            int i2 = 0;
            while (i2 < this.model_change_listeners.size()) {
                ModelChangeListener listener = (ModelChangeListener)this.model_change_listeners.get(i2);
                listener.modelRemoved(model_root);
                ++i2;
            }
            ++m;
        }
        TreeItem item = (TreeItem)this.reverse_map.get(agent);
        if (item != null) {
            OpFreeSubTree.launch(this, item, item);
        } else {
            EditorPlugin.DBG.warning("remove agent found null tree item for agent");
        }
        this.graph_window.updateTables();
        if (item != null) {
            item.dispose();
            this.disposables.remove(item);
        }
        this.setDirty(true);
        EditorPlugin.DBG.info("Reverse Map Items = " + this.reverse_map.values().size());
        EditorPlugin.DBG.info("SDDescriptor Map Items = " + this.sddescriptor_map.values().size());
        EditorPlugin.DBG.info("Counter Map Items = " + this.counter_map.values().size());
        EditorPlugin.DBG.info("Modifiable Map Items = " + this.modifiable_map.values().size());
        EditorPlugin.DBG.info("Reverse Graph Map Items = " + this.rgraph_map.values().size());
        EditorPlugin.DBG.info("Graph Map Items = " + this.graph_map.values().size());
        EditorPlugin.DBG.info("Bar Map Items = " + this.bar_map.values().size());
        EditorPlugin.DBG.info("Bar Slider Map Items = " + this.bar_slider_map.values().size());
        EditorPlugin.DBG.info("Source Map Items = " + this.source_map.values().size());
        EditorPlugin.DBG.info("Source Graph Map Items = " + this.source_graph_map.values().size());
        EditorPlugin.DBG.info("Disposables Items = " + this.disposables.size());
        EditorPlugin.DBG.info("Model Items = " + this.agents.size());
        Runtime r = Runtime.getRuntime();
        r.gc();
        long used = r.totalMemory() - r.freeMemory();
        EditorPlugin.DBG.info("USED MEMORY = " + used / 1024L + "k (+" + (used - this.prev_used) + ")");
        this.prev_used = used;
    }

    public void freeTreeItem(TreeItem item) {
        SDSnapshotObservation obs;
        SDModifiableVariableRepresentation rep;
        Object descriptor;
        if (item == null) {
            return;
        }
        Object agent = this.trcagent_map.remove(item);
        if (agent != null) {
            TreeItem trcagent_item = (TreeItem)this.reverse_map.remove(agent);
        }
        if ((descriptor = this.sddescriptor_map.remove(item)) != null) {
            TreeItem descriptor_item = (TreeItem)this.reverse_map.remove(descriptor);
        }
        if ((rep = (SDModifiableVariableRepresentation)this.modifiable_map.remove(item)) != null) {
            System.out.println("REMOVING CONTROL " + rep);
            try {
                this.graph_window.removeControl(rep);
            }
            catch (Throwable e) {
                EditorPlugin.DBG.error("problem removing control from graph window", e);
            }
            TreeItem rep_item = (TreeItem)this.reverse_map.remove(rep);
        }
        ZoomSlider rep_slider = (ZoomSlider)((Object)this.bar_slider_map.remove(item));
        ModifiableVariableBar bar = (ModifiableVariableBar)this.bar_map.remove(item);
        if (bar != null) {
            try {
                if (bar.bar.getZoomSlider() != null) {
                    bar.bar.getZoomSlider().removeZoomControlBar(bar.bar);
                    bar.bar.dispose();
                    this.disposables.remove(bar.bar);
                }
            }
            catch (NullPointerException e) {
                EditorPlugin.DBG.warning("bar zoomslider not found", e);
            }
        }
        if ((obs = (SDSnapshotObservation)this.counter_map.remove(item)) != null) {
            this.reverse_map.remove(obs);
            Graph obs_graph = (Graph)this.graph_map.remove(item);
            try {
                if (obs_graph != null) {
                    this.rgraph_map.remove(obs_graph);
                    obs_graph.setUseIndicator(false);
                    this.graph_window.removeGraph(obs_graph);
                }
            }
            catch (Throwable e) {
                EditorPlugin.DBG.error("problem removing graph from graph window", e);
            }
            BasicGraphSource source = (BasicGraphSource)this.source_map.remove(item);
            if (source != null) {
                this.source_graph_map.remove(source);
            }
        }
        if (!item.isDisposed()) {
            item.dispose();
        }
    }

    public void treeItemSelected(TreeItem item) {
        if (item.isDisposed()) {
            return;
        }
        try {
            TreeItem msgparent = item;
            while (msgparent != null) {
                if (msgparent.getText().equals(EditorPlugin.getString("MESSAGES"))) {
                    this.redoAllCBEs();
                    break;
                }
                msgparent = msgparent.getParentItem();
            }
            boolean parents_all_checked = true;
            TreeItem parent = item.getParentItem();
            while (parent != null) {
                if (!parent.getChecked()) {
                    parents_all_checked = false;
                    break;
                }
                parent = parent.getParentItem();
            }
            if (item.getParentItem() == null) {
                boolean b = item.getGrayed();
                this.treeItemSelected(item, parents_all_checked);
                item.setGrayed(b);
            } else {
                this.treeItemSelected(item, parents_all_checked);
            }
            this.graph_window.redraw();
        }
        catch (Throwable t) {
            EditorPlugin.DBG.logVisibleError(t, EditorPlugin.getString("ERROR_UPDATE_STATCONTREE"), false);
        }
    }

    private Graph getOrCreateGraphForSource(BasicGraphSource source) {
        Graph graph = (Graph)this.source_graph_map.get(source);
        if (graph == null) {
            Color col = this.getGraphWindow().getDisplay().getSystemColor(this.colours[this.next++]);
            if (this.next >= this.colours.length) {
                this.next = 0;
            }
            if (source instanceof GraphSource) {
                graph = new LineGraph(0, (SDSnapshotObservationGraphSource)source, this.graph_window.getXSlider(0), this.graph_window.getYSlider(0), col);
            } else if (source instanceof EnumerationGraphSource) {
                graph = new EnumerationGraph(this.graph_window.getXSlider(0), this.graph_window.getYSlider(0), col, (SDTextObservationGraphSource)source);
            }
            this.source_graph_map.put(source, graph);
        }
        return graph;
    }

    public void treeItemSelected(TreeItem item, boolean parents_all_checked) {
        SDSnapshotObservation obs;
        boolean checked = item.getChecked();
        if (!parents_all_checked) {
            checked = false;
            if (!item.getGrayed()) {
                this.setDirty(true);
            }
            item.setGrayed(true);
        } else {
            if (item.getGrayed()) {
                this.setDirty(true);
            }
            item.setGrayed(false);
        }
        EList events = (EList)this.msglist_map.get(item);
        if (events != null) {
            StatAgent agent = this.getStatAgent(events);
            if (checked && !agent.show_messages) {
                agent.show_messages = true;
                this.redoAllCBEs();
                this.setDirty(true);
            } else if (!checked && agent.show_messages) {
                agent.show_messages = false;
                this.redoAllCBEs();
                this.setDirty(true);
            }
        }
        if ((obs = (SDSnapshotObservation)this.counter_map.get(item)) != null) {
            Graph graph = (Graph)this.graph_map.get(item);
            BasicGraphSource source = (BasicGraphSource)this.source_map.get(item);
            if (source == null) {
                if (obs instanceof SDContiguousObservation) {
                    source = new SDSnapshotObservationGraphSource((SDContiguousObservation)obs);
                } else if (obs instanceof SDDiscreteObservation) {
                    source = new SDSnapshotObservationGraphSource((SDDiscreteObservation)obs);
                } else if (obs instanceof SDTextObservation) {
                    source = new SDTextObservationGraphSource((SDTextObservation)obs);
                } else {
                    EditorPlugin.DBG.info("SnapshotObservation neither Contiguous nor Discrete!");
                    return;
                }
                this.source_map.put(item, source);
            }
            if (graph == null && checked) {
                this.setDirty(true);
                graph = this.getOrCreateGraphForSource(source);
                if (graph.getXSlider().isDisposed()) {
                    graph.setXSlider(this.graph_window.getXSlider(0));
                }
                if (graph.getYSlider().isDisposed()) {
                    graph.setYSlider(this.graph_window.getYSlider(0));
                }
                SDDescriptor sd = (SDDescriptor)this.sddescriptor_map.get(item);
                graph.setUseIndicator(true);
                this.graph_window.addGraph(item.getText(), sd.getDescription(), graph, sd);
            } else if (graph != null && !checked) {
                this.setDirty(true);
                graph.setUseIndicator(false);
                this.graph_window.removeGraph(graph);
            }
            if (checked) {
                this.graph_map.put(item, graph);
                this.rgraph_map.put(graph, item);
            } else {
                this.graph_map.remove(item);
                if (graph != null) {
                    this.rgraph_map.remove(graph);
                }
            }
            return;
        }
        SDModifiableVariableRepresentation rep = (SDModifiableVariableRepresentation)this.modifiable_map.get(item);
        if (rep != null) {
            ModifiableVariableBar mbar = (ModifiableVariableBar)this.bar_map.get(item);
            if (mbar == null && checked) {
                this.setDirty(true);
                ZoomSlider slider = (ZoomSlider)((Object)this.bar_slider_map.get(item));
                if (slider == null) {
                    slider = this.graph_window.getYSlider(0);
                }
                if (slider.isDisposed()) {
                    slider = this.graph_window.getYSlider(0);
                }
                Image enabled = rep.getImage();
                ZoomImageBar varbar = null;
                if (rep.getModifierType() != 4 && enabled != null && rep.hasBar()) {
                    varbar = new ZoomImageBar(slider, ((Number)rep.getLastRequestedValue()).doubleValue(), enabled, enabled, enabled.getBounds().height + 6);
                    varbar.setToolTipText(item.getText());
                    mbar = new ModifiableVariableBar(this, varbar, rep, this.dirtiable);
                    varbar.addZoomControlBarListener(mbar);
                } else {
                    mbar = new ModifiableVariableBar(this, varbar, rep, this.dirtiable);
                }
                SDDescriptor sd = (SDDescriptor)this.sddescriptor_map.get(item);
                this.graph_window.addControl(item.getText(), sd.getDescription(), enabled, varbar, rep);
                if (varbar != null) {
                    this.disposables.add(varbar);
                }
                if (rep.getModifierType() != 4 && enabled != null && rep.hasBar()) {
                    mbar.bar.getZoomSlider().addZoomControlBar(mbar.bar);
                }
            } else if (mbar != null && !checked) {
                this.setDirty(true);
                ZoomControlBar zbar = mbar.bar;
                try {
                    this.bar_slider_map.put(item, zbar.getZoomSlider());
                    zbar.dispose();
                    zbar.getZoomSlider().removeZoomControlBar(zbar);
                    this.disposables.remove(zbar);
                }
                catch (Throwable x) {
                    // empty catch block
                }
                this.graph_window.removeControl(rep);
            }
            if (checked) {
                this.bar_map.put(item, mbar);
            } else {
                this.bar_map.remove(item);
            }
            return;
        }
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            this.treeItemSelected(children[i], checked);
            ++i;
        }
    }

    private void setTreeItemSlider(TreeItem item, boolean horizontal, ZoomSlider slider) {
        Graph obs_graph;
        ModifiableVariableBar bar = this.getVariableBar(item);
        if (!horizontal) {
            this.bar_slider_map.put(item, slider);
            try {
                if (bar.bar.getZoomSlider() != null) {
                    bar.bar.getZoomSlider().removeZoomControlBar(bar.bar);
                    bar.bar.setZoomSlider(slider);
                    bar.bar.getZoomSlider().addZoomControlBar(bar.bar);
                }
            }
            catch (NullPointerException e) {
                EditorPlugin.DBG.warning("bar zoomslider not found", e);
            }
        }
        if ((obs_graph = this.getGraph(item)) != null) {
            if (horizontal) {
                obs_graph.setXSlider((TimeZoomSlider)slider);
            } else {
                obs_graph.setYSlider(slider);
            }
        }
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            this.setTreeItemSlider(children[i], horizontal, slider);
            ++i;
        }
    }

    private SDDescriptor getDescriptor(TreeItem item) {
        SDDescriptor descriptor = (SDDescriptor)this.sddescriptor_map.get(item);
        return descriptor;
    }

    private SDMemberDescriptor getMemberDescriptor(TreeItem item) {
        SDDescriptor descriptor = (SDDescriptor)this.sddescriptor_map.get(item);
        if (descriptor instanceof SDMemberDescriptor) {
            return (SDMemberDescriptor)descriptor;
        }
        return null;
    }

    private SDModifiableVariableRepresentation getRepresentation(TreeItem item) {
        SDModifiableVariableRepresentation rep = (SDModifiableVariableRepresentation)this.modifiable_map.get(item);
        return rep;
    }

    private ModifiableVariableBar getVariableBar(TreeItem item) {
        ModifiableVariableBar bar = (ModifiableVariableBar)this.bar_map.get(item);
        return bar;
    }

    private SDSnapshotObservation getObservation(TreeItem item) {
        SDSnapshotObservation obs = (SDSnapshotObservation)this.counter_map.get(item);
        return obs;
    }

    private BasicGraphSource getGraphSource(TreeItem item) {
        BasicGraphSource obs_source = (BasicGraphSource)this.source_map.get(item);
        return obs_source;
    }

    private Graph getGraph(TreeItem item) {
        BasicGraphSource source = this.getGraphSource(item);
        if (source == null) {
            return null;
        }
        Graph obs_graph = (Graph)this.source_graph_map.get(source);
        return obs_graph;
    }

    public void alertTriggered(Alert alert) {
        Display.getDefault().asyncExec((Runnable)new AlertTableUpdate());
    }

    public void alertReset(Alert alert) {
        Display.getDefault().asyncExec((Runnable)new AlertTableUpdate());
    }

    public void removeAlert(Alert alert) {
        this.alerts.remove(alert);
        this.getGraphWindow().setAlerts(this.alerts.toArray());
    }

    public void addAlert(Alert alert) {
        alert.addAlertListener(this);
        this.alerts.add(alert);
        this.getGraphWindow().setAlerts(this.alerts.toArray());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class StatAgent {
        TRCAgent agent = null;
        Image image = null;
        ArrayList actions = new ArrayList();
        ArrayList modelactions = new ArrayList();
        ArrayList model_roots = new ArrayList();
        URI uri;
        int msgindex = 0;
        boolean show_messages = true;
        TreeItem msg_item = null;
        TreeItem msg_info_item = null;
        TreeItem msg_warn_item = null;
        TreeItem msg_error_item = null;
        TreeItem msg_loc_item = null;
        HashMap msg_locations = new HashMap();

        StatAgent() {
        }
    }

    class RootNode {
        String name;
        Image image;
        ArrayList actions = new ArrayList();
        TreeItem item;
        String id;
        String parent_id;
        ArrayList node_children = new ArrayList();

        RootNode() {
        }

        public void dispose() {
            this.item.dispose();
        }
    }

    class CBEUpdate
    implements Runnable {
        CBEUpdate() {
        }

        public void run() {
            StatisticalModelGraphViewer.this.appendAllCBEs();
        }
    }

    class CBEComparator
    implements Comparator {
        CBEComparator() {
        }

        public int compare(Object o1, Object o2) {
            CBECommonBaseEvent e1 = (CBECommonBaseEvent)o1;
            CBECommonBaseEvent e2 = (CBECommonBaseEvent)o2;
            return (int)(e1.getCreationTime() - e2.getCreationTime());
        }
    }

    class SetSliderAction
    implements Runnable {
        boolean horizontal;
        ZoomSlider slider;
        TreeItem item;

        public SetSliderAction(boolean horizontal, ZoomSlider slider, TreeItem item) {
            this.horizontal = horizontal;
            this.slider = slider;
            this.item = item;
        }

        public void run() {
            StatisticalModelGraphViewer.this.setTreeItemSlider(this.item, this.horizontal, this.slider);
            StatisticalModelGraphViewer.this.graph_window.redraw();
            StatisticalModelGraphViewer.this.graph_window.updateTables();
        }
    }

    class BasicAction
    implements SelectionListener {
        String id = EditorPlugin.getString("ACTION_UNKNOWN");
        String name;
        Runnable runnable;
        MenuItem menuitem;
        Image image;

        BasicAction() {
        }

        public void dispose() {
            if (this.menuitem != null) {
                this.menuitem.dispose();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.runnable.run();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.runnable.run();
        }
    }

    class DynamicActionWrapper
    extends BasicAction {
        TreeItem[] items;
        EObject[] objects;
        DynamicAction action;

        DynamicActionWrapper() {
        }

        public void dispose() {
            if (this.menuitem != null) {
                this.menuitem.dispose();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.action.perform(StatisticalModelGraphViewer.this, this.items, this.objects);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.action.perform(StatisticalModelGraphViewer.this, this.items, this.objects);
        }
    }

    class JumpToGraphTableDAction
    extends DynamicAction {
        JumpToGraphTableDAction() {
        }

        public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            if (items.length != 1) {
                return false;
            }
            Graph g = (Graph)StatisticalModelGraphViewer.this.graph_map.get(items[0]);
            if (g != null) {
                return items[0].getChecked() && !items[0].getGrayed();
            }
            return false;
        }

        public Image getImage() {
            return StatisticalModelGraphViewer.this.img.getImage("smodel_counter.gif");
        }

        public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            Graph g = (Graph)StatisticalModelGraphViewer.this.graph_map.get(items[0]);
            StatisticalModelGraphViewer.this.graph_window.showTab(0);
            StatisticalModelGraphViewer.this.graph_window.selectGraph(g);
        }
    }

    class SnapAllOffsetsDAction
    extends DynamicAction {
        SnapAllOffsetsDAction() {
        }

        public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            int i = 0;
            while (i < relations.length) {
                EObject o = relations[i];
                if (o instanceof SDDescriptor || o instanceof TRCAgent) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Image getImage() {
            return StatisticalModelGraphViewer.this.img.getImage("slider_h.gif");
        }

        public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            int i = 0;
            while (i < items.length) {
                this.perform(items[i]);
                ++i;
            }
        }

        private void perform(TreeItem item) {
            Graph graph = (Graph)StatisticalModelGraphViewer.this.graph_map.get(item);
            if (graph != null) {
                double tmax = graph.getGraphSource().getMax();
                double tnow = System.currentTimeMillis();
                graph.setXOffset(tnow - tmax);
                StatisticalModelGraphViewer.this.setDirty(true);
            }
            TreeItem[] children = item.getItems();
            int i = 0;
            while (i < children.length) {
                this.perform(children[i]);
                ++i;
            }
        }
    }

    class JumpToControlTableDAction
    extends DynamicAction {
        JumpToControlTableDAction() {
        }

        public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            if (items.length != 1) {
                return false;
            }
            SDModifiableVariableRepresentation rep = (SDModifiableVariableRepresentation)StatisticalModelGraphViewer.this.modifiable_map.get(items[0]);
            if (rep != null) {
                return items[0].getChecked() && !items[0].getGrayed();
            }
            return false;
        }

        public Image getImage() {
            return StatisticalModelGraphViewer.this.img.getImage("smodel_modifiablerep.gif");
        }

        public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            SDModifiableVariableRepresentation rep = (SDModifiableVariableRepresentation)StatisticalModelGraphViewer.this.modifiable_map.get(items[0]);
            StatisticalModelGraphViewer.this.graph_window.showTab(1);
            StatisticalModelGraphViewer.this.graph_window.selectControl(rep);
        }
    }

    class AgentRemoveDAction
    extends DynamicAction {
        AgentRemoveDAction() {
        }

        public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            int i = 0;
            while (i < relations.length) {
                if (!(relations[i] instanceof TRCAgent)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public Image getImage() {
            return StatisticalModelGraphViewer.this.img.getImage("smodel_remove.gif");
        }

        public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            int i = 0;
            while (i < relations.length) {
                try {
                    StatisticalModelGraphViewer.this.removeAgent((TRCAgent)relations[i]);
                }
                catch (Throwable t) {
                    EditorPlugin.DBG.warning("failed to remove agent", t);
                }
                ++i;
            }
            StatisticalModelGraphViewer.this.redoAllCBEs();
        }
    }

    class AgentRefreshDAction
    extends DynamicAction {
        AgentRefreshDAction() {
        }

        public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            int i = 0;
            while (i < relations.length) {
                if (!(relations[i] instanceof TRCAgent)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public Image getImage() {
            return StatisticalModelGraphViewer.this.img.getImage("event_invocation.gif");
        }

        public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            int i = 0;
            while (i < relations.length) {
                try {
                    StatisticalModelGraphViewer.this.updateAgent((TRCAgent)relations[i]);
                }
                catch (Throwable t) {
                    EditorPlugin.DBG.warning("failed to remove agent", t);
                }
                ++i;
            }
            StatisticalModelGraphViewer.this.redoAllCBEs();
        }
    }

    class AgentSaveDAction
    extends DynamicAction {
        AgentSaveDAction() {
        }

        public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            int i = 0;
            while (i < relations.length) {
                if (!(relations[i] instanceof TRCAgent)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public Image getImage() {
            return StatisticalModelGraphViewer.this.img.getImage("save.gif");
        }

        public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            int i = 0;
            while (i < relations.length) {
                try {
                    this.saveTRCAgent((TRCAgent)relations[i]);
                }
                catch (Throwable t) {
                    EditorPlugin.DBG.logVisibleError(t, EditorPlugin.getString("ERROR_SAVE_GENERAL"), true);
                    EditorPlugin.DBG.error("failed to save agent", t);
                }
                ++i;
            }
            StatisticalModelGraphViewer.this.redoAllCBEs();
        }

        public void saveTRCAgent(TRCAgent agent) throws IOException {
            try {
                agent.getAgentProxy().getProcessProxy().getNode().getMonitor().eResource().save(Collections.EMPTY_MAP);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                agent.getAgentProxy().getProcessProxy().getNode().eResource().save(Collections.EMPTY_MAP);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                agent.getAgentProxy().getProcessProxy().eResource().save(Collections.EMPTY_MAP);
            }
            catch (Exception e) {
                // empty catch block
            }
            agent.eResource().save(Collections.EMPTY_MAP);
        }
    }

    class ObservationMergeDAction
    extends DynamicAction {
        ObservationMergeDAction() {
        }

        public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            int descriptor_count = 0;
            int graph_count = 0;
            int i = 0;
            while (i < items.length) {
                SDSnapshotObservation obs = (SDSnapshotObservation)StatisticalModelGraphViewer.this.counter_map.get(items[i]);
                SDDescriptor des = (SDDescriptor)StatisticalModelGraphViewer.this.sddescriptor_map.get(items[i]);
                if (!(des instanceof SDMemberDescriptor)) {
                    des = null;
                }
                if (obs != null) {
                    ++graph_count;
                } else if (des != null) {
                    ++descriptor_count;
                } else {
                    return false;
                }
                ++i;
            }
            return descriptor_count == 1 && graph_count > 0;
        }

        public Image getImage() {
            return StatisticalModelGraphViewer.this.img.getImage("smodel_counter.gif");
        }

        public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            ArrayList<SDSnapshotObservation> observations = new ArrayList<SDSnapshotObservation>();
            SDMemberDescriptor target = null;
            int i = 0;
            while (i < relations.length) {
                SDSnapshotObservation obs = (SDSnapshotObservation)StatisticalModelGraphViewer.this.counter_map.get(items[i]);
                SDDescriptor des = (SDDescriptor)StatisticalModelGraphViewer.this.sddescriptor_map.get(items[i]);
                if (!(des instanceof SDMemberDescriptor)) {
                    des = null;
                }
                if (obs != null) {
                    observations.add(obs);
                } else if (des != null) {
                    target = (SDMemberDescriptor)des;
                }
                ++i;
            }
            if (target != null && observations.size() > 0) {
                ObservationMerger merger = new ObservationMerger(observations, target);
                StatisticalModelGraphViewer.this.updateModel((SDDescriptor)target);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                StatisticalModelGraphViewer.this.getGraphWindow().updateGraphs();
            }
        }
    }

    class AddAlertDAction
    extends DynamicAction
    implements IInputValidator {
        AddAlertDAction() {
        }

        public boolean canAppear(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            SDSnapshotObservation obs;
            return items.length == 1 && (obs = (SDSnapshotObservation)StatisticalModelGraphViewer.this.counter_map.get(items[0])) != null;
        }

        public Image getImage() {
            return StatisticalModelGraphViewer.this.img.getImage("alert_obj.gif");
        }

        public void perform(StatConInterface statcon, TreeItem[] items, EObject[] relations) {
            SDSnapshotObservation obs = (SDSnapshotObservation)StatisticalModelGraphViewer.this.counter_map.get(items[0]);
            InputDialog idialog = new InputDialog(StatisticalModelGraphViewer.this.graph_window.getShell(), EditorPlugin.getString("ALERT_NAME_TITLE"), EditorPlugin.getString("ALERT_NAME_MESSAGE"), EditorPlugin.getString("NEW_ALERT_NAME"), (IInputValidator)this);
            idialog.open();
            String name = idialog.getValue();
            if (name != null) {
                Alert alert;
                if (obs instanceof SDContiguousObservation) {
                    alert = new Alert((SDContiguousObservation)obs);
                } else if (obs instanceof SDDiscreteObservation) {
                    alert = new Alert((SDDiscreteObservation)obs);
                } else {
                    EditorPlugin.DBG.warning("Alert added but no known observation type to create alert over");
                    return;
                }
                alert.name = name;
                StatisticalModelGraphViewer.this.addAlert(alert);
            }
        }

        public String isValid(String s) {
            if (s.length() == 0) {
                return EditorPlugin.getString("ERROR_EMPTY_ALERT_NAME");
            }
            return null;
        }
    }

    class DropListener {
        String extension;
        StatConDropListener listener;

        DropListener() {
        }
    }

    abstract class TreeAction {
        TreeAction() {
        }

        public abstract void run(TreeItem var1);
    }

    class AlertTableUpdate
    implements Runnable {
        AlertTableUpdate() {
        }

        public void run() {
            try {
                StatisticalModelGraphViewer.this.graph_window.updateAlertTable();
            }
            catch (Throwable t) {
                EditorPlugin.DBG.error("unable to update alert table", t);
            }
        }
    }

    class DyanmicActionComparator
    implements Comparator {
        DyanmicActionComparator() {
        }

        public int compare(Object o1, Object o2) {
            DynamicAction a1 = (DynamicAction)o1;
            DynamicAction a2 = (DynamicAction)o2;
            int diff = a1.group.compareTo(a2.group);
            if (diff == 0) {
                return a1.name.compareTo(a1.name);
            }
            return diff;
        }
    }
}

