/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.monitoractions.internal.email;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;
import org.eclipse.hyades.statistical.ui.monitoractions.internal.email.MailerException;

public class Mailer {
    private static String EOL = "\r\n";
    private Socket socket;
    private DataInputStream dataInputStream;
    private PrintStream printStream;
    private int port = 25;
    private String host = "mail";
    private static char[] separators = new char[]{';', ' ', ','};

    public Mailer() {
    }

    public Mailer(String host) {
        this.host = host;
    }

    public Mailer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(String sender, String recipient, String localhostDomain, String subject, String message) throws MailerException {
        try {
            try {
                System.out.println("Sender:" + sender);
                System.out.println("Recipient:" + recipient);
                System.out.println("Domain:" + localhostDomain);
                System.out.println("Subject:" + subject);
                System.out.println("Message:" + message);
                this.socket = new Socket(this.host, this.port);
                this.dataInputStream = new DataInputStream(this.socket.getInputStream());
                this.printStream = new PrintStream(this.socket.getOutputStream());
                this.response("220");
                this.printStream.print("HELO " + localhostDomain + EOL);
                this.response("250");
                this.printStream.print("MAIL FROM: <" + sender + ">" + EOL);
                this.response("250");
                this.printStream.print("RCPT TO: <" + recipient + ">" + EOL);
                this.response("250");
                this.printStream.print("DATA" + EOL);
                this.response("354");
                this.printStream.print("To: Alert Recipient <" + recipient + ">" + EOL);
                this.printStream.print("From: Statistical Alert <" + sender + ">" + EOL);
                this.printStream.print("Subject:  " + subject + EOL);
                this.printStream.print(message + EOL);
                this.printStream.print("." + EOL);
                this.response("250");
                this.printStream.print("QUIT" + EOL);
                this.response("221");
            }
            catch (UnknownHostException e) {
                throw new MailerException("UnknownHostException - " + e);
            }
            catch (IOException e) {
                throw new MailerException("IOException - " + e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new MailerException("Error getting qualified host name for this machine");
            }
            Object var10_6 = null;
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            try {
                this.socket.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        this.socket.close();
        return;
    }

    /*
     * Unable to fully structure code
     */
    private void response(String expected) throws IOException, MailerException {
        System.out.println("Mailer waiting for response, expecting \"" + expected + "\"");
        response = this.dataInputStream.readLine();
        System.out.println("Mailer expected 220, received - \"" + response + "\"");
        if (response.startsWith(expected)) ** GOTO lbl10
        throw new MailerException("Unexpected response \"" + response + "\" from server " + this.host);
lbl-1000:
        // 1 sources

        {
            response = this.dataInputStream.readLine();
            System.out.println("Mailer expected 220, received - \"" + response + "\"");
            if (response.startsWith(expected)) continue;
            throw new MailerException("Unexpected response \"" + response + "\" from server " + this.host);
lbl10:
            // 2 sources

            ** while (!response.startsWith((String)(expected + " ")))
        }
lbl11:
        // 1 sources

    }

    public static String[] separateRecipients(String recipient) {
        Vector<String> recipientVector = new Vector<String>();
        boolean separating = true;
        StringBuffer current = new StringBuffer();
        char[] chars = recipient.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (Mailer.isSeparator(chars[i])) {
                if (!separating) {
                    recipientVector.add(current.toString());
                    current = new StringBuffer();
                }
                separating = true;
            } else {
                current.append(chars[i]);
                separating = false;
            }
            ++i;
        }
        if (!separating) {
            recipientVector.add(current.toString());
        }
        String[] recipientArray = new String[recipientVector.size()];
        int i2 = 0;
        while (i2 < recipientVector.size()) {
            recipientArray[i2] = (String)recipientVector.elementAt(i2);
            ++i2;
        }
        return recipientArray;
    }

    private static boolean isSeparator(char c) {
        int i = 0;
        while (i < separators.length) {
            if (c == separators[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

