/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.monitoractions.internal.logfile;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.monitoractions.internal.logfile.LogFileControl;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertActionControl;
import org.eclipse.swt.widgets.Composite;

public class LogFileAlertAction
implements AlertAction {
    boolean trigger;
    String name;
    double value;
    double time;
    String path = "StatConAlerts.log";
    static SimpleDateFormat sdf = new SimpleDateFormat();

    public AlertActionControl getControl(Composite c) {
        return new LogFileControl(c, this);
    }

    public String getDescription() {
        return EditorPlugin.getString("ALERT_ACTION_NAME_LOGFILE") + " (" + this.path + ")";
    }

    public String getProviderName() {
        return EditorPlugin.getString("ALERT_ACTION_NAME_LOGFILE");
    }

    public void setInformation(String name, SDSnapshotObservation obs, double value, double time, boolean trigger) {
        this.name = name;
        this.value = value;
        this.time = time;
        this.trigger = trigger;
    }

    public void run() {
        try {
            FileOutputStream fout = new FileOutputStream(this.path, true);
            PrintStream pout = new PrintStream(fout);
            Date d = new Date((long)this.time);
            if (this.trigger) {
                pout.println(sdf.format(d) + ": " + this.name + " triggered at " + this.value);
            } else {
                pout.println(sdf.format(d) + ": " + this.name + " reset at " + this.value);
            }
            pout.flush();
            fout.close();
        }
        catch (IOException e) {
            EditorPlugin.DBG.warning("error logging alert to file " + e);
        }
    }

    public Object clone() {
        LogFileAlertAction action = new LogFileAlertAction();
        action.name = this.name;
        action.value = this.value;
        action.time = this.time;
        action.trigger = this.trigger;
        action.path = this.path;
        return action;
    }
}

