/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.monitoractions.internal.sound;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.InvalidDataException;
import org.eclipse.hyades.statistical.ui.monitoractions.internal.sound.SoundAlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertActionControl;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SoundControl
extends AlertActionControl
implements SelectionListener {
    SoundAlertAction action;
    Label label;
    Text path;
    Button browse;

    public SoundControl(Composite c, SoundAlertAction action) {
        super(c, 0);
        this.action = action;
        this.initGraphics();
        this.initEventHandling();
        this.readFromAction(action);
    }

    private void initGraphics() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.label = new Label((Composite)this, 0);
        this.label.setText(EditorPlugin.getString("ALERT_ACTION_SOUND_PATH"));
        this.label.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 2, 1, 4, 4));
        this.path = new Text((Composite)this, 2048);
        this.path.setText("              ");
        this.path.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.browse = new Button((Composite)this, 0);
        this.browse.setText(EditorPlugin.getString("BROWSE"));
        this.browse.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 4, 3));
    }

    private void initEventHandling() {
        this.browse.addSelectionListener((SelectionListener)this);
    }

    public void readFromAction(AlertAction tmp) {
        SoundAlertAction lfaction = (SoundAlertAction)tmp;
        this.path.setText(lfaction.path);
    }

    public void writeToAction(AlertAction tmp) throws InvalidDataException {
        if (this.path.getText().length() == 0) {
            throw new InvalidDataException(EditorPlugin.getString("ERROR_EMPTY_ALERT_SOUND_PATH"));
        }
        SoundAlertAction lfaction = (SoundAlertAction)tmp;
        lfaction.path = this.path.getText();
    }

    public AlertAction writeToClonedAction() throws InvalidDataException {
        SoundAlertAction clone = (SoundAlertAction)this.action.clone();
        this.writeToAction(clone);
        return clone;
    }

    public AlertAction writeToOriginalAction() throws InvalidDataException {
        this.writeToAction(this.action);
        return this.action;
    }

    public String getDescription() {
        return EditorPlugin.getString("ALERT_ACTION_NAME_SOUND");
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.widgetSelected(e.getSource());
    }

    public void widgetSelected(Object o) {
        if (o == this.browse) {
            FileDialog fd = new FileDialog(this.getShell());
            fd.setFileName(this.path.getText());
            String tmp = fd.open();
            if (tmp != null && tmp.length() != 0) {
                this.path.setText(tmp);
            }
        }
    }
}

