/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal;

import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSliderUtilities;
import org.eclipse.swt.graphics.GC;

public class ZoomSliderTick {
    ZoomSlider slider;
    public double value;
    int pixel;
    public String representation;
    public boolean textVisible;

    public ZoomSliderTick() {
    }

    public ZoomSliderTick(ZoomSlider slider, double d) {
        this.slider = slider;
        this.value = d;
        this.pixel = (int)slider.value2Pixel(this.value);
        this.representation = ZoomSliderUtilities.double2String(this.value);
        this.textVisible = this.isTextVisible();
    }

    public int getPixel() {
        return this.pixel;
    }

    private String throughput(double value) {
        if (value == 0.0) {
            return "";
        }
        return String.valueOf(ZoomSliderUtilities.round(60000.0 / value, 1.0E-4));
    }

    public void paintLine(GC g) {
        g.setForeground(this.slider.foregroundColor);
        if (this.slider.getOrientation() == 0) {
            if (this.textVisible) {
                g.drawLine(0, this.pixel, this.slider.getBounds().width, this.pixel);
            } else {
                g.drawLine(0, this.pixel, 5, this.pixel);
                g.drawLine(this.slider.getBounds().width - 5, this.pixel, this.slider.getBounds().width - 1, this.pixel);
            }
        } else if (this.textVisible) {
            g.drawLine(this.pixel, 0, this.pixel, this.slider.getBounds().height);
        } else {
            g.drawLine(this.pixel, 0, this.pixel, 5);
            g.drawLine(this.pixel, this.slider.getBounds().height - 5, this.pixel, this.slider.getBounds().height - 1);
        }
    }

    public void paintText(GC g) {
        if (this.textVisible) {
            int width;
            int ascent = g.getFontMetrics().getAscent();
            int head = width = g.stringExtent((String)this.representation).x;
            int dotIndex = this.representation.indexOf(".");
            if (dotIndex != -1) {
                head = g.stringExtent((String)this.representation.substring((int)0, (int)dotIndex)).x;
            }
            int xPos = 0;
            int yPos = 0;
            g.setBackground(this.slider.backgroundColor);
            if (this.slider.getOrientation() == 0) {
                xPos = this.slider.getDecimalPointPosition() - head;
                yPos = this.pixel - g.stringExtent((String)this.representation).y / 2;
                g.fillRectangle(xPos - 2, yPos, width + 4, g.stringExtent((String)this.representation).y);
            } else {
                xPos = this.pixel - width / 2;
                if (this.overlaps(this.slider.getLastVisible(), g)) {
                    return;
                }
                this.slider.setLastVisible(this);
                yPos = this.slider.getBounds().height / 2 - this.slider.getFontHeight() / 2 - 1;
                g.fillRectangle(xPos, yPos, width, ascent + 2);
            }
            g.setForeground(this.slider.foregroundColor);
            g.drawString(this.representation, xPos, yPos - 1, true);
        }
    }

    protected boolean isTextVisible() {
        int oom;
        int startPoint = this.representation.indexOf(46);
        if (startPoint == -1) {
            startPoint = this.representation.length();
        }
        if ((oom = this.slider.getIncrementOOM()) >= 0) {
            ++oom;
        }
        try {
            char significantChar = this.representation.charAt(startPoint - oom);
            if (significantChar == '0') {
                return true;
            }
            if (significantChar == '5') {
                return this.slider.getIncrement() != 5.0 * Math.pow(10.0, this.slider.getIncrementOOM());
            }
            if (significantChar == '2') {
                return false;
            }
            return false;
        }
        catch (StringIndexOutOfBoundsException e) {
            return true;
        }
    }

    public boolean overlaps(ZoomSliderTick tick, GC g) {
        if (tick == null) {
            return false;
        }
        return tick.pixel > this.pixel ? tick.pixel < this.pixel + g.stringExtent((String)this.representation).x + 5 : tick.pixel > this.pixel - g.stringExtent((String)this.representation).x - 5;
    }
}

