/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.logging.adapter.Adapter;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.config.AdapterConfigPlugin;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.core.SerializationException;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StaticParserWrapper
extends Parser {
    private Adapter adapter;
    private String parserName;
    private String agentName;
    private String key = String.valueOf(System.currentTimeMillis());
    private String originalConfigFile = null;
    protected String newDirectory = null;
    protected String newFileName = null;
    protected String currentPlugin = "org.eclipse.hyades.logging.adapter.config";
    private static Hashtable activeWrappers = new Hashtable();

    public StaticParserWrapper() {
        this.adapter = new Adapter();
        this.parserName = new String(Messages.getString((String)"HyadesGAUnknownNameTag"));
        this.agentName = new String(Messages.getString((String)"HyadesGAUnknownNameTag"));
    }

    public static Log getLogInstance(String logKey) {
        return (Log)activeWrappers.remove(logKey);
    }

    public void parse(Log argLogger) throws LogParserException {
        try {
            activeWrappers.put(this.key, argLogger);
            this.adapter.start(false, false);
        }
        catch (AdapterException e) {}
    }

    public void setUserInput(Hashtable table) throws LogParserException {
        table.put("loggerKey", this.key);
        String newConfigFile = this.getNewConfigFile(table);
        this.adapter.setContextConfigPath(newConfigFile);
        this.adapter.setComponentConfigPath(newConfigFile);
    }

    public String getName() {
        return this.agentName;
    }

    public CommonBaseEvent[] parseNext() throws LogParserException {
        return null;
    }

    public String getVersion() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private InputStream getConfigInputStream(String fileName, Hashtable table) throws LogParserException {
        block11: {
            fileSeparator = System.getProperty("file.separator");
            try {
                if (fileName.indexOf(47) != -1 && fileSeparator != "/") {
                    fileName = fileName.replace('/', fileSeparator.charAt(0));
                }
                if (fileName.startsWith("." + fileSeparator)) {
                    fileName = fileName.substring(2);
                }
                return new FileInputStream(fileName);
            }
            catch (FileNotFoundException exc) {
                fileName2 = (String)table.get(Messages.getString((String)"HyadesGAConfigFileRootAttributeName")) + fileSeparator + fileName;
                try {
                    this.originalConfigFile = fileName2;
                    return new FileInputStream(fileName2);
                }
                catch (FileNotFoundException exc2) {
                    config_paths = (String)table.get("config_path");
                    if (config_paths == null || config_paths.length() == 0) break block11;
                    strtok = new StringTokenizer(config_paths, File.pathSeparator, false);
                    ** while (strtok.hasMoreTokens())
                }
            }
lbl-1000:
            // 1 sources

            {
                config_path = strtok.nextToken();
                f = new File(config_path, fileName);
                if (!f.exists()) continue;
                try {
                    table.remove("config_path");
                    return new FileInputStream(f.getAbsolutePath());
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_ERROR_", (String)fileName));
        {
            catch (SecurityException exc2) {
                throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Open_ERROR_", (String)fileName));
            }
        }
        catch (SecurityException exc) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Open_ERROR_", (String)fileName));
        }
    }

    private String getNewConfigFile(Hashtable table) throws LogParserException {
        Document doc = null;
        String version = (String)table.get(Messages.getString((String)"HyadesGALogVersionTagName"));
        String config_file = null;
        if (version == null) {
            version = Messages.getString((String)"HyadesGADefaultLogVersionTagName");
        }
        if ((config_file = (String)table.get(version)) == null && (config_file = (String)table.get(Messages.getString((String)"HyadesGADefaultLogVersionTagName"))) == null) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_No_Config_File_ERROR_"));
        }
        InputStream inStream = null;
        String configFileDirectory = null;
        this.originalConfigFile = config_file;
        try {
            Boolean append = Boolean.TRUE;
            Class<?> pathClass = Class.forName("org.eclipse.core.runtime.Path");
            Constructor<?> pathConstructor = pathClass.getConstructor(config_file.getClass());
            Object path = pathConstructor.newInstance(config_file);
            Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
            Class<?> pluginClass = Class.forName("org.eclipse.core.runtime.Plugin");
            Object plugin = platformClass.getMethod("getPlugin", this.currentPlugin.getClass()).invoke(null, this.currentPlugin);
            inStream = (InputStream)pluginClass.getMethod("openStream", Class.forName("org.eclipse.core.runtime.IPath"), Boolean.TYPE).invoke(plugin, path, append);
            URL url = (URL)pluginClass.getMethod("find", Class.forName("org.eclipse.core.runtime.IPath")).invoke(plugin, path);
            File f = new File(((URL)platformClass.getMethod("asLocalURL", url.getClass()).invoke(null, url)).getFile());
            configFileDirectory = f.getParent();
        }
        catch (ClassNotFoundException e) {
            inStream = this.getConfigInputStream(config_file, table);
            configFileDirectory = new File(config_file).getParentFile().getAbsolutePath();
        }
        catch (InvocationTargetException e) {
            inStream = this.getConfigInputStream(config_file, table);
            configFileDirectory = new File(this.originalConfigFile).getParentFile().getAbsolutePath();
        }
        catch (Exception e) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Open_ERROR_", (String)config_file), (Throwable)e);
        }
        String logFilePath = (String)table.get(Messages.getString((String)"HyadesGAInputLogFilenameTag"));
        File logFile = null;
        if (logFilePath != null && logFilePath.trim().length() > 0) {
            logFile = new File(logFilePath.trim());
        }
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inStream);
        }
        catch (SAXException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        NodeList sensorList = doc.getElementsByTagName(Messages.getString((String)"HyadesGASensorTagName"));
        int sensorCount = sensorList.getLength();
        int i = 0;
        while (i < sensorCount) {
            block49: {
                Attr sensorAttribute;
                String propValue;
                Element sensorElement = (Element)sensorList.item(i);
                if (sensorElement == null) break block49;
                Element sensorTypeInstance = null;
                String newConverterCmd = null;
                Element directoryPropertyElement = null;
                Element fileNamePropertyElement = null;
                NodeList sensorNodes = sensorElement.getChildNodes();
                int k = 0;
                while (k < sensorNodes.getLength()) {
                    block50: {
                        String propName;
                        Element sensorPropertyElement;
                        Element sensorNode;
                        block51: {
                            block55: {
                                block54: {
                                    block53: {
                                        block52: {
                                            if (sensorNodes.item(k).getNodeType() != 1) break block50;
                                            sensorNode = (Element)sensorNodes.item(k);
                                            if (!sensorNode.getTagName().equals(Messages.getString((String)"HyadesGAPropertyElementTagName"))) break block51;
                                            sensorPropertyElement = sensorNode;
                                            propName = sensorPropertyElement.getAttribute(Messages.getString((String)"HyadesGAPropertyNameAttributeName"));
                                            propValue = sensorPropertyElement.getAttribute(Messages.getString((String)"HyadesGAPropertyValueAttributeName"));
                                            if (!propName.equals(Messages.getString((String)"HyadesGAdirectoryAttributeName"))) break block52;
                                            directoryPropertyElement = sensorPropertyElement;
                                            if (logFile != null) {
                                                sensorPropertyElement.setAttribute(Messages.getString((String)"HyadesGAPropertyValueAttributeName"), logFile.getParent());
                                            }
                                            break block50;
                                        }
                                        if (!propName.equals(Messages.getString((String)"HyadesGAfileNameAttributeName"))) break block53;
                                        fileNamePropertyElement = sensorPropertyElement;
                                        if (logFile != null) {
                                            sensorPropertyElement.setAttribute(Messages.getString((String)"HyadesGAPropertyValueAttributeName"), logFile.getName());
                                        }
                                        break block50;
                                    }
                                    if (!propName.equals(Messages.getString((String)"HyadesGAconverterCmdAttributeName"))) break block54;
                                    if (propValue != null && propValue.length() > 0) {
                                        if (newConverterCmd == null) {
                                            newConverterCmd = this.modifyConverter(propValue, configFileDirectory, table, logFile);
                                        }
                                        sensorPropertyElement.setAttribute(Messages.getString((String)"HyadesGAPropertyValueAttributeName"), newConverterCmd);
                                    }
                                    break block50;
                                }
                                if (!propName.equals(Messages.getString((String)"HyadesGAstaticParserClassAttributeName"))) break block55;
                                this.parserName = propValue;
                                break block50;
                            }
                            propValue = (String)table.get(propName);
                            if (propValue == null) break block50;
                            sensorPropertyElement.setAttribute(Messages.getString((String)"HyadesGAPropertyValueAttributeName"), propValue.trim());
                            break block50;
                        }
                        if (sensorNode.getTagName().equals(Messages.getString((String)"HyadesGAStaticParserSensorTagName")) || sensorNode.getTagName().equals(Messages.getString((String)"HyadesGASingleFileSensorTagName"))) {
                            sensorTypeInstance = sensorNode;
                            NodeList sensorPropertyList = sensorTypeInstance.getElementsByTagName(Messages.getString((String)"HyadesGASensorPropertyElementTagName"));
                            int sensorPropertyCount = sensorPropertyList.getLength();
                            int j = 0;
                            while (j < sensorPropertyCount) {
                                sensorPropertyElement = (Element)sensorPropertyList.item(j);
                                propName = sensorPropertyElement.getAttribute(Messages.getString((String)"HyadesGASensorPropertyNameAttributeName"));
                                propValue = (String)table.get(propName);
                                if (propValue != null) {
                                    sensorPropertyElement.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueAttributeName"), propValue.trim());
                                }
                                ++j;
                            }
                            NamedNodeMap sensorTypeAttributeList = sensorTypeInstance.getAttributes();
                            int sensorTypeAttributeCount = sensorTypeAttributeList.getLength();
                            int j2 = 0;
                            while (j2 < sensorTypeAttributeCount) {
                                Node sensorTypeAttribute = sensorTypeAttributeList.item(j2);
                                String attrName = sensorTypeAttribute.getNodeName();
                                if (attrName.equals(Messages.getString((String)"HyadesGAdirectoryAttributeName"))) {
                                    if (logFile != null) {
                                        sensorTypeAttribute.setNodeValue(logFile.getParent());
                                    }
                                } else if (attrName.equals(Messages.getString((String)"HyadesGAfileNameAttributeName"))) {
                                    if (logFile != null) {
                                        sensorTypeAttribute.setNodeValue(logFile.getName());
                                    }
                                } else if (attrName.equals(Messages.getString((String)"HyadesGAstaticParserClassAttributeName"))) {
                                    this.parserName = sensorTypeAttribute.getNodeValue();
                                } else if (attrName.equals(Messages.getString((String)"HyadesGAconverterCmdAttributeName"))) {
                                    if (newConverterCmd == null) {
                                        newConverterCmd = this.modifyConverter(sensorTypeAttribute.getNodeValue(), configFileDirectory, table, logFile);
                                    }
                                    sensorTypeAttribute.setNodeValue(newConverterCmd);
                                } else {
                                    propValue = (String)table.get(attrName);
                                    if (propValue != null) {
                                        sensorTypeAttribute.setNodeValue(propValue.trim());
                                    }
                                }
                                ++j2;
                            }
                        }
                    }
                    ++k;
                }
                NamedNodeMap sensorAttributeList = sensorElement.getAttributes();
                int sensorTypeAttributeCount = sensorAttributeList.getLength();
                int k2 = 0;
                while (k2 < sensorTypeAttributeCount) {
                    Node sensorTypeAttribute = sensorAttributeList.item(k2);
                    String attrName = sensorTypeAttribute.getNodeName();
                    propValue = (String)table.get(attrName);
                    if (propValue != null && propValue.length() > 0) {
                        sensorTypeAttribute.setNodeValue(propValue.trim());
                    }
                    ++k2;
                }
                if (this.newDirectory != null) {
                    if (directoryPropertyElement != null) {
                        directoryPropertyElement.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueAttributeName"), this.newDirectory);
                    }
                    if (sensorTypeInstance != null) {
                        sensorAttribute = sensorTypeInstance.getAttributeNode(Messages.getString((String)"HyadesGAdirectoryAttributeName"));
                        sensorAttribute.setNodeValue(this.newDirectory);
                    }
                }
                if (this.newFileName != null) {
                    if (fileNamePropertyElement != null) {
                        fileNamePropertyElement.setAttribute(Messages.getString((String)"HyadesGASensorPropertyValueAttributeName"), this.newFileName);
                    }
                    if (sensorTypeInstance != null) {
                        sensorAttribute = sensorTypeInstance.getAttributeNode(Messages.getString((String)"HyadesGAfileNameAttributeName"));
                        sensorAttribute.setNodeValue(this.newFileName);
                    }
                }
            }
            ++i;
        }
        NodeList outputterList = doc.getElementsByTagName(Messages.getString((String)"HyadesGAOutputterTagName"));
        int outputterCount = outputterList.getLength();
        int i2 = 0;
        while (i2 < outputterCount) {
            Element outputterElement = (Element)outputterList.item(i2);
            Element outputterProperty = doc.createElement(Messages.getString((String)"HyadesGAPropertyElementTagName"));
            outputterProperty.setAttribute(Messages.getString((String)"HyadesGAPropertyValueAttributeName"), this.key);
            outputterProperty.setAttribute(Messages.getString((String)"HyadesGAPropertyNameAttributeName"), Messages.getString((String)"HyadesGAStaticParserLoggerKeyName"));
            outputterElement.appendChild(outputterProperty);
            ++i2;
        }
        File newFile = null;
        try {
            Class<?> platformClass = Class.forName("org.eclipse.core.runtime.Platform");
            Method getPluginStateLocationMethod = platformClass.getMethod("getPluginStateLocation", Class.forName("org.eclipse.core.runtime.Plugin"));
            Object iPathObject = getPluginStateLocationMethod.invoke(null, new Object[]{AdapterConfigPlugin.getPlugin()});
            Class<?> iPathClass = iPathObject.getClass();
            Method toOSStringMethod = iPathClass.getMethod("toOSString", null);
            newFile = new File((String)toOSStringMethod.invoke(iPathObject, null), "GLA" + System.currentTimeMillis() + ".adapter");
        }
        catch (Exception e) {
            try {
                newFile = File.createTempFile("GLA", ".adapter");
            }
            catch (Exception e2) {
                File oldFile = new File(config_file);
                String tmpFileName = new String("GLA" + System.currentTimeMillis() + ".adapter");
                newFile = new File(oldFile.getParent(), tmpFileName);
            }
        }
        newFile.deleteOnExit();
        try {
            XmlUtility.serialize((Document)doc, (File)newFile);
        }
        catch (SerializationException s) {
            throw new LogParserException(Messages.getString((String)"HyadesGA_CBE_Adapter_Config_File_Save_ERROR_", (String)newFile.getAbsolutePath()), (Throwable)s);
        }
        return newFile.getAbsolutePath();
    }

    protected String modifyConverter(String converter, String configFileDirectory, Hashtable table, File logfile) {
        return converter;
    }
}

