/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.DeleteUtil;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class DeleteAction
extends SelectionProviderAction
implements ISelectionChangedListener {
    private INavigator fViewer;
    private ArrayList deletedPaths = new ArrayList();

    public DeleteAction(INavigator viewer) {
        super((ISelectionProvider)viewer.getViewer(), UIPlugin.getResourceString("DELETE"));
        this.setDescription(UIPlugin.getResourceString("DELETE_RESOURCE"));
        this.setToolTipText(UIPlugin.getResourceString("DELETE_OBJECT_TOOLTIP"));
        ISharedImages images = UIPlugin.getDefault().getWorkbench().getSharedImages();
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        WorkbenchHelp.setHelp((IAction)this, (String)(UIPlugin.getPluginId() + ".delt0000"));
        this.fViewer = viewer;
    }

    public void run() {
        Object[] fSelections = ((IStructuredSelection)this.fViewer.getViewer().getSelection()).toArray();
        if (fSelections == null || fSelections.length == 0) {
            return;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        int i = 0;
        while (i < fSelections.length) {
            Object sel = fSelections[i];
            if (!this.validForDelete(sel)) {
                return;
            }
            ++i;
        }
        DeleteResourceDialog dlg = new DeleteResourceDialog(this.fViewer.getViewSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        final boolean deleteContents = dlg.getDeleteContent();
        this.deletedPaths.clear();
        int i2 = 0;
        while (i2 < fSelections.length) {
            final Object sel = fSelections[i2];
            if (sel != null) {
                BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    public void run() {
                        if (sel instanceof IResource) {
                            if (!DeleteAction.this.containsPath(((IResource)sel).getFullPath())) {
                                DeleteUtil.deleteResource((IResource)sel, deleteContents);
                                DeleteAction.this.deletedPaths.add(((IResource)sel).getFullPath());
                            }
                        } else if (sel instanceof TRCMonitor) {
                            DeleteUtil.deleteMonitor((TRCMonitor)sel, true, deleteContents);
                        } else if (sel instanceof TRCNode) {
                            DeleteUtil.deleteNode((TRCNode)sel, true, deleteContents);
                        } else if (sel instanceof TRCAgentProxy) {
                            DeleteUtil.deleteAgent((TRCAgentProxy)sel, true, deleteContents);
                        } else if (sel instanceof TRCProcessProxy) {
                            DeleteUtil.deleteProcess((TRCProcessProxy)sel, true, deleteContents);
                        } else if (sel instanceof CorrelationContainerProxy) {
                            DeleteUtil.deleteCorrelationContainer((CorrelationContainerProxy)sel, true, deleteContents);
                        } else if (sel instanceof INavigatorItem) {
                            ((INavigatorItem)sel).delete(true, deleteContents);
                        }
                    }
                });
            }
            ++i2;
        }
        fSelections = null;
        this.deletedPaths.clear();
        shell = null;
        ProfileEvent event = new ProfileEvent();
        event.setSource(null);
        event.setType(4096);
        UIPlugin.getDefault().notifyProfileEventListener(event);
        event = UIPlugin.getDefault().getProfileEvent();
        if (event == null) {
            event = new ProfileEvent();
        }
        event.setSource(null);
        event.setType(128);
        UIPlugin.getDefault().notifyProfileEventListener(event);
    }

    private boolean containsPath(IPath innerPath) {
        Iterator iter = this.deletedPaths.iterator();
        while (iter.hasNext()) {
            IPath path = (IPath)iter.next();
            if (!path.isPrefixOf(innerPath)) continue;
            return true;
        }
        return false;
    }

    private boolean checkContainer(IContainer container, int deep) {
        if (deep != 0) {
            if (deep != -1) {
                --deep;
            }
            try {
                IResource[] resources = container.members();
                int j = 0;
                while (j < resources.length) {
                    if (resources[j] instanceof IContainer && !this.checkContainer((IContainer)resources[j], deep)) {
                        return false;
                    }
                    ++j;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                return false;
            }
        }
        ArrayList monitors = PDContentProvider.getMonitors(container);
        return true;
    }

    private boolean validForDelete(Object sel) {
        if (sel != null) {
            if (sel instanceof IContainer) {
                return this.checkContainer((IContainer)sel, -1);
            }
            return !(sel instanceof TRCAgentProxy ? !this.checkAgentState((TRCAgentProxy)sel) : sel instanceof TRCProcessProxy && !this.checkAgentsState(((TRCProcessProxy)sel).getAgentProxies()));
        }
        return true;
    }

    private boolean checkAgentsState(EList eList) {
        Iterator iter = eList.iterator();
        while (iter.hasNext()) {
            TRCAgentProxy agent = (TRCAgentProxy)iter.next();
            if (agent.eIsProxy() || this.checkAgentState(agent)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAgentState(TRCAgentProxy a) {
        if (a.isActive() && (a.isAttached() || a.isMonitored()) || a.isCollectionData()) {
            this.treatActiveAgentWhenDelete(a);
            return false;
        }
        return true;
    }

    private void treatActiveAgentWhenDelete(TRCAgentProxy a) {
        String text = UIPlugin.getResourceString("DELETE_ACTIVE_AGENT_ERROR_");
        text = HyadesUtil.change(text, "%1", a.getName());
        final Shell shell = Display.getDefault().getActiveShell();
        if (shell != null) {
            final Status err = new Status(2, "org.eclipse.core.resources", 566, text, null);
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)shell, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("DELETE_FILE_ERROR_TITLE"), (IStatus)err);
                }
            });
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
        if (this.deletedPaths != null) {
            this.deletedPaths.clear();
        }
        this.deletedPaths = null;
    }

    class DeleteResourceDialog
    extends MessageDialog {
        private boolean deleteContent = false;
        private Button radio1;
        private Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(this){
            private final /* synthetic */ DeleteResourceDialog this$1;
            {
                this.this$1 = this$1;
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    DeleteResourceDialog.access$002(this.this$1, button == DeleteResourceDialog.access$100(this.this$1));
                }
            }
        };

        DeleteResourceDialog(Shell parentShell) {
            super(parentShell, UIPlugin.getResourceString("TRACE_MSG"), null, UIPlugin.getResourceString("CONFIRM_DEL_MSG"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            String text1 = UIPlugin.getResourceString("STR_DELETE_RESOURCE_PATH");
            this.radio1.setText(text1);
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String text2 = UIPlugin.getResourceString("STR_NOT_DELETE_RESOURCE");
            this.radio2.setText(text2);
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            return composite;
        }

        public boolean getDeleteContent() {
            return this.deleteContent;
        }

        static /* synthetic */ boolean access$002(DeleteResourceDialog x0, boolean x1) {
            x0.deleteContent = x1;
            return x0.deleteContent;
        }

        static /* synthetic */ Button access$100(DeleteResourceDialog x0) {
            return x0.radio1;
        }
    }
}

