/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import java.io.File;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class LaunchProcessUI
extends AbstractChangeable
implements SelectionListener {
    private Button _browseClass;
    private Button _browseDirPath;
    private Button _browseJarPath;
    private Composite _classGroup;
    private Composite _paramGroup;
    private Text _classname;
    private Text _classpath;
    private static String MAIN_METHOD_NAME = "main";
    private static String MAIN_METHOD_DESCRIPTOR = "([Ljava/lang/String;)V";
    private Listener _listener = new Listener(){

        public void handleEvent(Event event) {
            LaunchProcessUI.this.changed();
        }
    };

    public Composite createArgumentsControl(Composite parent) {
        this._paramGroup = new Composite(parent, 0);
        this._paramGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 3;
        GridData gd = GridUtil.createFill();
        this._paramGroup.setLayoutData((Object)gd);
        this._paramGroup.setLayout((Layout)layout);
        Label label = new Label(this._paramGroup, 0);
        gd = new GridData();
        gd.verticalAlignment = 1;
        label.setText(UIPlugin.getResourceString("CLASSPATH"));
        label.setLayoutData((Object)gd);
        Composite pathGroup = new Composite(this._paramGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        layout.marginHeight = 0;
        gd = GridUtil.createHorizontalFill();
        pathGroup.setLayoutData((Object)gd);
        pathGroup.setLayout((Layout)layout);
        this._classpath = new Text(pathGroup, 2882);
        gd = GridUtil.createFill();
        gd.heightHint = 70;
        gd.widthHint = 90;
        this._classpath.setLayoutData((Object)gd);
        this._classpath.addListener(24, this._listener);
        Composite btnGroup = new Composite(pathGroup, 0);
        gd = GridUtil.createVerticalFill();
        gd.horizontalIndent = 5;
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 7;
        btnGroup.setLayoutData((Object)gd);
        btnGroup.setLayout((Layout)layout);
        this._browseDirPath = new Button(btnGroup, 0x1000008);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this._browseDirPath.setLayoutData((Object)gd);
        this._browseDirPath.setText(UIPlugin.getResourceString("ADD_DIRECTORY"));
        this._browseJarPath = new Button(btnGroup, 0x1000008);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 2;
        this._browseJarPath.setLayoutData((Object)gd);
        this._browseJarPath.setText(UIPlugin.getResourceString("ADD_JAR"));
        label = new Label(btnGroup, 0);
        this._browseDirPath.addSelectionListener((SelectionListener)this);
        this._browseJarPath.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this._classpath, (String)(UIPlugin.getPluginId() + ".lpui0001"));
        return this._paramGroup;
    }

    public Composite createClassControl(Composite parent) {
        this._classGroup = new Composite(parent, 0);
        this._classGroup.setLayoutData((Object)GridUtil.createHorizontalFill());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        this._classGroup.setLayout((Layout)layout);
        Label label = new Label(this._classGroup, 0);
        label.setText(UIPlugin.getResourceString("CLASS_NAME"));
        this._classname = new Text(this._classGroup, 2052);
        this._classname.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._classname.addListener(24, this._listener);
        Composite btnGroup = new Composite(this._classGroup, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        btnGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        btnGroup.setLayout((Layout)layout);
        this._browseClass = new Button(btnGroup, 0x1000008);
        this._browseClass.setLayoutData((Object)GridUtil.createFill());
        this._browseClass.setText(UIPlugin.getResourceString("BROWSE"));
        this._browseClass.addSelectionListener((SelectionListener)this);
        this._classname.setFocus();
        WorkbenchHelp.setHelp((Control)this._classname, (String)(UIPlugin.getPluginId() + ".lpui0000"));
        return this._classGroup;
    }

    public Composite createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 10;
        content.setLayout((Layout)layout);
        GridData gd = GridUtil.createFill();
        content.setLayoutData((Object)gd);
        this.createClassControl(content);
        this.createArgumentsControl(content);
        this._classname.setFocus();
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".lpui0000"));
        WorkbenchHelp.setHelp((Control)content, (String)(UIPlugin.getPluginId() + ".lpui0000"));
        return content;
    }

    public void enable(boolean enable) {
        this.enableButtons(enable);
        this.enableText(enable);
    }

    private void enableButtons(boolean enable) {
        this._browseClass.setEnabled(enable);
        this._browseDirPath.setEnabled(enable);
        this._browseJarPath.setEnabled(enable);
    }

    private void enableText(boolean enable) {
        this._classname.setEnabled(enable);
        this._classname.setEditable(enable);
        this._classpath.setEnabled(enable);
        this._classpath.setEditable(enable);
    }

    public Control getBrowseClassButton() {
        return this._browseClass;
    }

    public Control getBrowseDirButton() {
        return this._browseDirPath;
    }

    public Control getBrowseJarButton() {
        return this._browseJarPath;
    }

    public Composite getClassGroup() {
        return this._classGroup;
    }

    public String getClassName() {
        return this._classname.getText().trim();
    }

    public String getClassPath() {
        return this._classpath.getText().trim();
    }

    public Text getClassPathUI() {
        return this._classpath;
    }

    public Text getClassUI() {
        return this._classname;
    }

    public void setClassName(String name) {
        this._classname.setText(name);
    }

    public void setClassPath(String path) {
        this._classpath.setText(path);
    }

    public void setLocalButtons(boolean local) {
        this.getBrowseClassButton().setEnabled(local);
        this.getBrowseDirButton().setEnabled(local);
        this.getBrowseJarButton().setEnabled(local);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    private boolean hasMainMethod(IMethodInfo[] mi) {
        int i = 0;
        while (i < mi.length) {
            mi[i].getAttributes();
            char[] desc = mi[i].getDescriptor();
            if (MAIN_METHOD_NAME.equals(new String(mi[i].getName())) && Flags.isPublic((int)mi[i].getAccessFlags()) && MAIN_METHOD_DESCRIPTOR.equals(new String(mi[i].getDescriptor()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void widgetSelected(SelectionEvent e) {
        Shell shell = this._browseClass.getShell();
        String osName = System.getProperty("os.name");
        if (e.widget == this._browseClass) {
            FileDialog dlg = new FileDialog(shell);
            dlg.setFilterExtensions(new String[]{"*.class"});
            dlg.open();
            String fileName = dlg.getFileName();
            if (fileName != null && !fileName.equals("")) {
                String classpath = dlg.getFilterPath();
                IClassFileReader cfr = ToolFactory.createDefaultClassFileReader((String)(classpath + File.separator + fileName), (int)3);
                String qualifiedClassName = null;
                if (cfr == null) {
                    qualifiedClassName = dlg.getFileName();
                    if (qualifiedClassName.endsWith(".class")) {
                        qualifiedClassName = qualifiedClassName.substring(0, qualifiedClassName.length() - 6);
                    }
                    MessageDialog.openWarning((Shell)this._browseClass.getShell(), (String)UIPlugin.getResourceString("STR_CANT_READ_CLASS_FILE_WARNING_TITLE"), (String)UIPlugin.getResourceString("STR_CANT_READ_CLASS_FILE_WARNING"));
                } else {
                    int endOfPackageIndex;
                    if (!this.hasMainMethod(cfr.getMethodInfos())) {
                        MessageDialog.openWarning((Shell)this._browseClass.getShell(), (String)UIPlugin.getResourceString("STR_CANT_READ_CLASS_FILE_WARNING_TITLE"), (String)UIPlugin.getResourceString("STR_CANT_READ_CLASS_MAIN_WARNING"));
                    }
                    if ((endOfPackageIndex = (qualifiedClassName = new String(cfr.getClassName())).lastIndexOf("/")) >= 0) {
                        String packageDir = qualifiedClassName.substring(0, qualifiedClassName.lastIndexOf("/"));
                        int beginningOfPackageIndex = classpath.lastIndexOf(packageDir = packageDir.replace('/', File.separatorChar));
                        if (beginningOfPackageIndex >= 0 && (classpath = classpath.substring(0, beginningOfPackageIndex)).endsWith(File.separator)) {
                            classpath = classpath.substring(0, classpath.length() - 1);
                        }
                    }
                }
                if (osName != null && osName.startsWith("Windows") && classpath.endsWith(":")) {
                    classpath = classpath + "\\";
                }
                this._classname.setText(qualifiedClassName.replace('/', '.'));
                String oldClassPath = this._classpath.getText().trim();
                oldClassPath = oldClassPath.equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : oldClassPath + File.pathSeparator;
                this._classpath.setText(oldClassPath + classpath);
            }
        } else if (e.widget == this._browseDirPath) {
            DirectoryDialog dlg = new DirectoryDialog(shell);
            String classpath = dlg.open();
            if (classpath != null && !classpath.equals("")) {
                String oldClassPath;
                if (osName != null && osName.startsWith("Windows") && classpath.endsWith(":")) {
                    classpath = classpath + "\\";
                }
                oldClassPath = (oldClassPath = this._classpath.getText().trim()).equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : oldClassPath + File.pathSeparator;
                classpath = oldClassPath + classpath;
                this._classpath.setText(classpath);
                this._classpath.setFocus();
            }
        } else if (e.widget == this._browseJarPath) {
            FileDialog dlg = new FileDialog(shell);
            dlg.setFilterExtensions(new String[]{"*.jar;*.zip"});
            dlg.open();
            String classpath = dlg.getFileName();
            if (classpath != null && !classpath.equals("")) {
                classpath = dlg.getFilterPath() + File.separator + classpath;
                String oldClassPath = this._classpath.getText().trim();
                oldClassPath = oldClassPath.equals("") || oldClassPath.endsWith(File.pathSeparator) ? oldClassPath : oldClassPath + File.pathSeparator;
                classpath = oldClassPath + classpath;
                this._classpath.setText(classpath);
            }
        }
        this.changed();
    }
}

