/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileAttachDelegate;
import org.eclipse.hyades.trace.ui.internal.util.ProcessTreeItem;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ProcessWrapperRunnable
implements IRunnableWithProgress {
    private Object parent;
    private Object[] children = null;
    private ILaunchConfiguration _conf;
    private boolean logAgentsEnabled;
    private boolean profileAgentsEnabled;
    private ArrayList fAgentTypeList;

    public ProcessWrapperRunnable(Object p_parent, ILaunchConfiguration c) {
        this.parent = p_parent;
        this._conf = c;
        this.logAgentsEnabled = UIPlugin.getDefault().getPreferenceStore().getBoolean("log_option");
        this.profileAgentsEnabled = UIPlugin.getDefault().getPreferenceStore().getBoolean("prof_option");
        this.fAgentTypeList = null;
    }

    private ArrayList getAgentTypeList() {
        if (this.fAgentTypeList == null) {
            this.fAgentTypeList = new ArrayList();
            this.fAgentTypeList.add("Logging");
        }
        return this.fAgentTypeList;
    }

    private boolean isDisplay(Object obj) {
        if (obj instanceof Process) {
            Enumeration agents = ((Process)obj).listAgents();
            while (agents.hasMoreElements()) {
                if (!this.isDisplay(agents.nextElement())) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Agent) {
            Agent agent = (Agent)obj;
            if (agent.isActive()) {
                if (this.logAgentsEnabled && agent.getType().equals("Logging") && !agent.isAttached()) {
                    return true;
                }
                if (this.profileAgentsEnabled && agent.getType().equals("Profiler") && !agent.isAttached()) {
                    return true;
                }
                ArrayList agentList = this.getAgentTypeList();
                int i = 0;
                while (i < agentList.size()) {
                    if (!agent.getType().equals("Logging") && agent.getType().equals((String)agentList.get(i))) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return true;
    }

    public void run(IProgressMonitor pm) {
        if (this.parent instanceof ProcessTreeItem) {
            ProcessTreeItem pti = (ProcessTreeItem)this.parent;
            if (pti.getData() == null) {
                Object[] childrenObjs = ProfileAttachDelegate.getNodeConfiguration(this._conf).toArray();
                if (childrenObjs.length == 0) {
                    this.children = null;
                } else {
                    Vector<ProcessTreeItem> childrenV = new Vector<ProcessTreeItem>();
                    int i = 0;
                    while (i < childrenObjs.length) {
                        if (this.isDisplay(childrenObjs[i])) {
                            childrenV.addElement(new ProcessTreeItem(childrenObjs[i], pti));
                        }
                        ++i;
                    }
                    this.children = childrenV.toArray();
                }
            } else if (pti.getData() instanceof Process) {
                Process process = (Process)pti.getData();
                Enumeration agents = process.listAgents();
                Vector<ProcessTreeItem> childrenV = new Vector<ProcessTreeItem>();
                while (agents.hasMoreElements()) {
                    Object agent = agents.nextElement();
                    if (!this.isDisplay(agent)) continue;
                    childrenV.addElement(new ProcessTreeItem(agent, pti));
                }
                this.children = childrenV.toArray();
            } else {
                this.children = null;
            }
        }
    }

    public Object[] getChildren() {
        if (this.children != null) {
            return this.children;
        }
        return new Object[0];
    }
}

