/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ProfileAttachDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration conf, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 4);
            monitor.subTask(UIPlugin.getResourceString("LAUNCHING_MESSAGES_ON_PROGRESS_VIEW"));
            boolean success = ProfileLaunchUtil.performProfilingTypesLaunch(conf);
            monitor.worked(1);
            if (!success) {
                monitor.setCanceled(true);
                return;
            }
            IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
            String hostName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getInt("localhost_port"));
            String projectName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
            String monitorName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
            String profileFile = null;
            if (conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false)) {
                profileFile = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String)null);
            }
            ProfilingSetsManager manager = ProfilingSetsManager.instance();
            ArrayList filters = manager.getFilters(conf);
            Vector options = manager.getOptions(conf);
            Vector agents = new Vector(ProfileAttachDelegate.getAgents(conf));
            monitor.worked(1);
            List agentList = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, (List)null);
            int agentCount = 0;
            if (agentList != null) {
                Iterator iter = agentList.iterator();
                while (iter.hasNext()) {
                    String agentString = (String)iter.next();
                    agentCount += new StringTokenizer(agentString, ":,").countTokens() - 1;
                }
            }
            if (agentCount != agents.size()) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        Shell parent = UIPlugin.getActiveWorkbenchShell();
                        Status status = new Status(2, UIPlugin.getPluginId(), 2, UIPlugin.getResourceString("ERROR_DLG_INVALID_AGENTS_REASON"), null);
                        ErrorDialog.openError((Shell)parent, (String)UIPlugin.getResourceString("TRACE_MSG"), (String)UIPlugin.getResourceString("LAUNCH_ERROR_"), (IStatus)status);
                    }
                });
                monitor.setCanceled(true);
                return;
            }
            monitor.worked(1);
            PDCoreUtil.attach(hostName, agents, options, filters, projectName, monitorName, String.valueOf(port), profileFile, launch);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        if (UIPlugin.getDefault().getPreferenceStore().getBoolean("profile_tips")) {
                            MessageDialogWithToggle.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)UIPlugin.getResourceString("PROFILING_TIP_TITLE"), (String)UIPlugin.getResourceString("ATTACH_INFO_MESSAGE"), (String)UIPlugin.getResourceString("ATTACH_MESSAGE_CHECKBOX_MSG"), (boolean)false, (IPreferenceStore)UIPlugin.getDefault().getPreferenceStore(), (String)"profile_tips");
                        }
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            });
            monitor.worked(1);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            throw e;
        }
    }

    static List getNodeConfiguration(ILaunchConfiguration conf) {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        try {
            String host = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
            int port = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PORT, store.getDefaultInt("localhost_port"));
            Enumeration enumeration = PDCoreUtil.getNodeConfiguration(host, port);
            ArrayList list = new ArrayList();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    list.add(enumeration.nextElement());
                }
            }
            return list;
        }
        catch (CoreException e) {
            HyadesUIPlugin.logError((Throwable)e);
            return null;
        }
    }

    public static List getAttributeProcesses(ILaunchConfiguration conf) {
        try {
            List processes = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AGENTS, (List)null);
            if (processes == null) {
                return new ArrayList();
            }
            Iterator iter = processes.iterator();
            ArrayList<ProcessAttribute> list = new ArrayList<ProcessAttribute>();
            while (iter.hasNext()) {
                list.add(new ProcessAttribute((String)iter.next()));
            }
            return list;
        }
        catch (Exception e) {
            HyadesUIPlugin.logError((Throwable)e);
            return new ArrayList();
        }
    }

    public static List getAttributeAgents(ILaunchConfiguration conf) {
        Iterator iter = ProfileAttachDelegate.getAttributeProcesses(conf).iterator();
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            ProcessAttribute pa = (ProcessAttribute)iter.next();
            list.addAll(pa.getAgentAttributes());
        }
        return list;
    }

    public static List getAgents(ILaunchConfiguration conf) {
        return ProfileAttachDelegate.getAgents(conf, ProfileAttachDelegate.getNodeConfiguration(conf));
    }

    static List getAgents(ILaunchConfiguration conf, List nodes) {
        ArrayList<Agent> agents;
        block5: {
            agents = new ArrayList<Agent>();
            if (nodes == null) break block5;
            try {
                Iterator iter = nodes.iterator();
                List list = ProfileAttachDelegate.getAttributeProcesses(conf);
                if (list != null) {
                    Map map = ProfileAttachDelegate.createMap(list);
                    Vector v = new Vector();
                    while (iter.hasNext()) {
                        Process process = (Process)iter.next();
                        String[] selected = (String[])map.get(process.getProcessId());
                        if (selected == null) continue;
                        int i = 0;
                        while (i < selected.length) {
                            agents.add(process.getAgent(selected[i]));
                            ++i;
                        }
                    }
                }
            }
            catch (Exception e) {
                HyadesUIPlugin.logError((Throwable)e);
            }
        }
        return agents;
    }

    public static Map createMap(List list) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ProcessAttribute pa = (ProcessAttribute)iter.next();
            Vector agentAttributes = pa.getAgentAttributes();
            String[] agents = new String[agentAttributes.size()];
            int i = 0;
            while (i < agents.length) {
                agents[i] = ((AgentAttribute)agentAttributes.elementAt(i)).getName();
                ++i;
            }
            map.put(pa.getPID(), agents);
        }
        return map;
    }

    public static class ProcessAttribute {
        private String _pid;
        private Vector _agentAttributes;

        public ProcessAttribute(Process process) {
            try {
                this._pid = process.getProcessId();
                this._agentAttributes = new Vector();
                Enumeration agentItems = process.listAgents();
                while (agentItems.hasMoreElements()) {
                    this._agentAttributes.addElement(new AgentAttribute((Agent)agentItems.nextElement()));
                }
            }
            catch (InactiveProcessException e) {
                HyadesUIPlugin.logError((Throwable)e);
            }
        }

        public ProcessAttribute(String processAttributeString) {
            StringTokenizer tok = new StringTokenizer(processAttributeString, ":");
            this._pid = tok.nextToken();
            this._agentAttributes = new Vector();
            tok = new StringTokenizer(tok.nextToken(), ",");
            while (tok.hasMoreTokens()) {
                this._agentAttributes.addElement(new AgentAttribute(tok.nextToken()));
            }
        }

        public String getPID() {
            return this._pid;
        }

        public String getAttributeString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this._pid);
            buf.append(':');
            int i = 0;
            while (i < this._agentAttributes.size()) {
                AgentAttribute agentAttr = (AgentAttribute)this._agentAttributes.elementAt(i);
                buf.append(agentAttr.getAttributeString());
                if (i < this._agentAttributes.size() - 1) {
                    buf.append(',');
                }
                ++i;
            }
            return buf.toString();
        }

        public int numAgents() {
            return this._agentAttributes.size();
        }

        public Vector getAgentAttributes() {
            return this._agentAttributes;
        }
    }

    public static class AgentAttribute {
        private String _name;
        private String _type;

        public AgentAttribute(Agent agent) {
            this._name = agent.getName();
            this._type = agent.getType();
        }

        public AgentAttribute(String agentAttributeString) {
            StringTokenizer tok = new StringTokenizer(agentAttributeString, ";");
            this._name = tok.nextToken();
            this._type = tok.nextToken();
        }

        public String getName() {
            return this._name;
        }

        public String getType() {
            return this._type;
        }

        public String getAttributeString() {
            return this.getName() + ";" + this.getType();
        }
    }
}

