/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileFiltersUI;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

public class ProfileFiltersTab {
    private TraceProfileFiltersUI _filtersUI = new TraceProfileFiltersUI();
    private ProfileTab parentTab;
    private StringBuffer filters;
    private String profilingTypeName;

    public ProfileFiltersTab(String parentName, ProfileTab pt) {
        this.parentTab = pt;
        this.profilingTypeName = parentName;
        this.filters = new StringBuffer();
    }

    public ProfileFiltersTab(String parentName) {
        this.filters = new StringBuffer();
        this.profilingTypeName = parentName;
    }

    public void setParentTab(ProfileTab pt) {
        this.parentTab = pt;
    }

    public Composite createControl(Composite parent) {
        return this._filtersUI.createControl(parent);
    }

    public void addListener(Listener _listener) {
        this._filtersUI.addListener(_listener);
    }

    public String getName() {
        return UIPlugin.getResourceString("TAB_NAME_FILTERS");
    }

    public Image getImage() {
        return PDPluginImages.getImage("filter_obj.gif");
    }

    public void activateFilters(FilterSetElement[] list, FilterSetElement selected) {
        FilterSetElement[] newList = this.order(list, selected);
        this._filtersUI.reset();
        this._filtersUI.addFilterSets(newList);
        this._filtersUI.setActiveFilterSet(selected);
    }

    public String getActiveFilterSet() {
        return this._filtersUI.getActiveFilterSet();
    }

    private FilterSetElement[] order(FilterSetElement[] list, FilterSetElement selected) {
        FilterSetElement[] ordered = new FilterSetElement[list.length];
        System.arraycopy(list, 0, ordered, 0, list.length);
        int i = 0;
        while (i < ordered.length) {
            if (ordered[i] == selected) {
                ordered[i] = ordered[0];
                ordered[0] = selected;
                break;
            }
            ++i;
        }
        return ordered;
    }

    public ArrayList getFilterSet() {
        return this._filtersUI.getFilterSet();
    }
}

