/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetType;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSet;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ProfileLaunchUtil {
    private static final String[] EMPTY = new String[0];

    public static String[] getEnvironmentVariables(ILaunchConfiguration conf) throws CoreException {
        Map envMap = conf.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, (Map)null);
        if (envMap != null) {
            ArrayList<String> list = new ArrayList<String>();
            Iterator iter = envMap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                list.add(key + "=" + envMap.get(key));
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            return array;
        }
        return EMPTY;
    }

    public static boolean performProfilingTypesLaunch(ILaunchConfiguration config) {
        boolean success = true;
        ProfilingSetsManager manager = ProfilingSetsManager.instance();
        IProfilingSet set = null;
        try {
            String setID = config.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_SET, (String)null);
            set = (IProfilingSet)manager.getProfilingSets().get(setID);
        }
        catch (CoreException e) {
            HyadesUIPlugin.logError((Throwable)e);
        }
        if (set == null) {
            return true;
        }
        IProfilingSetType[] profilingTypes = new ProfilingSetType[manager.getProfilingTypes().size()];
        profilingTypes = manager.getProfilingTypes().values().toArray(profilingTypes);
        List types = set.getProfilingTypes();
        int i = 0;
        while (i < profilingTypes.length) {
            IProfilingType type;
            String msg;
            if (types.contains(profilingTypes[i].getId()) && (msg = (type = profilingTypes[i].getProfilingType()).launch(config)) != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UIPlugin.getResourceString("ERROR_DLG_CONFLICTS_TITLE"), (String)msg);
                    }
                });
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String convertToDelimitedString(String[] array, char delimiter) {
        StringBuffer buf = new StringBuffer();
        if (array.length > 0) {
            int i = 0;
            while (i < array.length) {
                if (i != 0) {
                    buf.append(delimiter);
                }
                String arg = array[i].trim();
                if (array[i].startsWith("\"") && array[i].endsWith("\"")) {
                    buf.append(array[i]);
                } else if (array[i].indexOf(32) == -1) {
                    buf.append(array[i]);
                } else {
                    buf.append('\"');
                    buf.append(array[i]);
                    buf.append('\"');
                }
                ++i;
            }
        }
        return buf.toString();
    }
}

